package com.baijia.tianxiao.biz.erp.service;

import java.util.Collection;
import java.util.List;

import org.apache.http.Header;

import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

public interface ErpStudentService {

    /**
     * 添加学生到机构课程
     * 
     * @param orgId
     * @param courseId
     * @param studentIds
     * @param headers
     * @param doSignup true：产生报名记录， false:不产生报名记录
     */
    void addOrgCourseStudent(Long orgId, Long courseId, Collection<Long> studentIds, Collection<Header> headers,
        boolean doSignup);

    /**
     * 机构课程学生转班
     * 
     * @param orgId
     * @param studentId
     * @param fromCourseId
     * @param toCourseId
     * @param cause
     * @param headers
     */
    void transferOrgCourseStudent(Long orgId, Long studentId, Long fromCourseId, Long toCourseId, String cause,
        Collection<Header> headers);

    /**
     * 机构学员列表，附带出勤率
     * 
     * @param studentListRequestDto
     * @param orgId
     * @param pageDto
     * @return
     */
    StudentInfoListReponseDto getStudentListWithAttendanceRate(StudentListRequestDto studentListRequestDto, Long orgId,
        PageDto pageDto);
    
    /**
     * 分页查询班级学生信息
     * @param orgId
     * @param courseId
     * @param pageDto
     * @return
     */
//    List<CourseStudentInfoDto> getCourseStudentByCourseId(Long orgId, Long courseId, PageDto pageDto);

    /**
     * 根据参数模糊查询学员列表
     * @param orgId 机构id
     * @param param 学员姓名或手机号
     * @return
     */
    public List<PersonBaseDto> searchOrgStudents(Long orgId, String param, PageDto page) throws Exception;
    
    /**
     * 保存学员到课程(PC-ERP)
     * @param orgId
     * @param courseId
     * @param studentIds 学员id，包括现存、待添加、待删除学员
     */
    public void saveCourseStudents(Long orgId, Long courseId, Collection<Long> studentIds);
}
