
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.erp.dto.response.schedule;

import lombok.Data;


/**
 * 班级课节列表
 * @title LessonScheduleInfo
 * @desc TODO 
 * @author zhangbing
 * @date 2016年8月25日
 * @version 1.0
 */
@Data
public class LessonScheduleInfoDto {

    //课节ID
    private Long lessonId;
    
    //课程ID
    private Long courseId;
    
    //课程名称
    private String courseName;
    
    //课节起始时间
    private Long startTime;
    
    //课节结束时间
    private Long endTime;
    
    //老师名称
    private String teacherName;
    
    //老师ID
    private Long teacherId;
    
    //教室ID
    private Long roomId;
    
    //教室名称
    private String roomName;
 
    // 已报名学生数
    private int studentCount;
    
    //教室能容纳的人数
    private int roomCapacity;
    
    //冲突类型
    private ConflictInfoDto conflictInfo;
    
    //课节是否结束0=待上课,1=已结束,2=上课中
    private int lessonStatus;
    
    //是否冲突：0=false,1=true
    private int isConflict;
    
    //第几节课
    private int index;
    
    //已完成课结数
    private int finishedLessons;
    
    //总学生数
    private int totalStudents;

    //课类型  1班课  2一对一
    private int courseType;

    //1v1学员是否已经退班 0没有  1已退班
    private int studentStatus;
}

    