/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.dto.response;

import com.baijia.tianxiao.annotation.Show;
import com.baijia.tianxiao.constants.OrgCourseStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * @author shanyu
 * @version 1.0
 * @title CourseListInfoDto
 * @desc 机构课程列表
 * @date 2015年12月28日
 */
@Data
public class CourseListInfoDtoForVip {

    private String color; // 颜色

    private Long orgCourseId; // 课程ID

    private Long courseId; // 课程ID

    public void setOrgCourseId(Long orgCourseId) {
        this.orgCourseId = orgCourseId;
        this.courseId = orgCourseId;
    }

    private Long orgCourseNumber; // 课程number

    private String courseUrl; // 课程url

    public void setCoverUrl(String coverUrl) {
        if (StringUtils.isBlank(coverUrl)) {
            this.coverUrl = TianXiaoConstant.DEFAULT_CLASS_COVER;
        } else {
            this.coverUrl = coverUrl;
        }
    }

    @Show(name = "封面", lock = 1, operate = 0)
    private String coverUrl; // 课程url

    @Show(name = "课程名称", poName = "name")
    private String courseName; // 课程名称

    private String courseNamePinYin;

    @Show(name = "招生情况", operate = 0)
    public String getEnrollState() {
        return studentCount + "";//1v1直接展示学生人数
    }

    private Integer maxStudent; // 最大学生数

    private Integer studentCount; // 学生数量

    private Integer teacherCount; // 老师数量

    private Integer roomCount; // 教室数量

    private Integer lessonCount;// 排课课节

    @Show(name = "添加时间", poName = "createTime", type = 2)
    private Date createTime;//添加时间

    @Show(name = "课次单价", type = 1, poName = "price")
    private Double oneLessonPrice;

    @Show(name = "老师", operate = 0)
    private String teacherNames;

    @Show(name = "课消规则", operate = 0)
    private String consumerRule;

    @Show(name = "状态", poName = "status")
    private String statusStr;

    private Integer status;

    private Integer courseType;

    public void setStatus(Integer status) {
        this.status = status;
        statusStr = OrgCourseStatus.getNote(status);
    }

}
