
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.request;

import java.io.IOException;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.base.Preconditions;

import lombok.Data;

/**
 * @title EditLessonRequestDto
 * @desc TODO
 * @author cxm
 * @date 2016年1月3日
 * @version 1.0
 */
@Data
public class EditLessonRequestDto {

    private Long lessonId;

    private Long lessonDay;

    private String startTime;

    private String endTime;

    private Long teacherId;

    private Long roomId;

    private String studentIds;

    private LessonTime lessonTime;

    public Date getStartTime() {
        return this.initLessonTime().getStartTime();
    }

    public Date getEndTime() {
        return initLessonTime().getEndTime();
    }

    private LessonTime initLessonTime() {
        if (this.lessonTime == null) {
            if (this.lessonDay == null || this.lessonDay <= 0) {
                throw new IllegalArgumentException("课节的所在日期不正确");
            }
            Date date = new Date(lessonDay);
            if (date.after(TianXiaoConstant.MAX_TIMESTAMP_CALEN.getTime())) {
                throw new IllegalArgumentException("课节的所在日期请不要超过2037年1月1日");
            }
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            if (StringUtils.isBlank(this.startTime)) {
                throw new IllegalArgumentException("课节开始时间不能为空,格式为HH:mm");
            }
            if (StringUtils.isBlank(this.endTime)) {
                throw new IllegalArgumentException("课节结束时间不能为空,格式为HH:mm");
            }
            this.lessonTime = new LessonTime(cal, TimeStamp.parse(this.startTime), TimeStamp.parse(this.endTime));
        }
        return this.lessonTime;
    }

    public Collection<Long> getStudentIds() {
        if (StringUtils.isBlank(this.studentIds)) {
            return Collections.emptyList();
        }
        try {
            return JacksonUtil.str2List(this.studentIds, Long.class);
        } catch (IOException e) {
            throw new IllegalArgumentException("学生ID数组参数格式不正确");
        }
    }

    public void validate() {
        // Date now = new Date();
        Preconditions.checkArgument(this.getLessonId() != null && this.getLessonId() > 0, "课节ID不正确");
        Preconditions.checkArgument(this.getStartTime().before(getEndTime()), "课节结束时间不能早于开始时间");
    }
}
