
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.request;

import com.baijia.tianxiao.biz.erp.constant.RepeatUnit;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.google.common.collect.Sets;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.commons.lang3.time.DateUtils;

import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Set;

/**
 * @title AddCourseLessonRequestDtoForPC
 * @desc TODO
 * @author zhangrui
 */
@Data
public class AddCourseLessonRequestDtoForPC {

    private Long lessonId;

    /**
     * 课节开始日期
     */
    private Long startDay;

    private transient Date startDayTime;

    /**
     * 课节结束日期
     */
    private Long endDay;

    private transient Date endDayTime;

    private String startTime;

    private String endTime;

    private int enableRepeat;

    private Integer repeatUnit;

    private String weekDays;

    private String calendarDays;

    private Integer repeatRange;

    private Integer repeatCount;

    private Long courseId;

    private Long roomId;

    private Long teacherId;

    private String studentIds;

    public RepeatUnit getRepeatUnit() {
        RepeatUnit result = RepeatUnit.getByCode(this.repeatUnit);
        if (result == null) {
            result = RepeatUnit.NONE;
        }
        return result;
    }

    public Collection<Long> getStudentIds() {
        Set idsSet = Sets.newHashSet();
        if (StringUtils.isNotBlank(this.studentIds)) {
            String[] ids = StringUtils.split(this.studentIds.trim(),",");
            for(String id:ids){
                idsSet.add(NumberUtils.toLong(id));
            }
        }
        return idsSet;
    }

    public OrgClassLesson conver2Po(Long orgId, Date startTime, Date endTime) {
        OrgClassLesson lesson = new OrgClassLesson();
        lesson.setId(lessonId);
        lesson.setCourseId(courseId);
        lesson.setDelStatus(DataStatus.NORMAL.getValue());
        lesson.setEndTime(endTime);
        lesson.setOrgId(orgId);
        lesson.setRoomId(roomId);
        lesson.setStartTime(startTime);
        lesson.setUpdateTime(new Date());
        return lesson;
    }

    public void validate() {
        if (startDay == null || startDay <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节开始日期不能为空");
        }
        startDayTime = new Date(startDay);

        if (endDay != null && endDay > 0) {
            endDayTime = new Date(endDay);
        }

        if (courseId == null || courseId < 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级的ID不正确");
        }

        if (StringUtils.isBlank(startTime) || StringUtils.isBlank(endTime)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节开始时间和结束时间不能为空");
        }

        try {
            if (DateUtils.parseDate(startTime,"HH:mm").after(DateUtils.parseDate(endTime,"HH:mm"))) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节结束时间不能早于开始时间");
            }
        } catch (ParseException e) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "上课/下课时间格式错误");
        }
        if (enableRepeat == 1) {
            RepeatUnit unit = getRepeatUnit();
            if (unit == null) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "重复的时间粒度错误");
            }

            if(unit == RepeatUnit.CalendarDIY && StringUtils.isEmpty(calendarDays)){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "请勾选日期");
            }

            if(unit == RepeatUnit.WeekDIY && StringUtils.isEmpty(weekDays)){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "请选择每周几重复");
            }

            if (repeatCount == null || repeatCount <= 0 || repeatCount > 99) {
                if(unit != RepeatUnit.CalendarDIY){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "重复课节数范围1-99");
                }
            }

            if (repeatRange == null || repeatRange <= 0) {
                if(unit != RepeatUnit.CalendarDIY){
                    throw new BussinessException(CommonErrorCode.PARAM_ERROR, "重复课节的时间范围不能小于0");
                }
            }

        }
    }

}
