
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.request;

import java.io.IOException;
import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;

import org.apache.commons.lang3.StringUtils;

import com.baijia.tianxiao.biz.erp.constant.RepeatUnit;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.util.json.JacksonUtil;

import lombok.Data;
import org.apache.commons.lang3.time.DateUtils;

/**
 * @title AddCourseLessonRequestDto
 * @desc TODO
 * @author cxm
 * @date 2015年12月28日
 * @version 1.0
 */
@Data
public class AddCourseLessonRequestDto {

    private Long lessonId;

    /**
     * 课节开始日期
     */
    private Long startDay;

    private transient Date startDayTime;

    /**
     * 课节结束日期
     */
    private Long endDay;

    private transient Date endDayTime;

    private String startTime;

    private String endTime;

    private int enableRepeat;

    private Integer repeatUnit;

    private Integer repeatRange;

    private Integer repeatCount;

    private Long courseId;

    private Long roomId;

    private Long teacherId;

    private String studentIds;

    public RepeatUnit getRepeatUnit() {
        RepeatUnit result = RepeatUnit.getByCode(this.repeatUnit);
        if (result == null) {
            result = RepeatUnit.NONE;
        }
        return result;
    }

    public Collection<Long> getStudentIds() {
        if (StringUtils.isBlank(this.studentIds)) {
            return Collections.emptyList();
        }
        try {
            return JacksonUtil.str2List(this.studentIds, Long.class);
        } catch (IOException e) {
            throw new IllegalArgumentException("学生ID数组参数格式不正确");
        }
    }

    public OrgClassLesson conver2Po(Long orgId, Date startTime, Date endTime) {
        OrgClassLesson lesson = new OrgClassLesson();
        lesson.setId(lessonId);
        lesson.setCourseId(courseId);
        lesson.setDelStatus(DataStatus.NORMAL.getValue());
        lesson.setEndTime(endTime);
        lesson.setOrgId(orgId);
        lesson.setRoomId(roomId);
        lesson.setStartTime(startTime);
        lesson.setUpdateTime(new Date());
        return lesson;
    }

    public void validate() {
        if (startDay == null || startDay <= 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节开始日期不能为空");
        }
        startDayTime = new Date(startDay);

        if (endDay != null && endDay > 0) {
            endDayTime = new Date(endDay);
        }

        if (courseId == null || courseId < 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级的ID不正确");
        }

        if (StringUtils.isBlank(startTime) || StringUtils.isBlank(endTime)) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节开始时间和结束时间不能为空");
        }

        try {
            if (DateUtils.parseDate(startTime,"HH:mm").after(DateUtils.parseDate(endTime,"HH:mm"))) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节结束时间不能早于开始时间");
            }
        } catch (ParseException e) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "上课/下课时间格式错误");
        }

        if (enableRepeat == 1) {
            if (repeatCount == null || repeatCount <= 0 || repeatCount > 99) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "重复课节数范围1-99");
            }

            if (repeatRange == null || repeatRange <= 0) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "重复课节的时间范围不能小于0");
            }

            RepeatUnit unit = getRepeatUnit();
            if (unit == null || unit.getCode() > RepeatUnit.Year.getCode()) {
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "重复的时间粒度错误");
            }
        }
    }

}
