package com.baijia.tianxiao.biz.erp.dto;

import java.util.Calendar;
import java.util.Date;

import com.baijia.tianxiao.util.date.TimeStamp;

import lombok.Data;
import lombok.NonNull;

/**
 * 
 * @title LessonTime
 * @desc 课程的时间
 * @author cxm
 * @date 2015年10月15日
 * @version 1.0
 */
@Data
public class LessonTime {

    private Date startTime;

    private Date endTime;

    public LessonTime(@NonNull Calendar cal, TimeStamp startTimeStamp, TimeStamp endTimeStamp) {
        this.startTime = createDateTime(cal, startTimeStamp);
        this.endTime = createDateTime(cal, endTimeStamp);
    }

    public LessonTime(Date startTime, Date endTime) {
        this.startTime = startTime;
        this.endTime = endTime;
    }

    public static Date createDateTime(@NonNull Calendar cal, TimeStamp timeStamp) {
        if (timeStamp != null) {
            if (timeStamp.getHour() >= 0) {
                cal.set(Calendar.HOUR_OF_DAY, timeStamp.getHour());
            }

            if (timeStamp.getMinute() >= 0) {
                cal.set(Calendar.MINUTE, timeStamp.getMinute());
            }

            if (timeStamp.getSecond() >= 0) {
                cal.set(Calendar.SECOND, timeStamp.getSecond());
            }
        }
        return cal.getTime();
    }
}