/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.RoomClassLessonService;
import com.baijia.tianxiao.constant.BooleanEnum;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.solr.dto.ClassRoomQueryParam;
import com.baijia.tianxiao.dal.solr.dto.ClassRoomSolrDto;
import com.baijia.tianxiao.dal.solr.query.ClassRoomQuery;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.solr.client.solrj.SolrServerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class RoomClassLessonServiceImpl
implements RoomClassLessonService {
    private static final Logger log = LoggerFactory.getLogger(RoomClassLessonServiceImpl.class);
    private static final int ORDER_BY_ARRANGED_MINUTE_DESC = 3;
    private static final int ORDER_BY_ARRANGED_MINUTE_ASC = 4;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private ClassRoomQuery classRoomQuery;

    @Override
    public List<ClassRoomDto> getOrgClassRoomsListFromSolr(ClassRoomQueryParam param, PageDto pageDto) {
        try {
            return this.getOrgClassRoomsList(param, pageDto);
        }
        catch (Exception e) {
            log.info("query from solr ,ClassRoomQueryParam is : {} ", (Object)param);
            List list = null;
            try {
                list = this.classRoomQuery.queryClassRoom(param, pageDto);
            }
            catch (Exception e1) {
                log.debug("solr exception : {}", (Throwable)e1);
            }
            if (CollectionUtils.isEmpty((Collection)list)) {
                return Collections.EMPTY_LIST;
            }
            List roomIds = ListUtil.toKeyList((Collection)list, (String)"roomId", ClassRoomSolrDto.class);
            Set<Long> tags = this.tagForClassRecord(param.getOrgId(), roomIds);
            return this.buildClassRoomDto(list, tags);
        }
    }

    private List<ClassRoomDto> buildClassRoomDto(List<ClassRoomSolrDto> list, Set<Long> tags) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isEmpty(list)) {
            return result;
        }
        for (ClassRoomSolrDto solrDto : list) {
            ClassRoomDto dto = new ClassRoomDto();
            dto.setOrgId(solrDto.getOrgId());
            dto.setRoomId(solrDto.getRoomId());
            dto.setRoomName(solrDto.getRoomName());
            dto.setRoomSize(solrDto.getRoomSize());
            dto.setDelStatus(solrDto.getDelStatus() != 0);
            dto.setCreateTime(solrDto.getCreateTime());
            dto.setRecycleTime(solrDto.getRecycleTime());
            dto.setRecycleStatus(solrDto.getRecycleStatus());
            dto.setArrangedCount(solrDto.getArrangedCount());
            dto.setArrangedMinutes(solrDto.getArrangedMinutes());
            Integer tag = tags.contains(solrDto.getRoomId()) ? BooleanEnum.TRUE.getStatus() : BooleanEnum.FALSE.getStatus();
            dto.setClassRecord(tag);
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<ClassRoomDto> getOrgClassRoomsList(ClassRoomQueryParam param, PageDto pageDto) {
        log.info("query from db ,ClassRoomQueryParam is : {} ", (Object)param);
        Integer order = param.getOrder();
        List classRooms = order != null && (order == 3 || order == 4) ? this.orgClassRoomDao.getOrgClassRoomsList(param.getOrgId(), null, param.getRecycleStatus(), order, param.getRoomName(), null) : this.orgClassRoomDao.getOrgClassRoomsList(param.getOrgId(), null, param.getRecycleStatus(), order, param.getRoomName(), pageDto);
        if (CollectionUtils.isEmpty((Collection)classRooms)) {
            return Collections.emptyList();
        }
        List allRoomId = ListUtil.toKeyList((Collection)classRooms, (String)"id", OrgClassRoom.class);
        log.debug("[order]={}   [classRoomSize]={}", (Object)param.getOrder(), (Object)allRoomId.size());
        List allClassId = this.orgCourseRoomDao.getcoursIdsByRoomIds((Collection)allRoomId);
        Date start = DateUtil.getFirstDate((Date)new Date());
        Date end = DateUtil.getNextMonthFirstDate((Date)new Date());
        Map counts = this.orgClassLessonDao.getRoomArrangedCount((Collection)allClassId, start, end);
        Map minutes = this.orgClassLessonDao.getRoomArrangedMinute((Collection)allClassId, start, end);
        Set<Long> tags = this.tagForClassRecord(param.getOrgId(), allRoomId);
        List<ClassRoomDto> result = this.getRoomResutlList(classRooms, counts, minutes, tags);
        if (order != null && (order == 3 || order == 4)) {
            return this.sortByMinutes(order, result, pageDto);
        }
        return result;
    }

    private Set<Long> tagForClassRecord(Long orgId, List<Long> allRoomId) {
        Map map = this.orgClassLessonDao.getRoomClassRecordCount(orgId, allRoomId);
        HashSet roomLessonSet = Sets.newHashSet();
        for (Long l : map.keySet()) {
            if ((Integer)map.get(l) <= 0) continue;
            roomLessonSet.add(l);
        }
        return roomLessonSet;
    }

    private List<ClassRoomDto> getRoomResutlList(List<OrgClassRoom> classRooms, Map<Long, Integer> counts, Map<Long, Integer> minutes, Set<Long> tags) {
        ArrayList result = Lists.newArrayList();
        for (OrgClassRoom classRoom : classRooms) {
            ClassRoomDto dto = ClassRoomDto.covert2Dto((OrgClassRoom)classRoom);
            dto.setArrangedCount(counts.containsKey(classRoom.getId()) ? counts.get(classRoom.getId()) : Integer.valueOf(0));
            dto.setArrangedMinutes(minutes.containsKey(classRoom.getId()) ? minutes.get(classRoom.getId()) : Integer.valueOf(0));
            Integer tag = tags.contains(classRoom.getId()) ? BooleanEnum.TRUE.getStatus() : BooleanEnum.FALSE.getStatus();
            dto.setClassRecord(tag);
            result.add(dto);
        }
        return result;
    }

    private List<ClassRoomDto> sortByMinutes(Integer order, List<ClassRoomDto> result, PageDto pageDto) {
        if (CollectionUtils.isEmpty(result) || pageDto == null) {
            return result;
        }
        if (order == 3) {
            Collections.sort(result, new Comparator<ClassRoomDto>(){

                @Override
                public int compare(ClassRoomDto o1, ClassRoomDto o2) {
                    return o2.compare(o1);
                }
            });
        } else if (order == 4) {
            Collections.sort(result, new Comparator<ClassRoomDto>(){

                @Override
                public int compare(ClassRoomDto o1, ClassRoomDto o2) {
                    return o1.compare(o2);
                }
            });
        }
        int start = (pageDto.getPageNum() - 1) * pageDto.getPageSize();
        int end = start + pageDto.getPageSize();
        if (end > result.size()) {
            end = result.size();
        }
        if (start > result.size()) {
            return null;
        }
        return result.subList(start, end);
    }

    @Override
    public void dealClassRoomArranged(List<OrgClassRoom> list) {
        log.debug("[OrgClassRoom size]={}", (Object)list.size());
        List allRoomIds = ListUtil.toKeyList(list, (String)"id", OrgClassRoom.class);
        List allClassId = this.orgCourseRoomDao.getcoursIdsByRoomIds((Collection)allRoomIds);
        Date start = DateUtil.getFirstDate((Date)new Date());
        Date end = DateUtil.getNextMonthFirstDate((Date)new Date());
        Map counts = this.orgClassLessonDao.getRoomArrangedCount((Collection)allClassId, start, end);
        Map minutes = this.orgClassLessonDao.getRoomArrangedMinute((Collection)allClassId, start, end);
        log.debug("[arranged minute ]={}", (Object)minutes);
        for (OrgClassRoom room : list) {
            Integer count = (Integer)counts.get(room.getId());
            Integer minute = (Integer)minutes.get(room.getId());
            HashMap map = Maps.newHashMap();
            map.put("ID", room.getId() + "");
            map.put("ROOM_SIZE", room.getRoomSize() + "");
            map.put("ORG_ID", room.getOrgId() + "");
            map.put("ROOM_NAME", room.getRoomName());
            map.put("DEL_STATUS", room.isDelStatus() ? "1" : "0");
            map.put("RECYCLE_STATUS", room.getRecycleStatus() + "");
            map.put("CREATE_TIME", room.getCreateTime() + "");
            map.put("RECYCLE_TIME", room.getRecycleTime() == null ? null : room.getRecycleTime() + "");
            map.put("ARRANGED_COUNT", count == null ? null : count + "");
            map.put("ARRANGED_MINUTES", minute == null ? null : minute + "");
            try {
                this.classRoomQuery.insertNewRow((Map)map);
            }
            catch (SolrServerException e) {
                log.warn("[insert into solr catch exception]={}", (Throwable)e);
            }
            catch (IOException e) {
                log.warn("[insert into solr catch exception]={}", (Throwable)e);
            }
        }
    }
}

