/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.FinanceDataService;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpTo;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FinanceDataServiceImpl
implements FinanceDataService {
    private static final Logger log = LoggerFactory.getLogger(FinanceDataServiceImpl.class);
    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;

    @Override
    public List<TxSignupRecordDay> checkErrorSignupData() {
        Integer maxId = this.txSignupRecordDayDao.maxSignupRecordId();
        log.info("finance data get Error signup record = {}", (Object)maxId);
        ArrayList result = Lists.newArrayList();
        long recordId = INIT_SIGNUP_RECORED.intValue();
        while (recordId < (long)maxId.intValue()) {
            List txSignupRecordDayList = this.txSignupRecordDayDao.getTxSignupRecordListByMinId(Long.valueOf(recordId), null, 100, new String[0]);
            for (TxSignupRecordDay txSignupRecordDay : txSignupRecordDayList) {
                recordId = txSignupRecordDay.getId();
                if (txSignupRecordDay.getOpTo() == FinanceOpTo.EXPEND.getCode()) continue;
                Long dateSignupDayPrice = this.txSignupRecordDayDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate((Date)txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());
                Long dateSignupPrice = this.orgSignupInfoDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate((Date)txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());
                log.info("finance data checkout error signup data :{},{},{}", new Object[]{txSignupRecordDay, dateSignupPrice == null ? 0L : dateSignupPrice, dateSignupDayPrice});
                if (dateSignupPrice != null && dateSignupPrice.longValue() == dateSignupDayPrice.longValue()) continue;
                result.add(txSignupRecordDay);
            }
        }
        return result;
    }

    @Override
    public void dealErrorSignuoData(Long orgId, String mdate) {
        for (SignupSourceType signupSourceType : SignupSourceType.values()) {
            TxSignupRecordDay txSignupRecordDay;
            Long dateSignupPrice = this.orgSignupInfoDao.getSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            Integer numSignupPrice = this.orgSignupInfoDao.countSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            if (dateSignupPrice == null || numSignupPrice == null || dateSignupPrice <= 0L || numSignupPrice <= 0 || (txSignupRecordDay = this.txSignupRecordDayDao.getByDayType(orgId, mdate, signupSourceType.getCode().intValue(), FinanceOpTo.INCOME.getCode().intValue(), new String[0])) == null) continue;
            txSignupRecordDay.setOpPrice(Double.valueOf(dateSignupPrice.doubleValue() / 100.0));
            txSignupRecordDay.setOpCount(numSignupPrice);
            log.info("deal error signup data from {},{},{},to=={}", new Object[]{orgId, mdate, signupSourceType.getCode(), txSignupRecordDay});
            this.txSignupRecordDayDao.update((Object)txSignupRecordDay, new String[]{"opPrice", "opCount"});
        }
    }

    @Override
    public List<TxSignupRecordDay> checkErrorFianaceInfo() {
        Integer maxId = this.orgFinanceAccountRecordDao.maxFinanceInfoRecordId();
        log.info("finance data get Error finance info = {}", (Object)maxId);
        ArrayList result = Lists.newArrayList();
        long recordId = INIT_FINANCE_RECORED.intValue();
        while (recordId < (long)maxId.intValue()) {
            List txSignupRecordDayList = this.txSignupRecordDayDao.getTxSignupRecordListByMinId(Long.valueOf(recordId), null, 100, new String[0]);
            for (TxSignupRecordDay txSignupRecordDay : txSignupRecordDayList) {
                recordId = txSignupRecordDay.getId();
                if (txSignupRecordDay.getOpTo() == FinanceOpTo.EXPEND.getCode()) continue;
                Long dateSignupDayPrice = this.txSignupRecordDayDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate((Date)txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());
                Long dateSignupPrice = this.orgSignupInfoDao.getSignupPriceByDay(txSignupRecordDay.getOrgId(), DateUtil.getStrByDate((Date)txSignupRecordDay.getMdate()), txSignupRecordDay.getOpType());
                log.info("finance data checkout error signup data :{},{},{}", new Object[]{txSignupRecordDay, dateSignupPrice == null ? 0L : dateSignupPrice, dateSignupDayPrice});
                if (dateSignupPrice != null && dateSignupPrice.longValue() == dateSignupDayPrice.longValue()) continue;
                result.add(txSignupRecordDay);
            }
        }
        return result;
    }

    @Override
    public void dealErrorFinanceInfo(Long orgId, String mdate) {
        for (SignupSourceType signupSourceType : SignupSourceType.values()) {
            TxSignupRecordDay txSignupRecordDay;
            Long dateSignupPrice = this.orgSignupInfoDao.getSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            Integer numSignupPrice = this.orgSignupInfoDao.countSignupPriceByDay(orgId, mdate, signupSourceType.getCode());
            if (dateSignupPrice == null || numSignupPrice == null || dateSignupPrice <= 0L || numSignupPrice <= 0 || (txSignupRecordDay = this.txSignupRecordDayDao.getByDayType(orgId, mdate, signupSourceType.getCode().intValue(), FinanceOpTo.INCOME.getCode().intValue(), new String[0])) == null) continue;
            txSignupRecordDay.setOpPrice(Double.valueOf(dateSignupPrice.doubleValue() / 100.0));
            txSignupRecordDay.setOpCount(numSignupPrice);
            log.info("deal error signup data from {},{},{},to=={}", new Object[]{orgId, mdate, signupSourceType.getCode(), txSignupRecordDay});
            this.txSignupRecordDayDao.update((Object)txSignupRecordDay, new String[]{"opPrice", "opCount"});
        }
    }
}

