/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.vo.ImportStudent;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.util.date.DateUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErpStudentImportServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(ErpStudentImportServiceImpl.class);
    private OrgStudentService orgStudentService;
    private OrgStudentCourseService orgStudentCourseService;
    private OrgStudentLessonDao orgStudentLessonDao;
    private OrgCourseService orgCourseService;
    private OrgClassLessonDao orgClassLessonDao;
    private OrgSignupCourseService orgSignupCourseService;
    private OrgSignupCourseLessonService signupCourseLessonService;

    public void excelImport(Long orgId, Integer cascadeId, List<ImportStudent> importStudents) {
        ArrayList courseNames = Lists.newArrayList();
        ArrayList studentMobiles = Lists.newArrayList();
        for (ImportStudent importStudent : importStudents) {
            courseNames.add(importStudent.getCourseName());
            studentMobiles.add(importStudent.getStudentMobile());
        }
        long between0 = 0L;
        long between1 = 0L;
        long between2 = 0L;
        long addStudentTime = 0L;
        long addLessonTime = 0L;
        Date begin0 = new Date();
        Map orgCoursesMap = this.orgCourseService.getAllOrgCoursesMapByNames_class(Long.valueOf(orgId), (List)courseNames);
        ArrayList orgCourseIds = Lists.newArrayList();
        for (OrgCourse orgCourse : orgCoursesMap.values()) {
            orgCourseIds.add(orgCourse.getId());
        }
        Map orgClassLessonsMap = this.orgClassLessonDao.querylessonsByStartTime(new Date(), (Collection)orgCourseIds, Long.valueOf(orgId));
        Map endLessonsMap = this.orgClassLessonDao.queryEndedlessons((Collection)orgCourseIds, Long.valueOf(orgId));
        Date end0 = new Date();
        between0 = end0.getTime() - begin0.getTime();
        if (CollectionUtils.isNotEmpty(importStudents)) {
            for (ImportStudent importStudent : importStudents) {
                OrgSignupCourse orgSignupCourse = null;
                try {
                    String courseName = importStudent.getCourseName();
                    OrgCourse orgCourse = (OrgCourse)orgCoursesMap.get(courseName);
                    Long orgCourseId = orgCourse.getId();
                    List orgClassLessons = new ArrayList();
                    List endLessons = new ArrayList();
                    if (MapUtils.isNotEmpty((Map)orgClassLessonsMap)) {
                        orgClassLessons = (List)orgClassLessonsMap.get(orgCourseId);
                    }
                    if (MapUtils.isNotEmpty((Map)endLessonsMap) && endLessonsMap.get(orgCourseId) != null) {
                        endLessons = (List)endLessonsMap.get(orgCourseId);
                    }
                    Date begin1 = new Date();
                    StudentInfoDto orgStudent = null;
                    List dtos = this.orgStudentService.listOrgStudentByMobile(Long.valueOf(orgId), importStudent.getStudentMobile().toString());
                    if (CollectionUtils.isNotEmpty((Collection)dtos)) {
                        for (StudentInfoDto dto : dtos) {
                            if (!importStudent.getStudentMobile().equals(dto.getMobile()) || !importStudent.getStudentName().equals(dto.getName())) continue;
                            log.debug("*************can find dto:{}", (Object)dto);
                            orgStudent = dto;
                        }
                    }
                    if (orgStudent == null) {
                        orgStudent = new StudentInfoDto();
                        orgStudent.setMobile(importStudent.getStudentMobile().toString());
                        orgStudent.setName(importStudent.getStudentName().toString());
                        orgStudent.setAddCascadeId(Integer.valueOf(cascadeId == null ? 0 : cascadeId));
                        OrgStudentAddresponseDto addDto = this.orgStudentService.addStudentIgnoreExistMobile(orgStudent, null, null, Long.valueOf(orgId));
                        orgStudent.setStudentId(addDto.getUserId());
                    }
                    log.debug("**************orgStudent:{}", (Object)orgStudent);
                    Date end1 = new Date();
                    between1 = end1.getTime() - begin1.getTime();
                    addStudentTime += between1;
                    OrgStudentCourse orgStudentCourse = this.orgStudentCourseService.getBySidAndCid(Long.valueOf(orgId), orgStudent.getStudentId(), orgCourse.getId());
                    if (orgStudentCourse == null) {
                        orgStudentCourse = new OrgStudentCourse();
                        orgStudentCourse.setCourseId(orgCourse.getId());
                        orgStudentCourse.setRealCourseId(orgCourse.getId());
                        orgStudentCourse.setCreateTime(new Date());
                        orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                        orgStudentCourse.setOrgId(Long.valueOf(orgId));
                        orgStudentCourse.setStudentMobile(orgStudent.getMobile());
                        orgStudentCourse.setStudentName(orgStudent.getName());
                        orgStudentCourse.setUserId(orgStudent.getStudentId());
                        orgStudentCourse.setLessonCount(importStudent.getLessonCount());
                        orgStudentCourse.setStatus(Integer.valueOf(0));
                        this.orgStudentCourseService.saveOrgStudentCourse(orgStudentCourse);
                        orgSignupCourse = this.orgSignupCourseService.saveOrgSignupCourseByExcel(Long.valueOf(orgId), null, orgCourse, orgStudent.getStudentId(), importStudent.getLessonCount(), importStudent.getPayPrice());
                    } else {
                        if (orgStudentCourse.getDelStatus().intValue() != DeleteStatus.DELETED.getValue() && orgStudentCourse.getStatus() == 0) {
                            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u7cfb\u7edf\u4e2d\u8be5\u8bfe\u7a0b\u5df2\u6709\u8be5\u5b66\u5458\uff0c\u65e0\u6cd5\u5bfc\u5165");
                        }
                        if (orgStudentCourse.getDelStatus().intValue() == DeleteStatus.DELETED.getValue()) {
                            orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
                        }
                        if (orgStudentCourse.getStatus() != 0) {
                            orgStudentCourse.setStatus(Integer.valueOf(0));
                        }
                        orgStudentCourse.setLessonCount(Integer.valueOf(orgStudentCourse.getLessonCount() + importStudent.getLessonCount()));
                        this.orgStudentCourseService.updateOrgStudentCourse(orgStudentCourse);
                        orgSignupCourse = this.orgSignupCourseService.saveOrgSignupCourseByExcel(Long.valueOf(orgId), null, orgCourse, orgStudent.getStudentId(), importStudent.getLessonCount(), importStudent.getPayPrice());
                    }
                    if (CollectionUtils.isNotEmpty(orgClassLessons)) {
                        Integer insertCount;
                        OrgStudentLesson orgStudentLesson;
                        OrgClassLesson orgClassLesson3;
                        ArrayList orgStudentLessons = Lists.newArrayList();
                        if (importStudent.getInsertCount() == null && importStudent.getLessonCount() == null) {
                            for (Object orgClassLesson2 : orgClassLessons) {
                                OrgStudentLesson orgStudentLesson2 = this.createStudentLesson((long)orgId, (OrgClassLesson)orgClassLesson2, orgStudent);
                                orgStudentLessons.add(orgStudentLesson2);
                            }
                        } else if (importStudent.getLessonCount() != null && importStudent.getInsertCount() == null) {
                            Integer lessonCount = Integer.valueOf(importStudent.getLessonCount().toString());
                            if (lessonCount >= orgClassLessons.size()) {
                                Object orgClassLesson2;
                                orgClassLesson2 = orgClassLessons.iterator();
                                while (orgClassLesson2.hasNext()) {
                                    orgClassLesson3 = (OrgClassLesson)orgClassLesson2.next();
                                    orgStudentLesson = this.createStudentLesson((long)orgId, orgClassLesson3, orgStudent);
                                    orgStudentLessons.add(orgStudentLesson);
                                }
                            } else {
                                for (int i = 0; i < lessonCount; ++i) {
                                    orgClassLesson3 = (OrgClassLesson)orgClassLessons.get(i);
                                    orgStudentLesson = this.createStudentLesson((long)orgId, orgClassLesson3, orgStudent);
                                    orgStudentLessons.add(orgStudentLesson);
                                }
                            }
                        } else if (importStudent.getLessonCount() == null && importStudent.getInsertCount() != null) {
                            insertCount = Integer.valueOf(importStudent.getInsertCount().toString());
                            if (insertCount > endLessons.size()) {
                                for (int point = insertCount - endLessons.size() - 1; point < orgClassLessons.size(); ++point) {
                                    orgClassLesson3 = (OrgClassLesson)orgClassLessons.get(point);
                                    orgStudentLesson = this.createStudentLesson((long)orgId, orgClassLesson3, orgStudent);
                                    orgStudentLessons.add(orgStudentLesson);
                                }
                            } else {
                                for (OrgClassLesson orgClassLesson3 : orgClassLessons) {
                                    orgStudentLesson = this.createStudentLesson((long)orgId, orgClassLesson3, orgStudent);
                                    orgStudentLessons.add(orgStudentLesson);
                                }
                            }
                        } else if (importStudent.getLessonCount() != null && importStudent.getInsertCount() != null) {
                            insertCount = Integer.valueOf(importStudent.getInsertCount().toString());
                            Integer lessonCount = Integer.valueOf(importStudent.getLessonCount().toString());
                            int start = 0;
                            int end = lessonCount;
                            if (insertCount > endLessons.size()) {
                                start = insertCount - endLessons.size() - 1;
                                end = lessonCount + start;
                            }
                            if (end > orgClassLessons.size()) {
                                end = orgClassLessons.size();
                            }
                            while (start < end) {
                                OrgClassLesson orgClassLesson4 = (OrgClassLesson)orgClassLessons.get(start);
                                OrgStudentLesson orgStudentLesson3 = this.createStudentLesson((long)orgId, orgClassLesson4, orgStudent);
                                orgStudentLessons.add(orgStudentLesson3);
                                ++start;
                            }
                        }
                        Long studentId = orgStudent.getStudentId();
                        HashMap orgStudentLessonMap = Maps.newHashMap();
                        for (OrgStudentLesson orgStudentLesson4 : orgStudentLessons) {
                            Long lessonId = orgStudentLesson4.getLessonId();
                            orgStudentLessonMap.put(lessonId, orgStudentLesson4);
                        }
                        List orgStudentLessonsList = this.orgStudentLessonDao.getLessonsOfStudent(Long.valueOf(orgId), Long.valueOf(studentId), orgStudentLessonMap.keySet());
                        ArrayList updateList = Lists.newArrayList();
                        if (CollectionUtils.isNotEmpty((Collection)orgStudentLessonsList)) {
                            for (OrgStudentLesson orgStudentLessonDb : orgStudentLessonsList) {
                                Long lessonDbId = orgStudentLessonDb.getLessonId();
                                orgStudentLessonMap.remove(lessonDbId);
                                if (orgStudentLessonDb.getDelStatus() != 1) continue;
                                orgStudentLessonDb.setDelStatus(Integer.valueOf(0));
                                orgStudentLessonDb.setStartStatus(Integer.valueOf(0));
                                orgStudentLessonDb.setKexiaoStatus(Integer.valueOf(0));
                                orgStudentLessonDb.setUpdateTime(new Date());
                                updateList.add(orgStudentLessonDb);
                            }
                        }
                        if (CollectionUtils.isNotEmpty((Collection)updateList)) {
                            this.signupCourseLessonService.saveSignupCourseLessons(Long.valueOf(orgId), orgCourseId, (Collection)updateList, orgSignupCourse);
                            for (OrgStudentLesson orgStudentLesson3 : updateList) {
                                this.orgStudentLessonDao.update((Object)orgStudentLesson3, new String[0]);
                            }
                        }
                        if (MapUtils.isNotEmpty((Map)orgStudentLessonMap)) {
                            this.signupCourseLessonService.saveSignupCourseLessons(Long.valueOf(orgId), orgCourseId, orgStudentLessonMap.values(), orgSignupCourse);
                            for (OrgStudentLesson orgStudentLesson3 : orgStudentLessonMap.values()) {
                                try {
                                    this.orgStudentLessonDao.save((Object)orgStudentLesson3, new String[0]);
                                }
                                catch (Exception e) {
                                    log.error("save orgStudentLesson:{} failed", (Object)orgStudentLesson3);
                                }
                            }
                        }
                    }
                    Date end2 = new Date();
                    between2 = end2.getTime() - end1.getTime();
                    addLessonTime += between2;
                }
                catch (BussinessException be) {
                    log.warn("save importStudent error!,importStudent:{}", (Object)importStudent, (Object)be);
                    importStudent.setErrReason(be.getMessage());
                }
                catch (Exception e) {
                    log.error("save importStudent error!,importStudent:{}", (Object)importStudent, (Object)e);
                    importStudent.setErrReason("\u7cfb\u7edf\u65e0\u6cd5\u63d2\u5165\u6b64\u6570\u636e\uff0c\u8bf7\u8054\u7cfb\u5929\u6821\u5de5\u4f5c\u4eba\u5458\u4e3a\u60a8\u6392\u67e5");
                }
            }
            log.info("\u67e5\u8be2\u8017\u65f6\uff1a{} ms", (Object)between0);
            log.info("\u63d2\u5165\u5b66\u751f\u603b\u65f6\u95f4\uff1a{} ms", (Object)addStudentTime);
            log.info("\u63d2\u5165\u5b66\u751f\u8bfe\u7a0b\u3001\u8bfe\u7ed3\u7684\u603b\u65f6\u95f4\uff1a{} ms", (Object)addLessonTime);
        }
    }

    private OrgStudentLesson createStudentLesson(Long orgId, OrgClassLesson orgClassLesson, StudentInfoDto orgStudent) {
        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
        orgStudentLesson.setCreateTime(new Date());
        orgStudentLesson.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        orgStudentLesson.setLessonId(orgClassLesson.getId());
        orgStudentLesson.setOrgId(Long.valueOf(orgId));
        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
        orgStudentLesson.setStudentName(orgStudent.getName());
        orgStudentLesson.setUserId(orgStudent.getStudentId());
        orgStudentLesson.setCourseId(orgClassLesson.getCourseId());
        orgStudentLesson.setLessonDuration(Integer.valueOf(DateUtil.getMinuteDiff((Date)orgClassLesson.getStartTime(), (Date)orgClassLesson.getEndTime())));
        return orgStudentLesson;
    }
}

