package com.baijia.tianxiao.biz.erp.util;


import com.baijia.tianxiao.biz.erp.dto.CourseSigninRecordDto;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninRecordDto.StudentSigninRecord;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninStsDto;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninStsDto.StudentSigninSts;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.StudentSigninRecordDto;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.util.ExcelUtils;
import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;

import lombok.extern.slf4j.Slf4j;



/**
 * @title _4ClassSigninRecordStatistics
 * @desc TODO 
 * @author leiruiqi
 * @date 2016年7月28日
 * @version 1.0
 */

@Slf4j
public class _4ClassSigninRecordStatistics extends ExcelUtils implements ExcelConfig{
	
	public static final String BILL_BY_SIGNED = "IF(F%d>0,B%d*F%d,0)";
	public static final String BILL_BY_SIGNED_LEAVE = "IF(F%d>0,(B%d+C%d)*F%d,0)";
	public static final String BILL_BY_SIGNED_ABSENT = "IF(F%d>0,(B%d+D%d)*F%d,0)";
	public static final String BILL_BY_SIGNED_LEAVE_ABSENT = "IF(F%d>0,(B%d+C%d+D%d)*F%d,0)";
	/**
	 * @Description     : 班级签到结果 统计Excel
	 * @Modifier        : 
	 * @ModificationDate: 
	 *
	 * @Return void
	 */
	public static XSSFWorkbook excel(CourseSigninStsDto dto, String orgName, Date downloadTime){
		
		InputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
		
		try{
			in = Thread.currentThread().getContextClassLoader().getResourceAsStream(TEMPLATE_PATH_CLASS_SIGNINRECPDT_STS);
	        XSSFWorkbook workbook = new XSSFWorkbook(in);
	        XSSFSheet sheet = workbook.getSheetAt(0);
	        XSSFDrawing patriarch = (XSSFDrawing) sheet.createDrawingPatriarch();
	        
	        //1. 填充 基本信息
	        int lessonNum = dto.getLessonNum();
	        int planNum = dto.getPlanNum();
	        //fillTheXSSFCellWithStringValue(sheet, 2,1, null, EmojiFilter.filterEmoji(orgName));
	        fillTheXSSFCellWithStringValue(sheet, 2,1, null, EmojiFilter.filterEmoji(dto.getCourseName()));
	        fillTheXSSFCellWithStringValue(sheet, 3,1, null, lessonNum+"/"+planNum);
	        fillTheXSSFCellWithStringValue(sheet, 4,1, null, sdf.format(downloadTime));
	        
	        //2. 填充 标题栏
	        int titleRowNo = 8;
	        int titleStartCellNo = 1;
	        int titleEndCellNo = 5;
	        
	        Map<Integer,CellInfo> titleFormatMap = getCellInfoMap(sheet, titleRowNo, titleStartCellNo, titleStartCellNo);
	        XSSFCellStyle titleCellStyle = sheet.getRow(titleRowNo).getCell(titleStartCellNo).getCellStyle();
	        titleCellStyle.setWrapText(true);
	        int titleDemoCellWidth = sheet.getColumnWidth(titleEndCellNo);
	        
	        SimpleDateFormat datesdf = new SimpleDateFormat("yyyy-MM-dd");
	        SimpleDateFormat timesdf = new SimpleDateFormat("HH:mm");
	        
	        int i = 1;
            for(LessonResponseDto lesson:dto.getLessonCourseList()){
                int num = lesson.getIndex();
                fillTheXSSFCellWithStringValue(sheet, titleRowNo,titleEndCellNo-1+i,
                    decorateStyleWithDataFormatMap(titleEndCellNo,titleCellStyle,titleFormatMap),
                    String.format("第%d节\n%s  %s - %s\n%s\n%s",
                        num ,
                        datesdf.format(lesson.getLessonStartTime()),
                        timesdf.format(lesson.getLessonStartTime()),
                        timesdf.format(lesson.getLessonEndTime()),
                        StringUtils.isNotBlank(lesson.getRoomName())?lesson.getRoomName():"无教室",StringUtils.isNotBlank(lesson.getTeacherName())?lesson.getTeacherName():"无老师"
                      ));
                sheet.setColumnWidth(titleEndCellNo-1+i, titleDemoCellWidth);
                i++;
            }
	        
	        //3. 填充 数据列表
	        int demoRowNo = 9;
	        int demoCellStartNo = 0;
	        int demoCellEndNo = 2;
	        Map<Integer,CellInfo> demoFormatMap = getCellInfoMap(sheet, demoRowNo, demoCellStartNo, demoCellEndNo);
	        short demoRowHeight = sheet.getRow(demoRowNo).getHeight();
	        
	        List<StudentSigninSts> stuSigninStsList = dto.getStudentSigninStsList();
	        if( stuSigninStsList!=null && !stuSigninStsList.isEmpty() ){
	        	int rowNo = demoRowNo;
		        XSSFCellStyle cellStyle = sheet.getRow(rowNo).getCell(1).getCellStyle();
		        cellStyle.setWrapText(true);//强制换行
		        
	        	//设置边框
				if(ROW_WITH_BORDER){
			        fillCellStyleWithFullBorder(cellStyle, CellStyle.BORDER_THIN, IndexedColors.BLACK.getIndex());
		        }
				
				for(StudentSigninSts stuSigninSts:stuSigninStsList){
                    //设置行高
                    XSSFRow row = sheet.getRow(rowNo); 
                    if(sheet.getRow(rowNo) == null){
                        row = sheet.createRow(rowNo);
                    }
                    row.setHeight(demoRowHeight);
                    
                    int cellNo = demoCellStartNo-1;
                    
                    cellNo++; fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), EmojiFilter.filterEmoji(stuSigninSts.getStudentName()) );
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), stuSigninSts.getSignCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), stuSigninSts.getSignedCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), stuSigninSts.getLeaveCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), stuSigninSts.getAbsentCount());
                    Long userId = stuSigninSts.getUserId();
                    for(LessonResponseDto lesson:dto.getLessonCourseList()){
                        Long lessonId = lesson.getLessonId();
                        
                        cellNo++;
                        String studentSignKey = lessonId+"|"+userId;
                        Integer signStatusCode = dto.getSignInStatusMap().get(studentSignKey);
                        
                        if(signStatusCode == null){
                            signStatusCode = 0;
                        }
                        
                        SignStatus signInStatus = SignStatus.getSignStatusByCode(signStatusCode);
                        String signStatusName = "无签到记录";
                        if(signInStatus !=null && signInStatus != SignStatus.UNSIGN){
                            signStatusName = signInStatus.getMessage();
                        }
                        
                        fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(demoCellEndNo,cellStyle,demoFormatMap), signStatusName);
                    }
                    
                    
                    rowNo++;
                }
	        }
	        workbook.setSheetName(0, String.format("%s全部签到记录",dto.getCourseName()));
	        return workbook;
		}catch(Exception e){
			log.error("course signIn record export error ",e);
			return null;
		}
	}
	
	public static XSSFWorkbook excel(LessonTimeTableResponseDto dto, String orgName, Date downloadTime){
	    

        InputStream in = null;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
        
        try {
            in = Thread.currentThread().getContextClassLoader()
                .getResourceAsStream(TEMPLATE_PATH_LESSON_SIGNINRECPRD_STS);
            XSSFWorkbook workbook = new XSSFWorkbook(in);
            XSSFSheet sheet = workbook.getSheetAt(0);

            SimpleDateFormat datesdf = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat timesdf = new SimpleDateFormat("HH:mm");
            // 1. 填充 基本信息
            String courseName = dto.getCourseName();
            XSSFCellStyle titleCellStyle = sheet.getRow(0).getCell(0).getCellStyle();
            titleCellStyle.setWrapText(true);
          //设置边框
            if(ROW_WITH_BORDER){
                fillCellStyleWithFullBorder(titleCellStyle, CellStyle.BORDER_THIN, IndexedColors.BLACK.getIndex());
            }
            fillTheXSSFCellWithStringValue(sheet, 0, 0, titleCellStyle, String.format("%s课程签到记录\n签到课次:%s\n%s %s~%s\n%s\n%s",

                courseName, dto.getIndex(), datesdf.format(dto.getStartTime()), timesdf.format(dto.getStartTime()),
                timesdf.format(dto.getEndTime()), StringUtils.isNotBlank(dto.getRoomName()) ? dto.getRoomName() : "无教室",
                StringUtils.isNotBlank(dto.getTeacherName()) ? dto.getTeacherName() : "无老师"));
            
            int rowNo = 3;
            
            XSSFCellStyle cellStyle = sheet.getRow(rowNo).getCell(0).getCellStyle();
            cellStyle.setWrapText(true);//强制换行
            
            
            
            Map<Integer,CellInfo> demoFormatMap = getCellInfoMap(sheet, 3, 0, 2);
            for(OrgStudentsChooseListDto student:dto.getStudents()){
                
                
                String signStatusName = "无签到记录";
                SignStatus signInStatus = SignStatus.getSignStatusByCode(student.getSignStatus());
                if(signInStatus !=null && signInStatus!= SignStatus.UNSIGN){
                    signStatusName = signInStatus.getMessage();
                }
                
                Date signTime = student.getSignInTime();
                fillTheXSSFCellWithStringValue(sheet, rowNo,0, decorateStyleWithDataFormatMap(0,cellStyle,demoFormatMap), student.getName());
                fillTheXSSFCellWithStringValue(sheet, rowNo,1, decorateStyleWithDataFormatMap(1,cellStyle,demoFormatMap), signStatusName);
                fillTheXSSFCellWithStringValue(sheet, rowNo,2,decorateStyleWithDataFormatMap(2,cellStyle,demoFormatMap), signTime!=null?sdf.format(student.getSignInTime()):"~~" );
                
                rowNo++;
            }
            if(rowNo == 3){
                sheet.removeRow(sheet.getRow(rowNo));
            }
           
            workbook.setSheetName(0, String.format("第%s次签到记录",dto.getIndex()));
            return workbook;
            
        } catch (Exception e) {
            log.error("lesson signIn record export error ",e);
            return null;
        } 
	}
	
	
	/**
	 * @Description     : 班级签到详情 统计Excel
	 * @Modifier        : 
	 * @ModificationDate: 
	 *
	 * @Return void
	 */
	public static XSSFWorkbook excel(CourseSigninRecordDto dto, String orgName, Date downloadTime){
		
		InputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
		
		try{
			in = Thread.currentThread().getContextClassLoader().getResourceAsStream(TEMPLATE_PATH_CLASS_SIGNINRECPDT_STS);
	        XSSFWorkbook workbook = new XSSFWorkbook(in);
	        XSSFSheet sheet = workbook.getSheetAt(0);
	        XSSFDrawing patriarch = (XSSFDrawing) sheet.createDrawingPatriarch();
	        
	        //1. 填充 基本信息
	        Integer lessonNum = dto.getLessonNum();
	        Integer planNum = dto.getPlanNum();
	        if(planNum == null){
	            planNum = 0;
	        }
	        //fillTheXSSFCellWithStringValue(sheet, 2,1, null, EmojiFilter.filterEmoji(orgName));
	        fillTheXSSFCellWithStringValue(sheet, 1,1, null, EmojiFilter.filterEmoji(dto.getCourseName()));
	        fillTheXSSFCellWithStringValue(sheet, 2,1, null, sdf.format(downloadTime));
	        fillTheXSSFCellWithStringValue(sheet, 3,1, null, dto.getConsumeRuleStr());
	        //2. 填充 标题栏
	        int titleRowNo = 5;
	        int titleStartCellNo = 1;
	        int titleEndCellNo = 6;
	        
	        Map<Integer,CellInfo> titleFormatMap = getCellInfoMap(sheet, titleRowNo, titleStartCellNo, titleStartCellNo);
	        XSSFCellStyle titleCellStyle = sheet.getRow(titleRowNo).getCell(titleStartCellNo).getCellStyle();
	        titleCellStyle.setWrapText(true);
	        int titleDemoCellWidth = sheet.getColumnWidth(titleEndCellNo);
	        
	        SimpleDateFormat datesdf = new SimpleDateFormat("yyyy-MM-dd");
	        SimpleDateFormat timesdf = new SimpleDateFormat("HH:mm");
	        
	        int i = 1;
            for(LessonResponseDto lesson:dto.getLessonCourseList()){
                int num = lesson.getIndex();
                fillTheXSSFCellWithStringValue(sheet, titleRowNo,titleEndCellNo-1+i,
                    decorateStyleWithDataFormatMap(titleEndCellNo,titleCellStyle,titleFormatMap),
                    String.format("第%d节\n%s  %s - %s\n%s\n%s",
                        num ,
                        datesdf.format(lesson.getLessonStartTime()),
                        timesdf.format(lesson.getLessonStartTime()),
                        timesdf.format(lesson.getLessonEndTime()),
                        StringUtils.isNotBlank(lesson.getRoomName())?lesson.getRoomName():"无教室",
                        StringUtils.isNotBlank(lesson.getTeacherName())?lesson.getTeacherName():"无老师"
                      ));
                sheet.setColumnWidth(titleEndCellNo-1+i, titleDemoCellWidth);
                i++;
            }
	        
	        //3. 填充 数据列表
	        int demoRowNo = 6;
	        int demoCellStartNo = 0;
	        int demoCellEndNo = 2;
	        Map<Integer,CellInfo> demoFormatMap = getCellInfoMap(sheet, demoRowNo, demoCellStartNo, demoCellEndNo);
	        short demoRowHeight = sheet.getRow(demoRowNo).getHeight();
	        
	        List<StudentSigninRecord> studentSigninRecordList = dto.getStudentSigninRecordList();
	        if( studentSigninRecordList!=null && !studentSigninRecordList.isEmpty() ){
	        	int rowNo = demoRowNo;
		        XSSFCellStyle cellStyle = sheet.getRow(rowNo).getCell(1).getCellStyle();
		        cellStyle.setWrapText(true);//强制换行
		        
	        	//设置边框
				if(ROW_WITH_BORDER){
			        fillCellStyleWithFullBorder(cellStyle, CellStyle.BORDER_THIN, IndexedColors.BLACK.getIndex());
		        }
				
				for(StudentSigninRecord studentSigninRecord:studentSigninRecordList){
                    //设置行高
                    XSSFRow row = sheet.getRow(rowNo); 
                    if(sheet.getRow(rowNo) == null){
                        row = sheet.createRow(rowNo);
                    }
                    row.setHeight(demoRowHeight);
                    
                    int cellNo = demoCellStartNo-1;
                    
                    cellNo++; fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), EmojiFilter.filterEmoji(studentSigninRecord.getStudentName())); 
                    cellNo++; //fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), 0);
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), studentSigninRecord.getSignedCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), studentSigninRecord.getLeaveCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), studentSigninRecord.getAbsentCount());
                    cellNo++; //fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), planNum-studentSigninRecord.getSignCount());
                    
                    Long userId = studentSigninRecord.getUserId();
                    int lessonFinishCout = 0;
                    int arrangeCount = 0;
                    Date now = new Date();
                    for(LessonResponseDto lesson:dto.getLessonCourseList()){
                        Long lessonId = lesson.getLessonId();
                        
                        cellNo++;
                        String studentSignKey = lessonId+"|"+userId;
                        
                        Integer signStatusCode = dto.getSignInStatusMap().get(studentSignKey);
                        
                        if(signStatusCode == null){
                        	if (dto.getStudentLessonSet().contains(studentSignKey)) {
                        		signStatusCode = 0;
							} else {
								signStatusCode = -1;
							}
                            
                        }
                        short color = change(signStatusCode);
                        if (dto.getStudentLessonSet().contains(studentSignKey)) {
                            arrangeCount++;
                            //课节结束算课消
                            if(dto.getConsumRuleValue() == null || dto.getConsumRuleValue() ==0){
                                //检查时间
                                if(lesson.getLessonStartTime().before(now)){
                                    lessonFinishCout++;
                                }
                            }else{
                                Boolean bool = CourseConsumeRuleEnum.signStatusCodeIsConsume(dto.getConsumRuleValue(), signStatusCode);
                                if(bool){
                                    lessonFinishCout++;
                                }
                            }
                        }
                        String signStatusName ="";
                       
                        if(signStatusCode == -1) {
                        	signStatusName="未排课";
                        }else{
                        	SignStatus signInStatus = SignStatus.getSignStatusByCode(signStatusCode);
                            signStatusName = "无签到记录";
                            if(signInStatus !=null && signInStatus != SignStatus.UNSIGN){
                                signStatusName = signInStatus.getMessage();
                            }
                        }
                       // Integer courseRule = 1;
                        
                        
                        
                        fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(demoCellEndNo,cellStyle,demoFormatMap), signStatusName);
                        
                        XSSFCellStyle tempcellStyle = sheet.getRow(rowNo).getCell(cellNo).getCellStyle();
                     
                        tempcellStyle.setFillForegroundColor(color);
                        tempcellStyle.setFillPattern(CellStyle.SOLID_FOREGROUND);
                        sheet.getRow(rowNo).getCell(cellNo).setCellStyle(tempcellStyle);
                        
                        
                        
                    }
                    
                    fillTheXSSFCellWithStringValue(sheet, rowNo,5, decorateStyleWithDataFormatMap(demoCellEndNo,cellStyle,demoFormatMap), "" + lessonFinishCout);
                    fillTheXSSFCellWithStringValue(sheet, rowNo,1, decorateStyleWithDataFormatMap(demoCellEndNo,cellStyle,demoFormatMap), "" + arrangeCount);
                    rowNo++;
                }
	        }

	        workbook.setSheetName(0, String.format("%s全部签到记录",dto.getCourseName()));
	        return workbook;
		}catch(Exception e){
			log.error("course signIn record export error ",e);
			return null;
		}
	}
	
	private boolean checkSign(Integer ruleValue,Integer signStatus){
		return true;
	}
	private static short change(int s) {
		switch (s) {
		case 0:
			return IndexedColors.CORNFLOWER_BLUE.getIndex();	
		case 1:	
			return IndexedColors.WHITE.getIndex();
		case 2:	
			return IndexedColors.SKY_BLUE.getIndex();
		case 3:	
			return IndexedColors.TAN.getIndex();
		case -1:	
			return IndexedColors.GREY_25_PERCENT.getIndex();
		default:
			return IndexedColors.WHITE.getIndex();
		}
	}
	
	/**
	 * @Description     :  学员签到详情 统计Excel
	 * @Modifier        : 
	 * @ModificationDate: 
	 *
	 * @Return void
	 */
	public static XSSFWorkbook excel(StudentSigninRecordDto dto, String orgName, Date downloadTime){
		
		InputStream in = null;
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"); 
		
		try{
			in = Thread.currentThread().getContextClassLoader().getResourceAsStream(TEMPLATE_PATH_STUDENT_SIGNINRECPDT_STS);
	        XSSFWorkbook workbook = new XSSFWorkbook(in);
	        XSSFSheet sheet = workbook.getSheetAt(0);
	        XSSFDrawing patriarch = (XSSFDrawing) sheet.createDrawingPatriarch();
            XSSFCellStyle cellNoBoderStyle = sheet.getRow(3).getCell(0).getCellStyle(); 
            XSSFCellStyle cellRedFontStyle = sheet.getRow(3).getCell(1).getCellStyle(); 
            cellRedFontStyle.getFont().setColor(IndexedColors.RED.index);
	       
			
	        //1. 填充 基本信息
	        fillTheXSSFCellWithStringValue(sheet, 1,1, cellNoBoderStyle, EmojiFilter.filterEmoji(dto.getStudentName()));
	        fillTheXSSFCellWithStringValue(sheet, 2,1, cellNoBoderStyle, sdf.format(downloadTime));
	        
	        //2. 填充 标题栏
	        int titleRowNo = 4;
	        int titleStartCellNo = 0;
	        int titleEndCellNo = 0;
	        
	        Map<Integer,CellInfo> titleFormatMap = getCellInfoMap(sheet, titleRowNo, titleStartCellNo, titleEndCellNo);
	        XSSFCellStyle titleCellStyle = sheet.getRow(titleRowNo).getCell(titleStartCellNo).getCellStyle();
	        titleCellStyle.setWrapText(true);
	        
	        
	        //3. 填充 数据列表
	        int demoRowNo = 5;
	        int demoCellStartNo = 0;
	        int demoCellEndNo = 0;
	        Map<Integer,CellInfo> demoFormatMap = getCellInfoMap(sheet, demoRowNo, demoCellStartNo, demoCellEndNo);
	        short demoRowHeight = sheet.getRow(demoRowNo).getHeight();
	        XSSFCellStyle cellStyle = sheet.getRow(5).getCell(0).getCellStyle(); 
	        cellStyle.setWrapText(true);//强制换行
	        cellStyle.getFont().setColor(IndexedColors.BLACK.getIndex());
        	//设置边框
			if(ROW_WITH_BORDER){
		        fillCellStyleWithFullBorder(cellStyle, CellStyle.BORDER_THIN, IndexedColors.BLACK.getIndex());
	        }
	        List<com.baijia.tianxiao.biz.erp.dto.response.StudentSigninRecordDto.CourseSigninResult> courseSigninResultList = dto.getCourseSigninResultList();
	        if( courseSigninResultList !=null && !courseSigninResultList.isEmpty() ){
	        	int rowNo = demoRowNo;

                //设置行高
                XSSFRow row0 = sheet.getRow(rowNo); 
                if(sheet.getRow(rowNo) == null){
                    row0 = sheet.createRow(rowNo);
                }
                

                
               
				int number = 1;
				for(int i = 0; i < courseSigninResultList.size(); i ++) {
                    //设置行高
                    XSSFRow row = sheet.getRow(rowNo); 
                    if(sheet.getRow(rowNo) == null){
                        row = sheet.createRow(rowNo);
                    }
                    row.setHeight(demoRowHeight);
                    
                    int cellNo = demoCellStartNo-1;
                    
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), number++); 
                    cellNo++; fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getCourseName());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getPlanCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getArrangeCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getSignedCount());
                    
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getLeaveCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getAbsentCount());
                    cellNo++; fillTheXSSFCellWithIntValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getEndCount());
                    cellNo++; fillTheXSSFCellWithStringValue(sheet, rowNo,cellNo, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), courseSigninResultList.get(i).getCourseConsumeRuleStr());
                    rowNo++;
                }
				
				int varRowNo = rowNo + 3;
				for(int courseNum = 0; courseNum < dto.getCourseSigninResultList().size() ; courseNum++) {
					
					fillTheXSSFCellWithStringValue(sheet, varRowNo,0, decorateStyleWithDataFormatMap(0,cellNoBoderStyle,demoFormatMap), "课程名称"); 
					fillTheXSSFCellWithStringValue(sheet, varRowNo,1, decorateStyleWithDataFormatMap(1,cellNoBoderStyle,demoFormatMap), dto.getCourseSigninResultList().get(courseNum).getCourseName());
					varRowNo++;
					fillTheXSSFCellWithStringValue(sheet, varRowNo,0, decorateStyleWithDataFormatMap(0,cellNoBoderStyle,demoFormatMap), "已排课次"); 
					fillTheXSSFCellWithStringValue(sheet, varRowNo,1, decorateStyleWithDataFormatMap(1,cellNoBoderStyle,demoFormatMap), dto.getCourseSigninResultList().get(courseNum).getArrangeCount() + "");
					varRowNo++;
					fillTheXSSFCellWithStringValue(sheet, varRowNo,0, decorateStyleWithDataFormatMap(0,cellRedFontStyle,demoFormatMap), "已上课次"); 
					fillTheXSSFCellWithStringValue(sheet, varRowNo,1, decorateStyleWithDataFormatMap(1,cellRedFontStyle,demoFormatMap), dto.getCourseSigninResultList().get(courseNum).getEndCount() + "");
					varRowNo++;
					fillTheXSSFCellWithStringValue(sheet, varRowNo,0, decorateStyleWithDataFormatMap(0,cellRedFontStyle,demoFormatMap), "课消规则"); 
					fillTheXSSFCellWithStringValue(sheet, varRowNo,1, decorateStyleWithDataFormatMap(1,cellRedFontStyle,demoFormatMap), dto.getCourseSigninResultList().get(courseNum).getCourseConsumeRuleStr());
					varRowNo++;
					
					fillTheXSSFCellWithStringValue(sheet, varRowNo,0, decorateStyleWithDataFormatMap(0,titleCellStyle,titleFormatMap), "课节");
					fillTheXSSFCellWithStringValue(sheet, varRowNo,1, decorateStyleWithDataFormatMap(0,titleCellStyle,titleFormatMap), "上课时间");
					fillTheXSSFCellWithStringValue(sheet, varRowNo,2, decorateStyleWithDataFormatMap(0,titleCellStyle,titleFormatMap), "签到时间");
					fillTheXSSFCellWithStringValue(sheet, varRowNo,3, decorateStyleWithDataFormatMap(0,titleCellStyle,titleFormatMap), "签到记录");
					varRowNo++;
					
					SimpleDateFormat lst = new SimpleDateFormat("yyyy-MM-dd HH:mm");
					SimpleDateFormat let = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
					SimpleDateFormat st = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

					Long courseId = dto.getCourseSigninResultList().get(courseNum).getCourseId();
					for (LessonResponseDto lesson : dto.getLessonCourseListMap().get(courseId)) {

						fillTheXSSFCellWithIntValue(sheet, varRowNo, 0,
								decorateStyleWithDataFormatMap(0, cellStyle, demoFormatMap), lesson.getIndex());
						String tempDate = DateUtil.getStrByDateFormate(lesson.getLessonStartTime(), "yyyy-MM-dd");
			            String tempStartTime = DateUtil.getStrByDateFormate(lesson.getLessonStartTime(), "HH:mm");
			            String tempEndTime = DateUtil.getStrByDateFormate(lesson.getLessonEndTime(), "HH:mm");
						fillTheXSSFCellWithStringValue(sheet, varRowNo, 1,
								decorateStyleWithDataFormatMap(1, cellStyle, demoFormatMap),
								tempDate + " " + tempStartTime + "~" + tempEndTime);

						String studentSignKey = lesson.getLessonId() + "|" + dto.getStudentId();
						OrgLessonSign orgLessonSign = dto.getSignInStatusMap().get(studentSignKey);

						Integer signStatusCode = null;
						if (orgLessonSign != null) {
							signStatusCode = orgLessonSign.getStatus();
						}

						if (signStatusCode == null) {
							if (dto.getStudentLessonSet().contains(studentSignKey)) {
								signStatusCode = 0;
							} else {
								signStatusCode = -1;
							}

						}
						short color = change(signStatusCode);

						String signStatusName = "";
						
						if (signStatusCode == -1) {
							signStatusName = "未排课";
						} else {
							SignStatus signInStatus = SignStatus.getSignStatusByCode(signStatusCode);
							signStatusName = "无签到记录";
							if (signInStatus != null && signInStatus != SignStatus.UNSIGN) {
								signStatusName = signInStatus.getMessage();
							}
						}

						fillTheXSSFCellWithStringValue(sheet, varRowNo, 2,
								decorateStyleWithDataFormatMap(2, cellStyle, demoFormatMap),
								orgLessonSign !=null?st.format(orgLessonSign.getUpdateTime()):"--");
						fillTheXSSFCellWithStringValue(sheet, varRowNo, 3,
								decorateStyleWithDataFormatMap(3, cellStyle, demoFormatMap),
								signStatusName);
						XSSFCellStyle tempcellStyle = sheet.getRow(varRowNo).getCell(3).getCellStyle();
                        tempcellStyle.setFillForegroundColor(color);
                        tempcellStyle.setFillPattern(CellStyle.SOLID_FOREGROUND);
                        sheet.getRow(varRowNo).getCell(3).setCellStyle(tempcellStyle);
/*						if (orgLessonSign != null) {
							fillTheXSSFCellWithStringValue(sheet, varRowNo, 2,
									decorateStyleWithDataFormatMap(2, cellStyle, demoFormatMap),
									st.format(orgLessonSign.getUpdateTime()));
							fillTheXSSFCellWithStringValue(sheet, varRowNo, 3,
									decorateStyleWithDataFormatMap(3, cellStyle, demoFormatMap),
									SignStatus.getSignStatusByCode(orgLessonSign.getStatus()).getMessage());
						} else {
							fillTheXSSFCellWithStringValue(sheet, varRowNo, 2,
									decorateStyleWithDataFormatMap(2, cellStyle, demoFormatMap), "--");
							fillTheXSSFCellWithStringValue(sheet, varRowNo, 3,
									decorateStyleWithDataFormatMap(3, cellStyle, demoFormatMap),
									SignStatus.getSignStatusByCode(0).getMessage());
						}*/
						varRowNo++;
					}
					varRowNo++;
					varRowNo++;
				}
	        }
	        workbook.setSheetName(0, String.format("%s全部签到记录",dto.getStudentName()));
	        return workbook;
		}catch(Exception e){
			log.error("course signIn record export error ",e);
			return null;
		}
	}
	//彩色图
//	public static void main(String args[]) throws IOException, ParseException{
//		InputStream in = new FileInputStream(new File("/Users/zhenyujian/Desktop/校宝机构统计.xlsx"));
//		XSSFWorkbook workbook = new XSSFWorkbook(in);
//		XSSFSheet sheet = workbook.getSheetAt(0);
//		Map<Integer,CellInfo> demoFormatMap = getCellInfoMap(sheet, 1, 0, 5);
//		XSSFCellStyle cellStyle = sheet.getRow(1).getCell(1).getCellStyle();
//		
//		File dir = new File("/Users/zhenyujian/Desktop/txt");
//		File[] fileArray = dir.listFiles();
//		int i=0;
//		
//		int rowNo = 1;
//		for(File file:fileArray){
//			if(file.getName().endsWith("TXT")){
//				String dateStr = "2015-"+file.getName().split("\\.")[0]+"月"+file.getName().split("\\.")[1]+"日";
//				SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM月dd日");
//				Date date = sdf.parse(dateStr);
//
//				
//				InputStreamReader reader = new InputStreamReader(new FileInputStream(file), "GBK");
//				BufferedReader br = new BufferedReader(reader);
//				String str="";
//				int lineNum = 1;
//				String orgName = "";
//				String province = "";
//				String city = "";
//				while((str = br.readLine()) != null) {
//	                  //System.out.println(str);
//					  str =str.replaceAll("[0-9|.|．|，|-]*", "");
//					  str=str.trim();
//	                  if(lineNum%2==1){
//	                	  orgName = str;
//	                  }else{
//	                	  if(str.contains("内蒙古")){
//	                		  province = "内蒙古";
//	                		  str=str.replace("内蒙古", "");
//	                	  }else if(str.contains("山蒙古")){
//	                		  province = "内蒙古";
//	                		  str=str.replace("山蒙古", "");
//	                	  }else if(str.contains("肉蒙古")){
//	                		  province = "内蒙古";
//	                		  str=str.replace("肉蒙古", "");
//	                	  }else if(str.contains("内蒙吉")){
//	                		  province = "内蒙古";
//	                		  str=str.replace("内蒙吉", "");
//	                	  }else if(str.contains("广西壮族")){
//	                		  province = "广西壮族自治区";
//	                	  }else if(str.contains("西藏")){
//	                		  province = "西藏";
//	                	  }else if(str.contains("宁夏")){
//	                		  province = "宁夏";
//	                	  }else if(str.contains("新疆")){
//	                		  province = "新疆";
//	                		  str=str.replace("新疆", "");
//	                		  str=str.replace("省", "");
//	                	  }else if(str.contains("香港")){
//	                		  province = "香港";
//	                	  }else if(str.contains("澳门")){
//	                		  province = "澳门";
//	                	  }else{
//	                		  if(str.contains("省")){
//	                			  province = str.substring(0,str.indexOf("省"));
//	                			  str = str.substring(str.indexOf("省")+1,str.length());
//	                		  }else if(str.contains("雀")){
//	                			  province = str.substring(0,str.indexOf("雀"));
//	                			  str = str.substring(str.indexOf("雀")+1,str.length());
//	                		  }else{
//		                		  province="";
//		                	  }
//	                	  }
//	                	  
//	                	  city= str;
//	                	  if(city.endsWith("市")){
//	                		  city = city.substring(0,city.length()-1);
//	                	  }
//	                	  
//	                	  System.out.println(orgName+"  "+province+"   "+city+"  "+dateStr);
//	                	  int cellNo = 0;
//	                	  fillTheXSSFCellWithIntValue(sheet, rowNo, 0, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), rowNo);
//		                  fillTheXSSFCellWithStringValue(sheet, rowNo,1, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), orgName );
//		                  fillTheXSSFCellWithStringValue(sheet, rowNo,2, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), province );
//		                  fillTheXSSFCellWithStringValue(sheet, rowNo,3, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), city );
//		                  //fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_date)
//		                  fillTheXSSFCellWithDateValue(sheet, rowNo, 4, decorateStyleWithDataFormatMap(4,cellStyle,demoFormatMap), date);
//		                  rowNo++;
//	                  }
//	                  lineNum++;
//	            }
//				fillTheXSSFCellWithIntValue(sheet, rowNo, 0, decorateStyleWithDataFormatMap(0,cellStyle,demoFormatMap), rowNo);
//				rowNo++;
//				
//				br.close();
//	            reader.close();
//			}
//		}
//		FileOutputStream os = new FileOutputStream("/Users/zhenyujian/Desktop/2.xlsx"); 
//        workbook.write(os);
//        os.close();
//	}
	
	
	
	
	public static void main(String args[]) throws IOException, ParseException{
		InputStream in = new FileInputStream(new File("/Users/zhenyujian/Desktop/aa.xlsx"));
		XSSFWorkbook workbook = new XSSFWorkbook(in);
		XSSFSheet sheet = workbook.getSheetAt(0);
		Map<Integer,CellInfo> demoFormatMap = getCellInfoMap(sheet, 1, 0, 5);
		XSSFCellStyle cellStyle = sheet.getRow(1).getCell(1).getCellStyle();
		
		File dir = new File("/Users/zhenyujian/Desktop/小孜校宝图片");
		File[] fileArray = dir.listFiles();
		int i=0;
		
		int rowNo = 1;
		for(File file:fileArray){
			if(file.getName().endsWith("TXT")){
				String dateStr = file.getName().split("\\.")[0];
				SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
				Date date = sdf.parse(dateStr);

				
				InputStreamReader reader = new InputStreamReader(new FileInputStream(file), "GBK");
				BufferedReader br = new BufferedReader(reader);
				String str="";
				int lineNum = 1;
				String orgName = "";
				String province = "";
				String city = "";
				while((str = br.readLine()) != null) {
					boolean flag = str.startsWith("1")
		                	   ||str.startsWith("2")
		                	   ||str.startsWith("3")
		                	   ||str.startsWith("4")
		                	   ||str.startsWith("5")
		                	   ||str.startsWith("6")
		                	   ||str.startsWith("7")
		                	   ||str.startsWith("8")
		                	   ||str.startsWith("9");
	                  //System.out.println(str);
					  str =str.replaceAll("[0-9|.|．|，|-|、]*", "");
					  str=str.trim();
					  //System.out.println("##### "+str +"  "+str.startsWith("2015"));
					  if(str.startsWith("部")){// || str.startsWith("部")){
						  lineNum++;
						  continue;
					  }
					  str=str.replace("_。", "北");
					  str=str.replace("黑龙1二昔", "黑龙江省");
					  str=str.replace("广末", "广东");
					  str=str.replace("三昔", "南省");
					  str=str.replace("1二再昔", "江苏省");
					  str=str.replace("浙1二昔", "浙江省");
					  str=str.replace("卉", "市");
					  str=str.replace("币", "市");
					  str=str.replace("昔", "省");
					  str=str.replace("曾", "省");
					  str=str.replace("河三", "河南");
					  
	                  if(lineNum%2==1){
	                	  
	                	  orgName = str;
	                  }else{
	                	  if(flag){
	                		  System.out.println(orgName+"  "+province+"   "+city+"  "+dateStr);
		                	  int cellNo = 0;
		                	  fillTheXSSFCellWithIntValue(sheet, rowNo, 0, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), rowNo);
			                  fillTheXSSFCellWithStringValue(sheet, rowNo,1, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), orgName );
			                  fillTheXSSFCellWithStringValue(sheet, rowNo,2, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), province );
			                  fillTheXSSFCellWithStringValue(sheet, rowNo,3, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), city );
			                  //fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_date)
			                  fillTheXSSFCellWithDateValue(sheet, rowNo, 4, decorateStyleWithDataFormatMap(4,cellStyle,demoFormatMap), date);
			                  rowNo++;
	                		  orgName = str;
	    	                  continue;
	                	  }
	                	  if(str.contains("内蒙古")){
	                		  province = "内蒙古";
	                		  str=str.replace("内蒙古", "");
	                	  }else if(str.contains("山蒙古")){
	                		  province = "内蒙古";
	                		  str=str.replace("山蒙古", "");
	                	  }else if(str.contains("肉蒙古")){
	                		  province = "内蒙古";
	                		  str=str.replace("肉蒙古", "");
	                	  }else if(str.contains("内蒙吉")){
	                		  province = "内蒙古";
	                		  str=str.replace("内蒙吉", "");
	                	  }else if(str.contains("广西壮族")){
	                		  province = "广西壮族自治区";
	                	  }else if(str.contains("西藏")){
	                		  province = "西藏";
	                	  }else if(str.contains("宁夏")){
	                		  province = "宁夏";
	                	  }else if(str.contains("新疆")){
	                		  province = "新疆";
	                		  str=str.replace("新疆", "");
	                		  str=str.replace("省", "");
	                	  }else if(str.contains("香港")){
	                		  province = "香港";
	                	  }else if(str.contains("澳门")){
	                		  province = "澳门";
	                	  }else{
	                		  if(str.contains("省")){
	                			  province = str.substring(0,str.indexOf("省"));
	                			  str = str.substring(str.indexOf("省")+1,str.length());
	                		  }else if(str.contains("雀")){
	                			  province = str.substring(0,str.indexOf("雀"));
	                			  str = str.substring(str.indexOf("雀")+1,str.length());
	                		  }else{
		                		  province="";
		                	  }
	                	  }
	                	  
	                	  city= str;
	                	  if(city.endsWith("市")){
	                		  city = city.substring(0,city.length()-1);
	                	  }
	                	  
	                	  System.out.println(orgName+"  "+province+"   "+city+"  "+dateStr);
	                	  int cellNo = 0;
	                	  fillTheXSSFCellWithIntValue(sheet, rowNo, 0, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), rowNo);
		                  fillTheXSSFCellWithStringValue(sheet, rowNo,1, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), orgName );
		                  fillTheXSSFCellWithStringValue(sheet, rowNo,2, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), province );
		                  fillTheXSSFCellWithStringValue(sheet, rowNo,3, decorateStyleWithDataFormatMap(cellNo,cellStyle,demoFormatMap), city );
		                  //fillTheXSSFCellWithValue(sheet, rowNo, cellNo, cellStyle, value, ParamType.type_date)
		                  fillTheXSSFCellWithDateValue(sheet, rowNo, 4, decorateStyleWithDataFormatMap(4,cellStyle,demoFormatMap), date);
		                  rowNo++;
	                  }
	                  lineNum++;
	            }
				fillTheXSSFCellWithIntValue(sheet, rowNo, 0, decorateStyleWithDataFormatMap(0,cellStyle,demoFormatMap), rowNo);
				rowNo++;
				
				br.close();
	            reader.close();
			}
		}
		FileOutputStream os = new FileOutputStream("/Users/zhenyujian/Desktop/2.xlsx"); 
        workbook.write(os);
        os.close();
        System.out.println("end");
	}
	
	
	
	
//	public static void main(String args[]) throws IOException{
//		InputStream in = new FileInputStream(new File("/Users/zhenyujian/Desktop/c.xlsx"));
//		XSSFWorkbook workbook = new XSSFWorkbook(in);
//	    XSSFSheet sheet = workbook.getSheetAt(0);
//	    fillTheXSSFCellWithStringValue(sheet, 0,0, null, "hahaha");
//	    fillTheXSSFCellWithStringValue(sheet, 0,0, null, "hahah3333a");
//	    
//	    ByteArrayOutputStream byteArrayOut = new ByteArrayOutputStream();  
//	    BufferedImage bufferImg = ImageIO.read(new URL("http://www.baidu.com/img/bd_logo.png"));  
//	    ImageIO.write(bufferImg, "png", byteArrayOut);  
//	      
//	    XSSFDrawing patriarch = (XSSFDrawing) sheet.createDrawingPatriarch();  
//	    //XSSFClientAnchor anchor = new XSSFClientAnchor(1000, 1000, 1000, 1000, 2, 10, 3, 11);
//	    XSSFClientAnchor anchor = new XSSFClientAnchor();
//	    System.out.println(anchor.getAnchorType());
//	    //anchor.setAnchorType(3);
//	    anchor.setRow1(10);
//	    anchor.setRow2(11);
//	    anchor.setCol1(0);
//	    anchor.setCol2(1);
//	    anchor.setDx1(200);
//	    anchor.setDy1(200);
//	    anchor.setDx2(1300);
//	    anchor.setDy2(1300);
//	    System.out.println(anchor.getAnchorType());
	    
//	    Drawing patriarch = sheet.createDrawingPatriarch();
//	    CreationHelper helper = workbook.getCreationHelper();
//	    ClientAnchor anchor = helper.createClientAnchor();
//	    
//	    anchor.setRow1(10);
//	    anchor.setRow2(12);
//	    anchor.setCol1(0);
//	    anchor.setCol2(2);
//	    anchor.setDx1(0);
//	    anchor.setDy1(200);
//	    anchor.setDx2(0);
//	    anchor.setDy2(0);
//	    
//	    anchor.setAnchorType(2);
//	    Picture pict = patriarch.createPicture(anchor, workbook.addPicture(byteArrayOut.toByteArray(), XSSFWorkbook.PICTURE_TYPE_PNG));
	    //ClientAnchor pref = pict.getPreferredSize();

//	    anchor.setDx1(0);
//	    anchor.setDy1(200);
//	    anchor.setDx2(0);
//	    anchor.setDy2(300);
//	    pict.resize();

//        XSSFClientAnchor pref = (XSSFClientAnchor) pict.getPreferredSize();
        
        
//
//        int row2 = anchor.getRow1() + (pref.getRow2() - pref.getRow1());
//        int col2 = anchor.getCol1() + (pref.getCol2() - pref.getCol1());
//
//        anchor.setCol2(col2);
//        anchor.setDx1(0);
//        anchor.setDx2(pref.getDx2());
//
//        anchor.setRow2(row2);
//        anchor.setDy1(0);
//        anchor.setDy2(pref.getDy2());
//	    
//	    
//	    OutputStream os = new FileOutputStream(new File("/Users/zhenyujian/Desktop/b.xlsx"));
//	    workbook.write(os);
//	    os.close();
//	    System.out.println("123123123");
//	}
	
}