package com.baijia.tianxiao.biz.erp.thread;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.StringRedisTemplate;

import com.baijia.tianxiao.biz.erp.constant.UploadFileStatus;
import com.baijia.tianxiao.biz.erp.service.impl.ErpUploadServiceImpl;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.StudentInfoDto;
import com.baijia.tianxiao.sal.student.dto.response.OrgStudentAddresponseDto;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

@Data
@Slf4j
public class SaveStudentsThread implements  Runnable {
    private StringRedisTemplate redisTemplate;
    private OrgStudentService orgStudentService;
    private OrgStudentCourseService orgStudentCourseService;
    private OrgStudentLessonDao orgStudentLessonDao;
    private OrgCourseService orgCourseService;
    private OrgClassLessonDao orgClassLessonDao;

    private Integer orgId;//机构id
    private Integer cascadeId;//子账号id
    private String taskId;//批导任务id
    private int id;//用于区分线程
    private Map<Integer, Boolean> map;
    private List<ImportStudent> importStudents = Lists.newArrayList();

    public SaveStudentsThread() {
		
	}
    
	public void run() {
        try {
            List<String> courseNames = Lists.newArrayList();
            List<String> studentMobiles = Lists.newArrayList();
            for (ImportStudent importStudent : importStudents) {
                courseNames.add(importStudent.getCourseName());
                studentMobiles.add(importStudent.getStudentMobile());
            }
            
            long between0 = 0;//总查询耗时
            long between1 = 0;//一个学生导入耗时
            long between2 = 0;//一条课节导入耗时
            long addStudentTime = 0;
            long addLessonTime = 0;
            Date  begin0 = new Date();//查询前……
            
			Map<String, OrgCourse> orgCoursesMap = orgCourseService.getAllOrgCoursesMapByNames_class(orgId.longValue(), courseNames);
            List<Long> orgCourseIds = Lists.newArrayList();
            for(OrgCourse orgCourse: orgCoursesMap.values()) {
            	orgCourseIds.add(orgCourse.getId());
            }
            Map<Long, List<OrgClassLesson>> orgClassLessonsMap =  orgClassLessonDao.querylessonsByStartTime(new Date(), orgCourseIds, orgId.longValue());	
            Map<Long, List<OrgClassLesson>> endLessonsMap = orgClassLessonDao.queryEndedlessons(orgCourseIds, orgId.longValue());
            
            Date end0 = new Date();//查询后……
            between0 = (end0.getTime() - begin0.getTime());// 得到两者的毫秒数
            
            if (CollectionUtils.isNotEmpty(importStudents)) {
                for (final ImportStudent importStudent : importStudents) {
                    try {
                    	String courseName = importStudent.getCourseName();
                    	OrgCourse orgCourse = orgCoursesMap.get(courseName);
                    	Long orgCourseId = orgCourse.getId();
                    	
                    	List<OrgClassLesson> orgClassLessons = new ArrayList<OrgClassLesson>();
                    	List<OrgClassLesson> endLessons = new ArrayList<OrgClassLesson>();
                    	if(MapUtils.isNotEmpty(orgClassLessonsMap)) {
                    		orgClassLessons = orgClassLessonsMap.get(orgCourseId);
                    	}
                    	if(MapUtils.isNotEmpty(endLessonsMap)) {
                    		endLessons = endLessonsMap.get(orgCourseId);
                    	}
                        Date begin1 = new Date();//插入学生前……
                            
                        // 不存在orgstudent，创建
                        // 不存在orgstudentclass，创建
                        // 按照逻辑创建org_student_lesson
                        // 系统异常时，把当前数据从validlist删除，再插入errlist，修改错误和正确数目
                        StudentInfoDto orgStudent = null;
                        List<StudentInfoDto> dtos = orgStudentService.listOrgStudentByMobile(orgId.longValue(),
                            importStudent.getStudentMobile().toString());
                        
                        if (CollectionUtils.isNotEmpty(dtos)) {
                            for (StudentInfoDto dto : dtos) {
                                if (importStudent.getStudentMobile().equals(dto.getMobile())
                                    && importStudent.getStudentName().equals(dto.getName())) {
                                    log.debug("*************can find dto:{}", dto);
                                    orgStudent = dto;
                                }
                            }
                        }
                        if (orgStudent == null) {
                            orgStudent = new StudentInfoDto();
                            orgStudent.setMobile(importStudent.getStudentMobile().toString());
                            orgStudent.setName(importStudent.getStudentName().toString());
                            orgStudent.setAddCascadeId(cascadeId == null ? 0 : cascadeId);
                            OrgStudentAddresponseDto addDto = orgStudentService
                                .addStudentIgnoreExistMobile(orgStudent, null, null, orgId.longValue());
                            orgStudent.setStudentId(addDto.getUserId());
                        }
                        log.debug("**************orgStudent:{}", orgStudent);
                        
                        Date end1 = new Date();//插入学生后……课节前……
                        between1 = end1.getTime() - begin1.getTime();// 得到两者的毫秒数
	                    addStudentTime += between1; 

                        OrgStudentCourse orgStudentCourse = orgStudentCourseService
                            .getBySidAndCid(orgId.longValue(), orgStudent.getStudentId(), orgCourse.getId());
                        if (orgStudentCourse == null) {
                            orgStudentCourse = new OrgStudentCourse();
                            orgStudentCourse.setCourseId(orgCourse.getId());
                            orgStudentCourse.setCreateTime(new Date());
                            orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
                            orgStudentCourse.setOrgId(orgId.longValue());
                            orgStudentCourse.setStudentMobile(orgStudent.getMobile());
                            orgStudentCourse.setStudentName(orgStudent.getName());
                            orgStudentCourse.setUserId(orgStudent.getStudentId());
                            orgStudentCourse.setStatus(0);
                            orgStudentCourseService.saveOrgStudentCourse(orgStudentCourse);
                        }
                        if (orgStudentCourse.getDelStatus() == DeleteStatus.DELETED.getValue()) {
                            orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
                            orgStudentCourseService.updateOrgStudentCourse(orgStudentCourse);
                        }

                        if (orgStudentCourse.getStatus() != 0) {
                            orgStudentCourse.setStatus(0);
                            orgStudentCourseService.updateOrgStudentCourse(orgStudentCourse);
                        }

                        // 改为不排课，也让导入
                        if (CollectionUtils.isNotEmpty(orgClassLessons)) {
                            // 学员从班级下一个待开课课次开排，直至班级结课
                            // 这里看mrd比较好，pm找周希，rd找曹亮
                            List<OrgStudentLesson> orgStudentLessons = Lists.newArrayList();
                            if (importStudent.getInsertCount() == null
                                && importStudent.getLessonCount() == null) {
                                for (OrgClassLesson orgClassLesson : orgClassLessons) {
                                    OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                    orgStudentLesson.setCreateTime(new Date());
                                    orgStudentLesson.setDelStatus(DeleteStatus.NORMAL.getValue());
                                    orgStudentLesson.setLessonId(orgClassLesson.getId());
                                    orgStudentLesson.setOrgId(orgId.longValue());
                                    orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                    orgStudentLesson.setStudentName(orgStudent.getName());
                                    orgStudentLesson.setUserId(orgStudent.getStudentId());
                                    orgStudentLessons.add(orgStudentLesson);
                                }
                            } else if (importStudent.getLessonCount() != null
                                && importStudent.getInsertCount() == null) {
                                // 总课次不为空，插入课次为空
                                Integer lessonCount =
                                    Integer.valueOf(importStudent.getLessonCount().toString());
                                if (lessonCount >= orgClassLessons.size()) {
                                    for (OrgClassLesson orgClassLesson : orgClassLessons) {
                                        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                        orgStudentLesson.setCreateTime(new Date());
                                        orgStudentLesson.setDelStatus(DeleteStatus.NORMAL.getValue());
                                        orgStudentLesson.setLessonId(orgClassLesson.getId());
                                        orgStudentLesson.setOrgId(orgId.longValue());
                                        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                        orgStudentLesson.setStudentName(orgStudent.getName());
                                        orgStudentLesson.setUserId(orgStudent.getStudentId());
                                        orgStudentLessons.add(orgStudentLesson);
                                    }
                                } else {
                                    for (int i = 0; i < lessonCount; i++) {
                                        OrgClassLesson orgClassLesson = orgClassLessons.get(i);
                                        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                        orgStudentLesson.setCreateTime(new Date());
                                        orgStudentLesson.setDelStatus(DeleteStatus.NORMAL.getValue());
                                        orgStudentLesson.setLessonId(orgClassLesson.getId());
                                        orgStudentLesson.setOrgId(orgId.longValue());
                                        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                        orgStudentLesson.setStudentName(orgStudent.getName());
                                        orgStudentLesson.setUserId(orgStudent.getStudentId());
                                        orgStudentLessons.add(orgStudentLesson);
                                    }
                                }
                            } else if (importStudent.getLessonCount() == null
                                && importStudent.getInsertCount() != null) {
                                // 总课次为空，插入课次不为空
                                Integer insertCount =
                                    Integer.valueOf(importStudent.getInsertCount().toString());
                                if (insertCount > endLessons.size()) {
                                    int point = insertCount - endLessons.size() - 1;
                                    for (; point < orgClassLessons.size(); point++) {
                                        OrgClassLesson orgClassLesson = orgClassLessons.get(point);
                                        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                        orgStudentLesson.setCreateTime(new Date());
                                        orgStudentLesson.setDelStatus(DeleteStatus.NORMAL.getValue());
                                        orgStudentLesson.setLessonId(orgClassLesson.getId());
                                        orgStudentLesson.setOrgId(orgId.longValue());
                                        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                        orgStudentLesson.setStudentName(orgStudent.getName());
                                        orgStudentLesson.setUserId(orgStudent.getStudentId());
                                        orgStudentLessons.add(orgStudentLesson);
                                    }
                                } else {
                                    for (OrgClassLesson orgClassLesson : orgClassLessons) {
                                        OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                        orgStudentLesson.setCreateTime(new Date());
                                        orgStudentLesson.setDelStatus(DeleteStatus.NORMAL.getValue());
                                        orgStudentLesson.setLessonId(orgClassLesson.getId());
                                        orgStudentLesson.setOrgId(orgId.longValue());
                                        orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                        orgStudentLesson.setStudentName(orgStudent.getName());
                                        orgStudentLesson.setUserId(orgStudent.getStudentId());
                                        orgStudentLessons.add(orgStudentLesson);
                                    }
                                }
                            } else if (importStudent.getLessonCount() != null
                                && importStudent.getInsertCount() != null) {
                                Integer insertCount =
                                    Integer.valueOf(importStudent.getInsertCount().toString());
                                Integer lessonCount =
                                    Integer.valueOf(importStudent.getLessonCount().toString());
                                int start = 0;
                                int end = lessonCount;
                                if (insertCount > endLessons.size()) {
                                    start = insertCount - endLessons.size() - 1;
                                    end = lessonCount + start;
                                }

                                if (end > orgClassLessons.size()) {
                                    end = orgClassLessons.size();
                                }
                                for (; start < end; start++) {
                                    OrgClassLesson orgClassLesson = orgClassLessons.get(start);
                                    OrgStudentLesson orgStudentLesson = new OrgStudentLesson();
                                    orgStudentLesson.setCreateTime(new Date());
                                    orgStudentLesson.setDelStatus(DeleteStatus.NORMAL.getValue());
                                    orgStudentLesson.setLessonId(orgClassLesson.getId());
                                    orgStudentLesson.setOrgId(orgId.longValue());
                                    orgStudentLesson.setStudentMobile(orgStudent.getMobile());
                                    orgStudentLesson.setStudentName(orgStudent.getName());
                                    orgStudentLesson.setUserId(orgStudent.getStudentId());
                                    orgStudentLessons.add(orgStudentLesson);
                                }
                            }
                            
                            Long studentId = orgStudent.getStudentId();//学生id
                            Map<Long, OrgStudentLesson> orgStudentLessonMap = Maps.newHashMap();//插入课节
                        	for(OrgStudentLesson orgStudentLesson: orgStudentLessons) {
                        		Long lessonId = orgStudentLesson.getLessonId();
                        		orgStudentLessonMap.put(lessonId, orgStudentLesson);
                        	}
                        	List<OrgStudentLesson> orgStudentLessonsList = orgStudentLessonDao.getLessonsOfStudent(orgId.longValue(), studentId.longValue(), orgStudentLessonMap.keySet());

                        	List<OrgStudentLesson> updateList = Lists.newArrayList();//数据库中需要更新的课节(数据库中删除过)
                        	if(CollectionUtils.isNotEmpty(orgStudentLessonsList)) {
                        		for(OrgStudentLesson orgStudentLessonDb: orgStudentLessonsList) {
                        			Long lessonDbId = orgStudentLessonDb.getLessonId();
                        			orgStudentLessonMap.remove(lessonDbId);
                        			if(orgStudentLessonDb.getDelStatus() == 1) {
                            			orgStudentLessonDb.setDelStatus(0);
                            			orgStudentLessonDb.setStartStatus(0);
                            			orgStudentLessonDb.setKexiaoStatus(0);
                            			orgStudentLessonDb.setUpdateTime(new Date());
                            			updateList.add(orgStudentLessonDb);
                        			}
                        		}
                        	}
                        	
                        	if(CollectionUtils.isNotEmpty(updateList)) {
                        		for(OrgStudentLesson orgStudentLesson: updateList) {
                        			orgStudentLessonDao.update(orgStudentLesson);
                        		}
                        	}
                            if (MapUtils.isNotEmpty(orgStudentLessonMap)) {
                            	for (OrgStudentLesson orgStudentLesson: orgStudentLessonMap.values()) {
									try {
										orgStudentLessonDao.save(orgStudentLesson);
									} catch (Exception e) {
										log.error("save orgStudentLesson:{} failed", orgStudentLesson);
									}
								}
                            }
                        }
                        
                    Date end2 = new Date();//插入课节后
                    between2 = end2.getTime() - end1.getTime();// 得到两者的毫秒数
                    addLessonTime += between2;
                    } catch (final BussinessException be) {
                        log.warn("save importStudent error!,importStudent:{}", importStudent, be);
                        importStudent.setErrReason(be.getMessage());
                        appendErrorData(taskId, importStudent);
                    } catch (Exception e) {
                        log.error("save importStudent error!,importStudent:{}", importStudent, e);
                        // 错误追加
                        importStudent.setErrReason("系统无法插入此数据，请联系天校工作人员为您排查");
                        appendErrorData(taskId, importStudent);
                    }
                }
                
               map.put(id, true);
               log.info("查询耗时：{} ms", between0);
               log.info("插入学生总时间：{} ms",  addStudentTime);;
               log.info("插入学生课程、课结的总时间：{} ms", addLessonTime);
            }
        } catch (Throwable t) {
            log.error("save student to orgcourse error!", t);
            setTaskStatusError(taskId);
        }
    }
	
	   /**
     * @param taskId
     */

    protected void setTaskStatusError(final String taskId) {
        redisTemplate.execute(new RedisCallback<Boolean>() {

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                connection.setEx(getStatusKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE,
                    UploadFileStatus.ERROR.getCode().toString().getBytes());
                return true;
            }
        });
    }
    
    private final String getStatusKey(String taskId) {
        return taskId + ErpUploadServiceImpl.STATUS_SUFFIX;
    }
    
    private final String getErrDataKey(String taskId) {
        return taskId + ErpUploadServiceImpl.INVALID_LIST_SUFFIX;
    }

    private final String getErrDataSizeKey(String taskId) {
        return taskId + ErpUploadServiceImpl.INVALID_LIST_SIZE_SUFFIX;
    }

    private final String getValidDataSizeKey(String taskId) {
        return taskId + ErpUploadServiceImpl.VALID_LIST_SIZE_SUFFIX;
    }

    /**
     * @param taskId
     * @param
     */

    protected void appendErrorData(final String taskId, final Object data) {
        redisTemplate.execute(new RedisCallback<Boolean>() {

            @Override
            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                redisTemplate.opsForList().leftPush(getErrDataKey(taskId), JacksonUtil.obj2Str(data));
                connection.expire(getErrDataKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE);
                connection.incr(getErrDataSizeKey(taskId).getBytes());
                connection.expire(getErrDataSizeKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE);
                connection.decr(getValidDataSizeKey(taskId).getBytes());
                connection.expire(getValidDataSizeKey(taskId).getBytes(), ErpUploadServiceImpl.EXPIRE);
                return true;
            }
        });
    }
} 
