package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constants.sms.SmsMessageType;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXSaleClueRule;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.sal.organization.org.service.TXAccountService;
import com.baijia.tianxiao.sal.organization.org.service.TXSaleClueRuleService;
import com.baijia.tianxiao.sal.signup.constants.SignupSourceType;
import com.baijia.tianxiao.util.SmsSendUtil;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/9/23
 * Time: 上午11:28
 * To change this template use File | Settings | File Templates.
 */
@Service("syncSignupSuccessAndSyncFail")
@Slf4j
public class SyncSignupSuccessAndSyncFail implements SyncPayService {


    String SIGNUP_SMS_CONTENT_TEMPLATE = "您已成功在%s报名了课程%s!";

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private TXSaleClueRuleService tXSaleClueRuleService;

    @Resource
    private CourseClassService courseClassService;

    @Resource
    private TXAccountService txAccountService;


    @Override
    public void sync() {

        try {
            List<OrgSignupInfo> syncSignupInfoList = orgSignupInfoDao.getSignupSuccessAndNotSync();
            if (CollectionUtils.isNotEmpty(syncSignupInfoList)) {
                for (OrgSignupInfo signupInfo : syncSignupInfoList) {
                    List<OrgSignupCourse> signupCourses = orgSignupCourseDao.loadByPurchaseId(signupInfo.getSignupPurchaseId());
                    if (CollectionUtils.isEmpty(signupCourses)){
                        continue;
                    }
                    signupInfo.setOrgSignupCourses(signupCourses);
                    Map<Long, OrgSignupCourse> courseMap =
                        CollectorUtil.collectMap(signupCourses, new Function<OrgSignupCourse, Long>() {
                            @Override
                            public Long apply(OrgSignupCourse orgSignupCourse) {
                                return orgSignupCourse.getOrgCourseId();
                            }
                        });
                    StringBuilder sb = new StringBuilder();
                    List<OrgCourse> courseList = orgCourseDao.getByIds(courseMap.keySet());
                    for (int i = 0; i < courseList.size(); i++) {
                        sb.append("“" + courseList.get(i).getName() + "“");
                        if (i < courseList.size() - 1) {
                            sb.append("、");
                        }
                    }
                    Integer orgId = signupInfo.getOrgId().intValue();
                    OrgInfo orginfo = orgInfoDao.getOrgInfo(orgId, "shortname");
                    log.info("SignupInfoSmsProcessor :orgsignupInfo={}", signupInfo);

                    TXSaleClueRule txSaleClueRule = tXSaleClueRuleService.getByOrgId(orgId);
                    // 机构是否报名发短信设置设置
                    if (txSaleClueRule != null && txSaleClueRule.getSignupMsg() != null
                        && txSaleClueRule.getSignupMsg().intValue() == 0) {
                        SmsSendUtil.sendSms(signupInfo.getMobile(),
                            String.format(SIGNUP_SMS_CONTENT_TEMPLATE, orginfo.getShortName(), sb.toString()),
                            SmsMessageType.TIANXIAO_NOTIFY.getCode(), orgId, UserRole.ORGANIZATION.getRole(), true,txAccountService.getTxAccountSmsGate(orgId));
                    }

                    if (signupInfo != null) {
                        signupInfo.setSmsSend(1);// 已发送
                        log.info("sms before orgsignupinfo = {},result={}", signupInfo,
                            signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode());

                        orgSignupInfoDao.update(signupInfo);

                        if (signupInfo.getSourceType().intValue() != SignupSourceType.TUIGUANG.getCode()) {
                            try {
                                saveStudentCourse(signupInfo);
                            } catch (Exception e) {
                            }
                        }
                    }
                }
            }
        } catch (Exception e) {
            log.warn("sy signup sms fail {}", e);
        }
    }


    private void saveStudentCourse(@NonNull OrgSignupInfo orgSignupInfo) {
        for (OrgSignupCourse course : orgSignupInfo.getOrgSignupCourses()) {

            OrgCourse orgCourse = orgCourseDao.getByCourseId(course.getOrgCourseId());
            if (orgCourse != null) {
                if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                    courseClassService.createClassFor1V1(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId(),
                            course.getOrgCourseId(), course.getUserId(), course.getCount());
                } else {
                    OrgStudentCourse studentCourse = new OrgStudentCourse();
                    studentCourse.setCourseId(course.getOrgCourseId());
                    studentCourse.setCreateTime(new Date());
                    studentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
                    studentCourse.setOrgId(orgSignupInfo.getOrgId());
                    studentCourse.setUserId(orgSignupInfo.getUserId());
                    studentCourse.setStudentMobile(orgSignupInfo.getMobile());
                    studentCourse.setStudentName(orgSignupInfo.getStudentName());
                    studentCourse.setLessonCount(0);// 班课默认合同课次为0
                    studentCourse.setSignupPurchaseId(orgSignupInfo.getSignupPurchaseId());
                    try {
                        orgStudentCourseDao.save(studentCourse);
                    } catch (Exception e) {
                        log.warn("can not save student :{} into student course by error :{}", studentCourse, e);
                        e.printStackTrace();
                    }
                }
            }
        }
    }

}
