package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.dto.SplitPurchaseDto;
import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupSyncInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupSyncInfo;
import com.baijia.tianxiao.dto.signup.PayResponseDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * Created with IntelliJ IDEA. User: Victor Weng Date: 16/9/12 Time: 下午8:32 To change this template use File | Settings
 * | File Templates.
 */
@Service("syncSignupAndSpliteService")
@Slf4j
public class SyncSignupPurchaseAndSplitCourseServiceImpl implements SyncPayService {

    @Resource
    private OrgSinupPurchaseDao orgSinupPurchaseDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupSyncInfoDao orgSignupSyncInfoDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private SignupService signupService;

    @Override
    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRED)
    public void sync() {

        OrgSignupSyncInfo syncInfo = getSyncInfo(1);// 刷卡报名订单
        int maxSize = 100;

        // 从支付报名订单表同步成功的订单,自动提交课程拆分信息
        syncPurchase(syncInfo, maxSize);

        // 查询系统这边 purchase_status=1 && split_result=0的信息
        splitPurchase();

        // 查询系统中 purchase_status=0|2 && split_result=0|2 的信息,然后去pay.org_sinup_purchase中查找如果状态为1,那么就更新,理论上这一步是不需要的
        // syncOldPurchase();
        log.info("save syncInfo:{} to db", syncInfo);
        orgSignupSyncInfoDao.saveOrUpdateSyncInfo(syncInfo);
    }

    /**
     *
     */
    // private void syncOldPurchase() {
    //
    // List<Integer> pendList =
    // Lists.newArrayList(SplitCourseResult.PENDING.getCode(), SplitCourseResult.FAIL.getCode());
    //
    // List<Integer> paySuccessList = Lists.newArrayList(PayResult.FAIL.getCode(), PayResult.IN_PROGRESS.getCode());
    //
    // List<Integer> payTypeList =
    // Lists.newArrayList(PayType.PAY_POS_CARD.getCode(), PayType.WX_POS.getCode(), PayType.ALIPAY_POS.getCode());
    // // 只查询支付成功并且待报名的订单
    // List<OrgSignupInfo> pendingSplitList =
    // orgSignupInfoDao.searchSignupInfoWithCourseInfo(pendList, paySuccessList, payTypeList, null);
    //
    // log.info("get split course size:{}", pendingSplitList.size());
    // if (CollectionUtils.isNotEmpty(pendingSplitList)) {
    // Set<Long> purchaseIds = Sets.newHashSet();
    // for (OrgSignupInfo orgSignupInfo : pendingSplitList) {
    // purchaseIds.add(orgSignupInfo.getSignupPurchaseId());
    // }
    // Map<Long, OrgSinupPurchase> purchaseMap = getsinupPurchaseMap(purchaseIds);
    // for (OrgSignupInfo orgSignupInfo : pendingSplitList) {
    // updateSignupInfo(purchaseMap.get(orgSignupInfo.getSignupPurchaseId()), orgSignupInfo);
    // }
    // }
    // }

    /**
     *
     */
    private void splitPurchase() {

        List<Integer> pendList = Lists.newArrayList(SplitCourseResult.PENDING.getCode());

        List<Integer> paySuccessList = Lists.newArrayList(PayResult.SUCCESS.getCode());

        // List<Integer> payTypeList = Lists.newArrayList(PayType.PAY_POS_CARD.getCode(), PayType.WX_POS.getCode(),
        // PayType.ALIPAY_POS.getCode(), PayType.ONLINE_PAYMENT.getCode(), PayType.PAY_POS_KUAIQIAN_CARD.getCode(),
        // PayType.PAY_POS_YINLIAN_CARD.getCode());
        // 只查询支付成功并且待报名的订单
        List<OrgSignupInfo> pendingSplitList =
                orgSignupInfoDao.searchSignupInfoWithCourseInfo(pendList, paySuccessList, null, null);
        log.info("get split course size:{}", pendingSplitList.size());
        if (CollectionUtils.isNotEmpty(pendingSplitList)) {
            for (OrgSignupInfo orgSignupInfo : pendingSplitList) {
                updateSignupInfo(null, orgSignupInfo, null);
            }
        }
    }

    private void syncPurchase(OrgSignupSyncInfo syncInfo, int maxSize) {
        List<OrgSinupPurchase> purchases = orgSinupPurchaseDao.searchByUpdateTimeAndStatus(PayResult.SUCCESS.getCode(),
                syncInfo.getSyncTime(), maxSize);
        log.info("search success from pay by syncInfo:{},maxSize:{},results:{}", syncInfo, maxSize, purchases.size());
        Date current = new Date();
        if (CollectionUtils.isNotEmpty(purchases)) {
            Set<Long> purchaseIds = Sets.newHashSet();
            for (OrgSinupPurchase orgSinupPurchase : purchases) {
                purchaseIds.add(orgSinupPurchase.getPurchaseId());
                if (orgSinupPurchase.getUpdateTime().after(syncInfo.getSyncTime())
                        && orgSinupPurchase.getUpdateTime().before(current)) {
                    syncInfo.setSyncTime(orgSinupPurchase.getUpdateTime());
                }
            }
            log.debug("-------------------------------------------purchaseIds={}", purchaseIds);
            Map<Long, Long> tradeNoMap = RestUtils.getTradeNoMap(purchaseIds);

            log.info("found pay success purchase ids:{}", purchaseIds);
            Map<Long, OrgSignupInfo> signupInfos = getSignupInfoMap(purchaseIds);
            for (OrgSinupPurchase orgSinupPurchase : purchases) {
                Long purchaseId = orgSinupPurchase.getPurchaseId();
                OrgSignupInfo signupInfo = signupInfos.get(purchaseId);
                if (signupInfo == null) {
                    // 创建报名信息,
                    signupInfo = createAndSaveSignupInfo(orgSinupPurchase, tradeNoMap);
                    log.info("create signup info:{}", signupInfo);
                } else {
                    updateSignupInfo(orgSinupPurchase, signupInfo, tradeNoMap);
                }
            }
        }
    }

    @Transactional(rollbackFor = Exception.class, propagation = Propagation.REQUIRES_NEW)
    private OrgSignupInfo createAndSaveSignupInfo(OrgSinupPurchase sinupPurchase, Map<Long, Long> tradeNoMap) {
        log.info("create signup info from purchase:{}", sinupPurchase);
        OrgSignupInfo info = new OrgSignupInfo();
        info.setCreateTime(sinupPurchase.getPayTime());
        info.setIsDel(DeleteStatus.NORMAL.getValue());
        info.setMobile("");
        info.setOperator("");
        info.setOrgId(sinupPurchase.getOrgId());
        info.setOrgNumber(sinupPurchase.getOrgNumber());
        info.setPayType(PayType.getPayTypeByTypeStr(sinupPurchase.getPayType()).getCode());
        info.setPurchaseStatus(sinupPurchase.getStatus());
        info.setRemark("");
        info.setSignupPurchaseId(sinupPurchase.getPurchaseId());
        info.setSignupType(SignupType.POS_CARD.getCode());
        info.setSplitResult(SplitCourseResult.NOT_COMMIT.getCode());
        info.setStudentName("");
        info.setTotalPrices(NumberUtil.multiply(sinupPurchase.getTotalPrices(), new BigDecimal(100), 0).longValue());
        info.setUpdateTime(new Date());
        info.setPayTime(sinupPurchase.getPayTime());
        info.setUserId(0l);
        info.setTradeNo(tradeNoMap.get(sinupPurchase.getPurchaseId()));
        orgSignupInfoDao.saveOrUpdateSignupInfo(info);
        return info;
    }

    @Transactional
    private void updateSignupInfo(OrgSinupPurchase sinupPurchase, @NonNull OrgSignupInfo signupInfo,
                                  Map<Long, Long> tradeNoMap) {
        if (signupInfo.getTotalPrices().longValue() == 0l && sinupPurchase == null) {
            sinupPurchase = orgSinupPurchaseDao.getByPurchaseId(signupInfo.getSignupPurchaseId());
        }

        if (sinupPurchase != null && sinupPurchase.getStatus().intValue() != PayResult.SUCCESS.getCode()) {
            log.warn("sinupPurchase is not success:{}", sinupPurchase);
            return;
        }

        signupInfo.setPurchaseStatus(sinupPurchase != null ? sinupPurchase.getStatus() : PayResult.SUCCESS.getCode());

        // 兼容以前的任务,报名的时候才设置时间
        if (sinupPurchase != null && sinupPurchase.getPayTime() != null
                && signupInfo.getCreateTime().after(sinupPurchase.getPayTime())) {
            signupInfo.setCreateTime(sinupPurchase.getPayTime());
            if (CollectionUtils.isNotEmpty(signupInfo.getOrgSignupCourses())) {
                signupInfo.setTotalPrices((long) (sinupPurchase.getTotalPrices() * 100));
                signupInfo.setCreateTime(sinupPurchase.getPayTime());
                signupInfo.setPayTime(sinupPurchase.getPayTime());
                log.info("update split success pos pay before signup record:{}", sinupPurchase);
            }
        }
        if (sinupPurchase != null && signupInfo.getPayType().intValue() == PayType.CASH.getCode()) {
            log.info("force set cash pay type into pos pay type.");
            signupInfo.setPayTime(sinupPurchase.getPayTime());
            signupInfo.setSplitResult(SplitCourseResult.SUCCESS.getCode());
            // signupInfo.setPayType(PayType.PAY_POS_CARD.getCode());
        }
        log.info("sync signup purchase ={}", sinupPurchase);
        // 支付成功，同步支付方式
        if (sinupPurchase != null && sinupPurchase.getStatus().intValue() == PayResult.SUCCESS.getCode()) {
            log.info("sync signup purchase1 ={}", sinupPurchase);
            signupInfo.setPayType(PayType.getPayTypeByTypeStr(sinupPurchase.getPayType()).getCode());
            signupInfo.setPayTime(sinupPurchase.getPayTime());
        }
        if (tradeNoMap != null) {
            signupInfo.setTradeNo(tradeNoMap.get(sinupPurchase.getPurchaseId()));
        }
        try {
            List<SplitPurchaseDto> purchaseData = buildSplitPurchaseDto(signupInfo);
            if (CollectionUtils.isNotEmpty(purchaseData)) {
                log.info("start to split purchase :{}", purchaseData);
                if (signupInfo.getPayType().intValue() != PayType.CASH.getCode()) {
                    splitSignupPurchase(purchaseData);
                }
                signupInfo.setSplitResult(SplitCourseResult.SUCCESS.getCode());

                // 统一在这里发送短信
                if (StringUtils.isNoneBlank(signupInfo.getMobile())
                        && signupInfo.getPurchaseStatus().intValue() == PayResult.SUCCESS.getCode()) {
                    log.info("send sms to fronted student:{}", signupInfo.getMobile());
                    // signupService.sendSignUpSms(signupInfo.getSignupPurchaseId(), signupInfo.getOrgId(),
                    // signupInfo.getMobile());
                }
                signupInfo.setUpdateTime(new Date());// 更新时间
                orgSignupInfoDao.saveOrUpdateSignupInfo(signupInfo);
            }

        } catch (Exception e) {
            log.error("split signup purchase catch error:{}", e);
        }
        // orgSignupInfoDao.saveOrUpdateSignupInfo(signupInfo);
    }

    private List<SplitPurchaseDto> buildSplitPurchaseDto(OrgSignupInfo signupInfo) throws BussinessException {
        if (signupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            log.info("signupInfo has split ,skip");
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty(signupInfo.getOrgSignupCourses())) {
            log.info("signupInfo has no signup courses,skip");
            return Collections.emptyList();
        }
        List<SplitPurchaseDto> purchaseData = new ArrayList<>(signupInfo.getOrgSignupCourses().size());
        Long totalNew = 0l;
        if (CollectionUtils.isNotEmpty(signupInfo.getOrgSignupCourses())) {// 新提交的课程
            for (OrgSignupCourse signupCourse : signupInfo.getOrgSignupCourses()) {
                if (signupCourse.getPayPrice().intValue() < 0) {
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程价格错误啦");
                }
                totalNew += signupCourse.getPayPrice();
                // 构造提交到支付
                purchaseData.add(SplitPurchaseDto.Builder.create().setCourseNumber(signupCourse.getOrgCourseNumber())
                        .setPayPrice(signupCourse.getPayPrice()).setPurchaseId(signupInfo.getSignupPurchaseId())
                        .setUserId(signupInfo.getUserId()).build());
            }
        }
        if (totalNew.longValue() > signupInfo.getTotalPrices().longValue()) {
            log.error("current total price:{},is more than signup total price:{},signup info:{}", totalNew,
                    signupInfo.getTotalPrices(), signupInfo);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课程价格和支付价格不一致错误");
        } else if (totalNew.longValue() < signupInfo.getTotalPrices().longValue()) {
            log.info("signupInfo:{} has not fill complete ,skip", signupInfo);
            return Collections.emptyList();
        }
        return purchaseData;
    }

    private Map<Long, OrgSignupInfo> getSignupInfoMap(Collection<Long> purchaseIds) {
        List<OrgSignupInfo> infos = orgSignupInfoDao.searchByPurchaseIdsWithCourseInfo(purchaseIds);
        if (CollectionUtils.isEmpty(infos)) {
            return Collections.emptyMap();
        }
        Map<Long, OrgSignupInfo> result = Maps.newHashMap();
        for (OrgSignupInfo orgSignupInfo : infos) {
            result.put(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo);
        }
        return result;
    }

    // private Map<Long, OrgSinupPurchase> getsinupPurchaseMap(Collection<Long> purchaseIds) {
    // List<OrgSinupPurchase> purchases = orgSinupPurchaseDao.getByPurchaseIds(purchaseIds);
    // if (CollectionUtils.isNotEmpty(purchases)) {
    // Map<Long, OrgSinupPurchase> result = new HashMap<>();
    // for (OrgSinupPurchase orgSinupPurchase : purchases) {
    // result.put(orgSinupPurchase.getPurchaseId(), orgSinupPurchase);
    // }
    // return result;
    // }
    // return Collections.emptyMap();
    // }

    /**
     * @param posCardSignup
     * @return
     */
    private OrgSignupSyncInfo getSyncInfo(Integer posCardSignup) {
        OrgSignupSyncInfo syncInfo = orgSignupSyncInfoDao.getOrgSignupSyncInfo(posCardSignup);
        if (syncInfo == null) {
            syncInfo = new OrgSignupSyncInfo();
            syncInfo.setSyncId(0l);
            try {
                syncInfo.setSyncTime(DateUtils.parseDate("2015-09-01", "yyyy-MM-dd"));
            } catch (ParseException e) {
                e.printStackTrace();
            }
            syncInfo.setSyncType(posCardSignup);
        }
        return syncInfo;

    }

    /**
     * 拆分订单
     *
     * @param purchaseData
     * @throws BussinessException
     */
    public static void splitSignupPurchase(List<SplitPurchaseDto> purchaseData) throws BussinessException {
        String response = "";
        try {
            Map<String, String> params = new HashMap<String, String>();
            params.put("purchaseData", JacksonUtil.obj2Str(purchaseData));
            log.debug("purchaseData", JacksonUtil.obj2Str(purchaseData));
            final String url = PropertiesReader.getValue("url", "splitOrgSinupPurchase.url");
            response = HttpClientUtils.doPost(url, params, HttpClientUtils.CHARSET);
            log.info("fillCourseInfo--splitSignupPurchase-->response {}", response);
        } catch (Exception e) {
            log.warn("split purchase get error:{}", e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "拆单失败");
        }
        checkPayResponse(response, PayResponseDto.class);

    }

    private static <T extends PayResponseDto> T checkPayResponse(String response, Class<T> type)
            throws BussinessException {
        T splitSignupPurchaseResponseDto = null;
        if (StringUtils.isNotEmpty(response)) {
            try {
                splitSignupPurchaseResponseDto = JacksonUtil.str2Obj(response, type);
            } catch (Exception e) {
                log.error("parse result:{} to object get error:{}", response, e);
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "拆单订单失败0");
            }
            if (splitSignupPurchaseResponseDto != null) {
                if (splitSignupPurchaseResponseDto.getCode() != 0) {
                    String message = "";
                    try {
                        message = new String(splitSignupPurchaseResponseDto.getMsg().getBytes("UTF-8"), "UTF-8");
                    } catch (UnsupportedEncodingException e) {
                        throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "拆单订单失败1");
                    }
                    // 特殊处理,兼容测试环境修改状态测试
                    if (!message.startsWith("当前机构收费订单已分拆完成!")) {
                        throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "拆单订单失败2");
                    }
                }
            }
            return splitSignupPurchaseResponseDto;
        }
        throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "拆单订单失败3");
    }

}
