
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.biz.erp.constant.StudentStatus;
import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.biz.erp.dto.request.*;
import com.baijia.tianxiao.biz.erp.dto.response.*;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.ConflictInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonScheduleInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.NameAndIdDto;
import com.baijia.tianxiao.biz.erp.enums.BatchOperateType;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.CommentStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.dto.DropDownListRequestDto;
import com.baijia.tianxiao.dal.org.dto.TimeTableRequestDto;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.DropdownListType;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.course.dto.HeaderDto;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.LessonConflictEnum;
import com.baijia.tianxiao.sal.course.service.*;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.enums.LessonStatus;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.beust.jcommander.internal.Lists;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentMap;

/**
 * @author cxm
 * @version 1.0
 * @title CourseLessonServiceImpl
 * @desc TODO
 * @date 2015年12月28日
 */
@Service
@Slf4j
public class CourseLessonServiceImpl implements CourseLessonService {
    
    private static final String DEFAULT_ROOM_OR_TEACHER_NAME = "未设置";
    
    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private TeacherDao teacherDao;

    @Resource
    private OrgClassRoomDao orgClassRoomDao;

    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;

    @Resource
    private OrgCourseListService orgCourseListService;

    @Resource
    private CourseStudentService courseStudentService;


    @Resource
    private CourseTeacherService courseTeacherService;

    @Resource
    private ClassRoomService classRoomService;

    @Resource
    private OrgInfoDao orgInfoDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private OrgStudentCourseService orgStudentCourseService;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Autowired
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;

    @Resource
    private OrgLessonSignService orgLessonSignService;

    @Resource
    private OrgLessonConflictService orgLessonConflictService;
    
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;
    
    @Resource
    private TXCascadeAccountDao cascadeAccountDao;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto) {
//        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
//        Preconditions.checkArgument(startDay != null, "start day can not be null");
//        Preconditions.checkArgument(dto != null, "class lessons param is illegal");
//        Preconditions.checkArgument(dto.getCourseId() != null && dto.getCourseId() > 0, "courseId is illegal");
//
//        List<Calendar> calens =
//            dto.getRepeatUnit().getAvaliableDays(startDay, dto.getRepeatCount(), dto.getRepeatRange());
//        TimeStamp startTime = TimeStamp.parse(dto.getStartTime());
//        TimeStamp endTime = TimeStamp.parse(dto.getEndTime());
//
//        OrgClassLesson lesson = null;
//        List<OrgClassLesson> lessons = Lists.newArrayList();
//        int index = 1;
//        for (Calendar cal : calens) {
//            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
//            lesson = new OrgClassLesson();
//            lesson.setStartTime(lessonTime.getStartTime());
//            lesson.setEndTime(lessonTime.getEndTime());
//            lesson.setCourseId(dto.getCourseId());
//            lesson.setCreateTime(new Date());
//            lesson.setDelStatus(DataStatus.NORMAL.getValue());
//            lesson.setLayoutId(0l);
//            lesson.setRoomId(dto.getRoomId() != null ? dto.getRoomId() : 0l);
//            lesson.setUpdateTime(new Date());
//            lesson.setNumber(index);
//            lesson.setOrgId(orgId);
//            lessons.add(lesson);
//            index++;
//
//            // orgClassLessonDao.save(lesson);
//        }
//        log.info("save {} lessons into db,params:{}", lessons.size(), dto);
//        orgClassLessonDao.saveAll(lessons, "startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId",
//            "roomId", "updateTime", "orgId");
//
//        /**
//         * 添加教室到课程
//         */
//        Set<Long> roomIds = Sets.newHashSet();
//        roomIds.add(dto.getRoomId() != null ? dto.getRoomId() : 0l);
//        classRoomService.addClassRoomCourse(orgId.longValue(), dto.getCourseId(), roomIds);
//
//        // 如果原来有课节的话,需要重新安排课节编号
//        resetLessonNumber(orgId, dto.getCourseId());
//        for (OrgClassLesson classLesson : lessons) {
//            courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
//                dto.getStudentIds(), true);
//            Set<Long> teacherIds = Sets.newHashSet();
//            if (dto.getTeacherId() != null && dto.getTeacherId() > 0) {
//                teacherIds.add(dto.getTeacherId());
//                Set<Long> tempTeacherIds = Sets.newHashSet();
//                tempTeacherIds.addAll(teacherIds);
//                courseTeacherService.addTeacherToCourse(orgId, classLesson.getCourseId(), teacherIds);// 先添加到课程
//                courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
//                    tempTeacherIds);
//            }
//        }

        AddCourseLessonRequestDtoForPC dtoForPC = new AddCourseLessonRequestDtoForPC();
        try {
            BeanUtils.copyProperties(dtoForPC,dto);
            //AddCourseLessonRequestDto 复写了get方法的字段,并且返回值不与原字段类型匹配的,无法copy
            if(CollectionUtils.isNotEmpty(dto.getStudentIds())) {
                dtoForPC.setStudentIds(StringUtils.join(dto.getStudentIds().toArray(),","));
            }
            dtoForPC.setRepeatUnit(dto.getRepeatUnit().getCode());
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        addClassLessonsForPC(orgId,startDay,endDay,dtoForPC);
    }



    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addClassLessonsForPC(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDtoForPC dto) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(startDay != null, "start day can not be null");
        Preconditions.checkArgument(dto != null, "class lessons param is illegal");
        Preconditions.checkArgument(dto.getCourseId() != null && dto.getCourseId() > 0, "courseId is illegal");


        OrgCourse orgCourse = orgCourseDao.getByCourseId(dto.getCourseId());
        // 1v1 的非班级不能添加课节
        if(orgCourse.getCourseType()==CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() ==CourseTypeEnum.IS_CLASS_FALSE.getCode()){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "当前版本不支持，请升级新版本");
        }
            
        
        List<Calendar> calens =
                dto.getRepeatUnit().getAvaliableDays(startDay, dto.getRepeatCount(), dto.getRepeatRange(),dto.getWeekDays(),dto.getCalendarDays());
        TimeStamp startTime = TimeStamp.parse(dto.getStartTime());
        TimeStamp endTime = TimeStamp.parse(dto.getEndTime());

        OrgClassLesson lesson = null;
        List<OrgClassLesson> lessons = Lists.newArrayList();
        List<OrgLessonConflict> lessonConflicts = Lists.newArrayList();
        int index = 1;
        for (Calendar cal : calens) {
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            lesson = new OrgClassLesson();
            lesson.setStartTime(lessonTime.getStartTime());
            lesson.setEndTime(lessonTime.getEndTime());
            lesson.setCourseId(dto.getCourseId());
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(DataStatus.NORMAL.getValue());
            lesson.setLayoutId(0l);
            lesson.setRoomId(dto.getRoomId() != null ? dto.getRoomId() : 0l);
            lesson.setUpdateTime(new Date());
            lesson.setNumber(index);
            lesson.setOrgId(orgId);
            lessons.add(lesson);
            index++;

            // orgClassLessonDao.save(lesson);
        }
        log.info("save {} lessons into db,params:{}", lessons.size(), dto);
        orgClassLessonDao.saveAll(lessons, "startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId",
                "roomId", "updateTime", "orgId");

        /**
         * 添加教室到课程
         */
        Set<Long> roomIds = Sets.newHashSet();
        roomIds.add(dto.getRoomId() != null ? dto.getRoomId() : 0l);
        classRoomService.addClassRoomCourse(orgId.longValue(), dto.getCourseId(), roomIds);

        // 如果原来有课节的话,需要重新安排课节编号
        resetLessonNumber(orgId, dto.getCourseId());
        for (OrgClassLesson classLesson : lessons) {
            courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
                    dto.getStudentIds(), true);
            Set<Long> teacherIds = Sets.newHashSet();
            Set<Long> tempTeacherIds = Sets.newHashSet();
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0) {
                teacherIds.add(dto.getTeacherId());
                tempTeacherIds.addAll(teacherIds);
                courseTeacherService.addTeacherToCourse(orgId, classLesson.getCourseId(), teacherIds);// 先添加到课程
                courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
                        tempTeacherIds);
            }

            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setLessonId(classLesson.getId());
            conflict.setOrgId(orgId);
            conflict.setRoomId(classLesson.getRoomId()==null?0:classLesson.getRoomId());
            conflict.setStartTime(classLesson.getStartTime());
            conflict.setEndTime(classLesson.getEndTime());

            if(tempTeacherIds.size() > 1){
                int i = 1;
                for(Iterator<Long> teacherIt=tempTeacherIds.iterator();teacherIt.hasNext();i++){
                    if(i > 1){
                        try {
                            OrgLessonConflict cloneConflict = (OrgLessonConflict) BeanUtils.cloneBean(conflict);
                            cloneConflict.setTeacherId(teacherIt.next());
                            lessonConflicts.add(cloneConflict);
                        } catch (Exception e) {
                            throw new RuntimeException("clone bean error:",e);
                        }
                    }else{
                        conflict.setTeacherId(teacherIt.next());
                        lessonConflicts.add(conflict);
                    }
                }
            }else{
                conflict.setTeacherId(dto.getTeacherId()==null?0:dto.getTeacherId());
                lessonConflicts.add(conflict);
            }


        }


        //添加冲突检测表数据
        orgLessonConflictService.saveOrgLessonConflicts(lessonConflicts);
    }



    @Override
    @Transactional(readOnly = true)
    public ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        // Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        List<OrgClassLesson> lessons = queryLesson(orgId, lessonIdTeacherIdMap, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>() {
                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }

            Map<Long, OrgCourse> courseMap = Maps.newHashMap();
           // bugfix 这里如果校验是否需要课程名字，后面的组装对象的逻辑就无法通过判断课程是否删除来过滤无效的课节，所以注释掉，以确保程序正确
           // if (params.isNeedcourseName()) {
                courseMap = getOrgCourseMap(orgId, courseIds);
           // }
            Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = getOrgClassRoomMap(roomIds);
            }

            Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
            Map<Long, Integer> signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);
            }
            Map<Long, Integer> commentCount = Maps.newHashMap();
            Map<Long, Integer> lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument(params.getStudentId() != null && params.getStudentId() > 0, "学生ID不正确");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());

                commentCount = orgLessonCommentDao.getLessonCommentCountMap(lessonIds, orgId, userId, null,
                    UserRole.STUDENT.getRole(), false);

                List<OrgLessonSign> lessonSign = orgLessonSignDao.getStudentSign(orgId, userId,
                    UserRole.STUDENT.getRole(), lessonIds, "lessonId", "status");
                if (CollectionUtils.isNotEmpty(lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap(lessonSign, new Function<OrgLessonSign, Long>() {
                        @Override
                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, new Function<OrgLessonSign, Integer>() {
                        @Override
                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", lessonSignStatus);
                }
            }

            result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap,
                studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }
    @Override
    @Transactional(readOnly = true)
    public ListLessonResponseDto listSignInLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        // Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        List<OrgClassLesson> lessons = querySignInLesson(orgId, lessonIdTeacherIdMap, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>() {
                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }

            Map<Long, OrgCourse> courseMap = Maps.newHashMap();
            // bugfix 这里如果校验是否需要课程名字，后面的组装对象的逻辑就无法通过判断课程是否删除来过滤无效的课节，所以注释掉，以确保程序正确
            // if (params.isNeedcourseName()) {
            courseMap = getOrgCourseMap(orgId, courseIds);
            // }
            Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = getOrgClassRoomMap(roomIds);
            }

            Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
            Map<Long, Integer> signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);
            }
            Map<Long, Integer> commentCount = Maps.newHashMap();
            Map<Long, Integer> lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument(params.getStudentId() != null && params.getStudentId() > 0, "学生ID不正确");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());

                commentCount = orgLessonCommentDao.getLessonCommentCountMap(lessonIds, orgId, userId, null,
                    UserRole.STUDENT.getRole(), false);

                List<OrgLessonSign> lessonSign = orgLessonSignDao.getStudentSign(orgId, userId,
                    UserRole.STUDENT.getRole(), lessonIds, "lessonId", "status");
                if (CollectionUtils.isNotEmpty(lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap(lessonSign, new Function<OrgLessonSign, Long>() {
                        @Override
                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, new Function<OrgLessonSign, Integer>() {
                        @Override
                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", lessonSignStatus);
                }
            }

            result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap,
                studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    private Map<Long, String> getLessonIdTeacherName(Long orgId, Collection<Long> lessonIds,
        Map<Long, Long> lessonTeacherIdMap) {
        if (MapUtils.isEmpty(lessonTeacherIdMap)) {
            lessonTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        }
        Map<Long, String> teacherNameMap = teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        Map<Long, String> lessonIdTeacherNameMap = new HashMap<>(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, teacherNameMap.get(lessonTeacherIdMap.get(lessonId)));
        }
        return lessonIdTeacherNameMap;
    }

    @SuppressWarnings("unchecked")
    private List<OrgClassLesson> queryLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap,
        ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(),null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);
                log.debug("user cascadeId={},courseIds={}",TianxiaoMContext.getTXCascadeId(),tempIds);
                // bugfix 此处根据课程权限获取用户课节的逻辑有问题，如果用户指定查询一门课的课节会查出用户课程权限下的所有课节，故调整逻辑
                if(CollectionUtils.isEmpty(courseIds)){
                    courseIds.addAll(tempIds);
                }else{
                    // 如果是子帐号，并且指定了课程，那么需要判断课程是否在这个用户的权限中
                    if(!tempIds.containsAll(courseIds)){
                        courseIds.clear();
                    }
                }

                log.debug("after set courseIds:{}", courseIds);
                if(CollectionUtils.isEmpty(courseIds)){
                    return Collections.EMPTY_LIST;
                }

            }
        }

        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty(lessonIds)) {
                return Collections.emptyList();
            }
        }

        lessonIdTeacherIdMap = queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty(teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());

        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime  = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }

        List<OrgClassLesson> lessons = orgClassLessonDao.queryLessons(orgId, courseIds, roomIds, lessonIds, startTime,
            endTime, params.getPageDto());
        return lessons;
    }
    @SuppressWarnings("unchecked")
    private List<OrgClassLesson> querySignInLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap,
        ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(),null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);
                log.debug("user cascadeId={},courseIds={}",TianxiaoMContext.getTXCascadeId(),tempIds);
                // bugfix 此处根据课程权限获取用户课节的逻辑有问题，如果用户指定查询一门课的课节会查出用户课程权限下的所有课节，故调整逻辑
                if(CollectionUtils.isEmpty(courseIds)){
                    courseIds.addAll(tempIds);
                }else{
                    // 如果是子帐号，并且指定了课程，那么需要判断课程是否在这个用户的权限中
                    if(!tempIds.containsAll(courseIds)){
                        courseIds.clear();
                    }
                }

                log.debug("after set courseIds:{}", courseIds);
                if(CollectionUtils.isEmpty(courseIds)){
                    return Collections.EMPTY_LIST;
                }

            }
        }

        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty(lessonIds)) {
                return Collections.emptyList();
            }
        }

        lessonIdTeacherIdMap = queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty(teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());

        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime  = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }

        List<OrgClassLesson> lessons = orgClassLessonDao.querySignInLessons(orgId, courseIds, roomIds, lessonIds, startTime,
            endTime, params.getPageDto(), params.getLessonId());
        return lessons;
    }

    @Override
    @Transactional(readOnly = true)
    public List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument(params.getStartTime() != null && params.getEndTime() != null,
            "start time or end time is null");
        Preconditions.checkArgument(params.getEndTime().after(params.getStartTime()), "time condition error");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        List<OrgClassLesson> lessons = queryLesson(orgId, lessonIdTeacherIdMap, params, false);
        if (CollectionUtils.isNotEmpty(lessons)) {
            Set<Long> lessonIds = Sets.newHashSet();
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            if (lessonIdTeacherIdMap.isEmpty()) {
                lessonIdTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
                log.debug("query lessonId teacherId map:{}by lessonIds:{}", lessonIdTeacherIdMap, lessonIds);
            }
            Map<Long, OrgCourse> courseMap = getOrgCourseMap(orgId, courseIds);
            Map<Long, String> teacherNameMap = teacherDao.getTeacherRealNameMap(lessonIdTeacherIdMap.values());
            Map<Long, OrgClassRoom> classRoomMap = getOrgClassRoomMap(roomIds);
            List<LessonTimeTableResponseDto> result = Lists.newArrayList();
            for (OrgClassLesson lesson : lessons) {
                Long teacherId = lessonIdTeacherIdMap.get(lesson.getId());
                //bufix 稍加修改，过滤掉已经删除的课程
                OrgCourse tempCourse = courseMap.get(lesson.getCourseId());
                if(tempCourse!=null && tempCourse.getIsDel()==0){
                    LessonTimeTableResponseDto dto = buildTimeTableDto(lesson, tempCourse,
                        classRoomMap.get(lesson.getRoomId()), teacherId, teacherNameMap.get(teacherId));
                    result.add(dto);
                }
            }
            return result;
        } else {
            return Collections.emptyList();
        }
    }

    private Map<Long, OrgClassRoom> getOrgClassRoomMap(Collection<Long> roomIds) {
        List<OrgClassRoom> classRooms = orgClassRoomDao.getByIds(roomIds, "id", "roomName", "roomSize");
        return CollectorUtil.collectMap(classRooms, new Function<OrgClassRoom, Long>() {
            @Override
            public Long apply(OrgClassRoom input) {
                return input.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getOrgCourseMap(Long orgId, Collection<Long> courseIds) {
        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds, "id", "cover", "name", "color","isDel", "courseType");

        Iterator<OrgCourse> courseIter = courseList.iterator();
        while (courseIter.hasNext()) {
            OrgCourse orgCourse = courseIter.next();
            if(orgCourse.getIsDel()!=0){
                courseIter.remove();
            }
        }

        // 批量设置一下颜色
        orgCourseListService.getCourseList(courseList, orgId, false, false, false, false, false, false, false);
        return CollectorUtil.collectMap(courseList, new Function<OrgCourse, Long>() {
            @Override
            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
    }

    private LessonTimeTableResponseDto buildTimeTableDto(OrgClassLesson lesson, OrgCourse course,
        OrgClassRoom classRoom, Long teacherId, String teacherName) {
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        dto.setCourseId(lesson.getCourseId());
        if (course != null) {
            dto.setCourseColor(course.getColor());
            dto.setCourseName(course.getName());
        }
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setLessonId(lesson.getId());
        dto.setIndex(lesson.getNumber());
        dto.setRoomId(lesson.getRoomId());
        if (classRoom != null) {
            dto.setRoomName(classRoom.getRoomName());
        }
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        dto.setTeacherId(teacherId);
        dto.setTeacherName(teacherName);
        return dto;
    }

    private ListLessonResponseDto buildListLessonResponseDto(List<OrgClassLesson> lessons,
        Map<Long, OrgCourse> courseMap, Map<Long, String> lessonIdTeacherNameMap, Map<Long, OrgClassRoom> classRoomMap,
        Map<Long, Integer> studentCountMap, Map<Long, Integer> signStudentCountMap, Map<Long, Integer> commentCount,
        Map<Long, Integer> lessonSignStatus) {
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Date now = new Date();
            for (OrgClassLesson lesson : lessons) {
                if (result.getFirstLessonStartTime() == null
                    || result.getFirstLessonStartTime().after(lesson.getStartTime())) {
                    result.setFirstLessonStartTime(lesson.getStartTime());
                }
                if (result.getLastLessonStartTime() == null
                    || result.getLastLessonStartTime().before(lesson.getStartTime())) {
                    result.setLastLessonStartTime(lesson.getStartTime());
                }

                LessonResponseDto dto = new LessonResponseDto();
                dto.setCourseId(lesson.getCourseId());
                dto.setIndex(lesson.getNumber());
                OrgCourse course = courseMap.get(lesson.getCourseId());
                // bugfix 课程不存在则过滤掉，解决删除课程，课节并未删除，在签到列表展示的问题
                if(course == null){
                    continue;
                }
                if (StringUtils.isNotBlank(course.getName())) {
                    dto.setCourseName(course.getName());
                }
                dto.setCourseType(course.getCourseType().intValue());
                OrgClassRoom classRoom = classRoomMap.get(lesson.getRoomId());
                dto.setRoomId(lesson.getRoomId());
                if (classRoom != null) {
                    dto.setRoomName(classRoom.getRoomName());
                }
                dto.setTeacherName(lessonIdTeacherNameMap.get(lesson.getId()));
                dto.setLessonEndTime(lesson.getEndTime());
                dto.setLessonId(lesson.getId());
                dto.setLessonStartTime(lesson.getStartTime());
                CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
                if (now.after(lesson.getEndTime())) {
                    // 设置课程结束标记
                    signStatus = CourseSignStatus.NO_SIGN;
                    dto.setIsOver(1);
                }
                if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.SIGNING;
                }
                Integer signCount = signStudentCountMap.get(lesson.getId());
                SignStatus stuSignStatus = SignStatus.getSignStatusByCode(lessonSignStatus.get(lesson.getId()));
                if (stuSignStatus != null) {
                    log.debug("lessonId:{},lessonSignStatus:{},status:{}", lesson.getId(), lessonSignStatus,
                        stuSignStatus);
                    dto.setSignStatusEnum(stuSignStatus);
                } else {

                    if (signCount != null && signCount > 0) {
                        signStatus = CourseSignStatus.SIGNED;
                    }
                    dto.setCourseSignStatusEnum(signStatus);
                }

                Integer commentCnt = commentCount.get(lesson.getId());
                if (commentCnt != null && commentCnt > 0) {
                    dto.setCommentEnum(CommentStatus.COMMENTED);
                } else {
                    dto.setCommentEnum(
                        CommentStatus.getCommentStatusByTime(lesson.getStartTime(), lesson.getEndTime(), true));
                }

                Integer studentCount = studentCountMap.get(lesson.getId());
                dto.setSignCount(signCount != null ? signCount : 0);
                dto.setStudentCount(studentCount != null ? studentCount : 0);
                result.getList().add(dto);
            }
        }
        return result;

    }

    private Map<Long, Long> queryLessonIdByTeacherId(Long orgId, Collection<Long> teacherIds) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Collections.emptyMap();
        }
        List<OrgTeacherLesson> teacherLessons =
            orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, "lessonId", "teacherId");
        if (CollectionUtils.isNotEmpty(teacherLessons)) {
            Map<Long, Long> result = new HashMap<>();
            for (OrgTeacherLesson orgTeacherLesson : teacherLessons) {
                result.put(orgTeacherLesson.getLessonId(), orgTeacherLesson.getTeacherId());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly = true)
    public LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        Date now = new Date();
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", lessonId, lesson);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID不正确");
        }
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        // set course info
        OrgCourse course = orgCourseDao.getByCourseId(lesson.getCourseId(), "id", "name", "courseType", "color","isFinish");
        if (course == null) {
            log.warn("can not found course by lesson:{}", lesson);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "无法找到对应班级");
        }
        dto.setCourseColor(course.getColor());
        dto.setCourseId(course.getId());
        dto.setCourseType(course.getCourseType().intValue());
        dto.setCourseName(course.getName());
        dto.setCourseFinish(course.getIsFinish());
        // set lesson info
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setIndex(lesson.getNumber());
        dto.setLessonId(lesson.getId());
        CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
        if (now.after(lesson.getStartTime())) {
            signStatus = CourseSignStatus.NO_SIGN;
            if (now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
        }
        dto.setRoomId(lesson.getRoomId());
        dto.setSignStatusEnum(signStatus);
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        return dto;
    }

    @Override
    @Transactional(readOnly = true)
    public LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign) {
        LessonTimeTableResponseDto dto = lessonInfo(orgId, lessonId);
        // set student
        dto.setStudents(courseStudentService.getLessonStudent(orgId, lessonId, needStudentSign));
        for (OrgStudentsChooseListDto student : dto.getStudents()) {
            if (student.getSignStatus() != null && SignStatus.SIGNED.getCode() == student.getSignStatus()) {
                dto.increaseSignStudent();
            }
        }
        List<TeacherResponseDto> teacherDtos = courseTeacherService.getLessonTeacher(orgId, lessonId);
        if (CollectionUtils.isNotEmpty(teacherDtos)) {
            TeacherResponseDto teacherDto = teacherDtos.get(0);
            dto.setTeacherId(teacherDto.getTeacherId());
            dto.setTeacherName(teacherDto.getTeacherName());
        }
        // set room info
        if (dto.getRoomId() != null && dto.getRoomId() > 0) {
            OrgClassRoom classRoom = orgClassRoomDao.getById(dto.getRoomId(), "id", "roomName");
            dto.setRoomName(classRoom.getRoomName());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", lessonId, lesson);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节不存在或已被删除");
        }
        
        //删除课节权限判断
        //add by zhangbing
        hasDeleteLessonPermission(lesson.getCourseId());
        
        if (CollectionUtils.isNotEmpty(orgLessonCommentDao.getLessonComments(lessonId, null, null, "id"))) {
            throw new BussinessException(CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty(
            orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, null, null, "id"))) {
            throw new BussinessException(CommentErrorCode.LESSON_WITH_SIGN);
        }
        courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);

        orgClassLessonDao.delById(lessonId);
        resetLessonNumber(orgId, lesson.getCourseId());

        //冲突检测表逻辑删除
        List<Long> lessonIds = Lists.newArrayList(1);
        lessonIds.add(lessonId);
        orgLessonConflictService.delByLessonIds(orgId,lessonIds);

    }
    
    void hasDeleteLessonPermission(Long courseId) {
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(),null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);
                if (CollectionUtils.isEmpty(tempIds) || !tempIds.contains(courseId)) {
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "无权操作");
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void editLesson(Long orgId, EditLessonRequestDto editDto) {
        Preconditions.checkNotNull(editDto, "param can not be null");
        editDto.validate();
        OrgClassLesson lesson = orgClassLessonDao.getById(editDto.getLessonId());
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", editDto.getLessonId(), lesson);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID不正确");
        }
        //员工只能编辑自己是班主任的班级课节
        this.editValidate(lesson.getCourseId());
        lesson.setDelStatus(DataStatus.NORMAL.getValue());
        boolean needRearrange = false;
        if (!editDto.getEndTime().equals(lesson.getEndTime())
            || !editDto.getStartTime().equals(lesson.getStartTime())) {
            lesson.setEndTime(editDto.getEndTime());
            lesson.setStartTime(editDto.getStartTime());
            // 需要重新设置number
            needRearrange = true;
        }
        List<Long> teacherIds = Lists.newArrayList();
        if (editDto.getRoomId() == null) {
            editDto.setRoomId(0l);
        }
        if (editDto.getTeacherId() == null) {
            editDto.setTeacherId(0l);
        } else {
            teacherIds.add(editDto.getTeacherId());
        }
        lesson.setRoomId(editDto.getRoomId());
        lesson.setUpdateTime(new Date());

        orgClassLessonDao.update(lesson);
        if (needRearrange) {
            resetLessonNumber(orgId, lesson.getCourseId());
        }

        /**
         * 添加教室到课程
         */
        Set<Long> roomIds = Sets.newHashSet();
        roomIds.add(editDto.getRoomId() != null ? editDto.getRoomId() : 0l);
        classRoomService.addClassRoomCourse(orgId.longValue(), lesson.getCourseId(), roomIds);

        courseTeacherService.resetLessonTeacher(orgId, lesson.getCourseId(), lesson.getId(), teacherIds);
        // courseStudentService.resetLessonStudent(orgId, lesson.getCourseId(), lesson.getId(),
        // editDto.getStudentIds());


        //更新冲突检测表
        OrgLessonConflict conflict = new OrgLessonConflict();
        conflict.setOrgId(orgId);
        conflict.setTeacherId(editDto.getTeacherId());
        conflict.setRoomId(editDto.getRoomId());
        conflict.setLessonId(editDto.getLessonId());
        conflict.setStartTime(editDto.getStartTime());
        conflict.setEndTime(editDto.getEndTime());
        conflict.setDelStatus(DataStatus.NORMAL.getValue());
        orgLessonConflictService.updateOrgLessonConflictsForce(conflict);
    }
    
    void editValidate(Long courseId) {
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = cascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(),null,null,null);
                if (CollectionUtils.isEmpty(tempIds) || !tempIds.contains(courseId)) {
                    throw new BussinessException(CommonErrorCode.PERMISSION_DENY, "无权操作不属于您的课节");
                }
            }
        }
    }

    private void resetLessonNumber(Long orgId, Long courseId) {
        List<OrgClassLesson> lessons =
            orgClassLessonDao.queryLessons(orgId, Lists.newArrayList(courseId), null, null, null, null, null, "id");
        if (CollectionUtils.isNotEmpty(lessons)) {
            int index = 1;
            @SuppressWarnings("unchecked")
            Map<String, Number>[] params = new Map[lessons.size()];
            for (OrgClassLesson lesson : lessons) {
                Map<String, Number> param = new HashMap<>();
                param.put("id", lesson.getId());
                param.put("number", index);
                params[index - 1] = param;
                index++;
            }
            orgClassLessonDao.batchUpdateLessonNumber(params);
        }
    }

    @Override
    @Transactional(readOnly = true)
    public Long getTeacherId(Long orgId, Long lessonId) {
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        if (teacherLesson != null) {
            return teacherLesson.getTeacherId();
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    public List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        return this.orgStudentLessonDao.getUserIdsByLessonIds(orgId, lessonIds);
    }

    @Override
    public void export(HttpServletResponse response, Long orgId, ListLessonsRequestDto param,
        List<LessonTimeTableResponseDto> dtoList) {
        Preconditions.checkArgument(param.getStartTime() != null, "开始日期不能为空");
        Preconditions.checkArgument(param.getEndTime() != null, "结束日期不能为空");
        Preconditions.checkArgument(orgId != null && orgId.longValue() > 0L, "机构ID不能为空");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String startTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getStartTime());
        String endTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getEndTime());
        String fileName = orgName + "-课表统计-" + startTimeStr + "~" + endTimeStr + ".xlsx";
        SXSSFWorkbook workbook = null;
        List<Date> dates = DateUtil.getDateBetween(param.getStartTime(), param.getEndTime());

        try {
            workbook = new SXSSFWorkbook(200);
            HashMap cellStyleMap = new HashMap();
            List summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField(" ", "@", 5620));
            for (Date date : dates) {
                summaryFields.add(new ExportField(
                    "周" + DateUtil.getChineseWeekDay(date) + "(" + DateUtil.getDayStr(date) + ")", "@", 5120));
            }
            List titles = Lists.newArrayList();
            titles.add(startTimeStr + "~" + endTimeStr + "课表统计");

            ExcelCourseExportService.createSheet(workbook, "课表统计", titles, cellStyleMap, summaryFields, dtoList,
                param.getStartTime());
            ExcelCourseExportService.exportExcel(response, workbook, fileName);
            log.debug("course lesson export success");
        } catch (Exception var20) {
            log.error("export catch exception:", var20);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "导出数据处理异常");
        } finally {
            try {
                workbook.close();
            } catch (IOException var19) {
                log.error("close workbook catch error:", var19);
            }

        }

    }

    public static void main(String[] args) throws IOException {
        String json = FileUtils.readFileToString(new File("/Users/wengshengli/Downloads/response.json"));
        List dtoList = JacksonUtil.str2List(json, LessonTimeTableResponseDto.class);
        Date startDate = new Date(1465747200682l);
        Date endDate = new Date(1466351999682l);
        System.out.println(DateUtil.getDateDiff(startDate, endDate));
        List<Date> dates = DateUtil.getDateBetween(startDate, endDate);
        SXSSFWorkbook workbook = new SXSSFWorkbook(200);
        HashMap cellStyleMap = new HashMap();
        List summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("", "@", 5620));
        for (Date date : dates) {
            summaryFields.add(new ExportField(
                "周" + DateUtil.getChineseWeekDay(date) + "(" + DateUtil.getDayStr(date) + ")", "@", 5120));
        }
        List titles = Lists.newArrayList();
        titles.add("课节汇总表");
        ExcelCourseExportService.createSheet(workbook, "课节汇总", titles, cellStyleMap, summaryFields, dtoList, startDate);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write(new FileOutputStream(excelFile));
    }

    @Override
    public HeaderDto getHeaderInfo() {
        HeaderDto dto = new HeaderDto();
        Integer txCascadeAccountId = TianxiaoMContext.getTXCascadeId();
        if (txCascadeAccountId == null) {
            return dto;
        }
        OrgAccount orgAccount = orgAccountDao.getAccountById(TianxiaoMContext.getOrgId());
        if (orgAccount == null) {
            log.info("orgAccount doesn't exist! orgAccountId:{}", TianxiaoMContext.getOrgId());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "您无权使用此功能");
        }
        TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(txCascadeAccountId);
        if (txCascadeAccount == null) {
            log.info("txCascadeAccount doesn't exist! txCascadeAccountId:{}", txCascadeAccountId);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "您无权使用此功能");
        }
        // 员工显示自己的班级
        // 主管显示机构的班级
        List<Long> courseIds = Lists.newArrayList();
        Integer notSignCount = 0;
        if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
            courseIds = orgCourseDao.getCourseIdsByCascadeId(txCascadeAccountId, null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);
            if(CollectionUtils.isNotEmpty(courseIds)){
                notSignCount = orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
            }
        }
        if (txCascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
            notSignCount = orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
            courseIds = orgCourseDao.getCourseIds(orgAccount.getNumber().longValue(), null,null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);
        }
        Integer totalCount = courseIds.size();
        dto.setClassCount(totalCount);
        dto.setSignCount(notSignCount);
        return dto;
    }

    @Override
    @Transactional(readOnly = true)
    public ListLessonResponseDto  queryCourseLessons(Long orgId,ListLessonsRequestDto params){
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        List<OrgClassLesson> lessons = queryLesson(orgId, lessonIdTeacherIdMap, params, true);
        List<Long> courseIds = new ArrayList<Long>();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>() {
                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }

            Map<Long, OrgCourse> courseMap = getOrgCourseMap(orgId, courseIds);


            Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
            Map<Long, Integer> signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);
            }
            Map<Long, Integer> commentCount = Maps.newHashMap();
            Map<Long, Integer> lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument(params.getStudentId() != null && params.getStudentId() > 0, "学生ID不正确");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());

                commentCount = orgLessonCommentDao.getLessonCommentCountMap(lessonIds, orgId, userId, null,
                    UserRole.STUDENT.getRole(), false);

                List<OrgLessonSign> lessonSign = orgLessonSignDao.getStudentSign(orgId, userId,
                    UserRole.STUDENT.getRole(), lessonIds, "lessonId", "status");
                if (CollectionUtils.isNotEmpty(lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap(lessonSign, new Function<OrgLessonSign, Long>() {
                        @Override
                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, new Function<OrgLessonSign, Integer>() {
                        @Override
                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", lessonSignStatus);
                }
            }

            Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
            Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
            result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap,
                studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);

            Date now = new Date();
            int lastRow = result.getList().size()-1;
            if(lastRow>=0){
                result.setNewLessonId(result.getList().get(lastRow).getLessonId());
                for(LessonResponseDto lesson:result.getList()){
                    if(now.before(lesson.getLessonEndTime())){
                        result.setNewLessonId(lesson.getLessonId());
                        break;
                    }
                }
            }
            

        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }
    
    /**
     * 课节列表查询
     * 1.teacherId与courseId、roomId不在一张表,为了避免表查询,做如下处理
     *   1.1:如果筛选条件有老师ID，那么在tts.org_teacher_lesson表查出这个所教的课节ID集合
     *       1.1.1:再讲lessonIds作为查询条件在tts.org_class_lesson中筛选lesson
     *   1.2:如果筛选条件没有老师ID，直接在tts.org_class_lesson查询
     */
    @Override
    public List<LessonScheduleInfoDto>  queryCourseLessonsByParams(Long orgId, TimeTableRequestDto params, PageDto pageDto) {
        Collection<Long> lessonIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(params.getTeacherIds())) {
            List<OrgTeacherLesson> teacherLessons = orgTeacherLessonDao.queryTeacherLessons(orgId, params.getTeacherIds(), "lessonId");
            if (CollectionUtils.isNotEmpty(teacherLessons)) {
                lessonIds = BaseUtils.getPropertiesList(teacherLessons, "lessonId");
            }
        }
        
//        // 如果用户在筛选条件中选择了课程,那么需要查询当前登录用户具有哪些课程的查询权限
//        // 如果用户没有设置，那么需要判断用户具有的数据访问权限，设置课程ID集合
//        if (CollectionUtils.isEmpty(params.getCourseIds())) {
//            List<Long> courseIds = getCurrentUserCoursesIds();
//            if (CollectionUtils.isNotEmpty(courseIds)) {
//                params.setCourseIds(courseIds);
//            }
//        }
        List<OrgClassLesson> lessons = this.orgClassLessonDao.getOrgClassLessonByParams(orgId, params, lessonIds, pageDto);
        List<LessonScheduleInfoDto> data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set<Long> roomIds = BaseUtils.getPropertiesList(result, "roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();
                
                Set<Long> courseIds = BaseUtils.getPropertiesList(result, "courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds);
                Map<Long,OrgCourse> map = Maps.newHashMap();
                for(OrgCourse course : courseList){
                    map.put(course.getId(),course);
                }
                
                for (LessonResponseDto dto : result) {
                    //如果是1v1班级,并且班级人数=0的话就不在前段展示
                    if(map.get(dto.getCourseId()).getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && dto.getStudentCount() == 0){
                        continue;
                    }
                    Long courseId = dto.getCourseId();
                    
                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setRoomId(dto.getRoomId());
                    if (dto.getRoomId() == null || dto.getRoomId() <= 0) {
                        item.setRoomName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setRoomName(dto.getRoomName());
                        
                    }
                    
                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    if (dto.getTeacherId() == null || dto.getTeacherId() <= 0) {
                        item.setTeacherName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setTeacherName(dto.getTeacherName());
                        
                    }
                    
                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    if (now.before(dto.getLessonStartTime())) {
                        item.setLessonStatus(LessonStatus.UN_START.getStatus());
                    } else if (now.after(dto.getLessonEndTime())) {
                        item.setLessonStatus(LessonStatus.FINISHED.getStatus());
                    } else {
                        item.setLessonStatus(LessonStatus.ONGOING.getStatus());
                    }
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }
                    item.setCourseType(dto.getCourseType()==null?CourseTypeEnum.COURSE_TYPE_CLASS.getCode():dto.getCourseType());
                    
                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }
                    //封装冲突信息
                   // wrapConflictInfo(orgId, item);
                    /*if (params.getIsConflict() == BizConf.TRUE && item.getIsConflict() == BizConf.FALSE) {
                        continue;
                    } */
                    
                    data.add(item);
                }
                if(CollectionUtils.isNotEmpty(data)){
                    buildConflictInfo(orgId,params.getStartTime(),params.getEndTime(),data);
                    List<LessonScheduleInfoDto> tempList = Lists.newArrayList();
                    for(LessonScheduleInfoDto dto:data){
                        if (params.getIsConflict() == BizConf.TRUE && dto.getIsConflict() == BizConf.FALSE) {
                            continue;
                        } 
                        tempList.add(dto);
                    }
                    log.info("end buildConflictInfo orgId:{},params={},data.size={},tempList.size={}",orgId,params,data.size(),tempList.size());
                    data = tempList;
                    
                }
                
            }
        }
        log.info("queryCourseLessonsByCourseId.orgId:{}, params:{}, data:{}", orgId, params, data);
        return data;
    }
    
    private void buildConflictInfo(Long orgId,Long startTime,Long endTime,List<LessonScheduleInfoDto> lessonScheduleDto){
        Set<Long> teacherIdSet = Sets.newHashSet();
        Set<Long> roomIdSet = Sets.newHashSet();
        
        boolean needFindTime = false;
        if(startTime == null || endTime == null){
            needFindTime = true;
        }
        if(CollectionUtils.isEmpty(lessonScheduleDto)){
            return;
        }
        for(LessonScheduleInfoDto dto:lessonScheduleDto){
            if(dto.getTeacherId()!=null && dto.getTeacherId()>0){
                teacherIdSet.add(dto.getTeacherId());
            }
            if(dto.getRoomId() != null && dto.getRoomId()>0){
                roomIdSet.add(dto.getRoomId());
            }
            if(needFindTime){
                if(startTime == null||startTime>dto.getStartTime()){
                    startTime = dto.getStartTime();
                }
                
                if(endTime == null||endTime<dto.getEndTime()){
                    endTime = dto.getEndTime();
                }
            }
            
        }
        Date startDate = new Date(startTime);
        Date endDate = new Date(endTime);
        
        Map<Long,List<OrgLessonConflict>>  teacherConflictMap = orgLessonConflictDao.queryConfilctByTeacherIdsAndTimeRange(orgId, teacherIdSet, startDate, endDate);
       // log.info("finish query teacherConflictMap,orgId={},result={}",orgId,teacherConflictMap);
        Map<Long,List<OrgLessonConflict>>  roomConflictMap = orgLessonConflictDao.queryConfilctByClassRoomIdsAndTimeRange(orgId, roomIdSet, startDate, endDate);
     //   log.info("finish queryroomConflictMap,orgId={},result={}",roomConflictMap);
        Map<Long,Integer> lessonTeacherConflictCount = checkConflictCount(teacherConflictMap);
        log.info("finish build lessonTeacherConflictCount,orgId={},result={}",orgId,lessonTeacherConflictCount);
        Map<Long,Integer> lessonRoomConflictCount = checkConflictCount(roomConflictMap);
        log.info("finish build lessonRoomConflictCount,orgId={},result={}",orgId,lessonRoomConflictCount);
        
        for(LessonScheduleInfoDto dto:lessonScheduleDto){
            LessonConflictEnum conflict = LessonConflictEnum.NO_CONFLICT;
            
            Integer teacherConflictNum = lessonTeacherConflictCount.get(dto.getLessonId());
            if(teacherConflictNum==null){
                teacherConflictNum = 0;
            }
            Integer roomConflictNum = lessonRoomConflictCount.get(dto.getLessonId());
            if(roomConflictNum == null){
                roomConflictNum = 0;
            }
            if(teacherConflictNum > 0 && roomConflictNum > 0){
                conflict = LessonConflictEnum.TEACHER_AND_ROOM;
            }else if(teacherConflictNum > 0){
                conflict = LessonConflictEnum.TEACHER;
            }else if(roomConflictNum > 0){
                conflict = LessonConflictEnum.ROOM;
            }
            ConflictInfoDto conflictInfo = null;
            if (conflict != null && conflict != LessonConflictEnum.NO_CONFLICT) {
                conflictInfo = new ConflictInfoDto();
                conflictInfo.setConflictType(conflict.getCode());
                conflictInfo.setConflictTypeStr(conflict.getNote());
                dto.setIsConflict(BizConf.TRUE);
            } else {
                dto.setIsConflict(BizConf.FALSE);
            }
            
            dto.setConflictInfo(conflictInfo);
        }
        
    }
    
    public Map<Long,Integer> checkConflictCount(Map<Long,List<OrgLessonConflict>> conflictMap){
        /*while(list.size() >0 ){
        OrgLessonConflict conflict = list.get(0);
        for(OrgLessonConflict temp:list ){
            if(temp == conflict){
                continue;
            }
            if(conflict.getEndTime().getTime()>temp.getStartTime().getTime() && conflict.getStartTime().getTime() < temp.getEndTime().getTime()){
               // lessonIds.add()
            }
        }
        }*/
      
        Map<Long,Integer> conflictLessonCountMap = Maps.newHashMap();
       
        for (List<OrgLessonConflict> list : conflictMap.values()) {
            int size = list.size();
            for (int i = 0; i < size - 1; i++) {
                OrgLessonConflict conflict = list.get(i);

                for (int j = i + 1; j < size; j++) {
                    OrgLessonConflict temp = list.get(j);
                    
                    if (conflict.getEndTime().getTime() > temp.getStartTime().getTime()
                        && conflict.getStartTime().getTime() < temp.getEndTime().getTime()) {

                        Integer count = conflictLessonCountMap.get(conflict.getLessonId());
                        if (count == null) {
                            count = new Integer(0);
                        }
                        count++;
                        conflictLessonCountMap.put(conflict.getLessonId(), count);

                        Integer count2 = conflictLessonCountMap.get(temp.getLessonId());
                        if (count2 == null) {
                            count2 = new Integer(0);
                        }
                        count2++;
                        conflictLessonCountMap.put(temp.getLessonId(), count2);

                    }
                }

            }
        }
        return conflictLessonCountMap;
    }
    
    /**
     * 获取并缓存课程已上完的课结数
     * @param orgId
     * @param courseId
     * @return
     */
    Map<Long, Integer> getAndCachedFinishedLessonCount(Long orgId, Collection<Long> courseIds) {
        Map<Long, Integer> cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(courseIds)) {
            cache = this.orgClassLessonDao.getFinishLessonCount(orgId, courseIds, DeleteStatus.NORMAL.getValue());
        }
        return cache;
    }
    
    @Override
    public List<LessonScheduleInfoDto> queryCourseLessonsByParams(Long orgId, Long lessonId, Long teacherId,
        Long roomId, Long startTime, Long endTime, PageDto pageDto) {
        return null;
    }
    
    /**
     * 封装课节冲突信息
     * @param orgId
     * @param dto
     */
    void wrapConflictInfo(Long orgId, LessonScheduleInfoDto dto) {
        LessonConflictCheckDto lessonConflictCheckDto = new LessonConflictCheckDto();
        lessonConflictCheckDto.setEndTimeDate(new Date(dto.getEndTime()));
        lessonConflictCheckDto.setLessonId(dto.getLessonId());
        lessonConflictCheckDto.setPageNum(1);
        lessonConflictCheckDto.setPageSize(20);
        lessonConflictCheckDto.setRoomId(dto.getRoomId());
        lessonConflictCheckDto.setStartTimeDate(new Date(dto.getStartTime()));
        lessonConflictCheckDto.setTeacherId(dto.getTeacherId());
        LessonConflictEnum conflict = orgLessonConflictService.lessonConflictFlagCheck(orgId, lessonConflictCheckDto);
        ConflictInfoDto conflictInfo = null;
        if (conflict != null && conflict != LessonConflictEnum.NO_CONFLICT) {
            conflictInfo = new ConflictInfoDto();
            conflictInfo.setConflictType(conflict.getCode());
            conflictInfo.setConflictTypeStr(conflict.getNote());
            dto.setIsConflict(BizConf.TRUE);
        } else {
            dto.setIsConflict(BizConf.FALSE);
        }

        dto.setConflictInfo(conflictInfo);
    }
    
    
    
    /**
     * 获取当前登录用户的课程IDS
     * @return
     */
    private List<Long> getCurrentUserCoursesIds() {
        List<Long> courseIds = Lists.newArrayList();
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(),null,CourseTypeEnum.IS_CLASS_TRUE.getCode(),null);
                log.debug("user cascadeId={},courseIds={}",TianxiaoMContext.getTXCascadeId(),tempIds);
                // bugfix 此处根据课程权限获取用户课节的逻辑有问题，如果用户指定查询一门课的课节会查出用户课程权限下的所有课节，故调整逻辑
                if(CollectionUtils.isEmpty(courseIds)){
                    courseIds.addAll(tempIds);
                }else{
                    // 如果是子帐号，并且指定了课程，那么需要判断课程是否在这个用户的权限中
                    if(!tempIds.containsAll(courseIds)){
                        courseIds.clear();
                    }
                }
            }
        }
        return courseIds;
    }
    
    /**
     * 将OrgClassLesson对象转换成需要输出的对象
     * @param orgId
     * @param lessons
     * @return
     */
    private ListLessonResponseDto wrap(Long orgId, List<OrgClassLesson> lessons) {
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        ListLessonResponseDto result = new ListLessonResponseDto();
        
        Collections.sort(lessons, new Comparator<OrgClassLesson>() {
            @Override
            public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            roomIds.add(lesson.getRoomId());
            lessonIds.add(lesson.getId());
        }

        Map<Long, OrgCourse> courseMap = Maps.newHashMap();
       // bugfix 这里如果校验是否需要课程名字，后面的组装对象的逻辑就无法通过判断课程是否删除来过滤无效的课节，所以注释掉，以确保程序正确
       // if (params.isNeedcourseName()) {
            courseMap = getOrgCourseMap(orgId, courseIds);
       // }
        Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
        lessonIdTeacherNameMap = getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
        Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
        classRoomMap = getOrgClassRoomMap(roomIds);

        Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
        Map<Long, Integer> signStudentCountMap = orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);
            
        Map<Long, Integer> commentCount = Maps.newHashMap();
        Map<Long, Integer> lessonSignStatus = Maps.newHashMap();

        result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap,
            studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
        if (CollectionUtils.isNotEmpty(result.getList())) {
            lessonIdTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
            for (LessonResponseDto dto : result.getList()) {
                if (lessonIdTeacherIdMap.containsKey(dto.getLessonId())) {
                    dto.setTeacherId(lessonIdTeacherIdMap.get(dto.getLessonId()));
                }
            }
        }
        
        return result;
    }
    
    /**
     * 批量查询教室信息并缓存
     * @param roomIds
     * @return
     */
    Map<Long, OrgClassRoom> getAndCachedClassRoom(Collection<Long> roomIds) {
        List<OrgClassRoom> rooms = this.orgClassRoomDao.getByIds(roomIds, "id", "roomName", "roomSize");
        Map<Long, OrgClassRoom> cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(rooms)) {
            cache = BaseUtils.listToMap(rooms, "id");
        }
        return cache;
    }
    
    @Override
    @Transactional
    public void batchOperateLesson(Long orgId,Long courseId,List<Long> lessonIds,BatchOperateType operateType,String targetId){
      //  List<Long> leftLessonIds = orgClassLessonDao.getLeftLessonIds(orgId, courseId);
        
        /*if(!leftLessonIds.containsAll(lessonIds)){
            log.warn("leftlessonIds:{} is not contains lessonIds:{}", leftLessonIds, lessonIds);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "只支持操作未开课的课节");
        }*/

        if (CollectionUtils.isNotEmpty(lessonIds) ) {

            if(operateType==BatchOperateType.del_lesson){
                delLesson(orgId,courseId,lessonIds,targetId);
            }
            else if(operateType==BatchOperateType.add_student){
                addStudent(orgId,courseId,lessonIds,targetId);
            }
            else if(operateType==BatchOperateType.del_student){
                delStudent(orgId,courseId,lessonIds,targetId);
            }
            else if(operateType==BatchOperateType.change_teacher){
                Long teacherId = Long.valueOf(targetId);
                changeTeacher(orgId,courseId,lessonIds,teacherId);
            }
            else if(operateType==BatchOperateType.change_classroom){
                Long roomId = Long.valueOf(targetId);
                changeClassroom(orgId,courseId,lessonIds,roomId);
            }
            else if(operateType==BatchOperateType.change_time){
                String[] time = targetId.split(",");
                String startTimeStr = time[0];
                String endTimeStr = time[1];
                changeTime(orgId,courseId,lessonIds,startTimeStr,endTimeStr);
            }
        }

    }


    private void delLesson(Long orgId,Long courseId,List<Long> lessonIds,String targetId){

        /*Map<Long, Integer> signCountMap = orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);

        for(Long lessonId:lessonIds){
            Integer tempCount = signCountMap.get(lessonId);
            if(tempCount != null && tempCount>0){
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程已签到，不能删除");
            }
        }*/
        
        List<Integer> statusList = Lists.newArrayList();
        
        statusList.add(SignStatus.SIGNED.getCode());
        statusList.add(SignStatus.LEAVE.getCode());
        statusList.add(SignStatus.ABSENT.getCode());

        Map<String,Object> countCondition = new HashMap<String,Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("status", statusList);
        
        int count = orgLessonSignDao.countByCondition(countCondition, "userId", false);
        if(count>0){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程已签到，不能删除");
        }
        
        orgClassLessonDao.updateDelByLessonIds(orgId, lessonIds);
        
        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("delStatus","1");
        orgStudentLessonDao.update(condition, "delStatus");
        
        Map<String, Object> delCondition = new HashMap<>();
        delCondition.put("lessonId", lessonIds);
        orgTeacherLessonDao.delByCondition(delCondition);

        //冲突检测表逻辑删除
        orgLessonConflictService.delByLessonIds(orgId,lessonIds);

        resetLessonNumber(orgId, courseId);

    }
    private void addStudent(Long orgId,Long courseId,List<Long> lessonIds,String targetId){
       // String[] array = targetId.split(",");
      /*  Collection<Long> studentIds = Lists.newArrayList();
        for(String idStr:array){
            studentIds.add(Long.valueOf(idStr));
        }*/

        OrgCourse orgCourse = orgCourseDao.getById(courseId);
        if(orgCourse == null){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if(orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能添加学生，请下载新版天校");
        }
        List<Long> studentIds = null;
        try {
            studentIds = JacksonUtil.str2Obj(targetId, new TypeReference<List<Long>>() {
            });
        } catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id转换异常");
        }
       // courseStudentService.addStudentsToLessons(orgId, courseId, lessonIds, userIds, false);

        if (CollectionUtils.isEmpty(studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");
           // return;
        }
        if (true) {
            Map<Long, Long> userIdMap = orgStudentDao.getStudentIdUserIdMap(studentIds);
            if (MapUtils.isEmpty(userIdMap)) {
                log.warn("add student ids is empty");
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");
               // return;
            }
            studentIds = new ArrayList<Long>(userIdMap.values());
        }


        List<Long> courseStudents = orgStudentCourseDao.getStudents(orgId, courseId, 0);
        if (!courseStudents.containsAll(studentIds)) {
            studentIds.retainAll(courseStudents);
            log.warn("lesson studeng:{} is not all course student ids:{}", studentIds, courseStudents);

            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "必须从课程学生中添加课节学生");
        }

        Map<Long, List<Long>> lessonStudentIds = orgStudentLessonDao.getLessonStudentList(lessonIds);
        List<OrgStudentLesson> delLessonStudent = orgStudentLessonDao.getLessonStudentListDelStatus(lessonIds);
        Map<String,OrgStudentLesson> lesseonStudentMap = Maps.newHashMap();
        for(OrgStudentLesson orgStudentLesson:delLessonStudent){
            String tempKey = orgStudentLesson.getUserId()+"|"+orgStudentLesson.getLessonId();
            lesseonStudentMap.put(tempKey, orgStudentLesson);
        }
        log.info("check orgStudentLessonDao.getLessonStudentList(lessonIds):{},result={}",lessonIds,lessonStudentIds);
        List<OrgStudentLesson> saveStudentLessons = Lists.newArrayList();
        List<OrgStudentLesson> updateStudentLessons = Lists.newArrayList();
        for( Long lessonId:lessonIds){
            //Map<Long, List<Long>> lessonStudentIds = orgStudentLessonDao.getLessonStudentList(Lists.newArrayList(lessonId));
            //List<Long> tempStudentId = lessonStudentIds.get(lessonId);
            List<Long> tempStudentIds = new ArrayList<Long>(studentIds);
            if (lessonStudentIds.containsKey(lessonId)) {

                List<Long> addedStuIds = lessonStudentIds.get(lessonId);
                if (CollectionUtils.isNotEmpty(addedStuIds)) {
                    tempStudentIds.removeAll(addedStuIds);
                }
            }


            OrgStudentLesson po = null;
            for (Long studentId : tempStudentIds) {
                po = new OrgStudentLesson();
                po.setCreateTime(new Date());
                po.setLessonId(lessonId);
                po.setOrgId(orgId);
                po.setUserId(studentId);
                String tempKey = studentId+"|"+lessonId;
                if(lesseonStudentMap.containsKey(tempKey)){
                    OrgStudentLesson tempStudentLesson = lesseonStudentMap.get(tempKey);
                    po.setId(tempStudentLesson.getId());
                    po.setDelStatus(0);
                    po.setStartStatus(0);
                    updateStudentLessons.add(po);
                }else{
                    saveStudentLessons.add(po);
                }
                
            }

        }

        log.info("save students :{} to lessonid:{}", saveStudentLessons, lessonIds);
        orgStudentLessonDao.saveAll(saveStudentLessons, "createTime", "lessonId", "orgId", "userId");
        
        for(OrgStudentLesson updateStudentLesson:updateStudentLessons){
            orgStudentLessonDao.update(updateStudentLesson, "createTime", "delStatus", "startStatus");
        }
    }

    private int delStudent(Long orgId,Long courseId,List<Long> lessonIds,String targetId){
        
        OrgCourse orgCourse = orgCourseDao.getById(courseId);
        if(orgCourse == null){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if(orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能删除学生，请下载新版天校");
        }
        
        List<Long> studentIds = null;
        try {
            studentIds = JacksonUtil.str2Obj(targetId, new TypeReference<List<Long>>() {
            });
        } catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id转换异常");
        }
       // courseStudentService.addStudentsToLessons(orgId, courseId, lessonIds, userIds, false);

        if (CollectionUtils.isEmpty(studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");
           
        }
        if (true) {
            Map<Long, Long> userIdMap = orgStudentDao.getStudentIdUserIdMap(studentIds);
            if (MapUtils.isEmpty(userIdMap)) {
                log.warn("add student ids is empty");
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");
            }
            studentIds = new ArrayList<Long>(userIdMap.values());
        }

        List<Long> courseStudents = orgStudentCourseDao.getStudents(orgId, courseId, 0);

        if (!courseStudents.containsAll(studentIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", studentIds, courseStudents);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "必须从课程学生中删除课节学生");
        }

        List<Integer> statusList = Lists.newArrayList();
        
        statusList.add(SignStatus.SIGNED.getCode());
        statusList.add(SignStatus.LEAVE.getCode());
        statusList.add(SignStatus.ABSENT.getCode());

        Map<String,Object> countCondition = new HashMap<String,Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("userId",studentIds);
        
        countCondition.put("status", statusList);
        countCondition.put("userRole", UserRoleEnum.STUDENT.getCode());
        int count = orgLessonSignDao.countByCondition(countCondition, "userId", false);

        if(count >0){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "已经签到的学生不能删除");
        }

        return orgStudentLessonDao.delStudentFromLesson(orgId, lessonIds, studentIds);
        
    }

    private void changeTeacher(Long orgId,Long courseId,List<Long> lessonIds,Long teacherId){

       // Long teacherId = Long.valueOf(targetId);

        Map<String, Object> delCondition = new HashMap<>();
        delCondition.put("lessonId", lessonIds);
        int result = orgTeacherLessonDao.delByCondition(delCondition);
        log.info("del from org teacher lesson by lessonId:{},result:{}", lessonIds, result);

        List<OrgTeacherLesson> saveLessonTeachers = Lists.newArrayList();
        OrgTeacherLesson po = null;
        for (Long lessonId:lessonIds) {
            po = new OrgTeacherLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setTeacherId(teacherId);
            saveLessonTeachers.add(po);
        }
        log.info("save teachers :{} to lessonId:{}", saveLessonTeachers, lessonIds);
        orgTeacherLessonDao.saveAll(saveLessonTeachers, "createTime", "lessonId", "orgId", "teacherId");

        List<OrgCourseTeacher> courseTeachers = orgCourseTeacherDao.getTeacher(orgId, courseId);
        Set<Long> userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }

        if(!userIds.contains(teacherId)){
            List<Long> teacherIds  = new ArrayList<Long>();
            teacherIds.add(teacherId);
            courseTeacherService.addTeacherToCourse(orgId, courseId, teacherIds);
        }


        List<OrgLessonConflict> conflictList = Lists.newArrayList();
        for(Long lessonId:lessonIds){
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setTeacherId(teacherId);
            conflictList.add(conflict);
        }
        orgLessonConflictService.updateOrgLessonConflictForTeacherChange(conflictList);

    }

    private void changeClassroom(Long orgId,Long courseId,List<Long> lessonIds,Long roomId){
       // Long roomId = Long.valueOf(targetId);

        orgClassLessonDao.updateLessonClassRoom(orgId, lessonIds,roomId);

        List<ClassRoomDto> roomList = classRoomService.listOrgCourseRooms(orgId, courseId);
        List<Long> currentRoomIds = new ArrayList<Long>();
        for(ClassRoomDto dto:roomList){
            currentRoomIds.add(dto.getRoomId());
        }

        if(!currentRoomIds.contains(roomId)){
            List<Long> newCourseIds = new ArrayList<Long>();
            newCourseIds.add(roomId);
            classRoomService.addClassRoomCourse(orgId, courseId, newCourseIds);
        }


        for(Long lessonId:lessonIds){
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setRoomId(roomId);
            orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }

    }

    private void changeTime(Long orgId,Long courseId,List<Long> lessonIds,String startTimeStr,String endTimeStr){

        TimeStamp startTime = TimeStamp.parse(startTimeStr);
        TimeStamp endTime = TimeStamp.parse(endTimeStr);

        List<OrgClassLesson> list = orgClassLessonDao.getByIds(lessonIds);

        for(OrgClassLesson lesson:list){

            Calendar cal = Calendar.getInstance();
            cal.setTime(lesson.getStartTime());

            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);

            Map<String,Object> map = new HashMap<String,Object>();
            map.put("id", lesson.getId());
            map.put("startTime", lessonTime.getStartTime());
            map.put("endTime", lessonTime.getEndTime());

            this.orgClassLessonDao.update(map, "startTime","endTime");

            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lesson.getId());
            conflict.setStartTime(lessonTime.getStartTime());
            conflict.setEndTime(lessonTime.getEndTime());
            orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }
        resetLessonNumber(orgId, courseId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> addClassLessonsBatchForFastSignIn(Long orgId, Long courseId,Integer addLessonTimes,Set<Long> studentIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");

        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");

        Long defaultTeacherId = 0L;
        //快速签到的排课不给默认老师
        /*List<TeacherResponseDto> courseTeachers = courseTeacherService.listCourseTeacher(orgId, courseId);
        if(courseTeachers.size()>0){
            defaultTeacherId = courseTeachers.get(0).getTeacherId();
        }*/
        Long defaultRoomId = 0L;

        //快速签到的排课不给默认的教室
        /*List<ClassRoomDto> courseRooms = classRoomService.listOrgCourseRooms(orgId, courseId);
        if(courseRooms.size()>0){
            defaultRoomId = courseRooms.get(0).getRoomId();
        }*/

        OrgClassLesson lesson = null;
        List<OrgClassLesson> lessons = Lists.newArrayList();
        Date todayStartTime = DateUtil.getStartOfDay(new Date());
        Date startTime = DateUtil.getDiffDateTime(todayStartTime, 6, Calendar.HOUR_OF_DAY);
        Date endTime = DateUtil.getDiffDateTime(todayStartTime, 7, Calendar.HOUR_OF_DAY);

        for (int i=0;i<addLessonTimes;i++) {
            lesson = new OrgClassLesson();
            lesson.setStartTime(startTime);
            lesson.setEndTime(endTime);
            lesson.setCourseId(courseId);
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(DataStatus.NORMAL.getValue());
            lesson.setLayoutId(0l);
            lesson.setRoomId(defaultRoomId !=null?defaultRoomId:0L);
            lesson.setUpdateTime(new Date());
            lesson.setNumber(i+1);
            lesson.setOrgId(orgId);
            lessons.add(lesson);

        }
        log.info("save {} lessons into db,params:{}", lessons.size(),"courseId="+courseId );
        orgClassLessonDao.saveAll(lessons, "startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId",
            "roomId", "updateTime", "orgId");



        // 如果原来有课节的话,需要重新安排课节编号
        resetLessonNumber(orgId, courseId);
        List<Long> newLessonsIds = Lists.newArrayList();
        for (OrgClassLesson classLesson : lessons) {
            newLessonsIds.add(classLesson.getId());
            courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
                studentIds, true);
            if(defaultTeacherId !=null && defaultTeacherId>0){
                List<Long> tearcherIds = Lists.newArrayList();
                tearcherIds.add(defaultTeacherId);
                courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
                    tearcherIds);
            }

        }



        return newLessonsIds;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchEditLessonsForFastSignIn(FastSignInLessonsEditRequestDto dto){

        List<Long> lessonIds = dto.getLessonIds();
        Long orgId = dto.getOrgId();
        Long courseId = dto.getCourseId();
        Long roomId = dto.getRoomId();
        Long teacherId = dto.getTeacherId();
        String startTimeStr = dto.getStartTime();
        String endTimeStr = dto.getEndTime();
        if (CollectionUtils.isNotEmpty(lessonIds)) {

            if(roomId!=null &&roomId >0){
                changeClassroom(orgId, courseId, lessonIds, roomId);
            }
            if(teacherId !=null && teacherId >0){
                changeTeacher(orgId, courseId, lessonIds, teacherId);
            }
            if(StringUtils.isNotBlank(startTimeStr) && StringUtils.isNotBlank(endTimeStr)){
                changeTime(orgId, courseId, lessonIds, startTimeStr, endTimeStr);

            }

        }

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<LessonResponseDto> findLessonBaseInfoByLessonIds(Long orgId,Long courseId,List<Long> lessonIds){
        List<OrgClassLesson> lessons = orgClassLessonDao.queryLessons(orgId, null, null, lessonIds, null,
        null, null);

        return buildLessonBaseInfoList(orgId,courseId,lessons);

    }

    @Override
    @Transactional
    public List<LessonResponseDto> buildLessonBaseInfoList(Long orgId,Long courseId,List<OrgClassLesson> lessons){

        List<Long> lessonIds = Lists.newArrayList();
        for(OrgClassLesson lesson:lessons){
            lessonIds.add(lesson.getId());
        }

        Set<Long> roomIds = new HashSet<Long>();

        for(OrgClassLesson lesson:lessons){
            if(lesson.getRoomId() != null && lesson.getRoomId() >0){
                roomIds.add(lesson.getRoomId());
            }
        }
        Map<Long,Long> lessonTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);

        Map<Long, String> teacherNameMap = teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        Map<Long, String> lessonIdTeacherNameMap = new HashMap<>(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, teacherNameMap.get(lessonTeacherIdMap.get(lessonId)));
        }

        Map<Long, OrgClassRoom> lessonRoomMap = getOrgClassRoomMap(roomIds);

        List<LessonResponseDto> dtoList = new ArrayList<LessonResponseDto>();
        for(OrgClassLesson lesson:lessons){
            LessonResponseDto dto = new LessonResponseDto();
            dto.setCourseId(lesson.getCourseId());
            dto.setLessonId(lesson.getId());
            dto.setIndex(lesson.getNumber());
            Long roomId = lesson.getRoomId();

            OrgClassRoom classRoom = lessonRoomMap.get(roomId);
            if(classRoom!=null){
                dto.setRoomId(roomId);
                dto.setRoomName(classRoom.getRoomName());
            }

            Long teacherId = lessonTeacherIdMap.get(lesson.getId());
            if(teacherId!=null && teacherId >0){
                dto.setTeacherId(teacherId);
                dto.setTeacherName(teacherNameMap.get(teacherId));
            }

            dto.setLessonStartTime(lesson.getStartTime());
            dto.setLessonEndTime(lesson.getEndTime());

            dtoList.add(dto);
        }

        return dtoList;

    }

    @Override
    @Transactional(readOnly = true)
    public LessonConflictCheckListDto lessonConflictCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto) {

        PageDto pageDto = new PageDto();
        pageDto.setPageNum(lessonConflictCheckDto.getPageNum());
        pageDto.setPageSize(lessonConflictCheckDto.getPageSize());


        LessonConflictCheckListDto  lessonConflictCheckListDto = new LessonConflictCheckListDto();
        Long teacherId = lessonConflictCheckDto.getTeacherId();
        Long roomId = lessonConflictCheckDto.getRoomId();
        Date startTime = lessonConflictCheckDto.getStartTimeDate();
        Date endTime = lessonConflictCheckDto.getEndTimeDate();
        Long lessonId = lessonConflictCheckDto.getLessonId();

        if(teacherId != null && teacherId > 0){
            List<OrgLessonConflict> teacherConflictList = orgLessonConflictService.checkTeacherConflict(orgId,teacherId,startTime,endTime,lessonId,pageDto);

            if(CollectionUtils.isNotEmpty(teacherConflictList)){
                int num = orgLessonConflictService.queryTeacherConflictNum(orgId,teacherId,startTime,endTime,lessonId);
                try {
                    PageDto tpageDto = (PageDto) BeanUtils.cloneBean(pageDto);
                    tpageDto.setCount(num);
                    lessonConflictCheckListDto.setTeacherConflictPageDto(tpageDto);
                } catch (Exception e) {
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
                lessonConflictCheckListDto.setTeacherConflictData(change(teacherConflictList));

            }
        }

        if(roomId != null && roomId > 0){
            List<OrgLessonConflict> roomConflictList = orgLessonConflictService.checkRoomConflict(orgId,roomId,startTime,endTime,lessonId,pageDto);

            if(CollectionUtils.isNotEmpty(roomConflictList)){
                int num = orgLessonConflictService.queryRoomConflictNum(orgId,roomId,startTime,endTime,lessonId);
                try {
                    PageDto rpageDto = (PageDto) BeanUtils.cloneBean(pageDto);
                    rpageDto.setCount(num);
                    lessonConflictCheckListDto.setRoomConflictPageDto(rpageDto);
                } catch (Exception e) {
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
                lessonConflictCheckListDto.setRoomConflictData(change(roomConflictList));
            }
        }

        return lessonConflictCheckListDto;
    }

    @Override
    public void flushConflictData() {
        log.info("flushConflictData start load mysql data!!!!!!!!!!!!!!!!!!!!");
        List<OrgLessonConflict> list = orgClassLessonDao.getflushConflictData();
        log.info("flushConflictData load mysql data finished!!!!!!!!!!!!!!!!!!!!");
        //打印最后的lessonId
        Collections.sort(list, new Comparator<OrgLessonConflict>() {
            @Override
            public int compare(OrgLessonConflict o1, OrgLessonConflict o2) {
                if(o1.getLessonId() < o2.getLessonId()){
                    return -1;
                }else if(o1.getLessonId() > o2.getLessonId()){
                    return 1;
                }
                return 0;
            }
        });
        log.info("flushConflictData start lessonId :" + list.get(0).getLessonId() + " , end lessonId:" + list.get(list.size()-1).getLessonId() );
        if(CollectionUtils.isNotEmpty(list)){
            Set<Long> courseIds = BaseUtils.getPropertiesList(list,"courseId");
            int i=0,index=0;

            List<OrgCourse> courseList = Lists.newArrayList();
            Set<Long> querySet = null;
            for(Long cid:courseIds){
                if(i == 0){
                    querySet = Sets.newHashSet();
                }
                querySet.add(cid);
                i++;index++;
                if(i == 10000 || index == courseIds.size()){
                    List<OrgCourse> queryCourseList = orgCourseDao.getByIds(querySet);
                    courseList.addAll(queryCourseList);
                    i = 0;
                }
            }
            ConcurrentMap<Long,OrgCourse> courseMap = Maps.newConcurrentMap();
            if(CollectionUtils.isNotEmpty(courseList)){
                for(OrgCourse course:courseList){
                    if(course.getIsDel() == DataStatus.NORMAL.getValue()){
                        courseMap.putIfAbsent(course.getId(),course);
                    }
                }
                courseList = null;
                Iterator<OrgLessonConflict> it = list.iterator();
                while(it.hasNext()){
                    OrgLessonConflict conflict = it.next();
                    if(!courseMap.containsKey(conflict.getCourseId())){
                        it.remove();
                    }
                }
                courseMap = null;
                if(CollectionUtils.isNotEmpty(list)){
                    log.info("flushConflictData start insert mysql!!!!!!!!!!!!!!!!!!!!");
                    orgLessonConflictService.saveOrgLessonConflicts(list);
                    log.info("flushConflictData insert mysql finished!!!!!!!!!!!!!!!!!!!!");
                }
            }
        }
        list = null;
    }

    private List<LessonConflictInfoDto> change(List<OrgLessonConflict> source){
        List<LessonConflictInfoDto> dest = Lists.newArrayList();
        for(OrgLessonConflict conflict:source){
            LessonConflictInfoDto info = new LessonConflictInfoDto();
            info.setLessonId(conflict.getLessonId());
            OrgClassLesson lesson = orgClassLessonDao.getById(conflict.getLessonId());
            info.setIndex(lesson.getNumber());
            info.setLessonEndTime(lesson.getEndTime().getTime());
            info.setLessonStartTime(lesson.getStartTime().getTime());
            OrgCourse course = orgCourseDao.getById(lesson.getCourseId());
            info.setCourseName(course.getName());
            dest.add(info);
        }
        return dest;
    }

    @Override
    public List<NameAndIdDto> getLessonCalendarQueryDropDownList(Long orgId, DropDownListRequestDto params) {
        List<NameAndIdDto> result = Lists.newArrayList();
        if (params.getReqType() == DropdownListType.TEACHER.getType()) {
            List<OrgClassLesson> lessons = this.orgClassLessonDao.getOrgClassLessonByParams(orgId, params.getParams(), null, null);
            if (CollectionUtils.isNotEmpty(lessons)) {
                Set<Long> lessonIds = BaseUtils.getPropertiesList(lessons, "id");
                List<OrgTeacherLesson> lessonTeachers = orgTeacherLessonDao.queryByLessonIds(orgId, lessonIds);
                if (CollectionUtils.isNotEmpty(lessonTeachers)) {
                    Set<Long> teacherIds = BaseUtils.getPropertiesList(lessonTeachers, "teacherId");
                    List<Teacher> teachers = teacherDao.fuzzyQueryByNameAndMobile(orgId, teacherIds, params.getSearch());
                    result = collectTeacherInfo(teachers);
                }
            }
        } else if (params.getReqType() == DropdownListType.ROOM.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set<Long> roomIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                roomIds = BaseUtils.getPropertiesList(lessons, "roomId");
            }
            result = this.collectRoomInfo(orgId, roomIds, params.getSearch());
        } else if (params.getReqType() == DropdownListType.COURSE.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set<Long> courseIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                courseIds = BaseUtils.getPropertiesList(lessons, "courseId");
            }
            OrgAccount orgAccount = orgAccountDao.getById(TianxiaoPCContext.getOrgId());
            result = collectCourseInfo(orgAccount.getNumber(), params.getSearch(), courseIds);
        }
        return result;
    }
    
    /**
     * 查询课节集合
     * @param orgId
     * @param params
     * @return
     */
    private List<OrgClassLesson> getOrgLessonByParams(Long orgId, TimeTableRequestDto params) {
        List<OrgClassLesson> lessons = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(params.getTeacherIds())) {
            List<OrgTeacherLesson> teachers = this.orgTeacherLessonDao.queryTeacherLessons(orgId, params.getTeacherIds(), "lessonId");
            if (CollectionUtils.isNotEmpty(teachers)) {
                Set<Long> lessonIds = BaseUtils.getPropertiesList(teachers, "lessonId");
                lessons = this.orgClassLessonDao.getOrgClassLessonByParams(orgId, params, lessonIds, null);
            }
        }
        return lessons;
    }
    
    /**
     * 查询老师id和名称集合
     * @param teachers
     * @return
     */
    @SuppressWarnings("unchecked")
    private List<NameAndIdDto> collectTeacherInfo(List<Teacher> teachers) {
        List<NameAndIdDto> idAndNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(teachers)) {
            idAndNames = (List<NameAndIdDto>) CollectionUtils.collect(teachers, new Transformer() {
                
                @Override
                public Object transform(Object input) {
                    NameAndIdDto idAndName = new NameAndIdDto();
                    Teacher teacher = (Teacher)input;
                    idAndName.setId(teacher.getUserId());
                    idAndName.setName(teacher.getRealName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }
    
    /**
     * 查询课程id和名称集合
     * @param courseIds
     * @return
     */
    @SuppressWarnings("unchecked")
    private List<NameAndIdDto> collectCourseInfo(Integer orgNumber, String query, Collection<Long> courseIds) {
        List<NameAndIdDto> idAndNames = Lists.newArrayList();
        List<OrgCourse> courses = this.orgCourseDao.fuzzyQuery(orgNumber, query, courseIds, null);
        if (CollectionUtils.isNotEmpty(courses)) {
            idAndNames = (List<NameAndIdDto>) CollectionUtils.collect(courses, new Transformer() {
                
                @Override
                public Object transform(Object input) {
                    OrgCourse course = (OrgCourse)input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(course.getId());
                    idAndName.setName(course.getName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }
    
    /**
     * 查询教室名称和ID集合
     * @param roomIds
     * @return
     */
    @SuppressWarnings("unchecked")
    private List<NameAndIdDto> collectRoomInfo(Long orgId, Collection<Long> roomIds, String query) {
        List<NameAndIdDto> idAndNames = Lists.newArrayList();
        List<OrgClassRoom> rooms = this.orgClassRoomDao.getOrgClassRoomByNameAndIds(orgId, roomIds, query);
        if (CollectionUtils.isNotEmpty(rooms)) {
            idAndNames = (List<NameAndIdDto>) CollectionUtils.collect(rooms, new Transformer() {
                
                @Override
                public Object transform(Object input) {
                    OrgClassRoom room = (OrgClassRoom)input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(room.getId());
                    idAndName.setName(room.getRoomName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    /**
     * 课节详情
     * @param orgId
     * @param lessonId
     */
    @Override
    public LessonScheduleInfoDto lessonDetail(Long orgId, Long lessonId) {
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
//        LessonBaseInfoDto result = null;
//        if (lesson != null) {
//            result = wrap(orgId, lesson);
//        }
        if (lesson == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课节不存在或已被删除");
        }
        List<OrgClassLesson> lessons = Lists.newArrayList(lesson);
        List<LessonScheduleInfoDto> data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set<Long> roomIds = BaseUtils.getPropertiesList(result, "roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();
                
                Set<Long> courseIds = BaseUtils.getPropertiesList(result, "courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                for (LessonResponseDto dto : result) {
                    Long courseId = dto.getCourseId();

                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setRoomId(dto.getRoomId());
                    item.setRoomName(dto.getRoomName());
                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    item.setTeacherName(dto.getTeacherName());
                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    item.setCourseType(dto.getCourseType()==null?0:dto.getCourseType());
                    item.setLessonStatus(now.before(dto.getLessonStartTime()) ? LessonStatus.UN_START.getStatus() : (now.before(dto.getLessonEndTime())?LessonStatus.ONGOING.getStatus():LessonStatus.FINISHED.getStatus()));
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }
                    
                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }

                    OrgCourse course = orgCourseDao.getById(courseId);
                    if(course.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()){
                        List<Long> scount = orgStudentCourseDao.getStudents(orgId,courseId,0);
                        item.setStudentStatus(CollectionUtils.isEmpty(scount)? StudentStatus.YES.getCode():StudentStatus.NO.getCode());
                    }
                    
                    //封装冲突信息
                    wrapConflictInfo(orgId, item);
                    data.add(item);
                }
                return data.get(0);
            }
        }
        return null;
    }
    
    LessonBaseInfoDto wrap(Long orgId, OrgClassLesson lesson) {
        Long lessonId = lesson.getId();
        LessonBaseInfoDto result = new LessonBaseInfoDto();
        Long courseId = lesson.getCourseId();
        Long roomId = lesson.getRoomId();
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        
        getAndSetCourseInfo(courseId, result);
        getAndSetRoomInfo(roomId, result);
        result.setEndTime(lesson.getEndTime().getTime());
        result.setEndTimeStr(BaseUtils.getFormatTime(lesson.getEndTime(), "HH:mm"));
        result.setLessonId(lessonId);
        result.setStartTime(lesson.getStartTime().getTime());
        result.setStartTimeStr(BaseUtils.getFormatTime(lesson.getStartTime(), "HH:mm"));
        result.setTeacherId(teacherLesson.getTeacherId());
        result.setTeacherName(teacherLesson.getTeacherName());
        result.setDayOfWeek(DateUtil.getWeekDay(lesson.getStartTime()));
        result.setDuration(calculateDuration(lesson.getStartTime(), lesson.getEndTime()));
        result.setTime(getLessonStartTime(lesson.getStartTime()));
        
        return result;
    }
    
    String getLessonStartTime(Date date) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("M月d日");
        String time = sdf.format(date);
        String weekDay = DateUtil.getChineseWeekDay(date);
        sb.append(time).append(" ").append("星期").append(weekDay);
        return sb.toString();
    }
    
    /**
     * 计算课程时长:大于60分钟小时为单位,反之以分钟为单位
     * @param startTime
     * @param endTime
     * @return
     */
    String calculateDuration(Date startTime, Date endTime) {
        long interval = (endTime.getTime() - startTime.getTime()) / (1000 * 60);
        String duration = "";
        if (interval > 60) {
            BigDecimal bg1 = new BigDecimal(interval);
            BigDecimal bg2 = new BigDecimal(interval);
            duration = bg1.divide(bg2, 1, RoundingMode.HALF_DOWN).toString() +"小时";
        } else {
            duration = interval +"分钟";
        }
        return duration;
    }
    
    /**
     * 获取课程ID和名称信息
     * @param courseId
     * @return
     */
    void getAndSetCourseInfo(Long courseId, LessonBaseInfoDto result) {
        OrgCourse course = this.orgCourseDao.getById(courseId, "id", "name");
        if (course != null) {
            result.setCourseId(course.getId());
            result.setCourseName(course.getName());
        }
    }
    
    /**
     * 获取教室名称和ID信息
     * @param roomId
     * @param result
     */
    void getAndSetRoomInfo(Long roomId, LessonBaseInfoDto result) {
        OrgClassRoom room = this.orgClassRoomDao.getById(roomId, "id", "roomName");
        if (room != null) {
            result.setRoomName(room.getRoomName());
            result.setRoomId(room.getId());
        }
    }
}
