
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.CourseClassService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.util.SerialNumberUtil;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;

import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.annotation.Resource;

import lombok.extern.slf4j.Slf4j;

/**
 * @title CourseClassServiceImpl
 * @desc 班级操作单独拉出来管理，特别是对1对1课程的班级，处理逻辑是和班课有较大不同
 * @author leiruiqi
 * @date 2016年9月13日
 * @version 1.0
 */
@Service("courseClassService")
@Slf4j
public class CourseClassServiceImpl implements CourseClassService {

    @Resource
    private OrgCourseDao orgCourseDao;
    
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    
    @Resource
    private OrgStudentDao orgStudentDao;
    
    @Resource
    private CourseTeacherService courseTeacherService;
    
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    
    @Resource
    private ClassRoomService classRoomService;
    
    
    @Transactional(rollbackFor = Exception.class)
    @Override
    public OrgCourse createClassFor1V1(Long orgId,Long signupPurchaseId,Long parentCourseId,Long studentUserId,Integer lessonCount){
        OrgCourse orgCourse = orgCourseDao.getById(parentCourseId);
        
        if(orgCourse == null){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程无效");
        }
        
        boolean checkCourseTypeResult = isCourse1v1(orgCourse);
        if(!checkCourseTypeResult){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程无效，不能由班级创建班级");
        }
        
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, studentUserId);
        
        
        //先保存当前课程名字的快照
        orgCourse.setSnapshotName(orgCourse.getName());
        //1对1班级名字为学员和课程名字的组合
        orgCourse.setName(orgStudent.getName()+" "+orgCourse.getName());
        
        orgCourse.setNumber(System.nanoTime());
        
        orgCourse.setId(null);
        orgCourse.setCreateTime(null);
        orgCourse.setCourseType(CourseTypeEnum.COURSE_TYPE_1v1.getCode());
        orgCourse.setIsCourse(CourseTypeEnum.IS_COURSE_FALSE.getCode());
        orgCourse.setIsClass(CourseTypeEnum.IS_CLASS_TRUE.getCode());
        orgCourse.setParentId(parentCourseId);
        orgCourse.setFreq(lessonCount);
        orgCourseDao.save(orgCourse);
        
        Long newCourseId = orgCourse.getId();
        if (newCourseId != null && newCourseId > 0) {
            long number = SerialNumberUtil.generateNumber(orgCourse.getId().intValue(), SerialNumberUtil.COURSE_MAX, 4);
            orgCourse.setNumber(number);
            this.orgCourseDao.saveOrUpdate(orgCourse, "number");
        }
        
        // 处理班级学员
        {
            OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
            orgStudentCourse.setCourseId(newCourseId);

            orgStudentCourse.setCreateTime(new Date());
            orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
            orgStudentCourse.setOrgId(orgId.longValue());
            orgStudentCourse.setStudentMobile(orgStudent.getMobile());
            orgStudentCourse.setStudentName(orgStudent.getName());
            orgStudentCourse.setUserId(orgStudent.getUserId());
            orgStudentCourse.setLessonCount(lessonCount);
            orgStudentCourse.setSignupPurchaseId(signupPurchaseId==null?0:signupPurchaseId);
            orgStudentCourseDao.save(orgStudentCourse);
        }
        // 处理班级老师
        {
            List<Long> teacherUserIdList = orgCourseTeacherDao.getTeacherIdsByCourseId(parentCourseId);
            if(CollectionUtils.isNotEmpty(teacherUserIdList)){
                courseTeacherService.addTeacherToCourse(orgId, newCourseId, teacherUserIdList);
            }
        }
        // 处理教室
        {
            List<Long> roomIds = orgCourseRoomDao.getCourseRoomIds(orgId, parentCourseId);
            if(CollectionUtils.isNotEmpty(roomIds)){
                classRoomService.addClassRoomCourse(orgId, newCourseId, roomIds);
            }
        }
        return orgCourse;
        
        
        
    }
    
    
    
    private boolean isCourse1v1(OrgCourse orgCourse ){
        boolean checkCourseTypeResult = orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()
            && orgCourse.getIsCourse() ==CourseTypeEnum.IS_COURSE_TRUE.getCode() 
            && orgCourse.getIsClass() ==CourseTypeEnum.IS_CLASS_FALSE.getCode();
        return checkCourseTypeResult;
    }
    
    private boolean isClass1v1(OrgCourse orgCourse ){
        boolean checkCourseTypeResult = orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()
            && orgCourse.getIsCourse() ==CourseTypeEnum.IS_COURSE_FALSE.getCode() 
            && orgCourse.getIsClass() ==CourseTypeEnum.IS_CLASS_TRUE.getCode();
        return checkCourseTypeResult;
    }



    @Override
    public void synClass1v1NameForStudentNameChange(Long orgId,Long studentUserId) {
        
        OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgId, studentUserId);
        if(orgStudent == null){
            log.info("org student not exist orgId ={},studentUserId ={} ",orgId,studentUserId);
            return;
        }
        String studentName = orgStudent.getName();
        List<OrgStudentCourse> studentCourseList = orgStudentCourseDao.getOrgCourseIds(orgId, studentUserId, null, null);
        
        List<Long> courseIds = Lists.newArrayList();
        for(OrgStudentCourse studentCourse:studentCourseList){
            Long courseId = studentCourse.getCourseId();
            courseIds.add(courseId);
        }
        
        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds);
        for(OrgCourse orgCourse:courseList){
            if(isClass1v1(orgCourse) && orgCourse.getParentId() >0){
                
                orgCourse.setName(studentName+" "+orgCourse.getSnapshotName());
                
                orgCourseDao.update(orgCourse, "name");
                log.info("org course update name finish new name ={}",orgCourse.getName());
            }
            
        }
        
    }
}

    