
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.erp.service;

import java.util.List;
import java.util.Map;

import org.springframework.web.multipart.MultipartFile;

import com.baijia.tianxiao.biz.erp.vo.ImportCourse;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;

/**
 * @title ErpUploadService
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年7月5日
 * @version 1.0
 */

public interface ErpUploadService {
    public String uploadCourse(MultipartFile file) throws Exception;

    /**
     * @param taskId
     * @return
     */
        
    public List<ImportCourse> getValidCourseList(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    public List<ImportCourse> getInValidCourseList(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    public Map<String, String> getTaskStatus(String taskId);
    
    public void saveCourse(String taskId);
    
    public String uploadStudent(MultipartFile file) throws Exception;

    /**
     * @param taskId
     */
        
    void saveStudents(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    List<ImportStudent> getValidStudentList(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    List<ImportStudent> getInValidStudentList(String taskId);
    
    /**
     * 校验1V1课程文件
     * 
     * @param file
     * @return
     * @throws Exception
     */
    public String upload1V1Course(MultipartFile file) throws Exception;

    /**
     * 获取1V1课程正确数据
     * 
     * @param taskId
     * @return
     */
    public List<ImportCourse> getValid1V1CourseList(String taskId);

    /**
     * 获取1V1课程错误数据
     * 
     * @param taskId
     * @return
     */
    public List<ImportCourse> getInValid1V1CourseList(String taskId);

    
    /**
     * 确认保存1V1课程
     * 
     * @param taskId
     */
    public void save1V1Course(String taskId);
    
    /**
     * 校验1V1学员文件
     * 
     * @param file
     * @return
     * @throws Exception
     */
    public String upload1V1Student(MultipartFile file) throws Exception;

    /**
     * 获取1V1学员正确数据
     * 
     * @param taskId
     * @return
     */
    public List<ImportStudent> getValid1V1StudentList(String taskId);

    /**
     * 获取1V1学员错误数据
     * 
     * @param taskId
     * @return
     */
    public List<ImportStudent> getInValid1V1StudentList(String taskId);

    
    /**
     * 确认保存1V1学员
     * 
     * @param taskId
     */
    public void save1V1Student(String taskId);
}

    