
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.erp.service;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import com.baijia.tianxiao.biz.erp.dto.OrgCourseInfoPcDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CourseBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.CourseNameAndIdDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.VipClassDetailDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;


/**
 * @title ErpCourseService
 * @desc TODO 
 * @author zhangbing
 * @date 2016年8月25日
 * @version 1.0
 */
public interface ErpCourseService {

    /**
     * 天校-PC-ERP-课程详情
     * @param orgId
     * @param courseId
     * @return
     */
    CourseBaseInfoDto getCourseDetailById(Long orgId, Long courseId);
    
    /**
     * 天校PC一对一排课
     * 根据班级／课程id查询一对一课程的班级详情信息
     * @param orgId : 机构id
     * @param courseId ： 课程／班级id
     * @return
     */
	public VipClassDetailDto getVipClassDetailById(Long orgId, Long courseId);
    
    /**
     * 天校PC-ERP-新增/编辑课程
     * 添加或者修改一个课程 courseId <= 0 或者 courseId == null:表示添加。其它有效的courseId表示编辑。
     *
     * @param course
     */
    Long saveOrUpdateCourse(Long orgId, OrgCourseInfoPcDto course);
    
    /**
     * 获取pc-erp课程信息
     * @param orgId
     * @param courseId
     * @return
     */
    OrgCourseInfoPcDto getOrgCourseInfoPc(Long orgId, Long courseId) throws IllegalAccessException, InvocationTargetException;
    
    /**
     * 根据班级名称模糊匹配班级
     * @param orgId : 机构id
     * @param courseName ：查询字符串
     * @param type ： 查询类型 
     * @return
     */
    public List<CourseNameAndIdDto> fuzzyQuery(Long orgId, String courseName, Integer type, PageDto pageDto);
}

    