
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.service;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletResponse;

import com.baijia.tianxiao.biz.erp.dto.request.*;
import com.baijia.tianxiao.biz.erp.dto.response.LessonConflictCheckListDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonScheduleInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.NameAndIdDto;
import com.baijia.tianxiao.biz.erp.enums.BatchOperateType;
import com.baijia.tianxiao.dal.org.dto.DropDownListRequestDto;
import com.baijia.tianxiao.dal.org.dto.TimeTableRequestDto;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.sal.course.dto.HeaderDto;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

/**
 * @author cxm
 * @version 1.0
 * @title CourseLessonService
 * @desc TODO
 * @date 2015年12月30日
 */
public interface CourseLessonService {

    /**
     * 添加课节
     *
     * @param orgId
     * @param startDay
     * @param endDay
     * @param dto
     */
    void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto);

    /**
     * 添加课节 for PC
     *
     * @param orgId
     * @param startDay
     * @param endDay
     * @param dto
     */
    void addClassLessonsForPC(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDtoForPC dto);

    /**
     * 查看课节列表,默认查看今天以后的
     *
     * @param orgId
     * @param params
     * @return
     */
    ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params);

    /**
     * 查看课表
     *
     * @param orgId
     * @param params
     * @return
     */
    List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params);

    /**
     * 查看课节详情
     *
     * @param orgId
     * @param lessonId
     * @return
     */
    LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign);
    
    /**
     * 课节详情
     * @param orgId
     * @param lessonId
     * @return
     */
    LessonScheduleInfoDto lessonDetail(Long orgId, Long lessonId);

    /**
     * 编辑课节详情
     *
     * @param orgId
     * @param editDto
     */
    void editLesson(Long orgId, EditLessonRequestDto editDto);

    /**
     * @param orgId
     * @param lessonId
     */
    void delLesson(Long orgId, Long lessonId);

    /**
     * @param orgId
     * @param lessonId
     * @return
     */
    LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId);

    /**
     * 获取teacherId
     *
     * @param orgId
     * @param lessonId
     * @return
     */
    Long getTeacherId(Long orgId, Long lessonId);

    /**
     * 获取课节学生userId
     *
     * @param orgId
     * @param lessonIds
     * @return
     */
    List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds);


    /**
     * 导出
     *
     * @param response
     * @param orgId
     * @param dtoList
     */
    void export(HttpServletResponse response, Long orgId, ListLessonsRequestDto param, List<LessonTimeTableResponseDto> dtoList);

    
    /**
     * 临时凑合方案
     * 班级总数
     * 待签到班级总数
     * 
     * @return
     */
    public HeaderDto getHeaderInfo();
    
    /**
     * 批量操作课节
     * 
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @param operateType
     * @param targetId
     */
        
    public void batchOperateLesson(Long orgId,Long courseId,List<Long> lessonIds,BatchOperateType operateType,String targetStr);

    /**
     * 在排课模块中，查看指定课程的课节列表逻辑
     * 
     * @param orgId
     * @param params
     * @return
     */
        
    public ListLessonResponseDto  queryCourseLessons(Long orgId,ListLessonsRequestDto params);
    
    /**
     * 查询班级课节列表
     * @param orgId
     * @param courseId
     * @return
     */
    public List<LessonScheduleInfoDto>  queryCourseLessonsByParams(Long orgId, TimeTableRequestDto params, PageDto pageDto);
    
    public List<LessonScheduleInfoDto>  queryCourseLessonsByParams(Long orgId, Long lessonId, Long teacherId, Long roomId, Long startTime, Long endTime, PageDto pageDto);
    
    /**
     * @param orgId
     * @param params
     * @return
     */
        
    ListLessonResponseDto listSignInLessons(Long orgId, ListLessonsRequestDto params);
    
    
    public List<Long> addClassLessonsBatchForFastSignIn(Long orgId, Long courseId,Integer addLessonTimes,Set<Long> studentIds);
    
    public void batchEditLessonsForFastSignIn(FastSignInLessonsEditRequestDto dto);
    
    public List<LessonResponseDto> findLessonBaseInfoByLessonIds(Long orgId,Long courseId,List<Long> lessonIds);
    
    public List<LessonResponseDto> buildLessonBaseInfoList(Long orgId,Long courseId,List<OrgClassLesson> lessons);
    
    /**
     * 查询天校PC课表查询下拉列表数据
     * @params params: 联动查询条件
     * @return
     */
    public List<NameAndIdDto> getLessonCalendarQueryDropDownList(Long orgId, DropDownListRequestDto params);
   

    /**
     * 检测冲突,默认只获取3条冲突记录,如果需要更多,请调用OrgLessonConflictService的方法
     * @param orgId
     * @param lessonConflictCheckDto
     * @return
     */
    public LessonConflictCheckListDto lessonConflictCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto);

    public void flushConflictData();
}
