
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.dto.response;

import com.baijia.tianxiao.util.date.DateUtil;

import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @title H5LessonTimeTableResponseDto
 * @desc TODO
 * @author bjhl
 * @date 2016年1月5日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class H5LessonTimeTableResponseDto extends LessonTimeTableResponseDto {
    private String lessonStartTimeStr;

    private String lessonEndTimeStr;

    private String date;

    private Integer weekDay;

    @Override
    public void setStartTime(Date startTime) {
        super.setStartTime(startTime);
        String format = DateUtil.getStrByDateFormate(startTime, "yyyy-MM-dd HH:mm");
        String[] formats = format.split(" ");
        this.lessonStartTimeStr = formats[1];
        this.date = formats[0];
        this.weekDay = DateUtil.getWeekDay(startTime);
    }

    @Override
    public void setEndTime(Date endTime) {
        super.setEndTime(endTime);
        this.lessonEndTimeStr = DateUtil.getStrByDateFormate(endTime, "HH:mm");
    }

    public static H5LessonTimeTableResponseDto convert(LessonTimeTableResponseDto dto) {
        H5LessonTimeTableResponseDto result = new H5LessonTimeTableResponseDto();
        try {
            BeanUtils.copyProperties(result, dto);
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        result.setStartTime(dto.getStartTime());
        result.setEndTime(dto.getEndTime());
        return result;
    }
}
