
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.teacherCenter.service;

import com.baijia.tianxiao.biz.erp.dto.response.H5LessonResponseDto;
import com.baijia.tianxiao.biz.erp.teacherCenter.dto.LessonCommentStudentDto;
import com.baijia.tianxiao.sal.comment.dto.CommentAuditDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.List;

/**
 * @title ErpTeacherCenterTeacherService
 * @desc TODO
 * @author shanyu
 * @date 2016年1月3日
 * @version 1.0
 */

public interface ErpTeacherCenterService {

    /**
     * 获取老师信息
     * 
     * @param teacherId
     * @param orgId
     * @return
     */
    public TeacherResponseDto getTeacherInfo(Long teacherId, Long orgId);

    /**
     * 获取老师课程评价
     * 
     * @param orgId
     * @param teacherId
     * @param pageDto
     */
    public List<CommentAuditDto> getTeacherComment(Long orgId, Long teacherId, Boolean isSystem, Integer userRole,
        PageDto pageDto);

    /**
     * 获取最近一次课节
     * 
     * @param h5LessonList 正序的课节列表
     * @param lessonId 课节id
     * @return
     */
    public H5LessonResponseDto getLastLesson(List<H5LessonResponseDto> h5LessonList, Long lessonId);

    /**
     * 获取课节评价列表
     * 
     * @param orgId
     * @param lessonId
     * @param userRole
     * @return
     */
    public List<LessonCommentStudentDto> getCommentList(Long orgId, Long lessonId, Integer userRole);

    /**
     * 获取课程列表
     * 
     * @param orgId
     * @param teacherId
     * @param pageDto
     * @return
     */
    public List<CourseListReponseDto> getCoursesList(Long orgId, Long teacherId, PageDto pageDto);

    /**
     * 获取老师评级统计列表
     * 
     * @param orgId
     * @param page
     * @return
     */
    public List<CommentAuditDto> getTeacherAuditList(Long orgId, Integer userRole, Boolean isSystem, PageDto page);

}
