package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.enums.SyncSignupLessonCount;
import com.baijia.tianxiao.biz.erp.service.ErpStudentCourseService;
import com.baijia.tianxiao.biz.erp.sync.SyncErpService;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupCourseStatus;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/9/23
 * Time: 上午11:28
 * To change this template use File | Settings | File Templates.
 */
@Service("syncSignupCourseSercieImpl")
@Slf4j
public class SyncSignupCourseSercieImpl implements SyncErpService {

    @Autowired
    private OrgSignupCourseDao signupCourseDao;
    @Autowired
    private OrgStudentCourseDao studentCourseDao;
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;
    @Resource
    private ErpStudentCourseService erpStudentCourseService;

    private AtomicBoolean coureFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.SYNC_SIGNUP_COURSE_ID);
        try {
            if (!coureFlag.get()) {
                log.info("sync pay coursePurchase stat info :{}", syncInfo);
                coureFlag.set(true);
                syncSignupCourseInfo(syncInfo);
                coureFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            coureFlag.set(false);
        }
        log.info("save sync info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncSignupCourseInfo(TxMsgSyncTimestamp syncInfo) {

        List<OrgSignupCourse> signupCourseList = signupCourseDao.getCousePurchaseListByMinId(syncInfo.getSyncId(), syncInfo.getSyncTime(), 100, SignupCourseStatus.inStudentCourseStatus);
        log.info("save syncSignupCourseInfo:{} success", signupCourseList);
        if (CollectionUtils.isNotEmpty(signupCourseList)) {
            for (OrgSignupCourse signupCourse : signupCourseList) {
                try {
                    if (signupCourse.getUpdateTime().after(syncInfo.getSyncTime())) {
                        syncInfo.setSyncTime(signupCourse.getUpdateTime());
                    }
                    boolean isNeedSyncLessonCount = true;
                    if (!SignupCourseStatus.statusInStudentCourse(signupCourse.getStatus())) {
                        isNeedSyncLessonCount = false;//没有进过studentCourse忽略
                    }
                    if (signupCourse.getSyncLessonCount() == SyncSignupLessonCount.SYNC_SIGNUP.getCode()) {
                        isNeedSyncLessonCount = false;//已经处理不处理
                    }
                    /**
                     * 进班或退班  修改合同课次
                     */
                    OrgStudentCourse orgStudentCourse = studentCourseDao.getStudentCourseByRealCourseId(signupCourse.getOrgId(), signupCourse.getOrgCourseId(), signupCourse.getUserId());
                    if (isNeedSyncLessonCount) {
                        orgStudentCourse = erpStudentCourseService.signupToStudentCourse(signupCourse, orgStudentCourse);
                        log.info("[SignUpCourseProcessor] orgStudentCourse = {}", orgStudentCourse);

                        boolean hasChange = false;
                        if (orgStudentCourse != null && signupCourse.getClassId() <= 0) {
                            signupCourse.setClassId(orgStudentCourse.getCourseId());
                            hasChange = true;
                        }
                        if (signupCourse.getSyncLessonCount().intValue() != orgStudentCourse.getSyncLessonCount()) {
                            signupCourse.setSyncLessonCount(orgStudentCourse.getSyncLessonCount());
                            hasChange = true;
                        }
                        if (hasChange) {
                            log.info("SignUpCourseProcessor =={},", signupCourse);
                            signupCourseDao.update(signupCourse, "classId", "syncLessonCount");
                        }
                    } else {
                        if (orgStudentCourse != null && signupCourse.getClassId() <= 0) {
                            signupCourse.setClassId(orgStudentCourse.getCourseId());
                            signupCourseDao.update(signupCourse, "classId");
                        }
                    }
                } catch (Exception e) {
                    log.warn("sygn course purchase fail {}", e);
                }
            }
        }

    }


    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }

}
