package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.AssignmentPublishDto;
import com.baijia.tianxiao.biz.erp.service.SendMessageService;
import com.baijia.tianxiao.common.service.WechatMsgRenderService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgSubAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgSubAccount;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dal.wechat.constant.WechateTemplateMsgType;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Map;

/**
 * Created by hanlaijin on 17/3/21.
 */
@Slf4j
@Service
public class SendMessageServiceImpl implements SendMessageService {
    @Resource
    private WechatMsgRenderService wechatService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgTeacherDao yunyingTeacherDao;
    @Resource
    private TeacherDao cdbTeacherDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgSubAccountDao orgSubAccountDao;

    @Override
    public boolean send(AssignmentPublishDto assignmentPublishDto) {
        log.debug("[assignmentPublishDto]={},",assignmentPublishDto);
        paramCheck(assignmentPublishDto);
        Map<String, Object> params = buildSendMsgRequest(assignmentPublishDto);
        if(MapUtils.isEmpty(params)){
            return false;
        }
        log.debug("[send wx message param]={}",params);
        Object wechatMsg = wechatService.render(assignmentPublishDto.getTemplateId(), params);
        //网校使用主校区公众号
        OrgSubAccount account = orgSubAccountDao.getByOrgId(assignmentPublishDto.getOrgId().intValue());
        if(account!=null){
            if(account.getOnlineType() == Flag.TRUE.getInt()){
                if(account.getPid().intValue() != 0){
                    assignmentPublishDto.setOrgId(account.getPid().longValue());
                }
            }
        }
        boolean result = wechatService.sendMsg(assignmentPublishDto.getOrgId(),wechatMsg);
        return result;
    }

    private void paramCheck(AssignmentPublishDto assignmentPublishDto) {
        if(assignmentPublishDto == null){
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "没有接收到请求参数");
        }
        if (assignmentPublishDto.getStudentId() == null || assignmentPublishDto.getStudentId() < 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id错误");
        }
    }

    private Map<String, Object> buildSendMsgRequest(AssignmentPublishDto assignmentPublishDto) {
        Teacher teacher = new Teacher();
        Map<String, Object> params = Maps.newHashMap();
        OrgStudent student = orgStudentDao.getById(assignmentPublishDto.getStudentId());
        OrgTeacher orgTeacher = yunyingTeacherDao.getById(assignmentPublishDto.getTeacherId());
        if(orgTeacher == null){
            teacher.setRealName("机构");
        }else {
            teacher = cdbTeacherDao.getByUserId(orgTeacher.getUserId());
        }
        if(assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.HOMEWORK_PUBLISH_TO_STU.getValue())){
            params.put("template_id", WechateTemplateMsgType.HOMEWORK_PUBLISH_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(),teacher.getRealName()+"老师"));
            if(StringUtils.isBlank(student.getWeixin())){
                return null;
            }
            params.put("touser", student.getWeixin());
        }else if(assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.HOMEWORK_FINISH_TO_TEACHER.getValue())){
            params.put("template_id", WechateTemplateMsgType.HOMEWORK_FINISH_TO_TEACHER.getValue());
            assignmentPublishDto.setKeyword1(String.format(assignmentPublishDto.getKeyword1(),student.getName()));
            if(orgTeacher==null || StringUtils.isBlank(orgTeacher.getWeixin())){
                return null;
            }
            params.put("touser", orgTeacher.getWeixin());
        }else if(assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.HOMEWORK_CORRECT_TO_STU.getValue())){
            params.put("template_id", WechateTemplateMsgType.HOMEWORK_CORRECT_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(),student.getName()));
            assignmentPublishDto.setKeyword2(orgCourseDao.getCourseNameById(assignmentPublishDto.getClassId()));
            if(StringUtils.isBlank(student.getWeixin())){
                return null;
            }
            params.put("touser", student.getWeixin());
        }else if(assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.EXAM_PUBLISH_TO_STU.getValue())){
            params.put("template_id",WechateTemplateMsgType.EXAM_PUBLISH_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(),getOrgName(assignmentPublishDto.getOrgId())));
            assignmentPublishDto.setKeyword3(assignmentPublishDto.getKeyword3()+"分钟");
            if(StringUtils.isBlank(student.getWeixin())){
                return null;
            }
            params.put("touser", student.getWeixin());
        }else if(assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.EXAM_CORRECT_TO_STU.getValue())){
            params.put("template_id",WechateTemplateMsgType.EXAM_CORRECT_TO_STU.getValue());
            assignmentPublishDto.setFirst(String.format(assignmentPublishDto.getFirst(),student.getName()));
            if(StringUtils.isBlank(student.getWeixin())){
                return null;
            }
            params.put("touser", student.getWeixin());
        }else if(assignmentPublishDto.getTemplateId().equals(WechateTemplateMsgType.GRADE_OPEN_TO_STU.getValue())){
            params.put("template_id",WechateTemplateMsgType.GRADE_OPEN_TO_STU.getValue());
            if(StringUtils.isBlank(student.getWeixin())){
                return null;
            }
            params.put("touser", student.getWeixin());
        }
        params.put("url",assignmentPublishDto.getUrl());
        params.put("first", assignmentPublishDto.getFirst());
        params.put("keyword1", assignmentPublishDto.getKeyword1());
        params.put("keyword2", assignmentPublishDto.getKeyword2());
        params.put("keyword3", assignmentPublishDto.getKeyword3());
        params.put("remark", assignmentPublishDto.getRemark());
        return params;
    }

    private String getOrgName(Long orgId) {
        return orgInfoDao.getOrgShortNameByOrgId(orgId.intValue());
    }
}
