
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.biz.erp.constant.StudentStatus;
import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDtoForPC;
import com.baijia.tianxiao.biz.erp.dto.request.EditLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.FastSignInLessonEditRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.FastSignInLessonsEditRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.H5LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonCalendarResponse;
import com.baijia.tianxiao.biz.erp.dto.response.LessonConflictCheckListDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonConflictInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.DayScheduleDto;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.LessonScheduleDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.ConflictInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonScheduleInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.NameAndIdDto;
import com.baijia.tianxiao.biz.erp.enums.BatchOperateType;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.CommentStatus;
import com.baijia.tianxiao.constant.LessonStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonConflictDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dto.DropDownListRequestDto;
import com.baijia.tianxiao.dal.org.dto.TimeTableRequestDto;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.DropdownListType;
import com.baijia.tianxiao.enums.PermissionType;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.common.api.FilterSoftDelTeacherService;
import com.baijia.tianxiao.sal.course.constant.ArrangeStatus;
import com.baijia.tianxiao.sal.course.dto.HeaderDto;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.LessonConflictEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseLessonService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.constant.DeviceType;
import com.baijia.tianxiao.sal.organization.constant.TXPermissionConst;
import com.baijia.tianxiao.sal.organization.org.service.TxAccountPermissionService;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.CollectionHelper;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.Data;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.*;
import java.util.concurrent.ConcurrentMap;

/**
 * @author cxm
 * @version 1.0
 * @title CourseLessonServiceImpl
 * @desc TODO
 * @date 2015年12月28日
 */
@Service
@Slf4j
public class CourseLessonServiceImpl implements CourseLessonService {

    private static final String DEFAULT_ROOM_OR_TEACHER_NAME = "未设置";

    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private ClassRoomService classRoomService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgLessonConflictService orgLessonConflictService;
    @Resource
    private OrgLessonConflictDao orgLessonConflictDao;
    @Resource
    private TXCascadeAccountDao cascadeAccountDao;
    @Resource
    private OrgSignupCourseLessonService signupCourseLessonService;
    @Autowired
    private TxAccountPermissionService permissionService;
    @Autowired
    private FilterSoftDelTeacherService filterSoftDelTeacherService;
    @Autowired
    private OrgCourseTeacherDao courseTeacherDao;
    @Autowired
    private OrgTeacherService teacherService;

    @Override
    @Transactional(readOnly = true)
    public LessonCalendarResponse getLessonCalendar(@NonNull Long orgId, @NonNull Date startDate, @NonNull Date endDate,
        Long teacherId, Long roomId, Integer courseType) {
        LessonCalendarResponse result = buildEmptyCalendarByTimeRange(startDate, endDate);
        log.info("the calendar map is:{}", result);

        Map<Long, Long> lessonTeacherMap = Maps.newHashMap();
        if (teacherId != null && teacherId > 0) {
            lessonTeacherMap = queryLessonIdByTeacherId(orgId, Arrays.asList(teacherId));
            if (lessonTeacherMap == null || lessonTeacherMap.isEmpty()) {
                return result;
            }
        }

        List<OrgClassLesson> lessons =
            orgClassLessonDao.getLessonDates(orgId, lessonTeacherMap.keySet(), roomId, startDate, endDate);
        Set<Long> courseIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
        }

        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds, "id", "status", "courseType", "isDel");
        Map<Long, OrgCourse> courseMap = new HashMap<>();
        for (OrgCourse course : courseList) {
            courseMap.put(course.getId(), course);
        }

        LinkedHashSet<String> dateStrs = Sets.newLinkedHashSet();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (OrgClassLesson lesson : lessons) {
            OrgCourse course = courseMap.get(lesson.getCourseId());
            if (course.getIsDel() != DeleteStatus.DELETED.getValue()) {// 过滤掉删除的
                if (courseType != null) {// 按课程类型筛选
                    if (courseType == course.getCourseType()) {
                        dateStrs.add(sdf.format(lesson.getStartTime()));
                    }
                } else {
                    dateStrs.add(sdf.format(lesson.getStartTime()));
                }
            }
        }
        buildCalendarMap(result, dateStrs);
        return result;
    }

    private void buildCalendarMap(LessonCalendarResponse calendar, Collection<String> dateStrs) {
        Integer year = null;
        Integer month = null;
        Integer day = null;
        Map<Integer, Map<Integer, List<Integer>>> calendarMap = calendar.getCalendarMap();
        for (String dateStr : dateStrs) {
            String[] ymd = dateStr.split("-");
            year = Integer.valueOf(ymd[0].trim());
            month = Integer.valueOf(ymd[1].trim());
            day = Integer.valueOf(ymd[2].trim());

            Map<Integer, List<Integer>> monthMap = calendarMap.get(year);
            if (monthMap.containsKey(month)) {
                monthMap.get(month).add(day);
            } else {
                monthMap.put(month, Lists.<Integer> newArrayList(day));
            }
        }
    }

    private LessonCalendarResponse buildEmptyCalendarByTimeRange(Date startDate, Date endDate) {
        LessonCalendarResponse calendar = new LessonCalendarResponse();
        calendar.setCalendarMap(Maps.<Integer, Map<Integer, List<Integer>>> newTreeMap());
        int startYear = new DateTime(startDate).getYear();
        int endYear = new DateTime(endDate.getTime() - 1).getYear();
        for (Integer i = startYear; i <= endYear; i++) {
            calendar.getCalendarMap().put(i, Maps.<Integer, List<Integer>> newTreeMap());
        }
        return calendar;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto) {
        AddCourseLessonRequestDtoForPC dtoForPC = new AddCourseLessonRequestDtoForPC();
        try {
            BeanUtils.copyProperties(dtoForPC, dto);
            // AddCourseLessonRequestDto 复写了get方法的字段,并且返回值不与原字段类型匹配的,无法copy
            if (CollectionUtils.isNotEmpty(dto.getStudentIds())) {
                dtoForPC.setStudentIds(StringUtils.join(dto.getStudentIds().toArray(), ","));
            }
            dtoForPC.setRepeatUnit(dto.getRepeatUnit().getCode());
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        addClassLessonsForPC(orgId, startDay, endDay, dtoForPC);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addClassLessonsForPC(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDtoForPC dto) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(startDay != null, "start day can not be null");
        Preconditions.checkArgument(dto != null, "class lessons param is illegal");
        Preconditions.checkArgument(dto.getCourseId() != null && dto.getCourseId() > 0, "courseId is illegal");
        Preconditions.checkArgument(dto.getLessonName() != null && dto.getLessonName().length() < 21,
            "the lesson name is null or too long");

        OrgCourse orgCourse = orgCourseDao.getByCourseId(dto.getCourseId());
        // 1v1 的非班级不能添加课节
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()
            && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_FALSE.getCode()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "当前版本不支持，请升级新版本");
        }

        List<Calendar> calens = dto.getRepeatUnit().getAvaliableDays(startDay, dto.getRepeatCount(),
            dto.getRepeatRange(), dto.getWeekDays(), dto.getCalendarDays());
        TimeStamp startTime = TimeStamp.parse(dto.getStartTime());
        TimeStamp endTime = TimeStamp.parse(dto.getEndTime());

        OrgClassLesson lesson = null;
        List<OrgClassLesson> lessons = Lists.newArrayList();
        List<OrgLessonConflict> lessonConflicts = Lists.newArrayList();
        int index = 1;
        for (Calendar cal : calens) {
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            lesson = new OrgClassLesson();
            lesson.setStartTime(lessonTime.getStartTime());
            lesson.setEndTime(lessonTime.getEndTime());
            lesson.setCourseId(dto.getCourseId());
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(DataStatus.NORMAL.getValue());
            lesson.setLayoutId(0l);
            lesson.setRoomId(dto.getRoomId() != null ? dto.getRoomId() : 0l);
            lesson.setUpdateTime(new Date());
            lesson.setNumber(index);
            lesson.setName(dto.getLessonName());
            lesson.setOrgId(orgId);
            lessons.add(lesson);
            index++;

            // orgClassLessonDao.save(lesson);
        }
        log.info("save {} lessons into db,params:{}", lessons.size(), dto);
        orgClassLessonDao.saveAll(lessons, "startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId",
            "roomId", "updateTime", "orgId", "name");

        /**
         * 如果是新排课，设置cdb,org_course.arrange_lesson=1
         */
        if (orgCourse.getArrangeLesson() == ArrangeStatus.UNARRANGE.getCode()) {
            orgCourse.setArrangeLesson(ArrangeStatus.ARRANGEED.getCode());
            orgCourseDao.update(orgCourse, "arrangeLesson");
        }

        /**
         * 添加教室到课程
         */
        Set<Long> roomIds = Sets.newHashSet();
        roomIds.add(dto.getRoomId() != null ? dto.getRoomId() : 0l);
        classRoomService.addClassRoomCourse(orgId.longValue(), dto.getCourseId(), roomIds);

        // 如果原来有课节的话,需要重新安排课节编号
        resetLessonNumber(orgId, dto.getCourseId());
        for (OrgClassLesson classLesson : lessons) {
            courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
                dto.getStudentIds(), true);
            Set<Long> teacherIds = Sets.newHashSet();
            Set<Long> tempTeacherIds = Sets.newHashSet();
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0) {
                teacherIds.add(dto.getTeacherId());
                tempTeacherIds.addAll(teacherIds);
                courseTeacherService.addTeacherToCourse(orgId, classLesson.getCourseId(), teacherIds);// 先添加到课程
                courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
                    tempTeacherIds);
            }

            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setLessonId(classLesson.getId());
            conflict.setOrgId(orgId);
            conflict.setRoomId(classLesson.getRoomId() == null ? 0 : classLesson.getRoomId());
            conflict.setStartTime(classLesson.getStartTime());
            conflict.setEndTime(classLesson.getEndTime());

            if (tempTeacherIds.size() > 1) {
                int i = 1;
                for (Iterator<Long> teacherIt = tempTeacherIds.iterator(); teacherIt.hasNext(); i++) {
                    if (i > 1) {
                        try {
                            OrgLessonConflict cloneConflict = (OrgLessonConflict) BeanUtils.cloneBean(conflict);
                            cloneConflict.setTeacherId(teacherIt.next());
                            lessonConflicts.add(cloneConflict);
                        } catch (Exception e) {
                            throw new RuntimeException("clone bean error:", e);
                        }
                    } else {
                        conflict.setTeacherId(teacherIt.next());
                        lessonConflicts.add(conflict);
                    }
                }
            } else {
                conflict.setTeacherId(dto.getTeacherId() == null ? 0 : dto.getTeacherId());
                lessonConflicts.add(conflict);
            }
        }
        // 添加冲突检测表数据
        orgLessonConflictService.saveOrgLessonConflicts(lessonConflicts);
    }

    @Override
    @Transactional(readOnly = true)
    public ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params, boolean includeDelCourse) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        // Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        List<OrgClassLesson> lessons = queryLesson(orgId, lessonIdTeacherIdMap, params, true, includeDelCourse);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>() {
                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }

            Map<Long, OrgCourse> courseMap = Maps.newHashMap();
            // bugfix 这里如果校验是否需要课程名字，后面的组装对象的逻辑就无法通过判断课程是否删除来过滤无效的课节，所以注释掉，以确保程序正确
            // if (params.isNeedcourseName()) {
            courseMap = getOrgCourseMap(orgId, courseIds);
            // }
            Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = getOrgClassRoomMap(roomIds);
            }

            Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
            Map<Long, Integer> signedStudentCountMap = Maps.newHashMap();
            Map<Long, Integer> allSignStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signedStudentCountMap = orgLessonSignDao.querySignedLessonStudentCountMap(orgId, lessonIds);
                allSignStudentCountMap = orgLessonSignDao.querySignLessonStudentCountMap(orgId, lessonIds);
            }
            Map<Long, Integer> commentCount = Maps.newHashMap();
            Map<Long, Integer> lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument(params.getStudentId() != null && params.getStudentId() > 0, "学生ID不正确");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                List<OrgLessonSign> lessonSign = orgLessonSignDao.getStudentSign(orgId, userId,
                    UserRole.STUDENT.getRole(), lessonIds, "lessonId", "status");
                if (CollectionUtils.isNotEmpty(lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap(lessonSign, new Function<OrgLessonSign, Long>() {
                        @Override
                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, new Function<OrgLessonSign, Integer>() {
                        @Override
                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", lessonSignStatus);
                }
            }

            result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap,
                studentCountMap, allSignStudentCountMap, signedStudentCountMap, commentCount, lessonSignStatus);
            int lastRow = result.getList().size() - 1;
            Date now = new Date();
            if (lastRow >= 0) {
                result.setNewLessonId(result.getList().get(lastRow).getLessonId());
                for (LessonResponseDto lesson : result.getList()) {
                    if (now.before(lesson.getLessonEndTime())) {
                        result.setNewLessonId(lesson.getLessonId());
                        break;
                    }
                }
            }
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly = true)
    public ListLessonResponseDto listSignInLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        // Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        List<OrgClassLesson> lessons = querySignInLesson(orgId, lessonIdTeacherIdMap, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>() {
                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }

            Map<Long, OrgCourse> courseMap = Maps.newHashMap();
            // bugfix 这里如果校验是否需要课程名字，后面的组装对象的逻辑就无法通过判断课程是否删除来过滤无效的课节，所以注释掉，以确保程序正确
            // if (params.isNeedcourseName()) {
            courseMap = getOrgCourseMap(orgId, courseIds);
            // }
            Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = getOrgClassRoomMap(roomIds);
            }

            Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
            Map<Long, Integer> signStudentCountMap = Maps.newHashMap();
            Map<Long, Integer> signedStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = orgLessonSignDao.querySignLessonStudentCountMap(orgId, lessonIds);
                signedStudentCountMap = orgLessonSignDao.querySignedLessonStudentCountMap(orgId, lessonIds);
            }
            Map<Long, Integer> commentCount = Maps.newHashMap();
            Map<Long, Integer> lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument(params.getStudentId() != null && params.getStudentId() > 0, "学生ID不正确");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());

                commentCount = orgLessonCommentDao.getLessonCommentCountMap(lessonIds, orgId, userId, null,
                    UserRole.STUDENT.getRole(), false);

                List<OrgLessonSign> lessonSign = orgLessonSignDao.getStudentSign(orgId, userId,
                    UserRole.STUDENT.getRole(), lessonIds, "lessonId", "status");
                if (CollectionUtils.isNotEmpty(lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap(lessonSign, new Function<OrgLessonSign, Long>() {
                        @Override
                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, new Function<OrgLessonSign, Integer>() {
                        @Override
                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", lessonSignStatus);
                }
            }

            result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap,
                studentCountMap, signStudentCountMap, signedStudentCountMap, commentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    private Map<Long, String> getLessonIdTeacherName(Long orgId, Collection<Long> lessonIds,
        Map<Long, Long> lessonTeacherIdMap) {
        long l = System.currentTimeMillis();
        if (MapUtils.isEmpty(lessonTeacherIdMap)) {
            lessonTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        }
        Map<Long, String> teacherNameMap = teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        Map<Long, String> lessonIdTeacherNameMap = new HashMap<>(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            String name = teacherNameMap.get(lessonTeacherIdMap.get(lessonId));
            if (name != null) {
                lessonIdTeacherNameMap.put(lessonId, name);
            }
        }
        return lessonIdTeacherNameMap;
    }

    @SuppressWarnings("unchecked")
    private List<OrgClassLesson> queryLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap,
                                             ListLessonsRequestDto params, boolean isTimeTable, boolean includeDelCourse) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        // 1.登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 2.涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        // 3.所有人都有查看课表的权限，liuxiaopeng
        if (TianxiaoMContext.getTXCascadeId() != null && isTimeTable) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                handleStaffCourseIds(orgId,TianxiaoMContext.getTXCascadeId(),courseIds);
                if (CollectionUtils.isEmpty(courseIds)) {
                    return Collections.EMPTY_LIST;
                }

            }
        }

        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty(lessonIds)) {
                return Collections.emptyList();
            }
        }

        lessonIdTeacherIdMap = queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty(teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());

        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }

        // FIXME 脏逻辑,不要喷我,没时间修数据 -----> who are you?
        List<Long> notInCourseIds = Lists.transform(
            orgCourseDao.getCoursesByOrgNumber(orgAccountDao.getById(orgId, "number").getNumber().longValue(),
                DeleteStatus.DELETED.getValue(), "id", "courseType"),
            new Function<OrgCourse, Long>() {
                @Override
                public Long apply(OrgCourse input) {
                    return input.getId();
                }
            });

        List<OrgClassLesson> lessons = orgClassLessonDao.queryLessons(notInCourseIds, orgId, courseIds, roomIds,
            lessonIds, startTime, endTime, params.getPageDto(), null);
        return lessons;
    }

    @Override
    @Transactional(readOnly = true)
    public void handleStaffCourseIds(Long orgId,Integer cascadeId,Set<Long> courseIds){
        Set<Long> courseIdSet = new HashSet<>();
        List<Long> tmpIds = orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        courseIdSet.addAll(tmpIds);
        Long teacherId = teacherService.getUserIdByCascadeId(orgId, cascadeId);
        if(teacherId!=null){
            courseIdSet.addAll(courseTeacherDao.getCourseIdByTeacherId(teacherId));
        }
        // bugfix 此处根据课程权限获取用户课节的逻辑有问题，如果用户指定查询一门课的课节会查出用户课程权限下的所有课节，故调整逻辑
        if (CollectionUtils.isEmpty(courseIds)) {
            courseIds.addAll(courseIdSet);
        } else {
            // 如果是子帐号，并且指定了课程，那么需要判断课程是否在这个用户的权限中
            if (!courseIdSet.containsAll(courseIds)) {
                courseIds.clear();
            }
        }
        log.debug("after set courseIds:{}", courseIds);
    }

    @SuppressWarnings("unchecked")
    private List<OrgClassLesson> querySignInLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap,
        ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> teacherIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();

        Long number = orgAccountDao.getById(orgId, "number").getNumber().longValue();
        List<Long> delCourseIds =
            Lists.transform(orgCourseDao.getCoursesByOrgNumber(number, DeleteStatus.DELETED.getValue(), "id"),
                new Function<OrgCourse, Long>() {
                    @Override
                    public Long apply(OrgCourse input) {
                        return input.getId();
                    }
                });

        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
            courseIds.removeAll(delCourseIds);
        }
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                handleStaffCourseIds(orgId,TianxiaoMContext.getTXCascadeId(),courseIds);
                if (CollectionUtils.isEmpty(courseIds)) {
                    return Collections.EMPTY_LIST;
                }

            }
        }

        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty(lessonIds)) {
                return Collections.emptyList();
            }
        }

        lessonIdTeacherIdMap = queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty(teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());

        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }

        List<OrgClassLesson> lessons = orgClassLessonDao.querySignInLessons(orgId, courseIds, delCourseIds, roomIds,
            lessonIds, startTime, endTime, params.getPageDto(), params.getLessonId());
        return lessons;
    }

    @Override
    @Transactional(readOnly = true)
    public List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument(params.getStartTime() != null && params.getEndTime() != null,
            "start time or end time is null");
        Preconditions.checkArgument(params.getEndTime().after(params.getStartTime()), "time condition error");
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        List<OrgClassLesson> lessons = queryLesson(orgId, lessonIdTeacherIdMap, params, false, false);
        if (CollectionUtils.isNotEmpty(lessons)) {
            Set<Long> lessonIds = Sets.newHashSet();
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            if (lessonIdTeacherIdMap.isEmpty()) {
                lessonIdTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
                log.debug("query lessonId teacherId map:{}by lessonIds:{}", lessonIdTeacherIdMap, lessonIds);
            }
            Map<Long, OrgCourse> courseMap = getOrgCourseMap(orgId, courseIds);
            Map<Long, String> teacherNameMap = teacherDao.getTeacherRealNameMap(lessonIdTeacherIdMap.values());
            Collection<Long> orgCourseTeacherUserIds = teacherNameMap.keySet();
            filterSoftDelTeacherService.filterOrgCourseTeacherWithUserIds(orgId, orgCourseTeacherUserIds);
            Map<Long, OrgClassRoom> classRoomMap = getOrgClassRoomMap(roomIds);
            List<LessonTimeTableResponseDto> result = Lists.newArrayList();
            Date currentDate = new Date();
            for (OrgClassLesson lesson : lessons) {
                Long teacherId = lessonIdTeacherIdMap.get(lesson.getId());
                String teacherName = "";
                boolean needShow =
                    (orgCourseTeacherUserIds.contains(teacherId)) || (lesson.getEndTime().compareTo(currentDate) < 0);
                if (needShow) {
                    teacherName = teacherNameMap.get(teacherId);
                }

                // bufix 稍加修改，过滤掉已经删除的课程
                OrgCourse tempCourse = courseMap.get(lesson.getCourseId());
                if (tempCourse != null && tempCourse.getIsDel() == 0) {
                    if (params.getCourseType() != null && params.getCourseType() != tempCourse.getCourseType()) {
                        continue;
                    }
                    LessonTimeTableResponseDto dto = buildTimeTableDto(lesson, tempCourse,
                        classRoomMap.get(lesson.getRoomId()), teacherId, teacherName);
                    result.add(dto);
                }
            }
            return result;
        } else {
            return Collections.emptyList();
        }
    }

    private Map<Long, OrgClassRoom> getOrgClassRoomMap(Collection<Long> roomIds) {
        List<OrgClassRoom> classRooms =
            orgClassRoomDao.getByIds(roomIds, "id", "roomName", "roomSize", "recycleStatus");
        return CollectorUtil.collectMap(classRooms, new Function<OrgClassRoom, Long>() {
            @Override
            public Long apply(OrgClassRoom input) {
                return input.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getOrgCourseMap(Long orgId, Collection<Long> courseIds) {
        List<OrgCourse> courseList =
            orgCourseDao.getByIds(courseIds, "id", "cover", "name", "color", "isDel", "courseType");
        // 课程删除, 课节是否显示
        // Iterator<OrgCourse> courseIter = courseList.iterator();
        // while (courseIter.hasNext()) {
        // OrgCourse orgCourse = courseIter.next();
        // if (orgCourse.getIsDel() != 0) {
        // courseIter.remove();
        // }
        // }

        // 批量设置一下颜色
        orgCourseListService.getCourseList(courseList, orgId, false, false, false, false, false, false, false);
        return CollectorUtil.collectMap(courseList, new Function<OrgCourse, Long>() {
            @Override
            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
    }

    private LessonTimeTableResponseDto buildTimeTableDto(OrgClassLesson lesson, OrgCourse course,
        OrgClassRoom classRoom, Long teacherId, String teacherName) {
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        dto.setCourseId(lesson.getCourseId());
        if (course != null) {
            dto.setCourseColor(course.getColor());
            dto.setCourseName(course.getName());
        }
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setLessonId(lesson.getId());
        dto.setIndex(lesson.getNumber());
        dto.setRoomId(lesson.getRoomId());
        if (classRoom != null && classRoom.getRecycleStatus() != DeleteStatus.DELETED.getValue()) {
            dto.setRoomName(classRoom.getRoomName());
        }
        dto.setCourseType(course.getCourseType());
        dto.setLessonName(lesson.getName());
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        dto.setTeacherId(teacherId);
        dto.setTeacherName(teacherName == null ? "" : teacherName);
        return dto;
    }

    private ListLessonResponseDto buildListLessonResponseDto(List<OrgClassLesson> lessons,
        Map<Long, OrgCourse> courseMap, Map<Long, String> lessonIdTeacherNameMap, Map<Long, OrgClassRoom> classRoomMap,
        Map<Long, Integer> studentCountMap, Map<Long, Integer> signStudentCountMap,
        Map<Long, Integer> signedStudentCountMap, Map<Long, Integer> commentCount,
        Map<Long, Integer> lessonSignStatus) {
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Date now = new Date();
            for (OrgClassLesson lesson : lessons) {
                if (result.getFirstLessonStartTime() == null
                    || result.getFirstLessonStartTime().after(lesson.getStartTime())) {
                    result.setFirstLessonStartTime(lesson.getStartTime());
                }
                if (result.getLastLessonStartTime() == null
                    || result.getLastLessonStartTime().before(lesson.getStartTime())) {
                    result.setLastLessonStartTime(lesson.getStartTime());
                }

                LessonResponseDto dto = new LessonResponseDto();
                dto.setCourseId(lesson.getCourseId());
                dto.setIndex(lesson.getNumber());
                OrgCourse course = courseMap.get(lesson.getCourseId());
                // 这么改分页不出问题???
                // bugfix 课程不存在则过滤掉，解决删除课程，课节并未删除，在签到列表展示的问题
                if (course == null) {
                    continue;
                }
                if (StringUtils.isNotBlank(course.getName())) {
                    dto.setCourseName(course.getName());
                }
                dto.setCourseType(course.getCourseType().intValue());
                // dto.setCourseChargeUnit(course.getChargeUnit());
                OrgClassRoom classRoom = classRoomMap.get(lesson.getRoomId());
                dto.setRoomId(lesson.getRoomId());
                if (classRoom != null) {
                    dto.setRoomName(classRoom.getRoomName());
                }
                dto.setTeacherName(lessonIdTeacherNameMap.get(lesson.getId()));
                dto.setLessonEndTime(lesson.getEndTime());
                dto.setLessonId(lesson.getId());
                dto.setLessonStartTime(lesson.getStartTime());
                dto.setLessonName(lesson.getName());
                CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
                if (now.after(lesson.getEndTime())) {
                    // 设置课程结束标记
                    signStatus = CourseSignStatus.NO_SIGN;
                    dto.setIsOver(1);
                }
                if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.SIGNING;
                }
                Integer signCount = signStudentCountMap.get(lesson.getId());
                Integer inClassCount = signedStudentCountMap.get(lesson.getId());
                SignStatus stuSignStatus = SignStatus.getSignStatusByCode(lessonSignStatus.get(lesson.getId()));
                if (stuSignStatus != null) {
                    log.debug("lessonId:{},lessonSignStatus:{},status:{}", lesson.getId(), lessonSignStatus,
                        stuSignStatus);
                    dto.setSignStatusEnum(stuSignStatus);
                } else {

                    if (signCount != null && signCount > 0) {
                        signStatus = CourseSignStatus.SIGNED;
                    }
                    dto.setCourseSignStatusEnum(signStatus);

                }

                Integer commentCnt = commentCount.get(lesson.getId());
                if (commentCnt != null && commentCnt > 0) {
                    dto.setCommentEnum(CommentStatus.COMMENTED);
                } else {
                    dto.setCommentEnum(
                        CommentStatus.getCommentStatusByTime(lesson.getStartTime(), lesson.getEndTime(), true));
                }

                Integer studentCount = studentCountMap.get(lesson.getId());
                dto.setSignCount(inClassCount != null ? inClassCount : 0);
                dto.setTotalSignCount(signCount != null ? signCount : 0);
                dto.setStudentCount(studentCount != null ? studentCount : 0);
                result.getList().add(dto);
            }
        }
        return result;

    }

    private Map<Long, Long> queryLessonIdByTeacherId(Long orgId, Collection<Long> teacherIds) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Collections.emptyMap();
        }
        List<OrgTeacherLesson> teacherLessons =
            orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, "lessonId", "teacherId");
        if (CollectionUtils.isNotEmpty(teacherLessons)) {
            Map<Long, Long> result = new HashMap<>();
            for (OrgTeacherLesson orgTeacherLesson : teacherLessons) {
                result.put(orgTeacherLesson.getLessonId(), orgTeacherLesson.getTeacherId());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly = true)
    public LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        Date now = new Date();
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", lessonId, lesson);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID不正确");
        }
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        // set course info
        OrgCourse course =
            orgCourseDao.getByCourseId(lesson.getCourseId(), "id", "name", "courseType", "color", "isFinish");
        if (course == null) {
            log.warn("can not found course by lesson:{}", lesson);
            throw new BussinessException(CommonErrorCode.SYSTEM_ERROR, "无法找到对应班级");
        }
        dto.setCourseColor(course.getColor());
        dto.setCourseId(course.getId());
        dto.setCourseType(course.getCourseType().intValue());
        dto.setCourseName(course.getName());
        dto.setCourseFinish(course.getIsFinish());
        // set lesson info
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setIndex(lesson.getNumber());
        dto.setLessonId(lesson.getId());
        dto.setLessonName(lesson.getName());
        CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
        if (now.after(lesson.getStartTime())) {
            signStatus = CourseSignStatus.NO_SIGN;
            if (now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
        }
        dto.setRoomId(lesson.getRoomId());
        dto.setSignStatusEnum(signStatus);
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        return dto;
    }

    @Override
    @Transactional(readOnly = true)
    public LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign) {
        LessonTimeTableResponseDto dto = lessonInfo(orgId, lessonId);
        // set student
        dto.setStudents(courseStudentService.getLessonStudent(orgId, lessonId, needStudentSign));
        for (OrgStudentsChooseListDto student : dto.getStudents()) {
            if (student.getSignStatus() != null && SignStatus.SIGNED.getCode() == student.getSignStatus()) {
                dto.increaseSignStudent();
            }
        }
        List<TeacherResponseDto> teacherDtos = courseTeacherService.getLessonTeacher(orgId, lessonId);
        if (CollectionUtils.isNotEmpty(teacherDtos)) {
            TeacherResponseDto teacherDto = teacherDtos.get(0);
            dto.setTeacherId(teacherDto.getTeacherId());
            dto.setTeacherName(teacherDto.getTeacherName());
        }
        // set room info
        if (dto.getRoomId() != null && dto.getRoomId() > 0) {
            OrgClassRoom classRoom = orgClassRoomDao.getById(dto.getRoomId(), "id", "roomName", "recycleStatus");
            log.debug("[lesson detail.classroom status]=", classRoom.getRecycleStatus());
            if (classRoom.getRecycleStatus() == DeleteStatus.NORMAL.getValue()) {
                dto.setRoomName(classRoom.getRoomName());
            } else {
                OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
                if (DateUtil.compare(lesson.getStartTime(), new Date())) {
                    dto.setRoomName(classRoom.getRoomName());
                } else {
                    dto.setRoomName(null);
                    dto.setRoomId(null);
                }
            }
        }

        dto.setEditable(hasPermission(orgId, dto.getCourseId(), lessonId,TXPermissionConst.IF_CLASS_ARRANGE).getType());
        dto.setSignable(hasPermission(orgId, dto.getCourseId(), lessonId,TXPermissionConst.IF_SIGNUP).getType());
        dto.setCommentable(dto.getSignable());

        //1V1的课会根据这个状态来判断是否能够编辑
        if(CourseTypeEnum.isOneToOne(dto.getCourseType()) && dto.getStudents() != null && dto.getStudents().size()>0){
            boolean isFinish = isFinished(orgId,dto.getCourseId(),dto.getStudents().get(0).getUserId());
            dto.setCourseFinish(isFinish?1:0);
        }

        return dto;
    }

    private boolean isFinished(Long orgId,Long courseId,Long userId){
        OrgStudentCourse studentCourse = orgStudentCourseDao.getStudentCourse(orgId,courseId,userId);
        if(studentCourse!=null && studentCourse.getStatus()==0){
            return false;
        }else {
            return true;
        }
    }

    private PermissionType hasPermission(Long orgId, Long courseId, Long lessonId,TXPermissionConst permissionConst) {
        Integer cascadeId = TianxiaoMContext.getTXCascadeId();
        PermissionType type = PermissionType.FORBIDDEN;
        if (cascadeId != null && cascadeId > 0) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
            boolean hasPermission = permissionService.checkPermission(orgId, cascadeId, DeviceType.APP, permissionConst.getpCode());
            if (hasPermission) {
                List<Long> teacherIds = null;
                if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                    if(permissionConst == TXPermissionConst.IF_SIGNUP) {
                        //课节的老师 & 签到权限 签到权限
                        teacherIds = orgClassLessonDao.listCourseLessonTeacherId(lessonId);
                    }else {
                        //该班级的老师 & 有排课权限 排课权限
                        teacherIds = courseTeacherDao.getTeacherIdsByCourseId(courseId);
                    }
                    Long teacherId = teacherService.getUserIdByCascadeId(orgId,cascadeId);
                    if(teacherId!=null && teacherIds.contains(teacherId) ){
                        return PermissionType.ALLOWED;
                    }
                    List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                    if (CollectionUtils.isEmpty(tempIds) || !tempIds.contains(courseId)) {
                        type = PermissionType.FORBIDDEN;
                    } else {
                        type = PermissionType.ALLOWED;// 员工有权限&是该课班主任
                    }
                } else {// 主管只要有权限
                    type = PermissionType.ALLOWED;
                }
            } else {
                type = PermissionType.FORBIDDEN;
            }
        } else {
            type = PermissionType.ALLOWED;
        }
        return type;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void delLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(lessonId != null && lessonId > 0, "lessonId is illegal");
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", lessonId, lesson);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节不存在或已被删除");
        }
        // 删除课节权限判断
        // add by zhangbing
        hasDeleteLessonPermission(lesson.getCourseId());

        if (CollectionUtils.isNotEmpty(orgLessonCommentDao.getLessonComments(lessonId, null, null, "id"))) {
            throw new BussinessException(CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty(
            orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, false, null, null, "id"))) {
            throw new BussinessException(CommentErrorCode.LESSON_WITH_SIGN);
        }
        courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);

        List<Long> lessonIds = Lists.newArrayList();
        lessonIds.add(lessonId);

        orgClassLessonDao.updateDelByLessonIds(orgId, lessonIds);
        resetLessonNumber(orgId, lesson.getCourseId());
        signupCourseLessonService.deleteClassLessons(orgId, lessonIds);

        // 冲突检测表逻辑删除
        orgLessonConflictService.delByLessonIds(orgId, lessonIds);

    }

    void hasDeleteLessonPermission(Long courseId) {
        // 登录帐号为子帐号，并且是员工帐号，并且排课权限打开时，只能查看自己作为班主任的课节
        // 涉及到分页，这里取courseIds时，按照时间倒序，测试时需要关注数据是否取全
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                List<Long> tempIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null,
                    CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                if (CollectionUtils.isEmpty(tempIds) || !tempIds.contains(courseId)) {
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "无权操作");
                }
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void editLesson(Long orgId, EditLessonRequestDto editDto) {
        Preconditions.checkNotNull(editDto, "param can not be null");
        editDto.validate();
        OrgClassLesson lesson = orgClassLessonDao.getById(editDto.getLessonId());
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", editDto.getLessonId(), lesson);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课节ID不正确");
        }
        // 员工只能编辑自己是班主任的班级课节
        this.editValidate(orgId,lesson.getCourseId());
        lesson.setDelStatus(DataStatus.NORMAL.getValue());
        boolean needRearrange = false;
        if (!editDto.getEndTime().equals(lesson.getEndTime())
            || !editDto.getStartTime().equals(lesson.getStartTime())) {
            lesson.setEndTime(editDto.getEndTime());
            lesson.setStartTime(editDto.getStartTime());
            // 需要重新设置number
            needRearrange = true;
        }
        List<Long> teacherIds = Lists.newArrayList();
        if (editDto.getRoomId() == null) {
            editDto.setRoomId(0l);
        }
        if (editDto.getTeacherId() == null) {
            editDto.setTeacherId(0l);
        } else {
            teacherIds.add(editDto.getTeacherId());
        }
        lesson.setRoomId(editDto.getRoomId());
        lesson.setUpdateTime(new Date());
        lesson.setName(editDto.getLessonName());

        orgClassLessonDao.update(lesson);
        if (needRearrange) {
            resetLessonNumber(orgId, lesson.getCourseId());
            Integer duration = DateUtil.getMinuteDiff(lesson.getStartTime(), lesson.getEndTime());
            List<Long> userIds = orgStudentLessonDao.getUserIds(editDto.getLessonId(), orgId);
            orgStudentLessonDao.batchUpdateLessonDuration(userIds, duration, editDto.getLessonId());
            signupCourseLessonService.updateLessonDuration(orgId, lesson);
        }

        /**
         * 添加教室到课程
         */
        Set<Long> roomIds = Sets.newHashSet();
        roomIds.add(editDto.getRoomId() != null ? editDto.getRoomId() : 0l);
        classRoomService.addClassRoomCourse(orgId.longValue(), lesson.getCourseId(), roomIds);

        courseTeacherService.resetLessonTeacher(orgId, lesson.getCourseId(), lesson.getId(), teacherIds);
        // courseStudentService.resetLessonStudent(orgId, lesson.getCourseId(), lesson.getId(),
        // editDto.getStudentIds());

        // 更新冲突检测表
        OrgLessonConflict conflict = new OrgLessonConflict();
        conflict.setOrgId(orgId);
        conflict.setTeacherId(editDto.getTeacherId());
        conflict.setRoomId(editDto.getRoomId());
        conflict.setLessonId(editDto.getLessonId());
        conflict.setStartTime(editDto.getStartTime());
        conflict.setEndTime(editDto.getEndTime());
        conflict.setDelStatus(DataStatus.NORMAL.getValue());
        orgLessonConflictService.updateOrgLessonConflictsForce(conflict);
    }

    void editValidate(Long orgId,Long courseId) {
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = cascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount == null) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
            }
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                List<Long> courseIds = new ArrayList<>();
                List<Long> tempIds =
                    orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, null, null);
                courseIds.addAll(tempIds);
                Long teacherId = teacherService.getUserIdByCascadeId(orgId, TianxiaoMContext.getTXCascadeId());
                List<Long> teacherCourseIds = null;
                if(teacherId!=null){
                    teacherCourseIds = courseTeacherDao.getCourseIdByTeacherId(teacherId);
                }
                if(teacherCourseIds!=null && teacherCourseIds.size()>0){
                    courseIds.addAll(teacherCourseIds);
                }
                if (CollectionUtils.isEmpty(courseIds) || !courseIds.contains(courseId)) {
                    throw new BussinessException(CommonErrorCode.PERMISSION_DENY, "无权操作不属于您的课节");
                }
            }
        }
    }

    private void resetLessonNumber(Long orgId, Long courseId) {
        List<OrgClassLesson> lessons = orgClassLessonDao.queryLessons(orgId, Lists.newArrayList(courseId), null, null,
            null, null, null, null, "id");
        if (CollectionUtils.isNotEmpty(lessons)) {
            int index = 1;
            @SuppressWarnings("unchecked")
            Map<String, Number>[] params = new Map[lessons.size()];
            for (OrgClassLesson lesson : lessons) {
                Map<String, Number> param = new HashMap<>();
                param.put("id", lesson.getId());
                param.put("number", index);
                params[index - 1] = param;
                index++;
            }
            orgClassLessonDao.batchUpdateLessonNumber(params);
        }
    }

    @Override
    @Transactional(readOnly = true)
    public Long getTeacherId(Long orgId, Long lessonId) {
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        if (teacherLesson != null) {
            return teacherLesson.getTeacherId();
        }
        return null;
    }

    @Override
    @Transactional(readOnly = true)
    public List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        return this.orgStudentLessonDao.getUserIdsByLessonIds(orgId, lessonIds);
    }

    @Override
    public void export(HttpServletResponse response, Long orgId, ListLessonsRequestDto param,
        List<LessonTimeTableResponseDto> dtoList) {
        Preconditions.checkArgument(param.getStartTime() != null, "开始日期不能为空");
        Preconditions.checkArgument(param.getEndTime() != null, "结束日期不能为空");
        Preconditions.checkArgument(orgId != null && orgId.longValue() > 0L, "机构ID不能为空");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String startTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getStartTime());
        String endTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getEndTime());
        String fileName = orgName + "-课表统计-" + startTimeStr + "~" + endTimeStr + ".xlsx";
        SXSSFWorkbook workbook = null;
        List<Date> dates = DateUtil.getDateBetween(param.getStartTime(), param.getEndTime());

        try {
            workbook = new SXSSFWorkbook(200);
            HashMap cellStyleMap = new HashMap();
            List summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField(" ", "@", 5620));
            for (Date date : dates) {
                summaryFields.add(new ExportField(
                    "周" + DateUtil.getChineseWeekDay(date) + "(" + DateUtil.getDayStr(date) + ")", "@", 5120));
            }
            List titles = Lists.newArrayList();
            titles.add(startTimeStr + "~" + endTimeStr + "课表统计");

            ExcelCourseExportService.createSheet(workbook, "课表统计", titles, cellStyleMap, summaryFields, dtoList,
                param.getStartTime());

            ExcelCourseExportService.exportExcel(response, workbook, fileName);
            log.debug("course lesson export success");
        } catch (Exception var20) {
            log.error("export catch exception:", var20);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "导出数据处理异常");
        } finally {
            try {
                workbook.close();
            } catch (IOException var19) {
                log.error("close workbook catch error:", var19);
            }

        }

    }

    public static void main(String[] args) throws IOException {
        String json = FileUtils.readFileToString(new File("/Users/wengshengli/Downloads/response.json"));
        List dtoList = JacksonUtil.str2List(json, LessonTimeTableResponseDto.class);
        Date startDate = new Date(1465747200682l);
        Date endDate = new Date(1466351999682l);
        System.out.println(DateUtil.getDateDiff(startDate, endDate));
        List<Date> dates = DateUtil.getDateBetween(startDate, endDate);
        SXSSFWorkbook workbook = new SXSSFWorkbook(200);
        HashMap cellStyleMap = new HashMap();
        List summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("", "@", 5620));
        for (Date date : dates) {
            summaryFields.add(new ExportField(
                "周" + DateUtil.getChineseWeekDay(date) + "(" + DateUtil.getDayStr(date) + ")", "@", 5120));
        }
        List titles = Lists.newArrayList();
        titles.add("课节汇总表");
        ExcelCourseExportService.createSheet(workbook, "课节汇总", titles, cellStyleMap, summaryFields, dtoList, startDate);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write(new FileOutputStream(excelFile));
    }

    @Override
    public HeaderDto getHeaderInfo() {
        HeaderDto dto = new HeaderDto();
        Integer txCascadeAccountId = TianxiaoMContext.getTXCascadeId();
        if (txCascadeAccountId == null) {
            return dto;
        }
        OrgAccount orgAccount = orgAccountDao.getAccountById(TianxiaoMContext.getOrgId());
        if (orgAccount == null) {
            log.info("orgAccount doesn't exist! orgAccountId:{}", TianxiaoMContext.getOrgId());
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "您无权使用此功能");
        }
        TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(txCascadeAccountId);
        if (txCascadeAccount == null) {
            log.info("txCascadeAccount doesn't exist! txCascadeAccountId:{}", txCascadeAccountId);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "您无权使用此功能");
        }
        // 员工显示自己的班级
        // 主管显示机构的班级
        List<Long> courseIds = Lists.newArrayList();
        Integer notSignCount = 0;
        if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
            courseIds = orgCourseDao.getCourseIdsByCascadeId(txCascadeAccountId, null,
                CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            if (CollectionUtils.isNotEmpty(courseIds)) {
                notSignCount = orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
            }
        }
        if (txCascadeAccount.getAccountType() == CascadeType.MANAGER.getValue()) {
            notSignCount = orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
            courseIds = orgCourseDao.getCourseIds(orgAccount.getNumber().longValue(), null, null,
                CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        }
        Integer totalCount = courseIds.size();
        dto.setClassCount(totalCount);
        dto.setSignCount(notSignCount);
        return dto;
    }

    @Override
    @Transactional(readOnly = true)
    public ListLessonResponseDto queryCourseLessons(Long orgId, ListLessonsRequestDto params) {
        ListLessonResponseDto result = new ListLessonResponseDto();
        List<OrgClassLesson> lessons = new ArrayList<>();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        boolean isMaster = false;
        if(params.isTeacherLesson()){
            Integer cascadeId = TianxiaoMContext.getTXCascadeId();
            if (TianxiaoMContext.getTXCascadeId() != null) {
                TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
                if (txCascadeAccount == null) {
                    throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
                }
                if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                    Long teacherId = teacherService.getUserIdByCascadeId(orgId,TianxiaoMContext.getTXCascadeId());
                    params.setTeacherId(teacherId == null ? 0L : teacherId);
                    List<Long> masterCourseIds = orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                    if(masterCourseIds.contains(params.getCourseId())){
                        isMaster = true;
                    }
                }
            }
        }
        if (isMaster) {
            List<OrgClassLesson> masterLessons = orgClassLessonDao.queryLessons(orgId, Arrays.asList(params.getCourseId()), null, null, null, null,null,null);
            lessons = masterLessons;
        }else {
            lessons = queryLesson(orgId, lessonIdTeacherIdMap, params, true, false);
        }
        List<Long> courseIds = new ArrayList<Long>();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();

        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>() {
                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }

            Map<Long, OrgCourse> courseMap = getOrgCourseMap(orgId, courseIds);

            Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
            log.info("******** params:{},{},result:{}", orgId, lessonIds, studentCountMap);
            Map<Long, Integer> signStudentCountMap = Maps.newHashMap();
            Map<Long, Integer> signedStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = orgLessonSignDao.querySignLessonStudentCountMap(orgId, lessonIds);
                signedStudentCountMap = orgLessonSignDao.querySignedLessonStudentCountMap(orgId, lessonIds);
            }
            Map<Long, Integer> commentCount = Maps.newHashMap();
            Map<Long, Integer> lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument(params.getStudentId() != null && params.getStudentId() > 0, "学生ID不正确");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());

                // commentCount = orgLessonCommentDao.getLessonCommentCountMap(lessonIds, orgId, userId, null,
                // UserRole.STUDENT.getRole(), false);

                List<OrgLessonSign> lessonSign = orgLessonSignDao.getStudentSign(orgId, userId,
                    UserRole.STUDENT.getRole(), lessonIds, "lessonId", "status");
                if (CollectionUtils.isNotEmpty(lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap(lessonSign, new Function<OrgLessonSign, Long>() {
                        @Override
                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, new Function<OrgLessonSign, Integer>() {
                        @Override
                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", lessonSignStatus);
                }
            }

            Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
            Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
            result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap,
                studentCountMap, signStudentCountMap, signedStudentCountMap, commentCount, lessonSignStatus);

            Date now = new Date();
            int lastRow = result.getList().size() - 1;
            if (lastRow >= 0) {
                result.setNewLessonId(result.getList().get(lastRow).getLessonId());
                for (LessonResponseDto lesson : result.getList()) {
                    if (now.before(lesson.getLessonEndTime())) {
                        result.setNewLessonId(lesson.getLessonId());
                        break;
                    }
                }
            }

        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    /**
     * 课节列表查询 1.teacherId与courseId、roomId不在一张表,为了避免表查询,做如下处理 1.1:如果筛选条件有老师ID，那么在tts.org_teacher_lesson表查出这个所教的课节ID集合
     * 1.1.1:再将lessonIds作为查询条件在tts.org_class_lesson中筛选lesson 1.2:如果筛选条件没有老师ID，直接在tts.org_class_lesson查询
     * 2.org_class_lesson表有删除课程的脏数据,暂且使用notin实现//FIXME
     */
    @Override
    public List<LessonScheduleInfoDto> queryCourseLessonsByParams(Long orgId, TimeTableRequestDto params,
        PageDto pageDto) {
        Collection<Long> lessonIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(params.getTeacherIds())) {
            List<OrgTeacherLesson> teacherLessons =
                orgTeacherLessonDao.queryTeacherLessons(orgId, params.getTeacherIds(), "lessonId");
            if (CollectionUtils.isNotEmpty(teacherLessons)) {
                lessonIds = BaseUtils.getPropertiesList(teacherLessons, "lessonId");
            }
        }
        // // 如果用户在筛选条件中选择了课程,那么需要查询当前登录用户具有哪些课程的查询权限
        // // 如果用户没有设置，那么需要判断用户具有的数据访问权限，设置课程ID集合
        // if (CollectionUtils.isEmpty(params.getCourseIds())) {
        // List<Long> courseIds = getCurrentUserCoursesIds();
        // if (CollectionUtils.isNotEmpty(courseIds)) {
        // params.setCourseIds(courseIds);
        // }
        // }

        Long number = orgAccountDao.getById(orgId.intValue(), "number").getNumber().longValue();
        List<Long> delIds = // 获取机构所有删除的课程
            Lists.transform(orgCourseDao.getCoursesByOrgNumber(number, DeleteStatus.DELETED.getValue(), "id"),
                new Function<OrgCourse, Long>() {
                    @Override
                    public Long apply(OrgCourse input) {
                        return input.getId();
                    }
                });
        List<OrgClassLesson> lessons =
            this.orgClassLessonDao.getOrgClassLessonByParams(delIds, orgId, params, lessonIds, pageDto);
        List<LessonScheduleInfoDto> data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set<Long> roomIds = BaseUtils.getPropertiesList(result, "roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();
                Set<Long> courseIds = BaseUtils.getPropertiesList(result, "courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds);
                Map<Long, OrgCourse> map = Maps.newHashMap();
                for (OrgCourse course : courseList) {
                    map.put(course.getId(), course);
                }

                for (LessonResponseDto dto : result) {
                    // 如果是1v1班级,并且班级人数=0的话就不在前段展示
                    if (map.get(dto.getCourseId()).getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()
                        && dto.getStudentCount() == 0) {
                        continue;
                    }
                    // 按课程类型过滤
                    if (params.getCourseType() != null
                        && map.get(dto.getCourseId()).getCourseType() != params.getCourseType()) {
                        continue;
                    }
                    Long courseId = dto.getCourseId();

                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setRoomId(dto.getRoomId());
                    item.setLessonName(dto.getLessonName());
                    if (dto.getRoomId() == null || dto.getRoomId() <= 0) {
                        item.setRoomName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setRoomName(dto.getRoomName());

                    }

                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    if (dto.getTeacherId() == null || dto.getTeacherId() <= 0) {
                        item.setTeacherName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setTeacherName(dto.getTeacherName());

                    }

                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    if (now.before(dto.getLessonStartTime())) {
                        item.setLessonStatus(LessonStatus.UN_START.getStatus());
                    } else if (now.after(dto.getLessonEndTime())) {
                        item.setLessonStatus(LessonStatus.FINISHED.getStatus());
                    } else {
                        item.setLessonStatus(LessonStatus.ONGOING.getStatus());
                    }
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }
                    item.setCourseType(
                        dto.getCourseType() == null ? CourseTypeEnum.COURSE_TYPE_CLASS.getCode() : dto.getCourseType());

                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }
                    // 封装冲突信息
                    // wrapConflictInfo(orgId, item);
                    /*
                     * if (params.getIsConflict() == BizConf.TRUE && item.getIsConflict() == BizConf.FALSE) { continue;
                     * }
                     */

                    data.add(item);
                }
                if (CollectionUtils.isNotEmpty(data)) {
                    buildConflictInfo(orgId, params.getStartTime(), params.getEndTime(), data);
                    List<LessonScheduleInfoDto> tempList = Lists.newArrayList();
                    for (LessonScheduleInfoDto dto : data) {
                        if (params.getIsConflict() == BizConf.TRUE && dto.getIsConflict() == BizConf.FALSE) {
                            continue;
                        }
                        tempList.add(dto);
                    }
                    log.info("end buildConflictInfo orgId:{},params={},data.size={},tempList.size={}", orgId, params,
                        data.size(), tempList.size());
                    data = tempList;
                }
            }
        }
        log.info("queryCourseLessonsByCourseId.orgId:{}, params:{}, data:{}", orgId, params, data);
        return data;
    }

    private void buildConflictInfo(Long orgId, Long startTime, Long endTime,
        List<LessonScheduleInfoDto> lessonScheduleDto) {
        Set<Long> teacherIdSet = Sets.newHashSet();
        Set<Long> roomIdSet = Sets.newHashSet();

        boolean needFindTime = false;
        if (startTime == null || endTime == null) {
            needFindTime = true;
        }
        if (CollectionUtils.isEmpty(lessonScheduleDto)) {
            return;
        }
        for (LessonScheduleInfoDto dto : lessonScheduleDto) {
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0) {
                teacherIdSet.add(dto.getTeacherId());
            }
            if (dto.getRoomId() != null && dto.getRoomId() > 0) {
                roomIdSet.add(dto.getRoomId());
            }
            if (needFindTime) {
                if (startTime == null || startTime > dto.getStartTime()) {
                    startTime = dto.getStartTime();
                }

                if (endTime == null || endTime < dto.getEndTime()) {
                    endTime = dto.getEndTime();
                }
            }
        }
        Date startDate = new Date(startTime);
        Date endDate = new Date(endTime);

        Map<Long, List<OrgLessonConflict>> teacherConflictMap =
            orgLessonConflictDao.queryConfilctByTeacherIdsAndTimeRange(orgId, teacherIdSet, startDate, endDate);
        // log.info("finish query teacherConflictMap,orgId={},result={}",orgId,teacherConflictMap);
        Map<Long, List<OrgLessonConflict>> roomConflictMap =
            orgLessonConflictDao.queryConfilctByClassRoomIdsAndTimeRange(orgId, roomIdSet, startDate, endDate);
        // log.info("finish queryroomConflictMap,orgId={},result={}",roomConflictMap);
        Map<Long, Integer> lessonTeacherConflictCount = checkConflictCount(teacherConflictMap);
        log.info("finish build lessonTeacherConflictCount,orgId={},result={}", orgId, lessonTeacherConflictCount);
        Map<Long, Integer> lessonRoomConflictCount = checkConflictCount(roomConflictMap);
        log.info("finish build lessonRoomConflictCount,orgId={},result={}", orgId, lessonRoomConflictCount);

        for (LessonScheduleInfoDto dto : lessonScheduleDto) {
            LessonConflictEnum conflict = LessonConflictEnum.NO_CONFLICT;

            Integer teacherConflictNum = lessonTeacherConflictCount.get(dto.getLessonId());
            if (teacherConflictNum == null) {
                teacherConflictNum = 0;
            }
            Integer roomConflictNum = lessonRoomConflictCount.get(dto.getLessonId());
            if (roomConflictNum == null) {
                roomConflictNum = 0;
            }
            if (teacherConflictNum > 0 && roomConflictNum > 0) {
                conflict = LessonConflictEnum.TEACHER_AND_ROOM;
            } else if (teacherConflictNum > 0) {
                conflict = LessonConflictEnum.TEACHER;
            } else if (roomConflictNum > 0) {
                conflict = LessonConflictEnum.ROOM;
            }
            ConflictInfoDto conflictInfo = null;
            if (conflict != null && conflict != LessonConflictEnum.NO_CONFLICT) {
                conflictInfo = new ConflictInfoDto();
                conflictInfo.setConflictType(conflict.getCode());
                conflictInfo.setConflictTypeStr(conflict.getNote());
                dto.setIsConflict(BizConf.TRUE);
            } else {
                dto.setIsConflict(BizConf.FALSE);
            }

            dto.setConflictInfo(conflictInfo);
        }

    }

    public Map<Long, Integer> checkConflictCount(Map<Long, List<OrgLessonConflict>> conflictMap) {
        /*
         * while(list.size() >0 ){ OrgLessonConflict conflict = list.get(0); for(OrgLessonConflict temp:list ){ if(temp
         * == conflict){ continue; } if(conflict.getEndTime().getTime()>temp.getStartTime().getTime() &&
         * conflict.getStartTime().getTime() < temp.getEndTime().getTime()){ // lessonIds.add() } } }
         */

        Map<Long, Integer> conflictLessonCountMap = Maps.newHashMap();

        for (List<OrgLessonConflict> list : conflictMap.values()) {
            int size = list.size();
            for (int i = 0; i < size - 1; i++) {
                OrgLessonConflict conflict = list.get(i);

                for (int j = i + 1; j < size; j++) {
                    OrgLessonConflict temp = list.get(j);

                    if (conflict.getEndTime().getTime() > temp.getStartTime().getTime()
                        && conflict.getStartTime().getTime() < temp.getEndTime().getTime()) {

                        Integer count = conflictLessonCountMap.get(conflict.getLessonId());
                        if (count == null) {
                            count = new Integer(0);
                        }
                        count++;
                        conflictLessonCountMap.put(conflict.getLessonId(), count);

                        Integer count2 = conflictLessonCountMap.get(temp.getLessonId());
                        if (count2 == null) {
                            count2 = new Integer(0);
                        }
                        count2++;
                        conflictLessonCountMap.put(temp.getLessonId(), count2);

                    }
                }
            }
        }
        return conflictLessonCountMap;
    }

    /**
     * 获取并缓存课程已上完的课结数
     *
     * @param orgId
     * @param
     * @return
     */
    Map<Long, Integer> getAndCachedFinishedLessonCount(Long orgId, Collection<Long> courseIds) {
        Map<Long, Integer> cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(courseIds)) {
            cache = this.orgClassLessonDao.getFinishLessonCount(orgId, courseIds, DeleteStatus.NORMAL.getValue());
        }
        return cache;
    }

    /**
     * 封装课节冲突信息
     *
     * @param orgId
     * @param dto
     */
    void wrapConflictInfo(Long orgId, LessonScheduleInfoDto dto) {
        LessonConflictCheckDto lessonConflictCheckDto = new LessonConflictCheckDto();
        lessonConflictCheckDto.setEndTimeDate(new Date(dto.getEndTime()));
        lessonConflictCheckDto.setLessonId(dto.getLessonId());
        lessonConflictCheckDto.setPageNum(1);
        lessonConflictCheckDto.setPageSize(20);
        lessonConflictCheckDto.setRoomId(dto.getRoomId());
        lessonConflictCheckDto.setStartTimeDate(new Date(dto.getStartTime()));
        lessonConflictCheckDto.setTeacherId(dto.getTeacherId());
        LessonConflictEnum conflict = orgLessonConflictService.lessonConflictFlagCheck(orgId, lessonConflictCheckDto);
        ConflictInfoDto conflictInfo = null;
        if (conflict != null && conflict != LessonConflictEnum.NO_CONFLICT) {
            conflictInfo = new ConflictInfoDto();
            conflictInfo.setConflictType(conflict.getCode());
            conflictInfo.setConflictTypeStr(conflict.getNote());
            dto.setIsConflict(BizConf.TRUE);
        } else {
            dto.setIsConflict(BizConf.FALSE);
        }

        dto.setConflictInfo(conflictInfo);
    }

    /**
     * 将OrgClassLesson对象转换成需要输出的对象
     *
     * @param orgId
     * @param lessons
     * @return
     */
    private ListLessonResponseDto wrap(Long orgId, List<OrgClassLesson> lessons) {

        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<>();
        ListLessonResponseDto result = new ListLessonResponseDto();

        Collections.sort(lessons, new Comparator<OrgClassLesson>() {
            @Override
            public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            roomIds.add(lesson.getRoomId());
            lessonIds.add(lesson.getId());
        }

        Map<Long, OrgCourse> courseMap = Maps.newHashMap();
        // bugfix 这里如果校验是否需要课程名字，后面的组装对象的逻辑就无法通过判断课程是否删除来过滤无效的课节，所以注释掉，以确保程序正确
        // if (params.isNeedcourseName()) {
        courseMap = getOrgCourseMap(orgId, courseIds);
        // }
        Map<Long, String> lessonIdTeacherNameMap = Maps.newHashMap();
        lessonIdTeacherNameMap = getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
        Map<Long, OrgClassRoom> classRoomMap = Maps.newHashMap();
        classRoomMap = getOrgClassRoomMap(roomIds);
        Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
        Map<Long, Integer> signStudentCountMap = orgLessonSignDao.querySignLessonStudentCountMap(orgId, lessonIds);
        Map<Long, Integer> signedStudentCountMap = orgLessonSignDao.querySignedLessonStudentCountMap(orgId, lessonIds);

        Map<Long, Integer> commentCount = Maps.newHashMap();
        Map<Long, Integer> lessonSignStatus = Maps.newHashMap();

        result = buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap,
            signStudentCountMap, signedStudentCountMap, commentCount, lessonSignStatus);
        if (CollectionUtils.isNotEmpty(result.getList())) {
            lessonIdTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
            for (LessonResponseDto dto : result.getList()) {
                if (lessonIdTeacherIdMap.containsKey(dto.getLessonId())) {
                    dto.setTeacherId(lessonIdTeacherIdMap.get(dto.getLessonId()));
                }
            }
        }
        return result;
    }

    /**
     * 批量查询教室信息并缓存
     *
     * @param roomIds
     * @return
     */
    Map<Long, OrgClassRoom> getAndCachedClassRoom(Collection<Long> roomIds) {
        List<OrgClassRoom> rooms = this.orgClassRoomDao.getByIds(roomIds, "id", "roomName", "roomSize");
        Map<Long, OrgClassRoom> cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(rooms)) {
            cache = BaseUtils.listToMap(rooms, "id");
        }
        return cache;
    }

    @Override
    @Transactional
    public void batchOperateLesson(Long orgId, Long courseId, List<Long> lessonIds, BatchOperateType operateType,
        String targetId) {
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            if (operateType == BatchOperateType.del_lesson) {
                delLesson(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.add_student) {
                addStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.del_student) {
                delStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.change_teacher) {
                Long teacherId = Long.valueOf(targetId);
                changeTeacher(orgId, courseId, lessonIds, teacherId);
            } else if (operateType == BatchOperateType.change_classroom) {
                Long roomId = Long.valueOf(targetId);
                changeClassroom(orgId, courseId, lessonIds, roomId);
            } else if (operateType == BatchOperateType.change_time) {
                String[] time = targetId.split(",");
                String startTimeStr = time[0];
                String endTimeStr = time[1];
                changeTime(orgId, courseId, lessonIds, startTimeStr, endTimeStr);
            } else if (operateType == BatchOperateType.change_lesson_name) {
                Preconditions.checkArgument(null != targetId && targetId.length() < 21, "批量修改课节名称为空或超过20字符");
                orgClassLessonDao.batchUpdateLessonName(lessonIds, targetId);
            }
        }

    }

    private void delLesson(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {

        /*
         * Map<Long, Integer> signCountMap = orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);
         * 
         * for(Long lessonId:lessonIds){ Integer tempCount = signCountMap.get(lessonId); if(tempCount != null &&
         * tempCount>0){ throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程已签到，不能删除"); } }
         */

        List<Integer> statusList = Lists.newArrayList();

        statusList.add(SignStatus.SIGNED.getCode());
        statusList.add(SignStatus.LEAVE.getCode());
        statusList.add(SignStatus.ABSENT.getCode());

        Map<String, Object> countCondition = new HashMap<String, Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("status", statusList);

        int count = orgLessonSignDao.countByCondition(countCondition, "userId", false);
        if (count > 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "课程已签到，不能删除");
        }

        orgClassLessonDao.updateDelByLessonIds(orgId, lessonIds);
        signupCourseLessonService.deleteClassLessons(orgId, lessonIds);

        Map<String, Object> condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("delStatus", "1");
        orgStudentLessonDao.update(condition, "delStatus");

        Map<String, Object> delCondition = new HashMap<>();
        delCondition.put("lessonId", lessonIds);
        orgTeacherLessonDao.delByCondition(delCondition);

        // 冲突检测表逻辑删除
        orgLessonConflictService.delByLessonIds(orgId, lessonIds);

        resetLessonNumber(orgId, courseId);

    }

    private void addStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        OrgCourse orgCourse = orgCourseDao.getById(courseId);
        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能添加学生，请下载新版天校");
        }
        List<Long> studentIds = null;
        try {
            studentIds = JacksonUtil.str2Obj(targetId, new TypeReference<List<Long>>() {
            });
        } catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id转换异常");
        }
        // courseStudentService.addStudentsToLessons(orgId, courseId, lessonIds, userIds, false);

        if (CollectionUtils.isEmpty(studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");
            // return;
        }
        if (true) {
            Map<Long, Long> userIdMap = orgStudentDao.getStudentIdUserIdMap(studentIds);
            if (MapUtils.isEmpty(userIdMap)) {
                log.warn("add student ids is empty");
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");
                // return;
            }
            studentIds = new ArrayList<Long>(userIdMap.values());
        }

        List<Long> courseStudents = orgStudentCourseDao.getStudents(orgId, courseId, 0);
        if (!courseStudents.containsAll(studentIds)) {
            studentIds.retainAll(courseStudents);
            log.warn("lesson studeng:{} is not all course student ids:{}", studentIds, courseStudents);

            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "必须从课程学生中添加课节学生");
        }

        List<OrgClassLesson> classLessons = orgClassLessonDao.getByIds(lessonIds, "startTime", "endTime", "id");
        final Map<Long, OrgClassLesson> classLessonMap = CollectionHelper.toIdMap(classLessons);

        Map<Long, List<Long>> lessonStudentIds = orgStudentLessonDao.getLessonStudentList(lessonIds);
        List<OrgStudentLesson> delLessonStudent = orgStudentLessonDao.getLessonStudentListDelStatus(lessonIds);
        Map<String, OrgStudentLesson> lesseonStudentMap = Maps.newHashMap();
        for (OrgStudentLesson orgStudentLesson : delLessonStudent) {
            String tempKey = orgStudentLesson.getUserId() + "|" + orgStudentLesson.getLessonId();
            lesseonStudentMap.put(tempKey, orgStudentLesson);
        }
        log.info("check orgStudentLessonDao.getLessonStudentList(lessonIds):{},result={}", lessonIds, lessonStudentIds);
        List<OrgStudentLesson> saveStudentLessons = Lists.newArrayList();
        List<OrgStudentLesson> updateStudentLessons = Lists.newArrayList();
        List<OrgStudentLesson> studentLessons = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            // Map<Long, List<Long>> lessonStudentIds =
            // orgStudentLessonDao.getLessonStudentList(Lists.newArrayList(lessonId));
            // List<Long> tempStudentId = lessonStudentIds.get(lessonId);
            List<Long> tempStudentIds = new ArrayList<Long>(studentIds);
            if (lessonStudentIds.containsKey(lessonId)) {

                List<Long> addedStuIds = lessonStudentIds.get(lessonId);
                if (CollectionUtils.isNotEmpty(addedStuIds)) {
                    tempStudentIds.removeAll(addedStuIds);
                }
            }

            OrgClassLesson classLesson = classLessonMap.get(lessonId);

            int lessonDuration = DateUtil.getMinuteDiff(classLesson.getStartTime(), classLesson.getEndTime());
            OrgStudentLesson po = null;
            for (Long studentId : tempStudentIds) {
                po = new OrgStudentLesson();
                po.setCreateTime(new Date());
                po.setLessonId(lessonId);
                po.setOrgId(orgId);
                po.setUserId(studentId);
                po.setCourseId(courseId);
                po.setLessonDuration(lessonDuration);
                String tempKey = studentId + "|" + lessonId;
                if (lesseonStudentMap.containsKey(tempKey)) {
                    OrgStudentLesson tempStudentLesson = lesseonStudentMap.get(tempKey);
                    po.setId(tempStudentLesson.getId());
                    po.setDelStatus(0);
                    po.setStartStatus(0);
                    updateStudentLessons.add(po);
                } else {
                    saveStudentLessons.add(po);
                }
                studentLessons.add(po);
            }

        }
        Collections.sort(studentLessons, new Comparator<OrgStudentLesson>() {
            @Override
            public int compare(OrgStudentLesson o1, OrgStudentLesson o2) {
                OrgClassLesson lesson1 = classLessonMap.get(o1.getLessonId());
                OrgClassLesson lesson2 = classLessonMap.get(o2.getLessonId());
                return lesson1.getStartTime().compareTo(lesson2.getStartTime());
            }
        });
        if (!studentLessons.isEmpty()) {
            signupCourseLessonService.saveSignupCourseLessons(orgId, courseId, studentLessons);
        }
        log.info("save students :{} to lessonid:{}", saveStudentLessons, lessonIds);
        orgStudentLessonDao.saveAll(saveStudentLessons, "courseId", "createTime", "lessonId", "orgId", "userId",
            "lessonType", "lessonDuration", "kexiaoDuration");

        for (OrgStudentLesson updateStudentLesson : updateStudentLessons) {
            orgStudentLessonDao.update(updateStudentLesson, "delStatus", "startStatus", "courseId","lessonType","lessonDuration","kexiaoDuration");
        }
    }

    private int delStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {

        OrgCourse orgCourse = orgCourseDao.getById(courseId);
        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能删除学生，请下载新版天校");
        }

        List<Long> studentIds = null;
        try {
            studentIds = JacksonUtil.str2Obj(targetId, new TypeReference<List<Long>>() {
            });
        } catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id转换异常");
        }
        // courseStudentService.addStudentsToLessons(orgId, courseId, lessonIds, userIds, false);

        if (CollectionUtils.isEmpty(studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");

        }
        if (true) {
            Map<Long, Long> userIdMap = orgStudentDao.getStudentIdUserIdMap(studentIds);
            if (MapUtils.isEmpty(userIdMap)) {
                log.warn("add student ids is empty");
                throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生id为空");
            }
            studentIds = new ArrayList<Long>(userIdMap.values());
        }

        List<Long> courseStudents = orgStudentCourseDao.getStudents(orgId, courseId, 0);

        if (!courseStudents.containsAll(studentIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", studentIds, courseStudents);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "必须从课程学生中删除课节学生");
        }

        List<Integer> statusList = Lists.newArrayList();

        statusList.add(SignStatus.SIGNED.getCode());
        statusList.add(SignStatus.LEAVE.getCode());
        statusList.add(SignStatus.ABSENT.getCode());

        Map<String, Object> countCondition = new HashMap<String, Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("userId", studentIds);

        countCondition.put("status", statusList);
        countCondition.put("userRole", UserRoleEnum.STUDENT.getCode());
        int count = orgLessonSignDao.countByCondition(countCondition, "userId", false);

        if (count > 0) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "已经签到的学生不能删除");
        }
        if (!studentIds.isEmpty() && !lessonIds.isEmpty()) {
            signupCourseLessonService.deleteStudentLessons(orgId, studentIds, lessonIds);
        } else {
            log.info("studentIds={},lessonIds={}", studentIds, lessonIds);
        }

        return orgStudentLessonDao.delStudentFromLesson(orgId, lessonIds, studentIds);

    }

    private void changeTeacher(Long orgId, Long courseId, List<Long> lessonIds, Long teacherId) {

        // Long teacherId = Long.valueOf(targetId);

        Map<String, Object> delCondition = new HashMap<>();
        delCondition.put("lessonId", lessonIds);
        int result = orgTeacherLessonDao.delByCondition(delCondition);
        log.info("del from org teacher lesson by lessonId:{},result:{}", lessonIds, result);

        List<OrgTeacherLesson> saveLessonTeachers = Lists.newArrayList();
        OrgTeacherLesson po = null;
        for (Long lessonId : lessonIds) {
            po = new OrgTeacherLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setTeacherId(teacherId);
            saveLessonTeachers.add(po);
        }
        log.info("save teachers :{} to lessonId:{}", saveLessonTeachers, lessonIds);
        orgTeacherLessonDao.saveAll(saveLessonTeachers, "createTime", "lessonId", "orgId", "teacherId");

        List<OrgCourseTeacher> courseTeachers = orgCourseTeacherDao.getTeacher(orgId, courseId);
        Set<Long> userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }

        if (!userIds.contains(teacherId)) {
            List<Long> teacherIds = new ArrayList<Long>();
            teacherIds.add(teacherId);
            courseTeacherService.addTeacherToCourse(orgId, courseId, teacherIds);
        }

        List<OrgLessonConflict> conflictList = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setTeacherId(teacherId);
            conflictList.add(conflict);
        }
        orgLessonConflictService.updateOrgLessonConflictForTeacherChange(conflictList);

    }

    private void changeClassroom(Long orgId, Long courseId, List<Long> lessonIds, Long roomId) {
        // Long roomId = Long.valueOf(targetId);

        orgClassLessonDao.updateLessonClassRoom(orgId, lessonIds, roomId);

        List<ClassRoomDto> roomList = classRoomService.listOrgCourseRooms(orgId, courseId);
        List<Long> currentRoomIds = new ArrayList<Long>();
        for (ClassRoomDto dto : roomList) {
            currentRoomIds.add(dto.getRoomId());
        }

        if (!currentRoomIds.contains(roomId)) {
            List<Long> newCourseIds = new ArrayList<Long>();
            newCourseIds.add(roomId);
            classRoomService.addClassRoomCourse(orgId, courseId, newCourseIds);
        }

        for (Long lessonId : lessonIds) {
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setRoomId(roomId);
            orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }

    }

    private void changeTime(Long orgId, Long courseId, List<Long> lessonIds, String startTimeStr, String endTimeStr) {

        TimeStamp startTime = TimeStamp.parse(startTimeStr);
        TimeStamp endTime = TimeStamp.parse(endTimeStr);

        List<OrgClassLesson> list = orgClassLessonDao.getByIds(lessonIds);

        for (OrgClassLesson lesson : list) {

            Calendar cal = Calendar.getInstance();
            cal.setTime(lesson.getStartTime());

            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);

            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", lesson.getId());
            map.put("startTime", lessonTime.getStartTime());
            map.put("endTime", lessonTime.getEndTime());

            this.orgClassLessonDao.update(map, "startTime", "endTime");

            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lesson.getId());
            conflict.setStartTime(lessonTime.getStartTime());
            conflict.setEndTime(lessonTime.getEndTime());
            orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
            Integer duration = DateUtil.getMinuteDiff(lessonTime.getStartTime(), lessonTime.getEndTime());
            List<Long> userIds = orgStudentLessonDao.getUserIds(lesson.getId(), orgId);
            orgStudentLessonDao.batchUpdateLessonDuration(userIds, duration, lesson.getId());
            signupCourseLessonService.updateLessonDuration(orgId, lesson);
        }
        resetLessonNumber(orgId, courseId);
    }

    private void changeTime(Long orgId, Long courseId, List<Long> lessonIds, Date startTime, Date endTime) {
        List<OrgClassLesson> list = orgClassLessonDao.getByIds(lessonIds);
        for (OrgClassLesson lesson : list) {
            Map<String, Object> map = new HashMap<String, Object>();
            map.put("id", lesson.getId());
            map.put("startTime", startTime);
            map.put("endTime", endTime);

            this.orgClassLessonDao.update(map, "startTime", "endTime");

            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lesson.getId());
            conflict.setStartTime(startTime);
            conflict.setEndTime(endTime);
            orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }
        resetLessonNumber(orgId, courseId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<Long> addClassLessonsBatchForFastSignIn(Long orgId, Long courseId, List<TimeRange> timeRangeList,
        Collection<Long> studentIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");

        Long defaultTeacherId = 0L;
        // 快速签到的排课不给默认老师
        /*
         * List<TeacherResponseDto> courseTeachers = courseTeacherService.listCourseTeacher(orgId, courseId);
         * if(courseTeachers.size()>0){ defaultTeacherId = courseTeachers.get(0).getTeacherId(); }
         */
        Long defaultRoomId = 0L;

        // 快速签到的排课不给默认的教室
        /*
         * List<ClassRoomDto> courseRooms = classRoomService.listOrgCourseRooms(orgId, courseId);
         * if(courseRooms.size()>0){ defaultRoomId = courseRooms.get(0).getRoomId(); }
         */

        List<OrgClassLesson> lessons = Lists.newArrayList();
        OrgClassLesson lesson = null;
        int i = 1;
        for (TimeRange timeRange : timeRangeList) {
            lesson = new OrgClassLesson();
            lesson.setStartTime(timeRange.getStartTime());
            lesson.setEndTime(timeRange.getEndTime());
            lesson.setCourseId(courseId);
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(DataStatus.NORMAL.getValue());
            lesson.setLayoutId(0l);
            lesson.setRoomId(defaultRoomId != null ? defaultRoomId : 0L);
            lesson.setUpdateTime(new Date());
            lesson.setNumber(i++);
            lesson.setOrgId(orgId);
            lessons.add(lesson);
        }
        log.info("save {} lessons into db,params:{}", lessons.size(), "courseId=" + courseId);
        orgClassLessonDao.saveAll(lessons, "startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId",
            "roomId", "updateTime", "orgId");

        // 如果原来有课节的话,需要重新安排课节编号
        resetLessonNumber(orgId, courseId);
        List<Long> newLessonsIds = Lists.newArrayList();
        for (OrgClassLesson classLesson : lessons) {
            newLessonsIds.add(classLesson.getId());
            courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), studentIds,
                true);
            if (defaultTeacherId != null && defaultTeacherId > 0) {
                List<Long> tearcherIds = Lists.newArrayList();
                tearcherIds.add(defaultTeacherId);
                courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(),
                    tearcherIds);
            }

        }
        return newLessonsIds;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchEditLessonsForFastSignIn(FastSignInLessonsEditRequestDto dto) {
        List<Long> lessonIds = Lists.newArrayList(dto.getLessonId());
        Long orgId = dto.getOrgId();
        Long courseId = dto.getCourseId();
        Long roomId = dto.getRoomId();
        Long teacherId = dto.getTeacherId();
        String startTimeStr = dto.getStartTime();
        String endTimeStr = dto.getEndTime();
        String lessonName = dto.getLessonName();
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            if (roomId != null && roomId > 0) {
                changeClassroom(orgId, courseId, lessonIds, roomId);
            }
            if (teacherId != null && teacherId > 0) {
                changeTeacher(orgId, courseId, lessonIds, teacherId);
            }
            if (StringUtils.isNotBlank(startTimeStr) && StringUtils.isNotBlank(endTimeStr)) {
                changeTime(orgId, courseId, lessonIds, startTimeStr, endTimeStr);
            }
            if (null != dto.getLessonName()) {
                orgClassLessonDao.updateLessonName(orgId, lessonIds, lessonName);
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void batchEditLessonsForFastSignIn(List<FastSignInLessonEditRequestDto> dtos) {
        log.debug("request is :{}", dtos);
        Long orgId = TianxiaoMContext.getOrgId().longValue();
        for (FastSignInLessonEditRequestDto dto : dtos) {
            if (dto.getRoomId() != null && dto.getRoomId() > 0) {
                changeClassroom(orgId, dto.getCourseId(), Lists.newArrayList(dto.getLessonId()), dto.getRoomId());
            }
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0) {
                changeTeacher(orgId, dto.getCourseId(), Lists.newArrayList(dto.getLessonId()), dto.getTeacherId());
            }
            if (null != dto.getStartTime() && null != dto.getEndTime()) {
                changeTime(orgId, dto.getCourseId(), Lists.newArrayList(dto.getLessonId()), dto.getStartTime(),
                    dto.getEndTime());
            }
            if (null != dto.getLessonName()) {
                orgClassLessonDao.updateLessonName(orgId, Lists.newArrayList(dto.getLessonId()), dto.getLessonName());
            }
        }
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public List<LessonResponseDto> findLessonBaseInfoByLessonIds(Long orgId, Long courseId, List<Long> lessonIds) {
        List<OrgClassLesson> lessons =
            orgClassLessonDao.queryLessons(orgId, null, null, lessonIds, null, null, null, null);
        return buildLessonBaseInfoList(orgId, lessons);
    }

    @Override
    @Transactional
    public List<LessonResponseDto> buildLessonBaseInfoList(Long orgId, List<OrgClassLesson> lessons) {
        Set<Long> courseIds = Sets.newHashSet();
        Set<Long> roomIds = Sets.newHashSet();
        Set<Long> lessonIds = Sets.newHashSet();
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            lessonIds.add(lesson.getId());
            if (lesson.getRoomId() != null && lesson.getRoomId() > 0) {
                roomIds.add(lesson.getRoomId());
            }
        }
        List<OrgCourse> courseList = orgCourseDao.getByIds(courseIds, "id", "name", "courseType", "status");
        Map<Long, OrgCourse> courseMap = Maps.newHashMap();
        for (OrgCourse course : courseList) {
            courseMap.put(course.getId(), course);
        }

        Map<Long, Long> lessonTeacherIdMap = orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        Map<Long, String> teacherNameMap = teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        Map<Long, String> lessonIdTeacherNameMap = new HashMap<>(lessonTeacherIdMap.size());
        List<OrgLessonSign> signList = orgLessonSignDao.getCourseLessonSignIn(Lists.newArrayList(courseIds));
        Map<Long, Integer> studentCountMap = orgStudentLessonDao.queryLessonStudentCountMap(orgId, lessonIds);
        Map<Long, Integer> courseLessonSignInCount = orgLessonSignDao.querySignLessonStudentCountMap(orgId, lessonIds);
        Map<Long, Integer> courseLessonSignedCount =
            orgLessonSignDao.querySignedLessonStudentCountMap(orgId, lessonIds);
        log.debug("sign count. signList:{}, SignInCount:{}, SignedCount:{}", signList.size(),
            courseLessonSignInCount.size(), courseLessonSignedCount.size());
        Map<Long, Integer> lessonSignStatus = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(signList)) {
            lessonSignStatus = CollectorUtil.collectMap(signList, new Function<OrgLessonSign, Long>() {
                @Override
                public Long apply(OrgLessonSign input) {
                    return input.getLessonId();
                }
            }, new Function<OrgLessonSign, Integer>() {
                @Override
                public Integer apply(OrgLessonSign input) {
                    return input.getStatus();
                }
            });
        }

        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, teacherNameMap.get(lessonTeacherIdMap.get(lessonId)));
        }

        Map<Long, OrgClassRoom> lessonRoomMap = getOrgClassRoomMap(roomIds);

        List<LessonResponseDto> dtoList = new ArrayList<LessonResponseDto>();
        Date now = new Date();
        for (OrgClassLesson lesson : lessons) {
            LessonResponseDto dto = new H5LessonResponseDto();
            dto.setCourseId(lesson.getCourseId());
            OrgCourse course = courseMap.get(lesson.getCourseId());
            dto.setCourseName(course.getName());
            dto.setCourseType(course.getCourseType());
            dto.setLessonId(lesson.getId());
            dto.setLessonName(lesson.getName());
            dto.setIndex(lesson.getNumber());
            Long roomId = lesson.getRoomId();

            Integer signCount = courseLessonSignInCount.get(lesson.getId());
            Integer inClassCount = courseLessonSignedCount.get(lesson.getId());
            Integer studentCount = studentCountMap.get(lesson.getId());
            dto.setTotalSignCount(signCount != null ? signCount : 0);
            dto.setSignCount(inClassCount != null ? inClassCount : 0);
            dto.setStudentCount(studentCount != null ? studentCount : 0);

            CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
            if (now.after(lesson.getEndTime())) {
                // 设置课程结束标记
                signStatus = CourseSignStatus.NO_SIGN;
                dto.setIsOver(1);
            }
            if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
            SignStatus stuSignStatus = SignStatus.getSignStatusByCode(lessonSignStatus.get(lesson.getId()));
            if (stuSignStatus != null) {
                dto.setSignStatusEnum(stuSignStatus);
            } else {
                if (signCount != null && signCount > 0) {
                    signStatus = CourseSignStatus.SIGNED;
                }
                dto.setCourseSignStatusEnum(signStatus);
            }

            OrgClassRoom classRoom = lessonRoomMap.get(roomId);
            if (classRoom != null) {
                dto.setRoomId(roomId);
                dto.setRoomName(classRoom.getRoomName());
            }
            Long teacherId = lessonTeacherIdMap.get(lesson.getId());
            if (teacherId != null && teacherId > 0) {
                dto.setTeacherId(teacherId);
                dto.setTeacherName(teacherNameMap.get(teacherId) == null ? "" : teacherNameMap.get(teacherId));
            }
            dto.setLessonStartTime(lesson.getStartTime());
            dto.setLessonEndTime(lesson.getEndTime());
            dtoList.add(dto);
        }

        return dtoList;

    }

    @Override
    @Transactional(readOnly = true)
    public LessonConflictCheckListDto lessonConflictCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto) {

        PageDto pageDto = new PageDto();
        pageDto.setPageNum(lessonConflictCheckDto.getPageNum());
        pageDto.setPageSize(lessonConflictCheckDto.getPageSize());

        LessonConflictCheckListDto lessonConflictCheckListDto = new LessonConflictCheckListDto();
        Long teacherId = lessonConflictCheckDto.getTeacherId();
        Long roomId = lessonConflictCheckDto.getRoomId();
        Date startTime = lessonConflictCheckDto.getStartTimeDate();
        Date endTime = lessonConflictCheckDto.getEndTimeDate();
        Long lessonId = lessonConflictCheckDto.getLessonId();

        if (teacherId != null && teacherId > 0) {
            List<OrgLessonConflict> teacherConflictList =
                orgLessonConflictService.checkTeacherConflict(orgId, teacherId, startTime, endTime, lessonId, pageDto);

            if (CollectionUtils.isNotEmpty(teacherConflictList)) {
                int num =
                    orgLessonConflictService.queryTeacherConflictNum(orgId, teacherId, startTime, endTime, lessonId);
                try {
                    PageDto tpageDto = (PageDto) BeanUtils.cloneBean(pageDto);
                    tpageDto.setCount(num);
                    lessonConflictCheckListDto.setTeacherConflictPageDto(tpageDto);
                } catch (Exception e) {
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
                lessonConflictCheckListDto.setTeacherConflictData(change(teacherConflictList));

            }
        }

        if (roomId != null && roomId > 0) {
            List<OrgLessonConflict> roomConflictList =
                orgLessonConflictService.checkRoomConflict(orgId, roomId, startTime, endTime, lessonId, pageDto);

            if (CollectionUtils.isNotEmpty(roomConflictList)) {
                int num = orgLessonConflictService.queryRoomConflictNum(orgId, roomId, startTime, endTime, lessonId);
                try {
                    PageDto rpageDto = (PageDto) BeanUtils.cloneBean(pageDto);
                    rpageDto.setCount(num);
                    lessonConflictCheckListDto.setRoomConflictPageDto(rpageDto);
                } catch (Exception e) {
                    throw new BussinessException(CommonErrorCode.SYSTEM_ERROR);
                }
                lessonConflictCheckListDto.setRoomConflictData(change(roomConflictList));
            }
        }

        return lessonConflictCheckListDto;
    }

    @Override
    public void flushConflictData() {
        log.info("flushConflictData start load mysql data!!!!!!!!!!!!!!!!!!!!");
        List<OrgLessonConflict> list = orgClassLessonDao.getflushConflictData();
        log.info("flushConflictData load mysql data finished!!!!!!!!!!!!!!!!!!!!");
        // 打印最后的lessonId
        Collections.sort(list, new Comparator<OrgLessonConflict>() {
            @Override
            public int compare(OrgLessonConflict o1, OrgLessonConflict o2) {
                if (o1.getLessonId() < o2.getLessonId()) {
                    return -1;
                } else if (o1.getLessonId() > o2.getLessonId()) {
                    return 1;
                }
                return 0;
            }
        });
        log.info("flushConflictData start lessonId :" + list.get(0).getLessonId() + " , end lessonId:"
            + list.get(list.size() - 1).getLessonId());
        if (CollectionUtils.isNotEmpty(list)) {
            Set<Long> courseIds = BaseUtils.getPropertiesList(list, "courseId");
            int i = 0, index = 0;

            List<OrgCourse> courseList = Lists.newArrayList();
            Set<Long> querySet = null;
            for (Long cid : courseIds) {
                if (i == 0) {
                    querySet = Sets.newHashSet();
                }
                querySet.add(cid);
                i++;
                index++;
                if (i == 10000 || index == courseIds.size()) {
                    List<OrgCourse> queryCourseList = orgCourseDao.getByIds(querySet);
                    courseList.addAll(queryCourseList);
                    i = 0;
                }
            }
            ConcurrentMap<Long, OrgCourse> courseMap = Maps.newConcurrentMap();
            if (CollectionUtils.isNotEmpty(courseList)) {
                for (OrgCourse course : courseList) {
                    if (course.getIsDel() == DataStatus.NORMAL.getValue()) {
                        courseMap.putIfAbsent(course.getId(), course);
                    }
                }
                courseList = null;
                Iterator<OrgLessonConflict> it = list.iterator();
                while (it.hasNext()) {
                    OrgLessonConflict conflict = it.next();
                    if (!courseMap.containsKey(conflict.getCourseId())) {
                        it.remove();
                    }
                }
                courseMap = null;
                if (CollectionUtils.isNotEmpty(list)) {
                    log.info("flushConflictData start insert mysql!!!!!!!!!!!!!!!!!!!!");
                    orgLessonConflictService.saveOrgLessonConflicts(list);
                    log.info("flushConflictData insert mysql finished!!!!!!!!!!!!!!!!!!!!");
                }
            }
        }
        list = null;
    }

    @Override
    @Transactional(readOnly = true)
    public List<LessonResponseDto> findLessonBaseInfoByTimeRange(Long orgId, Date startDate, Date endDate,
        PageDto pageDto) {
        Long number = orgAccountDao.getById(orgId.intValue(), "number").getNumber().longValue();
        List<Long> delIds = // 获取机构所有删除的课程
            Lists.transform(orgCourseDao.getCoursesByOrgNumber(number, DeleteStatus.DELETED.getValue(), "id"),
                new Function<OrgCourse, Long>() {
                    @Override
                    public Long apply(OrgCourse input) {
                        return input.getId();
                    }
                });
        Integer cascadeId = TianxiaoMContext.getTXCascadeId();
        List<OrgClassLesson> lessons = new ArrayList<>();
        if(cascadeId!=null && cascadeId>0){
            lessons = listStaffClassLessons(orgId,cascadeId,delIds, startDate,endDate,pageDto);
            if(lessons.isEmpty()){
                return Lists.newArrayList();
            }
        }else {
            lessons = orgClassLessonDao.queryLessons(delIds, orgId, null, startDate, endDate, pageDto, true);
        }
        return buildLessonBaseInfoList(orgId, lessons);
    }

    @Override
    @Transactional(readOnly = true)
    public List<OrgClassLesson> listStaffClassLessons(Long orgId,Integer cascadeId,List<Long> delIds,Date startTime,Date endTime,PageDto pageDto) {
        TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(cascadeId);
        if (txCascadeAccount == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "子帐号不存在");
        }
        List<OrgClassLesson> lessons = new ArrayList<>();
        List<Long> courseIds = null;
        log.info("Param:orgId={},cascadeId={},delIds={}",orgId,cascadeId,delIds);
        if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
            courseIds = orgCourseDao.getCourseIdsByCascadeId(cascadeId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            if (CollectionUtils.isNotEmpty(courseIds)) {
                courseIds.removeAll(delIds);
                List<OrgClassLesson> masterLessons = orgClassLessonDao.queryLessons(delIds, orgId, courseIds, startTime, endTime, null, true);
                lessons.addAll(masterLessons);//添加作为班主任的课节
            }
            Long teacherId = teacherService.getUserIdByCascadeId(orgId, TianxiaoMContext.getTXCascadeId());
            List<OrgClassLesson> teacherLessons = new ArrayList<>();
            if (teacherId != null && teacherId > 0) {
                teacherLessons = orgClassLessonDao.listTeacherLessons(teacherId, startTime, endTime);

            }
            Set<Long> lessonIds = new HashSet<>();
            for (OrgClassLesson lesson : lessons) {
                lessonIds.add(lesson.getId());
            }

            for (OrgClassLesson lesson : teacherLessons) {
                if (!lessonIds.contains(lesson.getId()) && !delIds.contains(lesson.getCourseId())) {
                    lessons.add(lesson);
                }
            }

            Collections.sort(lessons, new Comparator<OrgClassLesson>() {
                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getStartTime().compareTo(o2.getStartTime());
                }
            });
            if (pageDto != null) {
                pageDto.setCount(lessons.size());
                int from = Math.min((pageDto.getPageNum() - 1) * pageDto.getPageSize(), lessons.size());
                int to = Math.min(pageDto.getPageNum() * pageDto.getPageSize(), lessons.size());
                lessons = lessons.subList(from, to);
            }
        }else {
            lessons = orgClassLessonDao.queryLessons(delIds, orgId, null, startTime, endTime, pageDto, true);
        }
        return lessons;
    }

    private List<LessonConflictInfoDto> change(List<OrgLessonConflict> source) {
        List<LessonConflictInfoDto> dest = Lists.newArrayList();
        for (OrgLessonConflict conflict : source) {
            LessonConflictInfoDto info = new LessonConflictInfoDto();
            info.setLessonId(conflict.getLessonId());
            OrgClassLesson lesson = orgClassLessonDao.getById(conflict.getLessonId());
            info.setIndex(lesson.getNumber());
            info.setLessonEndTime(lesson.getEndTime().getTime());
            info.setLessonStartTime(lesson.getStartTime().getTime());
            OrgCourse course = orgCourseDao.getById(lesson.getCourseId());
            info.setCourseName(course.getName());
            dest.add(info);
        }
        return dest;
    }

    @Override
    public List<NameAndIdDto> getLessonCalendarQueryDropDownList(Long orgId, DropDownListRequestDto params) {
        List<NameAndIdDto> result = Lists.newArrayList();
        if (params.getReqType() == DropdownListType.TEACHER.getType()) {
            List<OrgClassLesson> lessons =
                this.orgClassLessonDao.getOrgClassLessonByParams(null, orgId, params.getParams(), null, null);
            if (CollectionUtils.isNotEmpty(lessons)) {
                Set<Long> lessonIds = BaseUtils.getPropertiesList(lessons, "id");
                List<OrgTeacherLesson> lessonTeachers = orgTeacherLessonDao.queryByLessonIds(orgId, lessonIds);
                if (CollectionUtils.isNotEmpty(lessonTeachers)) {
                    Set<Long> teacherIds = BaseUtils.getPropertiesList(lessonTeachers, "teacherId");
                    List<Teacher> teachers =
                        teacherDao.fuzzyQueryByNameAndMobile(orgId, teacherIds, params.getSearch());
                    result = collectTeacherInfo(teachers);
                }
            }
        } else if (params.getReqType() == DropdownListType.ROOM.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set<Long> roomIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                roomIds = BaseUtils.getPropertiesList(lessons, "roomId");
            }
            result = this.collectRoomInfo(orgId, roomIds, params.getSearch());
        } else if (params.getReqType() == DropdownListType.COURSE.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set<Long> courseIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                courseIds = BaseUtils.getPropertiesList(lessons, "courseId");
            }
            OrgAccount orgAccount = orgAccountDao.getById(TianxiaoPCContext.getOrgId());
            result = collectCourseInfo(orgAccount.getNumber(), params.getSearch(), courseIds);
        }
        return result;
    }

    /**
     * 查询课节集合
     *
     * @param orgId
     * @param params
     * @return
     */
    private List<OrgClassLesson> getOrgLessonByParams(Long orgId, TimeTableRequestDto params) {
        List<OrgClassLesson> lessons = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(params.getTeacherIds())) {
            List<OrgTeacherLesson> teachers =
                this.orgTeacherLessonDao.queryTeacherLessons(orgId, params.getTeacherIds(), "lessonId");
            if (CollectionUtils.isNotEmpty(teachers)) {
                Set<Long> lessonIds = BaseUtils.getPropertiesList(teachers, "lessonId");
                lessons = this.orgClassLessonDao.getOrgClassLessonByParams(null, orgId, params, lessonIds, null);
            }
        }
        return lessons;
    }

    /**
     * 查询老师id和名称集合
     *
     * @param teachers
     * @return
     */
    @SuppressWarnings("unchecked")
    private List<NameAndIdDto> collectTeacherInfo(List<Teacher> teachers) {
        List<NameAndIdDto> idAndNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(teachers)) {
            idAndNames = (List<NameAndIdDto>) CollectionUtils.collect(teachers, new Transformer() {

                @Override
                public Object transform(Object input) {
                    NameAndIdDto idAndName = new NameAndIdDto();
                    Teacher teacher = (Teacher) input;
                    idAndName.setId(teacher.getUserId());
                    idAndName.setName(teacher.getRealName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    /**
     * 查询课程id和名称集合
     *
     * @param courseIds
     * @return
     */
    @SuppressWarnings("unchecked")
    private List<NameAndIdDto> collectCourseInfo(Integer orgNumber, String query, Collection<Long> courseIds) {
        List<NameAndIdDto> idAndNames = Lists.newArrayList();
        List<OrgCourse> courses = this.orgCourseDao.fuzzyQuery(orgNumber, query, courseIds, null);
        if (CollectionUtils.isNotEmpty(courses)) {
            idAndNames = (List<NameAndIdDto>) CollectionUtils.collect(courses, new Transformer() {

                @Override
                public Object transform(Object input) {
                    OrgCourse course = (OrgCourse) input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(course.getId());
                    idAndName.setName(course.getName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    /**
     * 查询教室名称和ID集合
     *
     * @param roomIds
     * @return
     */
    @SuppressWarnings("unchecked")
    private List<NameAndIdDto> collectRoomInfo(Long orgId, Collection<Long> roomIds, String query) {
        List<NameAndIdDto> idAndNames = Lists.newArrayList();
        List<OrgClassRoom> rooms = this.orgClassRoomDao.getOrgClassRoomByNameAndIds(orgId, roomIds, query);
        if (CollectionUtils.isNotEmpty(rooms)) {
            idAndNames = (List<NameAndIdDto>) CollectionUtils.collect(rooms, new Transformer() {

                @Override
                public Object transform(Object input) {
                    OrgClassRoom room = (OrgClassRoom) input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(room.getId());
                    idAndName.setName(room.getRoomName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    /**
     * 课节详情
     *
     * @param orgId
     * @param lessonId
     */
    @Override
    public LessonScheduleInfoDto lessonDetail(Long orgId, Long lessonId) {
        OrgClassLesson lesson = orgClassLessonDao.getById(lessonId);
        // LessonBaseInfoDto result = null;
        // if (lesson != null) {
        // result = wrap(orgId, lesson);
        // }
        if (lesson == null) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课节不存在或已被删除");
        }
        if (lesson.getDelStatus() == 1) {
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "课节不存在或已被删除");
        }
        List<OrgClassLesson> lessons = Lists.newArrayList(lesson);
        List<LessonScheduleInfoDto> data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set<Long> roomIds = BaseUtils.getPropertiesList(result, "roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();

                Set<Long> courseIds = BaseUtils.getPropertiesList(result, "courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                // 删除了的教室
                List<Long> recycleClassRoomIds = orgClassRoomDao.getRecycleRoomId(orgId, roomIds);
                log.debug("[all class room id]=", roomIds);
                log.debug("[deleted class room id]=", recycleClassRoomIds);
                for (LessonResponseDto dto : result) {
                    Long courseId = dto.getCourseId();
                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setLessonName(dto.getLessonName());
                    if (recycleClassRoomIds.contains(dto.getRoomId())) {
                        if (DateUtil.compare(lesson.getStartTime(), new Date())) {
                            item.setRoomId(dto.getRoomId());
                            item.setRoomName(dto.getRoomName());
                        } else {
                            item.setRoomId(null);
                            item.setRoomName(null);
                        }
                    } else {
                        item.setRoomId(dto.getRoomId());
                        item.setRoomName(dto.getRoomName());
                    }
                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    item.setTeacherName(dto.getTeacherName());
                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    item.setCourseType(dto.getCourseType() == null ? 0 : dto.getCourseType());
                    item.setLessonStatus(now.before(dto.getLessonStartTime()) ? LessonStatus.UN_START.getStatus()
                        : (now.before(dto.getLessonEndTime()) ? LessonStatus.ONGOING.getStatus()
                            : LessonStatus.FINISHED.getStatus()));
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }

                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }

                    OrgCourse course = orgCourseDao.getById(courseId);
                    if (course.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                        List<Long> scount = orgStudentCourseDao.getStudents(orgId, courseId, 0);
                        item.setStudentStatus(
                            CollectionUtils.isEmpty(scount) ? StudentStatus.YES.getCode() : StudentStatus.NO.getCode());
                    }

                    // 封装冲突信息
                    wrapConflictInfo(orgId, item);
                    data.add(item);
                }
                return data.get(0);
            }
        }
        return null;
    }

    LessonBaseInfoDto wrap(Long orgId, OrgClassLesson lesson) {
        Long lessonId = lesson.getId();
        LessonBaseInfoDto result = new LessonBaseInfoDto();
        Long courseId = lesson.getCourseId();
        Long roomId = lesson.getRoomId();
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);

        getAndSetCourseInfo(courseId, result);
        getAndSetRoomInfo(roomId, result);
        result.setEndTime(lesson.getEndTime().getTime());
        result.setEndTimeStr(BaseUtils.getFormatTime(lesson.getEndTime(), "HH:mm"));
        result.setLessonId(lessonId);
        result.setStartTime(lesson.getStartTime().getTime());
        result.setStartTimeStr(BaseUtils.getFormatTime(lesson.getStartTime(), "HH:mm"));
        result.setTeacherId(teacherLesson.getTeacherId());
        result.setTeacherName(teacherLesson.getTeacherName());
        result.setDayOfWeek(DateUtil.getWeekDay(lesson.getStartTime()));
        result.setDuration(calculateDuration(lesson.getStartTime(), lesson.getEndTime()));
        result.setTime(getLessonStartTime(lesson.getStartTime()));

        return result;
    }

    String getLessonStartTime(Date date) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("M月d日");
        String time = sdf.format(date);
        String weekDay = DateUtil.getChineseWeekDay(date);
        sb.append(time).append(" ").append("星期").append(weekDay);
        return sb.toString();
    }

    /**
     * 计算课程时长:大于60分钟小时为单位,反之以分钟为单位
     *
     * @param startTime
     * @param endTime
     * @return
     */
    String calculateDuration(Date startTime, Date endTime) {
        long interval = (endTime.getTime() - startTime.getTime()) / (1000 * 60);
        String duration = "";
        if (interval > 60) {
            BigDecimal bg1 = new BigDecimal(interval);
            BigDecimal bg2 = new BigDecimal(interval);
            duration = bg1.divide(bg2, 1, RoundingMode.HALF_DOWN).toString() + "小时";
        } else {
            duration = interval + "分钟";
        }
        return duration;
    }

    /**
     * 获取课程ID和名称信息
     *
     * @param courseId
     * @return
     */
    void getAndSetCourseInfo(Long courseId, LessonBaseInfoDto result) {
        OrgCourse course = this.orgCourseDao.getById(courseId, "id", "name");
        if (course != null) {
            result.setCourseId(course.getId());
            result.setCourseName(course.getName());
        }
    }

    /**
     * 获取教室名称和ID信息
     *
     * @param roomId
     * @param result
     */
    void getAndSetRoomInfo(Long roomId, LessonBaseInfoDto result) {
        OrgClassRoom room = this.orgClassRoomDao.getById(roomId, "id", "roomName");
        if (room != null) {
            result.setRoomName(room.getRoomName());
            result.setRoomId(room.getId());
        }
    }

    @Override
    public List<DayScheduleDto> getExportSchedule(Long orgId, TimeTableRequestDto params) {
        List<DayScheduleDto> data = DayScheduleDto.getWeekList(params.getStartTime());
        List<LessonScheduleInfoDto> lessonScheduleList = this.queryCourseLessonsByParams(orgId, params, null);
        if (CollectionUtils.isNotEmpty(lessonScheduleList)) {
            for (LessonScheduleInfoDto lessonInfo : lessonScheduleList) {
                LessonScheduleDto lessonDto = new LessonScheduleDto();
                lessonDto.setCourseId(lessonInfo.getCourseId());
                lessonDto.setLessonId(lessonInfo.getLessonId());
                lessonDto.setStart(lessonInfo.getStartTime());
                lessonDto.setEnd(lessonInfo.getEndTime());

                lessonDto.setCourseName(lessonInfo.getCourseName(), lessonInfo.getCourseType());
                lessonDto.setTeacherName(lessonInfo.getTeacherName());
                lessonDto.setTimeRange(lessonInfo.getStartTime(), lessonInfo.getEndTime());
                lessonDto.setClassRoom(lessonInfo.getRoomName());
                lessonDto.setStudentCount(lessonInfo.getStudentCount());

                Integer weekDay = DateUtil.getWeekDay(new Date(lessonInfo.getStartTime()));
                int index = (weekDay == 0 ? 7 : weekDay);
                DayScheduleDto dayScheduleDto = data.get(index - 1);
                dayScheduleDto.getLessons().add(lessonDto);
            }
            // 同一天的课表按照起始时间排序,起始时间相同按照结束时间排序
            for (DayScheduleDto daySchedule : data) {
                List<LessonScheduleDto> lessons = daySchedule.getLessons();
                if (CollectionUtils.isNotEmpty(lessons)) {
                    daySchedule.setLessonCount(lessons.size());
                    Collections.sort(lessons, new Comparator<LessonScheduleDto>() {
                        @Override
                        // long转为int只能用于差值,最大相差49天
                        public int compare(LessonScheduleDto o1, LessonScheduleDto o2) {
                            int startDiff = new Long(o1.getStart() - o2.getStart()).intValue();
                            if (startDiff < 0 || startDiff > 0) {
                                return startDiff;
                            } else {
                                int endDiff = new Long(o1.getEnd() - o2.getEnd()).intValue();
                                return endDiff;
                            }
                        }
                    });
                }
            }
        }
        return data;
    }

    @Override
    public void exportSchedule(HttpServletRequest request, HttpServletResponse response, Long orgId,
        TimeTableRequestDto params) {
        List<DayScheduleDto> data = this.getExportSchedule(orgId, params);
        String fileName = data.get(0).getDate() + "~" + data.get(data.size() - 1).getDate() + "课表.xlsx";
        SXSSFWorkbook workbook = null;
        try {
            workbook = new SXSSFWorkbook(200);
            HashMap cellStyleMap = new HashMap();

            List<ExportField> exportFields = Lists.newArrayList();
            for (DayScheduleDto dayScheduleDto : data) {
                exportFields.add(new ExportField(dayScheduleDto.getHeader(), "@", 5500));
            }
            ExcelCourseExportService.createScheduleSheet(workbook, "课表", cellStyleMap, exportFields, data);
            ExcelCourseExportService.exportExcel(request, response, workbook, fileName);
            log.debug("course lesson export success");
        } catch (Exception e) {
            log.error("export catch exception:", e);
            throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "导出数据处理异常");
        } finally {
            try {
                workbook.close();
            } catch (IOException var19) {
                log.error("close workbook catch error:", var19);
            }
        }
    }
}