
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.response;

import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;
import org.apache.commons.beanutils.BeanUtils;

import java.lang.reflect.InvocationTargetException;
import java.util.Date;

/**
 * @title H5LessonResponseDto
 * @desc TODO
 * @author cxm
 * @date 2016年1月4日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class H5LessonResponseDto extends LessonResponseDto {

    private String lessonStartTimeStr;

    private String lessonEndTimeStr;

    private String date;

    private Integer weekDay;

    /**
     * 评价学生数
     */
    private Integer commentStudent;

    @Override
    public void setLessonStartTime(Date lessonStartTime) {
        super.setLessonStartTime(lessonStartTime);
        String format = DateUtil.getStrByDateFormate(lessonStartTime, "yyyy-MM-dd HH:mm");
        String[] formats = format.split(" ");
        this.lessonStartTimeStr = formats[1];
        this.date = formats[0];
        this.weekDay = DateUtil.getWeekDay(lessonStartTime);
    }

    @Override
    public void setLessonEndTime(Date lessonEndTime) {
        super.setLessonEndTime(lessonEndTime);
        this.lessonEndTimeStr = DateUtil.getStrByDateFormate(lessonEndTime, "HH:mm");
    }

    public static H5LessonResponseDto convert(LessonResponseDto dto) {
        H5LessonResponseDto result = new H5LessonResponseDto();
        try {
            BeanUtils.copyProperties(result, dto);
        } catch (IllegalAccessException | InvocationTargetException e) {
            e.printStackTrace();
        }
        result.setLessonStartTime(dto.getLessonStartTime());
        result.setLessonEndTime(dto.getLessonEndTime());
        return result;
    }
}
