
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @title SignStatus
 * @desc TODO
 * @author cxm
 * @date 2015年12月29日
 * @version 1.0
 */
public enum StudentStatus {

    NO(0, "未退班"),

    YES(1, "已退班");

    private int code;

    private String note;

    private static Map<Integer, StudentStatus> map;

    private StudentStatus(int code, String note) {
        this.code = code;
        this.note = note;
    }

    static {
        map = new HashMap<>();
        for (StudentStatus sign : StudentStatus.values()) {
            map.put(sign.code, sign);
        }
    }

    public int getCode() {
        return this.code;
    }

    public String getNote() {
        return this.note;
    }

    public StudentStatus getSignByCode(Integer code) {
        return map.get(code);
    }
}
