package com.baijia.tianxiao.biz.erp.assignment.impl;

import com.baijia.tianxiao.biz.erp.assignment.AssignmentService;
import com.baijia.tianxiao.biz.erp.dto.AssignmentClassInfoDto;
import com.baijia.tianxiao.biz.erp.dto.AssignmentClassStudentDto;
import com.baijia.tianxiao.biz.erp.dto.AssignmentStudentDto;
import com.baijia.tianxiao.biz.erp.dto.AssignmentStudentInfoDto;
import com.baijia.tianxiao.biz.erp.dto.UserInfoDto;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Collections;
import java.util.List;
import java.util.Map;

/**
 * Created by hanlaijin on 17/3/13.
 */
@Service
@Slf4j
public class AssignmentServiceImpl implements AssignmentService {

    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentApiService orgStudentApiService;
    @Resource
    private StringRedisTemplate redisTemplate;

    @Override
    public List<AssignmentClassInfoDto> getClassInfos(Long orgId, Long cascadeId, Integer userRole, String classIds, String className) {
        log.debug("[getClassInfos] orgId={},cascadeId={},userRole={},classIds={}", orgId, cascadeId, userRole, classIds);
        OrgAccount org = orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (org == null) {
            throw new IllegalArgumentException("机构id不正确");
        }
        List<Long> classIdList = getClassIds(classIds);
        List<OrgCourse> courses = orgCourseDao.getCourseList(org.getNumber().longValue(), classIdList, className, null, null, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null, null);
        return AssignmentClassInfoDto.bulidClassInfos(courses);
    }

    private List<Long> getClassIds(String classIds) {
        if (StringUtils.isEmpty(classIds)) {
            return null;
        }
        List<Long> result = Lists.newArrayList();
        for (String s : classIds.split(",")) {
            result.add(Long.parseLong(s));
        }
        return result;
    }

    @Override
    public List<AssignmentStudentInfoDto> getStudentInfos(Long orgId, Long cascadeId, Integer userRole, String studentIds, Long classId) {
        log.debug("[getStudentInfos] orgId={},cascadeId={},userRole={},studentIds={},classId={}", orgId, cascadeId, userRole, studentIds, classId);
        Preconditions.checkArgument(orgId != null && orgId > 0, "机构id不正确");
        List<Long> userIds = getUserIds(orgId, studentIds, classId);
        log.debug("userIds={}", userIds);
        if (CollectionUtils.isEmpty(userIds)) {
            return Collections.EMPTY_LIST;
        }
        List<OrgStudent> students = orgStudentDao.getStudentByUserIds(orgId, userIds);
        Map<Long, String> studentAvatarUrlMap = orgStudentApiService.batchGetStudentAvatarUrl(students);
        return bulidStudentInfos(students, studentAvatarUrlMap);
    }

    private List<Long> getUserIds(Long orgId, String studentIds, Long classId) {
        List<Long> userIds = Lists.newArrayList();
        if (StringUtils.isNotEmpty(studentIds)) {
            String[] ids = studentIds.split(",");
            for (String id : ids) {
                userIds.add(Long.parseLong(id));
            }
        }
        if (classId != null) {
            userIds = orgStudentCourseDao.getStudents(orgId, classId,StudentCourseStatus.NORMAL.getCode());
        }
        return userIds;
    }

    private List<AssignmentStudentInfoDto> bulidStudentInfos(List<OrgStudent> students, Map<Long, String> studentAvatarUrlMap) {
        List<AssignmentStudentInfoDto> result = Lists.newArrayList();
        for (OrgStudent student : students) {
            AssignmentStudentInfoDto dto = new AssignmentStudentInfoDto();
            dto.setId(student.getId());
            dto.setName(student.getName());
            String url = studentAvatarUrlMap.get(student.getId());
            dto.setHeadUrl(url);
            dto.setWechatOpenId(student.getWeixin());
            dto.setMobile(student.getMobile());
            result.add(dto);
        }
        return result;
    }

    @Override
    public List<AssignmentClassStudentDto> getClassStudent(Long orgId) {
        OrgAccount org = orgAccountDao.getAccountById(orgId.intValue(), "number");
        if (org == null) {
            throw new IllegalArgumentException("机构id不正确");
        }
        List<OrgCourse> courses = orgCourseDao.getCoursesByCascadeIds(org.getNumber().longValue(), null, null, null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        if (CollectionUtils.isEmpty(courses)) {
            return Collections.EMPTY_LIST;
        }
        List<Long> courseIds = getAllClassId(courses);
        Map<Long, List<OrgStudentCourse>> classStudentMap = orgStudentCourseDao.getStudentMapBycourseIds(courseIds, StudentCourseStatus.NORMAL.getCode());
        return buildClassStudent(courses, classStudentMap);
    }

    private List<Long> getAllClassId(List<OrgCourse> courses) {
        List<Long> ids = Lists.newArrayList();
        for (OrgCourse c : courses) {
            ids.add(c.getId());
        }
        return ids;
    }

    private List<AssignmentClassStudentDto> buildClassStudent(List<OrgCourse> courses, Map<Long, List<OrgStudentCourse>> classStudentMap) {
        List<AssignmentClassStudentDto> list = Lists.newArrayList();
        for (OrgCourse c : courses) {
            AssignmentClassStudentDto dto = new AssignmentClassStudentDto();
            dto.setId(c.getId());
            dto.setName(c.getName());
            List<OrgStudentCourse> students = classStudentMap.get(c.getId());
            if (CollectionUtils.isNotEmpty(students)) {
                dto.setCount(students.size());
                for (OrgStudentCourse s : students) {
                    AssignmentStudentDto student = new AssignmentStudentDto();
                    student.setId(s.getId());
                    student.setName(s.getStudentName());
                    dto.getStudents().add(student);
                }
            } else {
                dto.setCount(0);
            }
        }
        return list;
    }

    @Override
    public UserInfoDto getChangedStudent(UserInfoDto dto) {
        log.debug("-------------------------[key]={}",dto);
        int count = 0;
        OrgStudent student = orgStudentDao.getById(dto.getUserId());
        Map<Long, String> studentAvatarUrlMap = orgStudentApiService.batchGetStudentAvatarUrl(Lists.newArrayList(student));
        String head = studentAvatarUrlMap.get(student.getId());
        if(!student.getMobile().equals(dto.getUserMobile())){
            dto.setUserMobile(student.getMobile());
            count++;
        }
        if(!head.equals(dto.getHeadUrl()) ){
            dto.setHeadUrl(head);
            count++;
        }
        if(!student.getName().equals(dto.getUserName())){
            dto.setUserName(student.getName());
            count++;
        }
        if(count==0){
            return null;
        }else {
            return dto;
        }
    }
}
