
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2016 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.util;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.time.StopWatch;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.web.multipart.MultipartFile;

import com.baijia.tianxiao.biz.erp.vo.ImportCourse;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.course.service.impl.ImportOrgCourseProcessServiceImpl.CourseFormat;
import com.baijia.tianxiao.sal.upload.service.UploadFileReaderService;
import com.baijia.tianxiao.sal.upload.service.impl.ExcelUploadFileReaderServiceImpl;
import com.baijia.tianxiao.util.ExcelUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.Data;
import lombok.extern.slf4j.Slf4j;

/**
 * @title ErpUploadFileUtil
 * @desc O(∩_∩)O~
 * @author caoliang
 * @date 2016年7月5日
 * @version 1.0
 */
@Slf4j
public class ErpUploadFileUtil {

    public final static Map<String, CourseFormat> colMap = Maps.newHashMap();
    public final static Map<String, StudentFormat> studentMap = Maps.newHashMap();
    public final static Map<String, CourseFormat> _1V1CourseMap = Maps.newHashMap();
    public final static Map<String, StudentFormat> _1V1StudentMap = Maps.newHashMap();
    public final static Map<String, CourseFormat> courseByTimesMap = Maps.newHashMap();
    
    public final static Map<Integer, String> courseFieldMap = Maps.newHashMap();
    public final static Map<Integer, String> studentFieldMap = Maps.newHashMap();
    public final static Map<Integer, String> _1V1CourseFieldMap = Maps.newHashMap();
    public final static Map<Integer, String> _1V1StudentFieldMap = Maps.newHashMap();
    public final static Map<Integer, String> courseByTimesFiledMap = Maps.newHashMap();

    @Data
    public static class StudentFormat {

        private String fieldName;
        private String formatRegex;
        private String formatMsg;

        public StudentFormat(String fieldName, String formatRegex, String formatMsg) {
            this.fieldName = fieldName;
            this.formatRegex = formatRegex;
            this.formatMsg = formatMsg;
        }

        String getFmtErrorMsg() {
            return formatMsg;
        }
    }

    static {
        colMap.put("课程名称", new CourseFormat("courseName", ".{1,20}", "【班课课程名称】不能为空，最多输入20个字符"));
        colMap.put("课程总价", new CourseFormat("coursePrice", "^(?!0(\\d|\\.0+$|$))\\d+(\\.\\d{1,2})?$", "【课程总价】需为大于0的数字，小数点后最多两位"));
        colMap.put("上课次数", new CourseFormat("freq", "^[1-9]\\d*$", "【上课次数】需为大于零整数"));
        colMap.put("上课人数", new CourseFormat("maxStudent", "^[1-9]\\d*$", "【上课人数】需为大于零整数"));

        studentMap.put("学员姓名", new StudentFormat("studentName", "^[a-zA-Z0-9\u4e00-\u9fa5]{1,30}$", "【学员姓名】不能为空，最多输入30个字符，仅支持数字、汉字和字母"));
        studentMap.put("学员手机", new StudentFormat("studentMobile", "^(\\+?86\\-?)?1\\d{2}\\-?\\d{4}\\-?\\d{4}$", "【学员手机】不能为空，并且需为以1开头的11位数字，不能包含特殊字符和空格"));
        studentMap.put("班课课程名称", new StudentFormat("courseName", ".{1,20}", "【班课课程名称】不能为空，最多输入20个字符"));
        studentMap.put("剩余总课次（小时）", new StudentFormat("lessonCount", "^[0-9]*[1-9][0-9]*$|(\\s&&[^\\f\\n\\r\\t\\v])*$", "【剩余总课次（小时）】需为大于零整数"));
        studentMap.put("剩余总课次（分钟）", new StudentFormat("lessonCountExtra", "^[0-9]*[1-9][0-9]*$|(\\s&&[^\\f\\n\\r\\t\\v])*$", "【剩余总课次（分钟）】需为大于零整数"));
        studentMap.put("从第几个课次插班", new StudentFormat("insertCount", "^[0-9]*[1-9][0-9]*$|(\\s&&[^\\f\\n\\r\\t\\v])*$", "【从第几个课次插班】需为大于零整数"));
        studentMap.put("剩余总学费", new StudentFormat("payPrice", "^0\\.00|0\\.0|0|(?!0+(?:\\.0+)?$)(?:[1-9]\\d*|0)(?:\\.\\d{1,2})?|0|0.0|0.00$", "【剩余总学费】需为大于零的两位小数"));
        
        _1V1CourseMap.put("1对1课程名称", new CourseFormat("courseName", ".{1,20}", "【1对1课程名称】不能为空，最多输入20个字符"));
        _1V1CourseMap.put("计费单位", new CourseFormat("chargeUnit", "小时|次", "【计费单位】不能为空，输入需为模板指定项"));
        _1V1CourseMap.put("课时单价", new CourseFormat("coursePrice", "^(?!0(\\d|\\.0+$|$))\\d+(\\.\\d{1,2})?$", "【课时单价】需为大于0的数字，小数点后最多两位"));
        
        _1V1StudentMap.put("学员姓名", new StudentFormat("studentName", "^[a-zA-Z0-9\u4e00-\u9fa5]{1,30}$", "【学员姓名】不能为空，最多输入30个字符，仅支持数字、汉字和字母"));
        _1V1StudentMap.put("学员手机", new StudentFormat("studentMobile", "^(\\+?86\\-?)?1\\d{2}\\-?\\d{4}\\-?\\d{4}$", "【学员手机】不能为空，并且需为以1开头的11位数字，不能包含特殊字符和空格"));
        _1V1StudentMap.put("1对1课程名称", new StudentFormat("courseName", ".{1,20}", "【1对1课程名称】不能为空，最多输入20个字符"));
        _1V1StudentMap.put("剩余总课次/时（小时）", new StudentFormat("lessonCount", "^[0-9]*[1-9][0-9]*$|(\\s&&[^\\f\\n\\r\\t\\v])*$", "【剩余总课次（小时）】需为大于零整数"));
        _1V1StudentMap.put("剩余总课次/时（分钟）", new StudentFormat("lessonCountExtra", "^[0-9]*[1-9][0-9]*$|(\\s&&[^\\f\\n\\r\\t\\v])*$", "【剩余总课次（分钟）】需为大于零整数"));
        _1V1StudentMap.put("剩余总学费", new StudentFormat("payPrice", "^0\\.00|0\\.0|0|(?!0+(?:\\.0+)?$)(?:[1-9]\\d*|0)(?:\\.\\d{1,2})?$", "【剩余总学费】需为大于零的两位小数"));
        
        courseByTimesMap.put("课程名称", new CourseFormat("courseName", ".{1,20}", "【课程名称】不能为空，最多输入20个字符"));
        courseByTimesMap.put("计费单位", new CourseFormat("chargeUnit", "小时|次", "【计费单位】不能为空，输入需为模板指定项"));
        courseByTimesMap.put("课时单价", new CourseFormat("coursePrice", "^(?!0(\\d|\\.0+$|$))\\d+(\\.\\d{1,2})?$", "【课时单价】不能为空，需为大于零的数字，小数点后最多两位"));
        
        
        
        
        courseFieldMap.put(0, "courseName");
        courseFieldMap.put(1, "coursePrice");
        courseFieldMap.put(2, "freq");
        courseFieldMap.put(3, "maxStudent");
        courseFieldMap.put(4, "errReason");

        studentFieldMap.put(0, "studentName");
        studentFieldMap.put(1, "studentMobile");
        studentFieldMap.put(2, "courseName");
        studentFieldMap.put(3, "lessonCount");
        studentFieldMap.put(4, "lessonCountExtra");
        studentFieldMap.put(5, "payPrice");
        studentFieldMap.put(6, "insertCount");
        studentFieldMap.put(7, "errReason");
        
        _1V1CourseFieldMap.put(0, "courseName");
        _1V1CourseFieldMap.put(1, "chargeUnit");
        _1V1CourseFieldMap.put(2, "coursePrice");
        _1V1CourseFieldMap.put(3, "errReason");
        
        _1V1StudentFieldMap.put(0, "studentName");
        _1V1StudentFieldMap.put(1, "studentMobile");
        _1V1StudentFieldMap.put(2, "courseName");
        _1V1StudentFieldMap.put(3, "lessonCount");
        _1V1StudentFieldMap.put(4, "lessonCountExtra");
        _1V1StudentFieldMap.put(5, "payPrice");
        _1V1StudentFieldMap.put(6, "errReason");
        

        courseByTimesFiledMap.put(0, "courseName");
        courseByTimesFiledMap.put(1, "chargeUnit");
        courseByTimesFiledMap.put(2, "coursePrice");
        courseByTimesFiledMap.put(3, "errReason");
        
        
    }

    public static UploadFileReaderService getUploadFileService(MultipartFile file) {
        UploadFileReaderService service = null;
        String fileName = file.getOriginalFilename();
        if (fileName.toLowerCase().endsWith(".xlsx")) {
            service = new ExcelUploadFileReaderServiceImpl(file);
        } else {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, fileName + "只支持模板文件导入");
        }
        return service;
    }

    public static List<String> getTemplateHeader(String fileName) {
        List<String> templateHeader = Lists.newArrayList();
        XSSFWorkbook xssfWorkbook = null;
        try {
            File file = new File(ErpUploadFileUtil.class.getClassLoader().getResource(fileName).getFile());
            xssfWorkbook = new XSSFWorkbook(file);
            XSSFSheet xssfSheet = xssfWorkbook.getSheetAt(1);
            XSSFRow xssfRow = xssfSheet.getRow(1);
            for (int i = xssfRow.getFirstCellNum(); i < xssfRow.getLastCellNum(); i++) {
                XSSFCell cell = xssfRow.getCell(i);
                templateHeader.add(cell.getStringCellValue());
            }
        } catch (Exception e) {
            log.error("getTemplateHeader", e);
        } finally {
            if (xssfWorkbook != null) {
                try {
                    xssfWorkbook.close();
                } catch (IOException e) {
                    log.error("close xssfWorkbook error!", e);
                }
            }
        }
        return templateHeader;
    }

    public static List<String> tranHeader(Object[] headerObjs) {
        Preconditions.checkArgument(ArrayUtils.isNotEmpty(headerObjs), "头信息为空");
        List<String> headers = Lists.newArrayList();
        for (Object obj : headerObjs) {
            if (obj != null) {
                headers.add(obj.toString());
            } else {
                headers.add("-");
            }
        }
        return headers;

    }

    public static XSSFWorkbook generateCourseExcel(XSSFWorkbook workbook, List<ImportCourse> data,
        boolean needBackColor,String targetFileName, Map<Integer, String> fieldMap) throws InvalidFormatException, IOException, IllegalAccessException,
            InvocationTargetException, NoSuchMethodException {
        if (workbook == null) {
            File file = new File(ErpUploadFileUtil.class.getClassLoader().getResource(targetFileName).getPath());
            workbook = new XSSFWorkbook(file);
        }
        XSSFSheet sheet = workbook.getSheetAt(1);
        if (CollectionUtils.isEmpty(data)) {
            return workbook;
        }
        XSSFCellStyle style = null;
        if (needBackColor) {
            style = ExcelUtils.getYellowBGStyle(workbook);
        } else {
            style = ExcelUtils.getWhitewBGStyle(workbook);
        }
        ExcelUtils.fillCellStyleWithFullBorder(style, CellStyle.BORDER_THIN, IndexedColors.GREY_25_PERCENT.getIndex());
        int currentRow = sheet.getLastRowNum() + 1;
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        for (int i = 0; i < data.size(); i++) {
            ImportCourse importCourse = data.get(i);
            XSSFRow row = sheet.getRow(currentRow);
            if (row == null) {
                row = sheet.createRow(currentRow);
            }
            for (int j = 0; j < fieldMap.size(); j++) {
                XSSFCell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                cell.setCellStyle(style);
                cell.setCellValue(BeanUtils.getProperty(importCourse, fieldMap.get(j)));
            }
            currentRow++;
        }
        stopwatch.stop();
        log.debug("export course stopwatch time:{}", stopwatch.getTime());
        return workbook;
    }

    public static XSSFWorkbook generateStudentExcel(XSSFWorkbook workbook, List<ImportStudent> data,
        boolean needBackColor, String targetFileName, Map<Integer, String> fieldMap) throws InvalidFormatException, IOException, IllegalAccessException,
            InvocationTargetException, NoSuchMethodException {
        if (workbook == null) {
            File file = new File(ErpUploadFileUtil.class.getClassLoader().getResource(targetFileName).getPath());
            workbook = new XSSFWorkbook(file);
        }
        XSSFSheet sheet = workbook.getSheetAt(1);
        if (CollectionUtils.isEmpty(data)) {
            return workbook;
        }
        XSSFCellStyle style = null;
        if (needBackColor) {
            style = ExcelUtils.getYellowBGStyle(workbook);
        } else {
            style = ExcelUtils.getWhitewBGStyle(workbook);
        }
        ExcelUtils.fillCellStyleWithFullBorder(style, CellStyle.BORDER_THIN, IndexedColors.GREY_25_PERCENT.getIndex());
        int currentRow = sheet.getLastRowNum() + 1;
        StopWatch stopwatch = new StopWatch();
        stopwatch.start();
        for (int i = 0; i < data.size(); i++) {
            ImportStudent importStudent = data.get(i);
            XSSFRow row = sheet.getRow(currentRow);
            if (row == null) {
                row = sheet.createRow(currentRow);
            }
            for (int j = 0; j < fieldMap.size(); j++) {
                XSSFCell cell = row.getCell(j);
                if (cell == null) {
                    cell = row.createCell(j);
                }
                cell.setCellStyle(style);
                cell.setCellValue(BeanUtils.getProperty(importStudent, fieldMap.get(j)));
            }
            currentRow++;
        }
        stopwatch.stop();
        log.debug("export student stopwatch time:{}", stopwatch.getTime());
        return workbook;
    }

    public static void main(String[] args) throws InvalidFormatException, IOException {
        String reg = "^[a-zA-Z0-9\u4e00-\u9fa5]{1,30}$";
        System.out.println(Pattern.matches(reg, "aa啊("));
    }
}
