package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.constant.StudentFiannceOpType;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxStudentFinanceAccount;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.CoursePurchaseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.po.CoursePurchase;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.signup.constant.TransferClassOrder;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.course.service.OrgSignupCourseService;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.sal.organization.finance.service.OrgFinanceAccountService;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.signup.service.TxStudentFinanceAccountService;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * 7天自动取消没有收费的报名记录
 */
@Service("syncCancelSignupService")
@Slf4j
public class SyncCancelSignupServiceImpl implements SyncPayService {

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupCourseService orgSignupCourseService;

    @Resource
    private SignupService signupService;

    @Resource
    private OrgStudentDao orgStudentDao;


    @Resource
    private TxStudentFinanceAccountService txStudentFinanceAccountService;

    @Override
    public void sync() {

        Date last7Day = DateUtil.getDayDiff(-7);
        List<OrgSignupInfo> signupInfos =
                orgSignupInfoDao.getNeedCannelPurchases(TransferClassOrder.NORMAL_ORDER, last7Day);

        log.info("SyncCancelSignupServiceImpl: signupInfos=={} success", signupInfos);

        if (CollectionUtils.isNotEmpty(signupInfos)) {
            for (OrgSignupInfo orgSignupInfo : signupInfos) {

                signupService.cancelSignupInfo(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo.getOrgId());

                if (orgSignupInfo.getStudentPayPrice() != null && orgSignupInfo.getStudentPayPrice().longValue() > 0) {

                    OrgStudent orgStudent = orgStudentDao.getStudentByUserId(orgSignupInfo.getOrgId(), orgSignupInfo.getUserId());
                    if (orgStudent == null) {
                        log.error("SyncCancelSignupServiceImpl  not find student =={}", orgSignupInfo);
                    }

                    String opInfo = orgSignupCourseService.getSignupCourseName(orgSignupInfo.getOrgId(), orgSignupInfo.getSignupPurchaseId());

                    txStudentFinanceAccountService.changeStudentFiannceAccount(orgSignupInfo.getOrgId(), -1, orgStudent.getId(), StudentFiannceOpType.PAY_CANCEL, orgSignupInfo.getStudentPayPrice(), opInfo, "");
                }
            }
        }
    }

}