/**
 * Baijiahulian.com Inc. Copyright (c) 2015-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.service.PersonalCenterService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.org.po.OrgInfo;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgTeacher;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.dao.UnifiedWechatAccountDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.dal.wechat.po.UnifiedWechatAccount;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.dto.smstoken.TeacherSmsTokenDto;
import com.baijia.tianxiao.sal.common.utils.OrgInfoCampare;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.organization.dto.OrgSelectionDto;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;

import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class PersonalCenterServiceImpl implements PersonalCenterService {

    @Autowired(required = false)
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;
    @Autowired
    private UnifiedWechatAccountDao unifiedWechatAccountDao;
    @Autowired
    private OrgStudentDao orgStudentDao;
    @Autowired
    private OrgTeacherDao orgTeacherDao;

    @Override
    public void fillStudentCenterInfoDto(StudentCenterInfoDto dto, String sms_token) throws Exception {
        if (dto == null || StringUtils.isBlank(sms_token)) {
            log.error("wrong param dto:{},wechatAppId:{}", dto, sms_token);
            return;
        }
        StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr(sms_token);
        Long orgId = token.getOrgId();
        String wechatAppId = token.getWechatAppId();
        String openId = token.getOpenId();

        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
        String websiteFmt = "%si/%s";
        websiteFmt = String.format(websiteFmt, WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());

        dto.setWebsite(websiteFmt);
        dto.setOrgId(orgId);

        if (wechatAppId != null && freeVersionService.isFreeAccount(wechatAppId.toString())) {
            dto.setFromFV(Flag.TRUE.getInt());
            dto.setImsite(WechatWebAuthLinkBuilder.imSite(WebAuthScope.BASE, wechatAppId.toString(), sms_token));

            List<OrgWechatOpenIdRecord> records =
                orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.STUDENT);

            if (CollectionUtils.isNotEmpty(records)) {
                List<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
                OrgSelectionDto orgSelectionDto = null;
                Map<Long, Integer> counterMap = new HashMap<Long, Integer>();

                for (OrgWechatOpenIdRecord record : records) {
                    if (counterMap.get(record.getOrgId().longValue()) != null) {
                        continue;
                    } else {
                        counterMap.put(record.getOrgId().longValue(), Flag.TRUE.getInt());
                        if (authorizationInfoDao.getByOrgId(record.getOrgId().intValue()) != null) {
                            continue;
                        }
                    }
                    orgSelectionDto = new OrgSelectionDto();
                    OrgBaseInfoDto orgInfo = orgInfoDao.getBaseInfo(record.getOrgId().intValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setOrgId(orgInfo.getOrgId().longValue());
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE,
                        record.getAuthorizerAppId(), record.getOrgId()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
            }
        } else {
            List<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
            // 处理统一公众号校区
            List<UnifiedWechatAccount> listAllCampusWithAnyOneOrgInfo =
                this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(orgId, true);
            if (GenericsUtils.notNullAndEmpty(listAllCampusWithAnyOneOrgInfo)) {
                List<Long> fieldList = GenericsUtils.toFieldList(listAllCampusWithAnyOneOrgInfo, "orgId");
                List<Integer> orgIds = Lists.newArrayListWithExpectedSize(fieldList.size());
                for (Long orgId_ : fieldList) {
                    orgIds.add(orgId_.intValue());
                }
                List<OrgStudent> students = this.orgStudentDao.findStudentWithOrgAndOpenId(orgIds, openId);
                Map<Long, OrgStudent> orgStudentMapper = Maps.newHashMap();
                if (GenericsUtils.notNullAndEmpty(students)) {
                    Map<Long, OrgStudent> mapperTmp = GenericsUtils.toFieldMap(students, "orgId");
                    orgStudentMapper.putAll(mapperTmp);
                }
                Map<Integer, OrgInfo> orgInfoMap = this.orgInfoDao.getOrgInfoMap(orgIds);
                List<OrgInfo> orgInfos = new ArrayList<>(orgInfoMap.values());
                Collections.sort(orgInfos, new Comparator<OrgInfo>() {
                    @Override
                    public int compare(OrgInfo o1, OrgInfo o2) {
                        return OrgInfoCampare.compareUsePinyin(o1.getShortName(), o2.getShortName());
                    }
                });
                for (OrgInfo orgInfo : orgInfos) {
                    Integer orgId_ = orgInfo.getOrgId();
                    OrgStudent orgStudent = orgStudentMapper.get(orgId_.longValue());
                    if (orgStudent == null) {
                        log.info("campus :{} has not contain the student with openId :{} ", orgId_, openId);
                        continue;
                    }
                    OrgSelectionDto orgSelectionDto = new OrgSelectionDto();
                    orgSelectionDto.setOrgId(orgInfo.getOrgId().longValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.studentCenter(WebAuthScope.BASE, wechatAppId,
                        orgInfo.getOrgId().longValue()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
                // TODO :是否可以同FE同学沟通下,将免费版的类型设置为2,废掉fromFV字段
                dto.setFromType(1);
            }
        }

    }

    @Override
    public void fillTeacherCenterInfoDto(TeacherResponseDto dto, String sms_token) throws Exception {
        if (dto == null || StringUtils.isBlank(sms_token)) {
            log.error("wrong param dto:{},wechatAppId:{}", dto, sms_token);
            return;
        }
        TeacherSmsTokenDto token = TeacherSmsTokenDto.fromTokenStr(sms_token);
        Long orgId = token.getOrgId();
        String wechatAppId = token.getWechatAppId();
        String openId = token.getOpenId();

        OrgAccount orgAccount = orgAccountDao.getAccountById(orgId.intValue());
        String websiteFmt = "%si/%s";
        websiteFmt = String.format(websiteFmt, WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());

        dto.setWebsite(websiteFmt);
        dto.setOrgId(orgId);

        if (wechatAppId != null && freeVersionService.isFreeAccount(wechatAppId.toString())) {
            dto.setFromFV(Flag.TRUE.getInt());
            // dto.setImsite( WechatWebAuthLinkBuilder.imSite(WebAuthScope.BASE, wechatAppId.toString(), sms_token));

            List<OrgWechatOpenIdRecord> records =
                orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.TEACHER);
            if (CollectionUtils.isNotEmpty(records)) {
                List<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
                OrgSelectionDto orgSelectionDto = null;
                Map<Long, Integer> counterMap = new HashMap<Long, Integer>();

                for (OrgWechatOpenIdRecord record : records) {
                    if (counterMap.get(record.getOrgId().longValue()) != null) {
                        continue;
                    } else {
                        counterMap.put(record.getOrgId().longValue(), Flag.TRUE.getInt());
                        if (authorizationInfoDao.getByOrgId(record.getOrgId().intValue()) != null) {
                            continue;
                        }
                    }

                    orgSelectionDto = new OrgSelectionDto();
                    OrgBaseInfoDto orgInfo = orgInfoDao.getBaseInfo(record.getOrgId().intValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setOrgId(orgInfo.getOrgId().longValue());
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE,
                        record.getAuthorizerAppId(), record.getOrgId()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
            }
        } else {
            List<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
            // 处理统一公众号校区
            List<UnifiedWechatAccount> listAllCampusWithAnyOneOrgInfo =
                this.unifiedWechatAccountDao.listAllCampusWithAnyOneOrgInfo(orgId, true);
            if (GenericsUtils.notNullAndEmpty(listAllCampusWithAnyOneOrgInfo)) {
                List<Long> fieldList = GenericsUtils.toFieldList(listAllCampusWithAnyOneOrgInfo, "orgId");
                List<Integer> orgIds = Lists.newArrayListWithExpectedSize(fieldList.size());
                for (Long orgId_ : fieldList) {
                    orgIds.add(orgId_.intValue());
                }
                List<OrgTeacher> orgTeachers = this.orgTeacherDao.findStudentWithOrgAndOpenId(orgIds, openId);
                log.info("orgTeachers are : {} ", orgTeachers);
                Map<Long, OrgTeacher> orgTeacherMapper = Maps.newHashMap();
                if (GenericsUtils.notNullAndEmpty(orgTeachers)) {
                    Map<Long, OrgTeacher> mapperTmp = GenericsUtils.toFieldMap(orgTeachers, "orgId");
                    orgTeacherMapper.putAll(mapperTmp);
                }
                log.info("orgTeacherMapper is :{} ", orgTeacherMapper);
                Map<Integer, OrgInfo> orgInfoMap = this.orgInfoDao.getOrgInfoMap(orgIds);
                List<OrgInfo> orgInfos = new ArrayList<>(orgInfoMap.values());
                Collections.sort(orgInfos, new Comparator<OrgInfo>() {
                    @Override
                    public int compare(OrgInfo o1, OrgInfo o2) {
                        return OrgInfoCampare.compareUsePinyin(o1.getShortName(), o2.getShortName());
                    }
                });
                for (OrgInfo orgInfo : orgInfos) {
                    Integer orgId_ = orgInfo.getOrgId();
                    OrgTeacher orgTeacher = orgTeacherMapper.get(orgId_.longValue());
                    log.info("find orgStudent is :{} ", orgTeacher);
                    if (orgTeacher == null) {
                        log.info("campus :{} has not contain the student with openId :{} ", orgId_, openId);
                        continue;
                    }
                    OrgSelectionDto orgSelectionDto = new OrgSelectionDto();
                    orgSelectionDto.setOrgId(orgInfo.getOrgId().longValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.teacherCenter(WebAuthScope.BASE, wechatAppId,
                        orgInfo.getOrgId().longValue()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
                // TODO :是否可以同FE同学沟通下,将免费版的类型设置为2,废掉fromFV字段
                dto.setFromType(1);
            }
        }

    }

    public static void main(String[] args) {
        String n1 = "1234";
        String n2 = "分校区";

        String pn1 = HanZiPinYinUtils.trans2PinYin(n1);
        String pn2 = HanZiPinYinUtils.trans2PinYin(n2);
        pn1 = pn1.toLowerCase();
        pn2 = pn2.toLowerCase();
        System.out.print("pn1:" + pn1 + " ,pn2 :" + pn2 + " is : " + pn1.compareTo(pn2));
    }

}
