package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.dal.constant.ChargeUnit;
import com.baijia.tianxiao.dal.course.dao.TeacherCourseDao;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.*;
import com.baijia.tianxiao.dal.org.po.*;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupCourseDao;
import com.baijia.tianxiao.dal.solr.dto.StudentDto;
import com.baijia.tianxiao.dal.solr.enums.StudentLessonStatus;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.common.api.OrgStudentApiService;
import com.baijia.tianxiao.sal.common.api.StudentKexiaoStatisticsApiService;
import com.baijia.tianxiao.sal.common.dto.KexiaoStatisticsSuper;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.util.StudentNameUtil;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sal.teacher.api.OrgTeacherService;
import com.baijia.tianxiao.sal.teacher.api.TeacherService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.GenericsUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.ListUtil;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

@Slf4j
@Service
public class ErpStudentServiceImpl implements ErpStudentService {

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private SignupService signupService;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private CourseStudentService courseStudentService;

    @Resource
    private OrgStudentService orgStudentService;

    @Resource
    private OrgLessonSignService orgLessonSignService;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Resource
    private StudentDao studentDao;

    @Resource
    private StorageDao storageDao;

    @Resource
    private OrgLessonSignDao orgLessonSignDao;

    @Resource
    private OrgAccountDao orgAccountDao;

    @Resource
    private OrgStudentApiService studentApiService;

    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;

    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Resource
    private OrgSignupCourseDao orgSignupCourseDao;

    @Resource
    private StudentKexiaoStatisticsApiService studentKexiaoStatisticsApiService;

    @Resource
    private OrgTeacherService teacherService;

    @Resource
    private TeacherCourseDao teacherCourseDao;

    @Resource
    private OrgClassLessonDao orgClassLessonDao;

    @Override
    public StudentInfoListReponseDto getStudentListWithAttendanceRate(StudentListRequestDto studentListRequestDto,
        Long orgId, PageDto pageDto) {
        boolean needFilter = false;
        List<Long> tempcourseIds = null;
        List<Long> tempstudentIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                tempcourseIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null,
                    CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);

                Long teacherId = teacherService.getUserIdByCascadeId(orgId, TianxiaoMContext.getTXCascadeId());

                if (teacherId != null && teacherId > 0) {
                    List<Long> courseIds = orgClassLessonDao.listCourseIdByTeacherId(teacherId);
                    if(courseIds!=null && courseIds.size()>0){
                        tempcourseIds.addAll(courseIds);
                    }
                }

                tempstudentIds = orgStudentService.getStudentidsByCourseIds(orgId, tempcourseIds);
                if (CollectionUtils.isEmpty(tempstudentIds)) {
                    return new StudentInfoListReponseDto();
                }
                needFilter = true;
            }
        }
        log.debug("tempcourseIds={}", tempcourseIds);
        log.debug("tempstudentIds={}", tempstudentIds);

        StudentInfoListReponseDto studentInfoListReponseDto = null;
        if (needFilter) {
            studentInfoListReponseDto =
                orgStudentService.getStudentList(studentListRequestDto, tempstudentIds, orgId, pageDto);
        } else {
            studentInfoListReponseDto = orgStudentService.getStudentList(studentListRequestDto, orgId, pageDto);
        }

        log.debug("studentInfoListReponseDto={}", studentInfoListReponseDto);
        List<Long> studentIds = Lists.newArrayList();
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            studentIds.add(stu.getStudentId());
        }
        Map<Long, Double> map = orgLessonSignService.getAttendanceRateOfStudents(orgId, studentIds);
        log.debug("map={}", map);
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            Double rate = map.get(stu.getStudentId());
            stu.setAttendanceRate(rate == null ? 0.00 : rate);
        }
        return studentInfoListReponseDto;
    }

    /**
     * 添加学生到课程
     * 
     * @param orgId
     * @param courseId
     * @param studentIds
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addOrgCourseStudent(Long orgId, Long courseId, Collection<Long> studentIds, Collection<Header> headers,
        boolean doSignup) {
        if (CollectionUtils.isEmpty(studentIds)) {
            log.info("studentIds is empty");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生ID为空");
        }

        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId);

        if (orgCourse == null) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "班级不存在");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "1对1课程不能添加学生");
        }
        List<OrgStudent> orgStudents = this.orgStudentDao.getStudentByIds(orgId, studentIds);

        for (OrgStudent orgStudent : orgStudents) {

            OrgStudentCourse osc = orgStudentCourseDao.getStudentCourse(orgId, courseId, orgStudent.getUserId());

            if (osc == null) {
                OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
                buildOrgStudentCourse(orgStudentCourse, orgStudent, courseId);
                orgStudentCourse.setStatus(StudentCourseStatus.NORMAL.getCode());
                this.orgStudentCourseDao.save(orgStudentCourse);
                if (doSignup) {
                    signUp(orgId, orgCourse, orgStudent.getId());
                }
            } else {
                osc.setStatus(StudentCourseStatus.NORMAL.getCode());
                this.orgStudentCourseDao.update(osc, "status");
                if (doSignup) {
                    signUp(orgId, orgCourse, orgStudent.getId());
                }
            }
        }
    }

    /**
     * 添加到课程的学生报名
     * 
     * @param orgId
     * @param orgCourse
     * @param studentId
     */
    private void signUp(Long orgId, OrgCourse orgCourse, Long studentId) {
        List<SignupCourseInfoDto> courseInfos = Lists.newArrayList();
        FillCourseInfoRequestDto signUpDto = new FillCourseInfoRequestDto();
        SignupCourseInfoDto courseInfo = new SignupCourseInfoDto();
        courseInfo.setCount(1);
        courseInfo.setDiscount(100);
        courseInfo.setOrgCourseName(orgCourse.getName());
        courseInfo.setOrgCourseId(orgCourse.getId());
        courseInfo.setOrgCourseNumber(orgCourse.getNumber());
        courseInfo.setOriginPrice(orgCourse.getPrice());
        courseInfo.setPayPrice(orgCourse.getPrice());
        courseInfo.setPreferential(0);
        courseInfos.add(courseInfo);
        signUpDto.setCourseInfos(courseInfos);
        signUpDto.setOrgId(orgId);
        signUpDto.setSignupType(SignupType.FRONTED.getCode());
        OrgStudent student = this.orgStudentDao.getById(studentId);
        if (student != null && student.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
            signUpDto.setStudentMobile(student.getMobile());
            signUpDto.setStudentName(StudentNameUtil.buildStudentName(student));
            log.debug("signUpDto = {}", signUpDto);
            signupService.signUp(signUpDto);
        } else {
            log.warn("student = null, orgId = {}, studentId = {}", orgId, studentId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "studentId = " + studentId + " not found!");
        }
    }

    private void buildOrgStudentCourse(OrgStudentCourse orgStudentCourse, OrgStudent ttsStudent,
        @NonNull Long courseId) {
        orgStudentCourse.setCourseId(courseId);
        orgStudentCourse.setRealCourseId(courseId);
        orgStudentCourse.setOrgId(ttsStudent.getOrgId());
        orgStudentCourse.setUserId(ttsStudent.getUserId());
        orgStudentCourse.setStudentMobile(MaskUtil.maskMobile(ttsStudent.getMobile()));
        if (StringUtils.isEmpty(ttsStudent.getName())) {
            orgStudentCourse.setStudentName(StringUtils.EMPTY);
        } else {
            orgStudentCourse.setStudentName(ttsStudent.getName());
        }
        orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
        orgStudentCourse.setRealCourseId(courseId);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void transferOrgCourseStudent(@NonNull Long orgId, @NonNull Long studentId, @NonNull Long fromCourseId,
        @NonNull Long toCourseId, String cause, @NonNull Collection<Header> headers) {

        // 从班级退出
        courseStudentService.transferOrgCourseStudent(orgId, studentId, fromCourseId, toCourseId, cause);
        // 转入到班级
        List<Long> studentIds = Lists.newArrayList();
        studentIds.add(studentId);
        // 被转入学生不添加报名
        addOrgCourseStudent(orgId, toCourseId, studentIds, headers, false);
    }

    @Override
    @Transactional(readOnly = true)
    public List<PersonBaseDto> searchOrgStudents(Long orgId, Integer studentStatus, Long courseNumber, String searchKey,
        PageDto page) throws Exception {
        Preconditions.checkArgument(orgId != null, "orgId can not be null");
        OrgAccount account = this.orgAccountDao.getById(orgId);
        if (account == null) {
            throw new BussinessException(StudentErrorCode.ORG_NOT_EXIST);
        }

        // 根据学员的状态进行筛选操作
        StudentListRequestDto studentListRequestDto = new StudentListRequestDto();
        studentListRequestDto.setStudentStatus(studentStatus);
        studentListRequestDto.setSearchKey(searchKey);
        studentListRequestDto.setNeedClassInfo(false);
        List<StudentDto> searchStudentList =
            this.orgStudentService.searchStudentList(studentListRequestDto, orgId, page);
        log.info("searchStudentList is:{} ", searchStudentList);

        Map<Long, Integer> studentStatusMap = Maps.newHashMap();
        Map<Long, KexiaoStatisticsSuper> KexiaoStatisticsSupers = Maps.newHashMap();

        List<OrgStudent> students = Lists.newArrayList();
        for (StudentDto sd : searchStudentList) {
            OrgStudent os = new OrgStudent();
            os.setId(sd.getStudentId());
            os.setWeixin(sd.getWeixin());
            os.setUserId(sd.getUserId());
            os.setAvatar(sd.getAvatar());
            os.setLessonStatus(sd.getStuLessonStatus());
            os.setName(sd.getName());
            os.setMobile(sd.getMobile());
            studentStatusMap.put(sd.getUserId(), 0);
            students.add(os);
        }

        OrgCourse byCourseNumber = null;
        if (GenericsUtils.notNullAndEmpty(searchStudentList) && courseNumber != null) {
            List<Long> userIds = ListUtil.toKeyList(searchStudentList, "userId", StudentDto.class);
            byCourseNumber = this.orgCourseDao.getByCourseNumber(courseNumber, "id", "chargeUnit");
            Long courseId = byCourseNumber.getId();
            List<KexiaoStatisticsSuper> kexiaoSupers = Lists.newArrayList();
            for (Long userId : userIds) {
                KexiaoStatisticsSuper kss = KexiaoStatisticsSuper.newInstanceWithUserId();
                kss.setUserId(userId);
                kss.setCourseId(courseId);
                kexiaoSupers.add(kss);
                KexiaoStatisticsSupers.put(userId, kss);
            }
            studentKexiaoStatisticsApiService.fillStudentKeXiaoStatistics(orgId, kexiaoSupers, 3);
            for (KexiaoStatisticsSuper kss : kexiaoSupers) {
                Long userId = kss.getUserId();
                boolean hasSignupRecord = kss.isHasSignupCourseRecord();
                Integer leftClassTimes = kss.getLeftClassTimesForKexiaoValue();
                Integer totalClassTimes = kss.getTotalClassTimesForKexiaoValue();
                if (!hasSignupRecord) {
                    studentStatusMap.put(userId, 0);
                } else if (leftClassTimes != null && totalClassTimes != null) {
                    if (leftClassTimes < totalClassTimes) {
                        studentStatusMap.put(userId, 1);
                    } else {
                        studentStatusMap.put(userId, 2);
                    }
                }
            }
        }
        Integer chargeUnit = ChargeUnit.BY_TIMES.getCode();
        if (byCourseNumber != null) {
            chargeUnit = byCourseNumber.getChargeUnit();
        }

        List<PersonBaseDto> list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(students)) {
            boolean isShowMobile = txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
            Map<Long, String> avatarMap = studentApiService.batchGetStudentAvatarUrl(students);
            for (OrgStudent orgStudent : students) {
                PersonBaseDto dto = new PersonBaseDto();
                dto.setId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setPinyinName(HanZiPinYinUtils.getLowerCasePinYin(orgStudent.getName()));
                dto.setAvatarUrl(avatarMap.get(orgStudent.getId()));
                if (!isShowMobile) {
                    dto.setMobile(MaskUtil.maskMobile(dto.getMobile()));
                } else {
                    dto.setMobile(orgStudent.getMobile());
                }
                dto.setStudentClassStatus(studentStatusMap.get(orgStudent.getUserId()));
                KexiaoStatisticsSuper kexiaoStatisticsSuper = KexiaoStatisticsSupers.get(orgStudent.getUserId());
                dto.setChargeUnit(chargeUnit);
                if (kexiaoStatisticsSuper != null) {
                    dto.setFinishClassHourForKexiao(kexiaoStatisticsSuper.getFinishClassTimesForKexiao());
                    dto.setTotalClassHourForKexiao(kexiaoStatisticsSuper.getTotalClassTimesForKexiao());
                } else {
                    String showZero = "0";
                    if (chargeUnit == null || chargeUnit == ChargeUnit.BY_OTHER.getCode()) {
                        showZero = "--";
                    } else if (ChargeUnit.isByTime(chargeUnit)) {
                        showZero = "0.0";
                    }
                    dto.setFinishClassHourForKexiao(showZero);
                    dto.setTotalClassHourForKexiao(showZero);
                }
                list.add(dto);
            }
        }
        return list;
    }

    /**
     * @param
     * @param dto
     */
    public void setStudentLessonStatus(Integer lessonStatus, PersonBaseDto dto) {
        if (lessonStatus == null) {
            lessonStatus = StudentLessonStatus.NOT_ENROLL.getStatus();
        }
        if (StudentLessonStatus.NOT_ENROLL.getStatus() == lessonStatus) {
            dto.setStudentClassStatus(0);
        } else if (StudentLessonStatus.STUDYING.getStatus() == lessonStatus
            || StudentLessonStatus.TO_CHARGE.getStatus() == lessonStatus) {
            dto.setStudentClassStatus(1);
        } else if (StudentLessonStatus.PAST.getStatus() == lessonStatus) {
            dto.setStudentClassStatus(2);
        } else {
            dto.setStudentClassStatus(0);
        }
    }

    /**
     * 批量获取学生头像并缓存
     * 
     * @param usrIds
     * @return
     */
    private Map<Long, String> getAndCacheStudentAvatar(Collection<Long> usrIds) {
        Map<Long, String> map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(usrIds)) {
            return map;
        }

        List<Student> students = studentDao.getByUserIds(usrIds, "userId", "avatar");
        // log.debug("students = {}", students);
        Map<Long, Integer> userIdStorageIdMap = Maps.newHashMap();// 学生id到头像id的map

        Set<Integer> avatarIds = Sets.newHashSet();
        for (Student student : students) {
            if (student.getAvatar() != null) {
                avatarIds.add(student.getAvatar());
            }
            userIdStorageIdMap.put(student.getUserId(), student.getAvatar());
        }
        // log.debug("userIdStorageIdMap={}", userIdStorageIdMap);
        Map<Long, String> storageIdUrlMap = Maps.newHashMap();// 头像id到url的map
        // log.debug("avatarIds = {}", avatarIds);
        List<Storage> storages = storageDao.getByIds(avatarIds);
        for (Storage storage : storages) {
            storageIdUrlMap.put(storage.getId(),
                StorageUtil.constructUrl(storage.getFid(), storage.getMimetype(), storage.getSn()));
        }
        // log.debug("storageIdUrlMap = {}", storageIdUrlMap);

        for (Student student : students) {
            if (student.getAvatar() != null) {
                // log.debug("{} -> {} -> {}", student.getUserId(), userIdStorageIdMap.get(student.getUserId()),
                // storageIdUrlMap.get(userIdStorageIdMap.get(student.getUserId().longValue())));
                map.put(student.getUserId(),
                    storageIdUrlMap.get(userIdStorageIdMap.get(student.getUserId()).longValue()));
            }
        }
        return map;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveCourseStudents(Long orgId, Long courseId, Collection<Long> studentIds) {
        Preconditions.checkArgument(orgId != null && orgId > 0, "orgId is illegal");
        Preconditions.checkArgument(courseId != null && courseId > 0, "courseId is illegal");
        List<Long> studentUserIds = Lists.newArrayList();
        Map<Long, Long> userIdAndIdMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(studentIds)) {
            // <userId,id>
            userIdAndIdMap = this.orgStudentDao.getStudentUserIdAndIdMap(studentIds);
            studentUserIds.addAll(userIdAndIdMap.keySet());
        }
        // 当前班级的学生,排除已转班/退班的学生
        Set<Long> existStudents = Sets.newHashSet();
        List<OrgStudentCourse> courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId);
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus().intValue() == 0) {
                existStudents.add(orgStudentCourse.getUserId());
            }
        }
        // existStudents的学生本身可能已在OrgStudent中删除，需要过滤
        Map<Long, Long> existStudentMap = this.orgStudentDao.getUserIdStudentIdMap(existStudents, orgId, true);
        existStudents = existStudentMap.keySet();

        Set<Long> tempStudents = Sets.newHashSet(existStudents);
        Set<Long> toDelStudents = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty(studentUserIds)) {
            tempStudents.removeAll(studentUserIds);
        }
        toDelStudents.addAll(tempStudents);

        // 已排课的学生
        List<OrgStudentLesson> lessonStudents =
            this.orgStudentLessonDao.getOrgStudentLessonsByCourseIds(Arrays.asList(courseId));
        Set<Long> arrangeStudents = BaseUtils.getPropertiesList(lessonStudents, "userId");
        for (Long studentId : toDelStudents) {
            if (arrangeStudents.contains(studentId)) {
                throw new BussinessException(CommonErrorCode.BUSINESS_ERROR, "已排课的学生无法删除");
            }
        }

        // 与app端处理保持一致，简单的退班操作，后面根据pm需求优化.20160907.wangsixia
        if (CollectionUtils.isNotEmpty(toDelStudents)) {
            this.orgStudentCourseDao.batchDeleteOrgCourseStudent(orgId, courseId, toDelStudents,
                StudentCourseStatus.WITHDRAW.getCode());
        }

        studentUserIds.removeAll(existStudents);
        if (CollectionUtils.isNotEmpty(studentUserIds)) {
            Set<Long> toAddStudents = Sets.newHashSet();
            for (Long userId : studentUserIds) {
                toAddStudents.add(userIdAndIdMap.get(userId));
            }
            this.addOrgCourseStudent(orgId, courseId, toAddStudents, null, false);
        }
    }
}
