
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.service;

import com.baijia.tianxiao.biz.erp.dto.request.*;
import com.baijia.tianxiao.biz.erp.dto.response.*;
import com.baijia.tianxiao.biz.erp.dto.response.exportCourse.DayScheduleDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonScheduleInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.NameAndIdDto;
import com.baijia.tianxiao.biz.erp.enums.BatchOperateType;
import com.baijia.tianxiao.dal.org.dto.DropDownListRequestDto;
import com.baijia.tianxiao.dal.org.dto.TimeTableRequestDto;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.solr.dto.TimeRange;
import com.baijia.tianxiao.sal.course.dto.HeaderDto;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/**
 * @author cxm
 * @version 1.0
 * @title CourseLessonService
 * @desc TODO
 * @date 2015年12月30日
 */
public interface CourseLessonService {

    /**
     * 获取有课日历
     * 
     * @param orgId
     * @param startDate
     * @param endDate
     * @return
     */
    LessonCalendarResponse getLessonCalendar(Long orgId, Date startDate, Date endDate,Long teacherId,Long roomId,Integer courseType);

    /**
     * 添加课节
     *
     * @param orgId
     * @param startDay
     * @param endDay
     * @param dto
     */
    void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto);

    /**
     * 添加课节 for PC
     *
     * @param orgId
     * @param startDay
     * @param endDay
     * @param dto
     */
    void addClassLessonsForPC(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDtoForPC dto);

    /**
     * 查看课节列表,默认查看今天以后的
     *
     * @param orgId
     * @param params
     * @return
     */
    ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params, boolean includeDelCourse);

    /**
     * 查看课表
     *
     * @param orgId
     * @param params
     * @return
     */
    List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params);

    /**
     * 查看课节详情
     *
     * @param orgId
     * @param lessonId
     * @return
     */
    LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign);

    /**
     * 课节详情
     * 
     * @param orgId
     * @param lessonId
     * @return
     */
    LessonScheduleInfoDto lessonDetail(Long orgId, Long lessonId);

    /**
     * 编辑课节详情
     *
     * @param orgId
     * @param editDto
     */
    void editLesson(Long orgId, EditLessonRequestDto editDto);

    /**
     * @param orgId
     * @param lessonId
     */
    void delLesson(Long orgId, Long lessonId);

    /**
     * @param orgId
     * @param lessonId
     * @return
     */
    LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId);

    /**
     * 获取teacherId
     *
     * @param orgId
     * @param lessonId
     * @return
     */
    Long getTeacherId(Long orgId, Long lessonId);

    /**
     * 获取课节学生userId
     *
     * @param orgId
     * @param lessonIds
     * @return
     */
    List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds);

    /**
     * 导出
     *
     * @param response
     * @param orgId
     * @param dtoList
     */
    void export(HttpServletResponse response, Long orgId, ListLessonsRequestDto param,
        List<LessonTimeTableResponseDto> dtoList);

    /**
     * 临时凑合方案 班级总数 待签到班级总数
     * 
     * @return
     */
    HeaderDto getHeaderInfo();

    /**
     * 批量操作课节
     * 
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @param operateType
     * @param targetStr
     */

    void batchOperateLesson(Long orgId, Long courseId, List<Long> lessonIds, BatchOperateType operateType,
        String targetStr);

    /**
     * 在排课模块中，查看指定课程的课节列表逻辑
     * 
     * @param orgId
     * @param params
     * @return
     */

    ListLessonResponseDto queryCourseLessons(Long orgId, ListLessonsRequestDto params);

    /**
     * 查询班级课节列表
     * 
     * @param orgId
     * @param params
     * @return
     */

    List<LessonScheduleInfoDto> queryCourseLessonsByParams(Long orgId, TimeTableRequestDto params, PageDto pageDto);

    /**
     * 获取课表导出数据,与查询课表参数相同
     * @param orgId
     * @param params
     * @return
     */
    List<DayScheduleDto> getExportSchedule(Long orgId, TimeTableRequestDto params);

    /**
     * 导出课表信息
     * @param response
     * @param orgId
     * @param params
     */
    void exportSchedule(HttpServletRequest request, HttpServletResponse response, Long orgId, TimeTableRequestDto params);
    
    
    

    /**
     * @param orgId
     * @param params
     * @return
     */

    ListLessonResponseDto listSignInLessons(Long orgId, ListLessonsRequestDto params);

    List<Long> addClassLessonsBatchForFastSignIn(Long orgId, Long courseId, List<TimeRange> timeRangeList, Collection<Long> studentIds);

    void batchEditLessonsForFastSignIn(FastSignInLessonsEditRequestDto dto);

    void batchEditLessonsForFastSignIn(List<FastSignInLessonEditRequestDto> dtos);

    /**
     * 快速签到成功保存页面返回的课节基本信息.
     * @param orgId
     * @param courseId
     * @param lessonIds
     * @return
     */
    List<LessonResponseDto> findLessonBaseInfoByLessonIds(Long orgId, Long courseId, List<Long> lessonIds);

    List<LessonResponseDto> buildLessonBaseInfoList(Long orgId, List<OrgClassLesson> lessons);

    /**
     * 查询天校PC课表查询下拉列表数据
     * 
     * @params params: 联动查询条件
     * @return
     */
    List<NameAndIdDto> getLessonCalendarQueryDropDownList(Long orgId, DropDownListRequestDto params);

    /**
     * 检测冲突,默认只获取3条冲突记录,如果需要更多,请调用OrgLessonConflictService的方法
     * 
     * @param orgId
     * @param lessonConflictCheckDto
     * @return
     */
    LessonConflictCheckListDto lessonConflictCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto);

    void flushConflictData();

    List<LessonResponseDto> findLessonBaseInfoByTimeRange(Long orgId, Date startDate, Date endDate, PageDto pageDto);

    public List<OrgClassLesson> listStaffClassLessons(Long orgId,Integer cascadeId,List<Long> delIds,Date startTime,Date endTime,PageDto pageDto);

    public void handleStaffCourseIds(Long orgId,Integer cascadeId,Set<Long> courseIds);
}
