package com.baijia.tianxiao.biz.erp.dto.response.exportCourse;

import com.baijia.tianxiao.util.date.DateUtil;
import lombok.Data;
import org.joda.time.LocalDate;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 每天的课表
 * Created by wangsixia on 2016/12/1.
 */
@Data
public class DayScheduleDto {
    // 周一
    private String week;
    // 11.28
    private String date;
    // 周一 (11.28)
    private String header;
    // 当天的课节数
    private int lessonCount;

    private List<LessonScheduleDto> lessons;

    /**
     * 获取一周的默认课表
     * @param time
     * @return
     */
    public static List<DayScheduleDto> getWeekList(Long time) {
        List<DayScheduleDto> list = new ArrayList<>();
        Date monday = new LocalDate(time).dayOfWeek().withMinimumValue().toDate();
        int index = 0;
        do {
            Date temp = DateUtil.getDiffDateTime(monday, index);
            String weekDay = DateUtil.getChineseWeekDay(temp);
            DayScheduleDto dto = new DayScheduleDto();
            dto.setWeek("周" + weekDay);
            dto.setDate(DateUtil.getStrByDateFormate(temp, "MM.dd"));
            dto.setHeader(dto.getWeek() + " (" + dto.getDate() + ")");
            List<LessonScheduleDto> lessonList = new ArrayList<>();
            dto.setLessons(lessonList);
            list.add(dto);
            index++;
        } while (index < 7);
        return list;
    }

    public static void main(String[] args) {
        Date today = new Date();
        List<DayScheduleDto> list = DayScheduleDto.getWeekList(today.getTime());
        for (DayScheduleDto dto : list) {
            System.out.println(dto);
        }

        String fileName = list.get(0).getDate() + " ~ " + list.get(list.size() - 1).getDate() + "课表.xlsx";
        System.out.println(fileName);
    }
}
