
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.response;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;

import java.util.List;
import java.util.Map;
import java.util.Set;

import lombok.Data;

/**
 * @title StudentSigninRecordDto
 * @desc TODO
 * @author yuanxiaojun
 * @date 2016年08月25日
 * @version 1.0
 */
@Data
public class StudentSigninRecordDto {

	private Long studentId;
	private String studentName;
	private Map<String,OrgLessonSign> signInStatusMap;
	private Set<String> studentLessonSet;
	private List<CourseSigninResult> courseSigninResultList;//学生签到记录列表
	
	private Map<Long, List<LessonResponseDto>> lessonCourseListMap;//课程对应的课节信息
	//private Map<String,Integer> signInStatusMap;
	//private Map<Long, CourseSignin> courseSigninMap;
	
	public static class CourseSigninResult {
		//private Long userId;
		//private String studentName;
	    private Long courseId;//课程id
		private String courseName;//课程名称
		private String courseConsumeRuleStr;
		private Integer courseConsumeRuleValue;
		//private String stuPinyinName;
		private int arrangeCount;//排课次数
		private int planCount;//计划课次
		private int signedCount;//到课次数
		private int leaveCount;//请假次数
		private int absentCount;//缺课次数
		private int endCount;//完成次数
		
		

        public Long getCourseId() {
        
            return courseId;
        }
        public void setCourseId(Long courseId) {
        
            this.courseId = courseId;
        }
        public int getEndCount() {
        
            return endCount;
        }
        public void setEndCount(int endCount) {
        
            this.endCount = endCount;
        }
        public String getCourseConsumeRuleStr() {
        
            return courseConsumeRuleStr;
        }
        public void setCourseConsumeRuleStr(String courseConsumeRuleStr) {
        
            this.courseConsumeRuleStr = courseConsumeRuleStr;
        }
        public Integer getCourseConsumeRuleValue() {
        
            return courseConsumeRuleValue;
        }
        public void setCourseConsumeRuleValue(Integer courseConsumeRuleValue) {
        
            this.courseConsumeRuleValue = courseConsumeRuleValue;
        }

		public int getPlanCount() {
			return planCount;
		}
		public void setPlanCount(int planCount) {
			this.planCount = planCount;
		}
		public int getArrangeCount() {
			return arrangeCount;
		}
		public void setArrangeCount(int arrangeCount) {
			this.arrangeCount = arrangeCount;
		}
		public String getCourseName() {
			return courseName;
		}
		public void setCourseName(String courseName) {
			this.courseName = courseName;
		}
		
		public int getSignedCount() {
			return signedCount;
		}
		public void setSignedCount(int signedCount) {
			this.signedCount = signedCount;
		}
		public int getLeaveCount() {
			return leaveCount;
		}
		public void setLeaveCount(int leaveCount) {
			this.leaveCount = leaveCount;
		}
		public int getAbsentCount() {
			return absentCount;
		}
		public void setAbsentCount(int absentCount) {
			this.absentCount = absentCount;
		}
	}	
	
	public static class CourseSignin {
		private Long courseId;//课程id
		private String courseName;//课程名称
		private Integer arrangeNum;//已排课次
		private Integer lessonNum;//已上课次
		private Integer consumRuleValue;
		private String consumeRuleStr;
		private List<LessonResponseDto> lessonCourseList;//课节列表
		public Long getCourseId() {
			return courseId;
		}
		public void setCourseId(Long courseId) {
			this.courseId = courseId;
		}
		public String getCourseName() {
			return courseName;
		}
		public void setCourseName(String courseName) {
			this.courseName = courseName;
		}
		public Integer getArrangeNum() {
			return arrangeNum;
		}
		public void setArrangeNum(Integer arrangeNum) {
			this.arrangeNum = arrangeNum;
		}
		public Integer getLessonNum() {
			return lessonNum;
		}
		public void setLessonNum(Integer lessonNum) {
			this.lessonNum = lessonNum;
		}
		public Integer getConsumRuleValue() {
			return consumRuleValue;
		}
		public void setConsumRuleValue(Integer consumRuleValue) {
			this.consumRuleValue = consumRuleValue;
		}
		public String getConsumeRuleStr() {
			return consumeRuleStr;
		}
		public void setConsumeRuleStr(String consumeRuleStr) {
			this.consumeRuleStr = consumeRuleStr;
		}
		public List<LessonResponseDto> getLessonCourseList() {
			return lessonCourseList;
		}
		public void setLessonCourseList(List<LessonResponseDto> lessonCourseList) {
			this.lessonCourseList = lessonCourseList;
		}
	}
}
