/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.response;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.constant.CommentStatus;
import com.baijia.tianxiao.constant.SignStatus;
import lombok.Data;

import java.util.Date;

/**
 * @title LessonResponseResponseDto
 * @desc TODO
 * @author cxm
 * @date 2015年12月29日
 * @version 1.0
 */
@Data
public class LessonResponseDto {

    private Long lessonId;

    private String lessonName;

    private Long teacherId;

    private String teacherName;

    private Long roomId;

    private String roomName;

    private Long courseId;

    private String courseName;

    private Integer courseType;

    private int index;

    private Date lessonStartTime;

    private Date lessonEndTime;

    // 到课学生数
    private int signCount;
    // 签到的学生总数
    private int totalSignCount;

    // 已报名学生数
    private int studentCount;

    /**
     * 是否已结束
     */
    private int isOver;

    public void setIsOver(int isOver) {
        this.isOver = isOver;
    }

    private int signStatus;

    private Date signTime;

    private String signStatusStr;

    private int commentStatus = CommentStatus.NOT_BEGIN.getCode();

    private String commentStr = CommentStatus.NOT_BEGIN.getMessage();

    public void setCourseSignStatusEnum(CourseSignStatus signStatusEnum) {
        if (signStatusEnum != null) {
            this.signStatus = signStatusEnum.getCode();
            this.signStatusStr = signStatusEnum.getNote();
            if (signStatus == CourseSignStatus.SIGNED.getCode()) {
                this.signStatusStr = "到课人数";
            }
        }
    }

    public void setSignStatusEnum(SignStatus signStatusEnum) {
        if (signStatusEnum != null) {
            this.signStatus = signStatusEnum.getCode();
            this.signStatusStr = signStatusEnum.getMessage();
        }
    }

    public void setCommentEnum(CommentStatus commentStatusEnum) {
        if (commentStatusEnum != null) {
            this.commentStatus = commentStatusEnum.getCode();
            this.commentStr = commentStatusEnum.getMessage();
        }
    }

}
