package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.dal.finance.dao.TxFinanceInfoDao;
import com.baijia.tianxiao.dal.finance.po.TxxFinanceInfo;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgFinanceAccountRecordDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgFinanceAccountRecord;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupRefundDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupRefund;
import com.baijia.tianxiao.dal.statistic.dao.TxFinanceRecordDayDao;
import com.baijia.tianxiao.dal.statistic.dao.TxSignupRecordDayDao;
import com.baijia.tianxiao.dal.statistic.po.TxFinanceRecordDay;
import com.baijia.tianxiao.dal.statistic.po.TxSignupRecordDay;
import com.baijia.tianxiao.dal.sync.constant.MsgSyncType;
import com.baijia.tianxiao.dal.sync.dao.TxMsgSyncTimestampDao;
import com.baijia.tianxiao.dal.sync.po.TxMsgSyncTimestamp;
import com.baijia.tianxiao.sal.organization.finance.constant.FinanceOpType;
import com.baijia.tianxiao.util.date.DateUtil;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

/**
 * Created with IntelliJ IDEA.
 * User: Victor Weng
 * Date: 16/6/30
 * Time: 下午4:45
 * To change this template use File | Settings | File Templates.
 */
@Service("syncSignupRefundRecordService")
@Slf4j
public class SyncSignupRefundRecordServiceImpl implements SyncPayService {
    @Resource
    private TxMsgSyncTimestampDao txMsgSyncTimestampDao;

    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;

    @Resource
    private OrgSignupRefundDao orgSignupRefundDao;

    @Resource
    private TxSignupRecordDayDao txSignupRecordDayDao;

    @Resource
    private OrgFinanceAccountRecordDao orgFinanceAccountRecordDao;


    @Resource
    private TxFinanceInfoDao txFinanceInfoDao;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private TxFinanceRecordDayDao txFinanceRecordDayDao;

    private AtomicBoolean signupRefundRecordFlag = new AtomicBoolean(false);

    @Override
    public void sync() {

        TxMsgSyncTimestamp syncInfo = getSyncInfo(MsgSyncType.CW_SIGNUP_REFUND_RECORD);
        try {
            if (!signupRefundRecordFlag.get()) {
                log.info("sync cw signuprecord refund info :{}", syncInfo);
                signupRefundRecordFlag.set(true);
                syncSignupRefundRecordDay(syncInfo);
                signupRefundRecordFlag.set(false);
            } else {
                log.warn("has not finish,skip");
            }
        } catch (Exception e) {
            e.printStackTrace();
            log.error("sync task error :{}", e);
        } finally {
            signupRefundRecordFlag.set(false);
        }
        log.info("save sync signuprefund info:{}", syncInfo);
        txMsgSyncTimestampDao.saveOrUpdate(syncInfo);
    }

    private void syncSignupRefundRecordDay(TxMsgSyncTimestamp syncInfo) {
        List<OrgSignupRefund> signupRefunds = orgSignupRefundDao.getOrgSignupRefundListByMinId(syncInfo.getSyncId(),
                syncInfo.getSyncTime(), 100);

        log.info("save syncSignupRefundRecordDay:{} success", signupRefunds.size());

        if (CollectionUtils.isNotEmpty(signupRefunds)) {
            for (OrgSignupRefund orgSignupRefund : signupRefunds) {
                try {
                    if (orgSignupRefund.getId() > syncInfo.getSyncId()) {
                        syncInfo.setSyncId(Long.valueOf(orgSignupRefund.getId()));
                    }
                    OrgSignupInfo orgSignupInfo = orgSignupInfoDao.searchByPurchaseId(orgSignupRefund.getSignupPurchaseId());
                    if (orgSignupInfo != null) {
                        saveSignupRecordDay(orgSignupInfo, orgSignupRefund);

                        saveFinanceInfo(orgSignupInfo, orgSignupRefund);
                        saveFinanceRecordDay(orgSignupInfo, orgSignupRefund);
                    }
                } catch (Exception e) {
                    log.warn("sync finance record fail {}", e);
                }
            }
        }
    }


    private void saveFinanceInfo(OrgSignupInfo orgSignupInfo, OrgSignupRefund orgSignupRefund) {
        int opTo = 2;//退款

        OrgCourse orgCourse = orgCourseDao.getByCourseId(orgSignupRefund.getCourseId());
        OrgFinanceAccountRecord orgFinanceAccountRecord = orgFinanceAccountRecordDao.currentAccount(orgSignupInfo.getOrgId(), orgSignupRefund.getCreateTime());


        TxxFinanceInfo txFinanceInfo = new TxxFinanceInfo();
        txFinanceInfo.setOrgId(orgSignupInfo.getOrgId());
        txFinanceInfo.setCreateTime(orgSignupRefund.getCreateTime());
        txFinanceInfo.setCurrBalance(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrBalance());
        txFinanceInfo.setCurrFreezeMoney(orgFinanceAccountRecord == null ? 0.0 : orgFinanceAccountRecord.getCurrFreezeMoney());
        txFinanceInfo.setExpectedEarning(orgFinanceAccountRecord==null?0.0:orgFinanceAccountRecord.getCurrExpectedEarning());
        txFinanceInfo.setOpMoney(orgSignupRefund.getRefundPrice().doubleValue() / 100);
        txFinanceInfo.setOpType(FinanceOpType.DRAWBACK.getCode());
        txFinanceInfo.setPayType(PayType.CASH.getCode());
        txFinanceInfo.setPurchaseId(orgSignupRefund.getSignupPurchaseId() + "");
        txFinanceInfo.setCourseId(orgCourse.getId());

        StringBuffer opinfo = new StringBuffer();
        opinfo.append(orgCourse != null ? orgCourse.getName() : "").append(" ");
        opinfo.append("学生:").append(orgSignupInfo.getStudentName()).append(" ");

        txFinanceInfo.setOpInfo(opinfo.toString());
        txFinanceInfo.setOpTo(opTo);

        log.debug("saveFinanceInfo={}", txFinanceInfo);
        txFinanceInfoDao.save(txFinanceInfo);
    }


    private void saveFinanceRecordDay(OrgSignupInfo orgSignupInfo, OrgSignupRefund orgSignupRefund) {
        int opType = PayType.CASH.getCode();
        int opTo = 2;//退款
        String mdate = DateUtil.getStrByDate(orgSignupRefund.getCreateTime());

        TxFinanceRecordDay txFinanceRecordDay = txFinanceRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo);
        if (txFinanceRecordDay == null) {
            txFinanceRecordDay = new TxFinanceRecordDay();
            txFinanceRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txFinanceRecordDay.setMdate(orgSignupRefund.getCreateTime());
            txFinanceRecordDay.setOpCount(1);
            txFinanceRecordDay.setOpPrice(orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txFinanceRecordDay.setOpType(opType);
            txFinanceRecordDay.setOpTo(opTo);
        } else {
            txFinanceRecordDay.setOpPrice(txFinanceRecordDay.getOpPrice() + orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txFinanceRecordDay.setOpCount(txFinanceRecordDay.getOpCount() + 1);
        }
        log.debug("saveFinanceRecordDay={}", txFinanceRecordDay);
        txFinanceRecordDayDao.saveOrUpdate(txFinanceRecordDay);
    }

    private void saveSignupRecordDay(OrgSignupInfo orgSignupInfo, OrgSignupRefund orgSignupRefund) {
        int opType = orgSignupInfo.getSourceType();
        int opTo = 2;//退款
        String mdate = DateUtil.getStrByDate(orgSignupRefund.getCreateTime());

        TxSignupRecordDay txSignupRecordDay = txSignupRecordDayDao.getByDayType(orgSignupInfo.getOrgId(), mdate, opType, opTo);
        if (txSignupRecordDay == null) {
            txSignupRecordDay = new TxSignupRecordDay();
            txSignupRecordDay.setOrgId(orgSignupInfo.getOrgId());
            txSignupRecordDay.setMdate(orgSignupRefund.getCreateTime());
            txSignupRecordDay.setOpCount(1);
            txSignupRecordDay.setOpPrice(orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txSignupRecordDay.setOpType(opType);
            txSignupRecordDay.setOpTo(opTo);
        } else {
            txSignupRecordDay.setOpPrice(txSignupRecordDay.getOpPrice() + orgSignupRefund.getRefundPrice().doubleValue() / 100);
            txSignupRecordDay.setOpCount(txSignupRecordDay.getOpCount() + 1);
        }
        log.debug("saveSignupRecordDay={}", txSignupRecordDay);
        txSignupRecordDayDao.saveOrUpdate(txSignupRecordDay);
    }


    private TxMsgSyncTimestamp getSyncInfo(MsgSyncType syncType) {
        TxMsgSyncTimestamp syncInfo = txMsgSyncTimestampDao.getSyncTimestampByType(syncType.getSyncType());
        if (syncInfo == null) {
            syncInfo = new TxMsgSyncTimestamp();
            syncInfo.setSyncId(0l);
            syncInfo.setSyncTime(new Date());
            syncInfo.setSyncType(syncType.getSyncType());
        }
        return syncInfo;
    }
}
