
package com.baijia.tianxiao.biz.erp.service.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.util.StudentNameUtil;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.google.common.collect.Lists;

import lombok.NonNull;
import lombok.extern.slf4j.Slf4j;

@Slf4j
@Service
public class ErpStudentServiceImpl implements ErpStudentService {

    @Resource
    private OrgStudentDao orgStudentDao;

    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;

    @Resource
    private SignupService signupService;

    @Resource
    private OrgCourseDao orgCourseDao;

    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;

    @Resource
    private OrgCourseService orgCourseService;

    @Resource
    private CourseStudentService courseStudentService;

    @Resource
    private OrgStudentService orgStudentService;

    @Resource
    private OrgLessonSignService orgLessonSignService;

    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    @Override
    public StudentInfoListReponseDto getStudentListWithAttendanceRate(StudentListRequestDto studentListRequestDto,
        Long orgId, PageDto pageDto) {
        boolean needFilter = false;
        List<Long> tempcourseIds = null;
        List<Long> tempstudentIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = txCascadeAccountDao.getById(TianxiaoMContext.getTXCascadeId());
            if (txCascadeAccount.getAccountType() == CascadeType.STAFF.getValue()) {
                tempcourseIds = orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                tempstudentIds = orgStudentService.getStudentidsByCourseIds(orgId, tempcourseIds);
                if (CollectionUtils.isEmpty(tempstudentIds)) {
                    return new StudentInfoListReponseDto();
                }
                needFilter = true;
            }
        }
        log.debug("tempcourseIds={}", tempcourseIds);
        log.debug("tempstudentIds={}", tempstudentIds);

        StudentInfoListReponseDto studentInfoListReponseDto = null;
        if (needFilter) {
            studentInfoListReponseDto =
                orgStudentService.getStudentList(studentListRequestDto, tempstudentIds, orgId, pageDto);
        } else {
            studentInfoListReponseDto = orgStudentService.getStudentList(studentListRequestDto, orgId, pageDto);
        }

        log.debug("studentInfoListReponseDto={}", studentInfoListReponseDto);
        List<Long> studentIds = Lists.newArrayList();
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            studentIds.add(stu.getStudentId());
        }
        Map<Long, Double> map = orgLessonSignService.getAttendanceRateOfStudents(orgId, studentIds);
        log.debug("map={}", map);
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            Double rate = map.get(stu.getStudentId());
            stu.setAttendanceRate(rate == null ? 0.00 : rate);
        }
        return studentInfoListReponseDto;
    }

    /**
     * 添加学生到课程
     * 
     * @param orgId
     * @param courseId
     * @param studentIds
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public void addOrgCourseStudent(Long orgId, Long courseId, Collection<Long> studentIds, Collection<Header> headers,
        boolean doSignup) {
        if (CollectionUtils.isEmpty(studentIds)) {
            log.info("studentIds is empty");
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "学生ID为空");
        }

        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId);

        List<OrgStudent> orgStudents = this.orgStudentDao.getStudentByIds(orgId, studentIds);

        for (OrgStudent orgStudent : orgStudents) {

            OrgStudentCourse osc = orgStudentCourseDao.getStudentCourse(orgId, courseId, orgStudent.getUserId());

            if (osc == null) {
                OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
                buildOrgStudentCourse(orgStudentCourse, orgStudent, courseId);
                orgStudentCourse.setStatus(0);
                this.orgStudentCourseDao.save(orgStudentCourse);
                if (doSignup) {
                    signUp(orgId, orgCourse, orgStudent.getId());
                }
            } else {
                osc.setStatus(0);
                this.orgStudentCourseDao.update(osc, "status");
                if (doSignup) {
                    signUp(orgId, orgCourse, orgStudent.getId());
                }
            }
        }

    }

    /**
     * 添加到课程的学生报名
     * 
     * @param orgId
     * @param orgCourse
     * @param studentId
     */
    private void signUp(Long orgId, OrgCourse orgCourse, Long studentId) {
        List<SignupCourseInfoDto> courseInfos = Lists.newArrayList();
        FillCourseInfoRequestDto signUpDto = new FillCourseInfoRequestDto();
        SignupCourseInfoDto courseInfo = new SignupCourseInfoDto();
        courseInfo.setCount(1);
        courseInfo.setDiscount(100);
        courseInfo.setOrgCourseName(orgCourse.getName());
        courseInfo.setOrgCourseId(orgCourse.getId());
        courseInfo.setOrgCourseNumber(orgCourse.getNumber());
        courseInfo.setOriginPrice(orgCourse.getPrice());
        courseInfo.setPayPrice(orgCourse.getPrice());
        courseInfo.setPreferential(0);
        courseInfos.add(courseInfo);
        signUpDto.setCourseInfos(courseInfos);
        signUpDto.setOrgId(orgId);
        signUpDto.setSignupType(SignupType.FRONTED.getCode());
        OrgStudent student = this.orgStudentDao.getById(studentId);
        if (student != null && student.getDelStatus() == DeleteStatus.NORMAL.getValue()) {
            signUpDto.setStudentMobile(student.getMobile());
            signUpDto.setStudentName(StudentNameUtil.buildStudentName(student));
            log.debug("signUpDto = {}", signUpDto);
            signupService.signUp(signUpDto);
        } else {
            log.warn("student = null, orgId = {}, studentId = {}", orgId, studentId);
            throw new BussinessException(CommonErrorCode.PARAM_ERROR, "studentId = " + studentId + " not found!");
        }
    }

    private void buildOrgStudentCourse(OrgStudentCourse orgStudentCourse, OrgStudent ttsStudent,
        @NonNull Long courseId) {
        orgStudentCourse.setCourseId(courseId);
        orgStudentCourse.setOrgId(ttsStudent.getOrgId());
        orgStudentCourse.setUserId(ttsStudent.getUserId());
        orgStudentCourse.setStudentMobile(MaskUtil.maskMobile(ttsStudent.getMobile()));
        if (StringUtils.isEmpty(ttsStudent.getName())) {
            orgStudentCourse.setStudentName(StringUtils.EMPTY);
        } else {
            orgStudentCourse.setStudentName(ttsStudent.getName());
        }
        orgStudentCourse.setDelStatus(DeleteStatus.NORMAL.getValue());
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void transferOrgCourseStudent(@NonNull Long orgId, @NonNull Long studentId, @NonNull Long fromCourseId,
        @NonNull Long toCourseId, String cause, @NonNull Collection<Header> headers) {

        // 从班级退出
        courseStudentService.transferOrgCourseStudent(orgId, studentId, fromCourseId, toCourseId, cause);
        // 转入到班级
        List<Long> studentIds = Lists.newArrayList();
        studentIds.add(studentId);
        // 被转入学生不添加报名
        addOrgCourseStudent(orgId, toCourseId, studentIds, headers, false);
    }

}
