
 /**
 * Baijiahulian.com Inc.
 * Copyright (c) 2014-2016 All Rights Reserved.
 */
    
package com.baijia.tianxiao.biz.erp.service;

import java.util.List;
import java.util.Map;

import org.springframework.web.multipart.MultipartFile;

import com.baijia.tianxiao.biz.erp.vo.ImportCourse;
import com.baijia.tianxiao.biz.erp.vo.ImportStudent;

/**
 * @title ErpUploadService
 * @desc O(∩_∩)O~ 
 * @author caoliang
 * @date 2016年7月5日
 * @version 1.0
 */

public interface ErpUploadService {
    public String uploadCourse(MultipartFile file) throws Exception;

    /**
     * @param taskId
     * @return
     */
        
    public List<ImportCourse> getValidCourseList(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    public List<ImportCourse> getInValidCourseList(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    public Map<String, String> getTaskStatus(String taskId);
    
    public void saveCourse(String taskId);
    
    public String uploadStudent(MultipartFile file) throws Exception;

    /**
     * @param taskId
     */
        
    void saveStudents(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    List<ImportStudent> getValidStudentList(String taskId);

    /**
     * @param taskId
     * @return
     */
        
    List<ImportStudent> getInValidStudentList(String taskId);
}

    