
package com.baijia.tianxiao.biz.erp.service;

import java.util.Map;

import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterCourseListDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StuentCenterCourseLessonDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

public interface ErpStudentCenterService {

    /**
     * 学生在本机构的所有课节信息
     * 
     * @return
     */
    // StudentCenterLessonListDto getLessonList(Long orgId, Long studentId, Date firstLessonStartTime,
    // Date lastLessonStartTime, PageDto pageDto);

    /**
     * 一个学生的所有课程，不跨机构
     * 
     * @param StudentId
     * @param searchKey
     * @param page
     * @return
     */
    StudentCenterCourseListDto getCourseList(Long orgId, Long studentId, PageDto pageDto);

    /**
     * 个人中心首页
     * 
     * @param studentId
     * @return
     */
    StudentCenterInfoDto getInfo(Long orgId, Long studentId);

    /**
     * 一个学生的某个课程的课节
     * 
     * @param orgId
     * @param courseId
     * @return
     */
    StuentCenterCourseLessonDto getCourseLesson(Long orgId, Long courseId, Long studentId);

    /**
     * 评价详情页
     * 
     * @param orgId
     * @param lessonId
     * @param userId
     * @return
     */
    Map<String, Object> buildStudentCommentDetail(Long orgId, Long lessonId, Long userId, Integer userRole);

    /**
     * 
     * @param orgId
     * @param lessonId
     * @param studentId
     * @return
     */
    Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId);

}

    