
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */

package com.baijia.tianxiao.biz.erp.service;

import com.baijia.tianxiao.biz.erp.dto.request.UserSmsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.CourseSmsListDto;
import com.baijia.tianxiao.biz.erp.dto.response.UserSmsResponseDto;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;

import java.util.Date;
import java.util.List;

/**
 * @title ErpCourseSmsService
 * @desc 课表短信发送
 * @author shanyu
 * @date 2015年12月25日
 * @version 1.0
 */

public interface ErpCourseSmsService {

    /**
     * 获取课程短信发送详情列表
     * 
     * @param orgId
     * @param startTime
     * @param endTime
     * @param searchKey
     * @param pageDto
     * @return
     */
    public List<CourseSmsListDto> getCourseList(Long orgId, Date startTime, Date endTime, String searchKey,
        PageDto pageDto);

    /**
     * 老师或者学生查看课表短信的状态列表。
     * 
     * @param orgId
     * @param dto
     * @return
     */
    public List<UserSmsResponseDto> getCourseSmsViewList(Long orgId, UserSmsRequestDto dto);
}
