
/**
 * Baijiahulian.com Inc. Copyright (c) 2014-2015 All Rights Reserved.
 */
package com.baijia.tianxiao.biz.erp.dto.request;

import java.util.Date;

import com.baijia.tianxiao.sqlbuilder.dto.PageRequestDto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * @title ListLessonsRequestDto
 * @desc TODO
 * @author cxm
 * @date 2015年12月29日
 * @version 1.0
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class ListLessonsRequestDto extends PageRequestDto {
    private Long teacherId;

    private Long roomId;

    private Long studentId;

    private Long courseId;

    private Long lessonId;

    private Long commentId;

    private Long startTime;

    private Long endTime;

    private Long firstLessonStartTime;

    private Long lastLessonStartTime;

    private transient Date startTimeDate;

    private transient Date endTimeDate;

    // 以下3个都是查询标记
    private boolean needTeacherName;

    private boolean needcourseName;

    private boolean needRoomName;

    private boolean needSignInfo = true;

    private boolean needStudentSignStatus;

    public Date getStartTime() {
        if (this.startTime != null && this.startTime > 0) {
            startTimeDate = new Date(this.startTime);
        }
        return startTimeDate;
    }

    public Date getEndTime() {
        if (this.endTime != null && this.endTime > 0) {
            endTimeDate = new Date(this.endTime);
        }
        return endTimeDate;
    }

    public Date getFirstLessonStartTime() {
        if (this.firstLessonStartTime != null && this.firstLessonStartTime > 0) {
            return new Date(this.firstLessonStartTime);
        }
        return null;
    }

    public Date getLastLessonStartTime() {
        if (this.lastLessonStartTime != null && this.lastLessonStartTime > 0) {
            return new Date(this.lastLessonStartTime);
        }
        return null;
    }

}
