/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterCourseListDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StuentCenterCourseLessonDto;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.service.ErpStudentCenterService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.sal.comment.dto.CommentInfoDto;
import com.baijia.tianxiao.sal.comment.service.LessonCommentService;
import com.baijia.tianxiao.sal.course.dto.response.ClassLessonInfoDto;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.SmsService;
import com.baijia.tianxiao.sal.organization.org.dto.OrgBaseInfoModel;
import com.baijia.tianxiao.sal.organization.org.service.OrgBaseService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpStudentCenterServiceImpl
implements ErpStudentCenterService {
    private static final Logger log = LoggerFactory.getLogger(ErpStudentCenterServiceImpl.class);
    @Resource
    private CourseLessonService courseLessonService;
    @Resource
    private OrgCourseService orgCourseService;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseStudentService orgCourseStudentService;
    @Resource
    private OrgBaseService orgBaseService;
    @Resource
    private LessonCommentService lessonCommentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private SmsService smsService;

    @Override
    @Transactional(readOnly=true)
    public StudentCenterCourseListDto getCourseList(Long orgId, Long studentId, PageDto pageDto) {
        log.info("orgId={},studentId={},page={}", new Object[]{orgId, studentId, pageDto});
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        StudentCenterCourseListDto dto = new StudentCenterCourseListDto();
        dto.setLogo(orgBaseInfoModel.getLogo());
        dto.setOrgName(orgBaseInfoModel.getShortName());
        List list = this.orgCourseListService.getCourseList(orgId, studentId, pageDto);
        for (CourseListReponseDto courseDto : list) {
            dto.addCourseListReponseDto(courseDto);
        }
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public StudentCenterInfoDto getInfo(@NonNull Long orgId, @NonNull Long studentId) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        Map map = this.orgCourseStudentService.getStudentNameAndAvatar(orgId, studentId);
        Map courseLessonInfoMap = this.orgCourseStudentService.getStudentCourseLessonInfo(orgId, studentId);
        StudentCenterInfoDto studentCenterInfoDto = new StudentCenterInfoDto();
        studentCenterInfoDto.setAvatarUrl((String)map.get("avatarUrl"));
        studentCenterInfoDto.setName((String)map.get("name"));
        studentCenterInfoDto.setLessonToday((Integer)courseLessonInfoMap.get("lessonToday"));
        studentCenterInfoDto.setCourseCount((Integer)courseLessonInfoMap.get("courseCount"));
        studentCenterInfoDto.setCommentCount((Integer)courseLessonInfoMap.get("commentCount"));
        return studentCenterInfoDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public StuentCenterCourseLessonDto getCourseLesson(Long orgId, Long courseId, Long studentId) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null && userId > 0L ? 1 : 0) != 0, (Object)"student not exist!");
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        StuentCenterCourseLessonDto dto = new StuentCenterCourseLessonDto();
        dto.setLogo(orgBaseInfoModel.getLogo());
        dto.setOrgName(orgBaseInfoModel.getShortName());
        dto.setExtension(orgBaseInfoModel.getExtension());
        this.smsService.viewSms(orgId, courseId, userId, Integer.valueOf(UserRole.STUDENT.getRole()));
        ListLessonsRequestDto params = new ListLessonsRequestDto();
        params.setCourseId(courseId);
        params.setStudentId(studentId);
        params.setNeedStudentSignStatus(true);
        params.setNeedRoomName(true);
        params.setNeedTeacherName(true);
        params.setNeedcourseName(true);
        ListLessonResponseDto listResponse = this.courseLessonService.listLessons(orgId, params);
        dto.setLessonCount(listResponse.getList().size());
        ArrayList lessonIds = Lists.newArrayList();
        for (LessonResponseDto lessonResponseDto : listResponse.getList()) {
            lessonIds.add(lessonResponseDto.getLessonId());
        }
        Map commentMap = this.lessonCommentService.getStudentLessonCommentMap(userId, (Collection)lessonIds);
        log.debug("respose list = {}", listResponse.getList());
        for (LessonResponseDto respDto : listResponse.getList()) {
            ClassLessonInfoDto classLessonInfoDto = new ClassLessonInfoDto();
            classLessonInfoDto.setLessonId(respDto.getLessonId());
            classLessonInfoDto.setIndex(Integer.valueOf(respDto.getIndex()));
            classLessonInfoDto.setStartTime(respDto.getLessonStartTime());
            classLessonInfoDto.setEndTime(respDto.getLessonEndTime());
            classLessonInfoDto.setHasComment((Boolean)commentMap.get(respDto.getLessonId()));
            classLessonInfoDto.setSignStatus(Integer.valueOf(respDto.getSignStatus()));
            classLessonInfoDto.setSignStatusStr(respDto.getSignStatusStr());
            classLessonInfoDto.setTeacherName(respDto.getTeacherName());
            classLessonInfoDto.setIsOver(Integer.valueOf(respDto.getIsOver()));
            classLessonInfoDto.setCourseName(respDto.getCourseName());
            classLessonInfoDto.setRoomName(respDto.getRoomName());
            dto.getLessons().add(classLessonInfoDto);
        }
        CourseListReponseDto courseListReponseDto = this.orgCourseService.getOrgBasicCourseInfo(orgId, courseId);
        if (courseListReponseDto != null) {
            dto.setCourseName(courseListReponseDto.getCourseName());
            dto.setCourseUrl(courseListReponseDto.getCoverUrl());
        }
        log.debug("dto = {}", (Object)dto);
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Object> buildStudentCommentDetail(Long orgId, Long lessonId, Long studentId, Integer userRole) {
        Long userId = this.orgStudentDao.getUserId(studentId);
        Preconditions.checkArgument((userId != null ? 1 : 0) != 0, (Object)"student not exists!");
        if (userRole == null) {
            userRole = UserRole.STUDENT.getRole();
        }
        CommentInfoDto commentInfoDto = this.lessonCommentService.getCommentDetail(lessonId, userId, orgId, userRole);
        log.debug("commentInfoDto = {}", (Object)commentInfoDto);
        HashMap map = Maps.newHashMap();
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        map.put("orgName", orgBaseInfoModel.getShortName());
        map.put("logo", orgBaseInfoModel.getLogo());
        map.put("courseName", commentInfoDto.getCourseName());
        List teacherIds = this.orgTeacherLessonDao.getUserIds(lessonId, orgId);
        TeacherResponseDto teacherResponseDto = null;
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && (teacherResponseDto = this.courseTeacherService.getTeacher((Long)teacherIds.get(0), orgId)) != null) {
            map.put("teacherName", teacherResponseDto.getTeacherName());
            map.put("avatarUrl", teacherResponseDto.getAvatar());
        }
        map.put("index", commentInfoDto.getIndex());
        map.put("startTime", commentInfoDto.getStartTime());
        map.put("endTime", commentInfoDto.getEndTime());
        map.put("score", commentInfoDto.getScore());
        map.put("content", commentInfoDto.getContent() == null ? "" : commentInfoDto.getContent());
        map.put("urls", commentInfoDto.getUrls() == null ? "" : commentInfoDto.getUrls());
        return map;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, Object> buildLessonInfo(Long orgId, Long lessonId, Long studentId) {
        Map map = this.orgCourseService.buildLessonInfo(orgId, lessonId, studentId);
        OrgBaseInfoModel orgBaseInfoModel = this.orgBaseService.getOrgBaseInfoModel(orgId);
        map.put("orgName", orgBaseInfoModel.getShortName());
        map.put("logo", orgBaseInfoModel.getLogo());
        return map;
    }
}

