/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.CourseListInfoDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseListService;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.beust.jcommander.internal.Lists;
import com.beust.jcommander.internal.Sets;
import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ErpCourseListServiceImpl
implements ErpCourseListService {
    private static final Logger log = LoggerFactory.getLogger(ErpCourseListServiceImpl.class);
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgCourseRoomDao orgCourseRoomDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private OrgLessonSignService orgLessonSignService;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    public List<CourseListInfoDto> getCourseList(Long orgId, Date startTime, Date endTime, String searchKey, String teacherIds, String roomIds, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        List courseIds = null;
        Set teacherIdSet = Sets.newHashSet();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{teacherIds})) {
            String[] arr;
            for (String str : arr = teacherIds.split(",")) {
                teacherIdSet.add(Long.parseLong(str));
            }
            courseIds = Lists.newArrayList();
            if (CollectionUtils.isNotEmpty((Collection)teacherIdSet)) {
                courseIds = this.orgCourseTeacherDao.getCourseIdsByteacherIds((Collection)teacherIdSet);
            }
        }
        List courses = this.orgCourseDao.getCourseList(orgNumber, courseIds, searchKey, null, startTime, endTime, pageDto, new String[0]);
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, true, Boolean.valueOf(true), true, false, true);
        List responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            responseDto.add(dto);
        }
        return responseDto;
    }

    @Override
    public List<CourseListInfoDto> getCourseListWithAttendanceRate(Long orgId, String searchKey, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        List courses = this.orgCourseDao.getCourseList(orgNumber, null, searchKey, null, null, null, pageDto, new String[0]);
        List<CourseListReponseDto> dtos = this.getCourseListWithAttendanceRate(courses, orgId);
        List responseDto = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : dtos) {
            CourseListInfoDto dto = new CourseListInfoDto();
            this.buildCourseListInfoDto(courseListReponseDto, dto);
            responseDto.add(dto);
        }
        return responseDto;
    }

    private List<CourseListReponseDto> getCourseListWithAttendanceRate(List<OrgCourse> courses, Long orgId) {
        log.info("courses={},orgId={}", courses, (Object)orgId);
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId not valid!");
        if (CollectionUtils.isEmpty(courses)) {
            return Collections.emptyList();
        }
        List dtos = this.orgCourseListService.getCourseList(courses, orgId, true, false, false, Boolean.valueOf(true), false, false, false);
        List courseIds = Lists.newArrayList();
        for (OrgCourse course : courses) {
            courseIds.add(course.getId());
        }
        Map rateMap = this.orgLessonSignService.getAttendanceRateOfCourses(orgId, (Collection)courseIds);
        for (CourseListReponseDto dto : dtos) {
            Long courseId = dto.getOrgCourseId();
            Double attendanceRate = (Double)rateMap.get(courseId);
            if (attendanceRate != null) {
                dto.setAttendanceRate(attendanceRate);
                continue;
            }
            dto.setAttendanceRate(Double.valueOf(0.0));
        }
        return dtos;
    }

    private void buildCourseListInfoDto(CourseListReponseDto courseListReponseDto, CourseListInfoDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setFreq(courseListReponseDto.getFreq());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setLessonFinish(courseListReponseDto.getLessonFinish());
        dto.setMaxStudent(courseListReponseDto.getMaxStudent());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setRoomCount(courseListReponseDto.getRoomCount());
        dto.setStartTime(courseListReponseDto.getStartTime());
        dto.setStudentCount(courseListReponseDto.getStudentCount());
        dto.setTeacherCount(courseListReponseDto.getTeacherCount());
        dto.setAttendanceRate(courseListReponseDto.getAttendanceRate());
    }

    @Override
    public CourseListInfoDto getCourseDetail(Long orgId, Long orgCourseId) {
        CourseListReponseDto dto = this.orgCourseListService.getCourseDetail(orgId, orgCourseId);
        CourseListInfoDto courseListInfoDto = new CourseListInfoDto();
        this.buildCourseListInfoDto(dto, courseListInfoDto);
        return courseListInfoDto;
    }
}

