/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.EditLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.CommentStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.beust.jcommander.internal.Lists;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseLessonServiceImpl
implements CourseLessonService {
    private static final Logger log = LoggerFactory.getLogger(CourseLessonServiceImpl.class);
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private CourseTeacherService courseTeacherService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((startDay != null ? 1 : 0) != 0, (Object)"start day can not be null");
        Preconditions.checkArgument((dto != null ? 1 : 0) != 0, (Object)"class lessons param is illegal");
        Preconditions.checkArgument((dto.getCourseId() != null && dto.getCourseId() > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        List<Calendar> calens = dto.getRepeatUnit().getAvaliableDays(startDay, dto.getRepeatCount(), dto.getRepeatRange());
        TimeStamp startTime = TimeStamp.parse((String)dto.getStartTime());
        TimeStamp endTime = TimeStamp.parse((String)dto.getEndTime());
        OrgClassLesson lesson = null;
        List lessons = Lists.newArrayList();
        int index = 1;
        for (Calendar cal : calens) {
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            lesson = new OrgClassLesson();
            lesson.setStartTime(lessonTime.getStartTime());
            lesson.setEndTime(lessonTime.getEndTime());
            lesson.setCourseId(dto.getCourseId());
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            lesson.setLayoutId(Long.valueOf(0L));
            lesson.setRoomId(Long.valueOf(dto.getRoomId() != null ? dto.getRoomId() : 0L));
            lesson.setUpdateTime(new Date());
            lesson.setNumber(Integer.valueOf(index));
            lesson.setOrgId(orgId);
            lessons.add(lesson);
            ++index;
        }
        log.info("save {} lessons into db,params:{}", (Object)lessons.size(), (Object)dto);
        this.orgClassLessonDao.saveAll(lessons, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId"});
        this.resetLessonNumber(orgId, dto.getCourseId());
        for (OrgClassLesson classLesson : lessons) {
            this.courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), dto.getStudentIds(), true);
            HashSet teacherIds = Sets.newHashSet();
            if (dto.getTeacherId() == null || dto.getTeacherId() <= 0L) continue;
            teacherIds.add(dto.getTeacherId());
            this.courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), (Collection)teacherIds);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        HashMap<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Object, Object> courseMap = Maps.newHashMap();
            if (params.isNeedcourseName()) {
                courseMap = this.getOrgCourseMap(orgId, courseIds);
            }
            Map<Object, Object> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = this.getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Object, Object> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = this.getOrgClassRoomMap(roomIds);
            }
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    private Map<Long, String> getLessonIdTeacherName(Long orgId, Collection<Long> lessonIds, Map<Long, Long> lessonTeacherIdMap) {
        if (MapUtils.isEmpty(lessonTeacherIdMap)) {
            lessonTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        }
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        HashMap<Long, String> lessonIdTeacherNameMap = new HashMap<Long, String>(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, (String)teacherNameMap.get(lessonTeacherIdMap.get(lessonId)));
        }
        return lessonIdTeacherNameMap;
    }

    private List<OrgClassLesson> queryLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap, ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet teacherIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(this.courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return Collections.emptyList();
            }
        }
        lessonIdTeacherIdMap = this.queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());
        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)courseIds, (Collection)roomIds, (Collection)lessonIds, startTime, endTime, params.getPageDto(), new String[0]);
        return lessons;
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((params.getStartTime() != null && params.getEndTime() != null ? 1 : 0) != 0, (Object)"start time or end time is null");
        Preconditions.checkArgument((boolean)params.getEndTime().after(params.getStartTime()), (Object)"time condition error");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, false);
        if (CollectionUtils.isNotEmpty(lessons)) {
            HashSet lessonIds = Sets.newHashSet();
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            if (lessonIdTeacherIdMap.isEmpty()) {
                lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
                log.debug("query lessonId teacherId map:{}by lessonIds:{}", lessonIdTeacherIdMap, (Object)lessonIds);
            }
            Map<Long, OrgCourse> courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonIdTeacherIdMap.values());
            Map<Long, OrgClassRoom> classRoomMap = this.getOrgClassRoomMap(roomIds);
            List result = Lists.newArrayList();
            for (OrgClassLesson lesson : lessons) {
                Long teacherId = lessonIdTeacherIdMap.get(lesson.getId());
                LessonTimeTableResponseDto dto = this.buildTimeTableDto(lesson, courseMap.get(lesson.getCourseId()), classRoomMap.get(lesson.getRoomId()), teacherId, (String)teacherNameMap.get(teacherId));
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Map<Long, OrgClassRoom> getOrgClassRoomMap(Collection<Long> roomIds) {
        List classRooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"id", "roomName", "roomSize"});
        return CollectorUtil.collectMap((Collection)classRooms, (Function)new Function<OrgClassRoom, Long>(){

            public Long apply(OrgClassRoom input) {
                return input.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getOrgCourseMap(Long orgId, Collection<Long> courseIds) {
        List courseList = this.orgCourseDao.getByIds(courseIds, new String[]{"id", "cover", "name", "color"});
        this.orgCourseListService.getCourseList(courseList, orgId, false, false, false, Boolean.valueOf(false), false, false, false);
        return CollectorUtil.collectMap((Collection)courseList, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
    }

    private LessonTimeTableResponseDto buildTimeTableDto(OrgClassLesson lesson, OrgCourse course, OrgClassRoom classRoom, Long teacherId, String teacherName) {
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        dto.setCourseId(lesson.getCourseId());
        if (course != null) {
            dto.setCourseColor(course.getColor());
            dto.setCourseName(course.getName());
        }
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setLessonId(lesson.getId());
        dto.setIndex(lesson.getNumber());
        dto.setRoomId(lesson.getRoomId());
        if (classRoom != null) {
            dto.setRoomName(classRoom.getRoomName());
        }
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        dto.setTeacherId(teacherId);
        dto.setTeacherName(teacherName);
        return dto;
    }

    private ListLessonResponseDto buildListLessonResponseDto(List<OrgClassLesson> lessons, Map<Long, OrgCourse> courseMap, Map<Long, String> lessonIdTeacherNameMap, Map<Long, OrgClassRoom> classRoomMap, Map<Long, Integer> studentCountMap, Map<Long, Integer> signStudentCountMap, Map<Long, Integer> commentCount, Map<Long, Integer> lessonSignStatus) {
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Date now = new Date();
            for (OrgClassLesson lesson : lessons) {
                if (result.getFirstLessonStartTime() == null || result.getFirstLessonStartTime().after(lesson.getStartTime())) {
                    result.setFirstLessonStartTime(lesson.getStartTime());
                }
                if (result.getLastLessonStartTime() == null || result.getLastLessonStartTime().before(lesson.getStartTime())) {
                    result.setLastLessonStartTime(lesson.getStartTime());
                }
                LessonResponseDto dto = new LessonResponseDto();
                dto.setCourseId(lesson.getCourseId());
                dto.setIndex(lesson.getNumber());
                OrgCourse course = courseMap.get(lesson.getCourseId());
                if (course != null) {
                    dto.setCourseName(course.getName());
                }
                OrgClassRoom classRoom = classRoomMap.get(lesson.getRoomId());
                dto.setRoomId(lesson.getRoomId());
                if (classRoom != null) {
                    dto.setRoomName(classRoom.getRoomName());
                }
                dto.setTeacherName(lessonIdTeacherNameMap.get(lesson.getId()));
                dto.setLessonEndTime(lesson.getEndTime());
                dto.setLessonId(lesson.getId());
                dto.setLessonStartTime(lesson.getStartTime());
                CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
                if (now.after(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.NO_SIGN;
                    dto.setIsOver(1);
                }
                if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.SIGNING;
                }
                Integer signCount = signStudentCountMap.get(lesson.getId());
                SignStatus stuSignStatus = SignStatus.getSignStatusByCode((Integer)lessonSignStatus.get(lesson.getId()));
                if (stuSignStatus != null) {
                    log.debug("lessonId:{},lessonSignStatus:{},status:{}", new Object[]{lesson.getId(), lessonSignStatus, stuSignStatus});
                    dto.setSignStatusEnum(stuSignStatus);
                } else {
                    if (signCount != null && signCount > 0) {
                        signStatus = CourseSignStatus.SIGNED;
                    }
                    dto.setCourseSignStatusEnum(signStatus);
                }
                Integer commentCnt = commentCount.get(lesson.getId());
                if (commentCnt != null && commentCnt > 0) {
                    dto.setCommentEnum(CommentStatus.COMMENTED);
                } else {
                    dto.setCommentEnum(CommentStatus.getCommentStatusByTime((Date)lesson.getStartTime(), (Date)lesson.getEndTime(), (boolean)true));
                }
                Integer studentCount = studentCountMap.get(lesson.getId());
                dto.setSignCount(signCount != null ? signCount : 0);
                dto.setStudentCount(studentCount != null ? studentCount : 0);
                result.getList().add(dto);
            }
        }
        return result;
    }

    private Map<Long, Long> queryLessonIdByTeacherId(Long orgId, Collection<Long> teacherIds) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Collections.emptyMap();
        }
        List teacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, new String[]{"lessonId", "teacherId"});
        if (CollectionUtils.isNotEmpty((Collection)teacherLessons)) {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            for (OrgTeacherLesson orgTeacherLesson : teacherLessons) {
                result.put(orgTeacherLesson.getLessonId(), orgTeacherLesson.getTeacherId());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Date now = new Date();
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[]{"id", "name", "color"});
        if (course == null) {
            log.warn("can not found course by lesson:{}", (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u73ed\u7ea7");
        }
        dto.setCourseColor(course.getColor());
        dto.setCourseId(course.getId());
        dto.setCourseName(course.getName());
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setIndex(lesson.getNumber());
        dto.setLessonId(lesson.getId());
        CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
        if (now.after(lesson.getStartTime())) {
            signStatus = CourseSignStatus.NO_SIGN;
            if (now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
        }
        dto.setRoomId(lesson.getRoomId());
        dto.setSignStatusEnum(signStatus);
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign) {
        LessonTimeTableResponseDto dto = this.lessonInfo(orgId, lessonId);
        dto.setStudents(this.courseStudentService.getLessonStudent(orgId, lessonId, needStudentSign));
        List teacherDtos = this.courseTeacherService.getLessonTeacher(orgId, lessonId);
        if (CollectionUtils.isNotEmpty((Collection)teacherDtos)) {
            TeacherResponseDto teacherDto = (TeacherResponseDto)teacherDtos.get(0);
            dto.setTeacherId(teacherDto.getTeacherId());
            dto.setTeacherName(teacherDto.getTeacherName());
        }
        if (dto.getRoomId() != null && dto.getRoomId() > 0L) {
            OrgClassRoom classRoom = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)dto.getRoomId(), new String[]{"id", "roomName"});
            dto.setRoomName(classRoom.getRoomName());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonCommentDao.getLessonComments(lessonId, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_SIGN);
        }
        this.courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        this.courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);
        this.orgClassLessonDao.delById((Serializable)lessonId);
        this.resetLessonNumber(orgId, lesson.getCourseId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editLesson(Long orgId, EditLessonRequestDto editDto) {
        Preconditions.checkNotNull((Object)editDto, (Object)"param can not be null");
        editDto.validate();
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)editDto.getLessonId(), new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)editDto.getLessonId(), (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        boolean needRearrange = false;
        if (!editDto.getEndTime().equals(lesson.getEndTime()) || !editDto.getStartTime().equals(lesson.getStartTime())) {
            lesson.setEndTime(editDto.getEndTime());
            lesson.setStartTime(editDto.getStartTime());
            needRearrange = true;
        }
        List teacherIds = Lists.newArrayList();
        if (editDto.getRoomId() == null) {
            editDto.setRoomId(0L);
        }
        if (editDto.getTeacherId() == null) {
            editDto.setTeacherId(0L);
        } else {
            teacherIds.add(editDto.getTeacherId());
        }
        lesson.setRoomId(editDto.getRoomId());
        lesson.setUpdateTime(new Date());
        this.orgClassLessonDao.update((Object)lesson, new String[0]);
        if (needRearrange) {
            this.resetLessonNumber(orgId, lesson.getCourseId());
        }
        this.courseTeacherService.resetLessonTeacher(orgId, lesson.getCourseId(), lesson.getId(), (Collection)teacherIds);
    }

    private void resetLessonNumber(Long orgId, Long courseId) {
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), null, null, null, null, null, new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            int index = 1;
            Map[] params = new Map[lessons.size()];
            for (OrgClassLesson lesson : lessons) {
                HashMap<String, Number> param = new HashMap<String, Number>();
                param.put("id", lesson.getId());
                param.put("number", index);
                params[index - 1] = param;
                ++index;
            }
            this.orgClassLessonDao.batchUpdateLessonNumber(params);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Long getTeacherId(Long orgId, Long lessonId) {
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        if (teacherLesson != null) {
            return teacherLesson.getTeacherId();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        return this.orgStudentLessonDao.getUserIdsByLessonIds(orgId, lessonIds);
    }
}

