/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.CourseSigninRecordDto;
import com.baijia.tianxiao.biz.erp.dto.CourseSigninStsDto;
import com.baijia.tianxiao.biz.erp.dto.request.FastSignInLesssonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.FastSignInViewCourseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.StudentSigninRecordDto;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.service.ErpSignInService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.dal.course.po.OrgCoursePhoto;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseConsumeRule;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.enums.CourseConsumeRuleEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgCourseConsumeRuleService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="erpSignInService")
public class ErpSignInServiceImpl
implements ErpSignInService {
    private static final Logger log = LoggerFactory.getLogger(ErpSignInServiceImpl.class);
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private CourseLessonService courseLessonService;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgCourseConsumeRuleService orgCourseConsumeRuleService;

    @Override
    public FastSignInViewCourseDto getSignInCourseInfo(Long orgId, Long courseId) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (course != null) {
            ArrayList<OrgCourse> list = new ArrayList<OrgCourse>();
            list.add(course);
            List<FastSignInViewCourseDto> dtoList = this.getSignInCourseInfoList(orgId, list);
            if (dtoList.size() > 0) {
                return dtoList.get(0);
            }
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0bid\u65e0\u6548");
    }

    private List<OrgLessonSign> queryEfectLessonSignBatch(List<Long> courseIds) {
        List list = this.orgLessonSignDao.getCourseLessonSignIn(courseIds);
        return list;
    }

    private Map<Long, Integer> findCourseLessonSignInCountMap(List<OrgLessonSign> list) {
        HashMap map = Maps.newHashMap();
        HashSet<Long> lessonSet = new HashSet<Long>();
        for (OrgLessonSign orgLessonSign : list) {
            if (orgLessonSign.getStatus() == null || orgLessonSign.getStatus() <= 0) continue;
            Long courseId = orgLessonSign.getCourseId();
            Long lessonId = orgLessonSign.getLessonId();
            if (lessonSet.contains(lessonId)) continue;
            lessonSet.add(lessonId);
            Integer count = (Integer)map.get(courseId);
            if (count == null) {
                count = new Integer(0);
                map.put(courseId, count);
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            map.put(courseId, count);
        }
        return map;
    }

    private Map<Long, Integer> findLessonSignInCountMap(List<OrgLessonSign> list) {
        HashMap map = Maps.newHashMap();
        for (OrgLessonSign orgLessonSign : list) {
            if (orgLessonSign.getStatus() == null || orgLessonSign.getStatus() <= 0) continue;
            Long lessonId = orgLessonSign.getLessonId();
            Integer count = (Integer)map.get(lessonId);
            if (count == null) {
                count = new Integer(0);
                map.put(lessonId, count);
            }
            Integer n = count;
            Integer n2 = count = Integer.valueOf(count + 1);
            map.put(lessonId, count);
        }
        return map;
    }

    @Override
    public List<FastSignInViewCourseDto> getSignInCourseInfoList(Long orgId, List<OrgCourse> orgCourseList) {
        ArrayList dtoList = Lists.newArrayList();
        HashSet courseIdSet = Sets.newHashSet();
        for (OrgCourse couse : orgCourseList) {
            courseIdSet.add(couse.getId());
        }
        ArrayList<Long> courseIds = new ArrayList<Long>(courseIdSet);
        Map coverMap = this.orgCourseListService.getCoverMap(orgCourseList);
        Map coursePhotoMap = this.orgCourseListService.getPhoteMap(courseIds);
        Map studentCountMap = this.courseStudentService.getCourseStudentCntMap(orgId, courseIds, Boolean.valueOf(false));
        List<OrgLessonSign> signList = this.queryEfectLessonSignBatch(courseIds);
        Map<Long, Integer> courseLessonSignInCount = this.findCourseLessonSignInCountMap(signList);
        for (OrgCourse course : orgCourseList) {
            FastSignInViewCourseDto dto = new FastSignInViewCourseDto();
            dto.setOrgCourseId(course.getId());
            dto.setCourseName(course.getName());
            dto.setCourseCount(course.getFreq());
            dto.setMaxStudent(course.getMaxStudent());
            dto.setStudentCount((Integer)studentCountMap.get(course.getId()));
            Integer signCount = courseLessonSignInCount.get(course.getId());
            dto.setSignCount(signCount);
            dto.setCoverUrl((String)coverMap.get(course.getCover()));
            OrgCoursePhoto coursePhoto = (OrgCoursePhoto)coursePhotoMap.get(course.getId());
            if (coursePhoto != null && StringUtils.isNotBlank((CharSequence)coursePhoto.getCutUrl())) {
                dto.setCoverUrl(coursePhoto.getCutUrl());
            }
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> batchCreateLessonsAndSignIn(FastSignInLesssonsRequestDto dto) {
        List<Long> lessonIds = this.courseLessonService.addClassLessonsBatchForFastSignIn(dto.getOrgId(), dto.getCourseId(), dto.getLessonTimes(), dto.getStudentSignStatusMap().keySet());
        if (lessonIds == null || lessonIds.size() != dto.getLessonTimes().intValue()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65b0\u5efa\u8bfe\u8282\u6570\u76ee\u4e0d\u5339\u914d");
        }
        this.orgLessonSignService.orgStudentLessonBatchFastSign(dto.getOrgId(), dto.getCourseId(), lessonIds, dto.getStudentSignStatusMap());
        return lessonIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<LessonResponseDto> getCourseLessonSignInRecord(Long orgId, Long courseId) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (course == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0bid\u65e0\u6548");
        }
        ArrayList<Long> courseIds = new ArrayList<Long>();
        courseIds.add(courseId);
        List lessonList = this.orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null, new String[0]);
        List<LessonResponseDto> lessonResponList = this.courseLessonService.buildLessonBaseInfoList(orgId, courseId, lessonList);
        List<OrgLessonSign> signList = this.queryEfectLessonSignBatch(courseIds);
        Map<Long, Integer> courseLessonSignInCount = this.findLessonSignInCountMap(signList);
        ArrayList lessonIds = Lists.newArrayList();
        for (OrgClassLesson lesson : lessonList) {
            lessonIds.add(lesson.getId());
        }
        Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
        for (LessonResponseDto dto : lessonResponList) {
            Long lessonId = dto.getLessonId();
            Integer signCount = courseLessonSignInCount.get(lessonId);
            Integer studentCount = (Integer)studentCountMap.get(lessonId);
            dto.setSignCount(signCount != null ? signCount : 0);
            dto.setStudentCount(studentCount != null ? studentCount : 0);
        }
        return lessonResponList;
    }

    private Map<Integer, String> getCoverMap(List<OrgCourse> courses) {
        Collection coverList = CollectorUtil.collect(courses, (Function)new Function<OrgCourse, Integer>(){

            public Integer apply(OrgCourse arg0) {
                return arg0.getCover();
            }
        });
        List storages = this.storageDao.getByIds(coverList, new String[0]);
        return CollectorUtil.collectMap((Collection)storages, (Function)new Function<Storage, Integer>(){

            public Integer apply(Storage arg0) {
                return arg0.getId().intValue();
            }
        }, (Function)new Function<Storage, String>(){

            public String apply(Storage arg0) {
                if (StringUtils.isNotBlank((CharSequence)arg0.getAttach_url())) {
                    return arg0.getAttach_url();
                }
                return StorageUtil.constructUrl((Long)arg0.getFid(), (String)arg0.getMimetype(), (String)arg0.getSn());
            }
        });
    }

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    public List<FastSignInViewCourseDto> getCourseInfo(Long orgId, String searchName, Integer limit) {
        log.info("searchName = {}", (Object)searchName);
        Preconditions.checkArgument((searchName != null && !searchName.isEmpty() ? 1 : 0) != 0, (Object)"orgId invalid!");
        Long orgNumber = this.getOrgNumber(orgId);
        List courseIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                log.debug("user cascadeId={},courseIds={}", (Object)TianxiaoMContext.getTXCascadeId(), (Object)tempIds);
                log.debug("after set courseIds:{}", courseIds);
                if (CollectionUtils.isEmpty((Collection)tempIds)) {
                    return Collections.EMPTY_LIST;
                }
                courseIds = tempIds;
            }
        }
        List orgCourseList = this.orgCourseDao.getCourseByOrgNumberAndCourseName(orgNumber, searchName, null, courseIds, limit);
        List<FastSignInViewCourseDto> fastSignViewCourseDtoList = this.getSignInCourseInfoList(orgId, orgCourseList);
        return fastSignViewCourseDtoList;
    }

    @Override
    public List<FastSignInViewCourseDto> getStudentInfo(Long orgId, String searchName, Integer limit) {
        Long orgNumber = this.getOrgNumber(orgId);
        List orgStudents = this.orgStudentDao.getStudentByOrgIdAndCourseName(orgId, searchName);
        HashSet orgStudentCoursesIds = Sets.newHashSet();
        HashSet userIds = Sets.newHashSet();
        for (OrgStudent orgStudent : orgStudents) {
            userIds.add(orgStudent.getUserId());
        }
        List orgStudentCourses = null;
        if (userIds.size() > 0) {
            orgStudentCourses = this.orgStudentCourseDao.getOrgStudentCourseByUserIds(orgId, (Collection)userIds);
            userIds.removeAll(userIds);
            for (int j = 0; j < orgStudentCourses.size(); ++j) {
                userIds.add(((OrgStudentCourse)orgStudentCourses.get(j)).getUserId());
                orgStudentCoursesIds.add(((OrgStudentCourse)orgStudentCourses.get(j)).getCourseId());
            }
        }
        List courseIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                log.debug("user cascadeId={},courseIds={}", (Object)TianxiaoMContext.getTXCascadeId(), (Object)tempIds);
                if (CollectionUtils.isEmpty((Collection)tempIds)) {
                    return Collections.EMPTY_LIST;
                }
                courseIds = tempIds;
            }
        }
        if (courseIds != null) {
            orgStudentCoursesIds.retainAll(courseIds);
        }
        Map courseStudentUserIdMap = this.orgStudentCourseDao.getStudentIdMapBycourseIdsNoStatus((Collection)orgStudentCoursesIds, orgId);
        ArrayList orgIds = Lists.newArrayList();
        orgIds.add(orgId);
        List orgStudentsList = this.orgStudentDao.getStudentsByUserIdsAndOrgIds((Collection)orgIds, (Collection)userIds);
        HashMap orgStudentsMap = Maps.newHashMap();
        HashMap courseStudentNameMap = Maps.newHashMap();
        for (OrgStudent stu : orgStudentsList) {
            orgStudentsMap.put(stu.getUserId(), stu.getName());
        }
        for (Long courseId : orgStudentCoursesIds) {
            List courseUserIds = (List)courseStudentUserIdMap.get(courseId);
            ArrayList tempUserIds = new ArrayList(courseUserIds);
            tempUserIds.retainAll(userIds);
            ArrayList studentNameList = Lists.newArrayList();
            for (Long userId : tempUserIds) {
                String name = (String)orgStudentsMap.get(userId);
                if (!StringUtils.isNotBlank((CharSequence)name)) continue;
                studentNameList.add(name);
            }
            courseStudentNameMap.put(courseId, studentNameList);
        }
        List orgCourseList = Lists.newArrayList();
        if (orgStudentCoursesIds.size() > 0) {
            orgCourseList = this.orgCourseDao.getCourseByOrgNumberAndCourseName(orgNumber, null, null, (Collection)orgStudentCoursesIds, limit);
        }
        List<FastSignInViewCourseDto> fastSignViewCourseDtoList = this.getSignInCourseInfoList(orgId, orgCourseList);
        for (FastSignInViewCourseDto dto : fastSignViewCourseDtoList) {
            Long courseId = dto.getOrgCourseId();
            List studentNameList = (List)courseStudentNameMap.get(courseId);
            dto.setStudentNames(studentNameList);
        }
        return fastSignViewCourseDtoList;
    }

    @Override
    public CourseSigninStsDto queryCourseStudentSignInInfoDto(Long orgId, Long courseId) {
        CourseSigninStsDto.StudentSigninSts sts;
        Long userId;
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (course == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0bid\u65e0\u6548");
        }
        ArrayList<Long> courseIds = new ArrayList<Long>();
        courseIds.add(courseId);
        List lessonList = this.orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null, new String[0]);
        List<LessonResponseDto> lessonResponList = this.courseLessonService.buildLessonBaseInfoList(orgId, courseId, lessonList);
        List userIds = this.courseStudentService.getCourseStudentUserIds(orgId, courseId);
        Map studentMap = this.orgStudentDao.getStudentMap((Collection)userIds, orgId);
        List<OrgLessonSign> signList = this.queryEfectLessonSignBatch(courseIds);
        CourseSigninStsDto dto = new CourseSigninStsDto();
        dto.setCourseId(courseId);
        dto.setPlanNum(course.getFreq());
        dto.setCourseName(course.getName());
        dto.setLessonCourseList(lessonResponList);
        dto.setLessonNum(lessonResponList.size());
        ArrayList<CourseSigninStsDto.StudentSigninSts> studentSigninStsList = new ArrayList<CourseSigninStsDto.StudentSigninSts>();
        dto.setStudentSigninStsList(studentSigninStsList);
        HashMap<Long, CourseSigninStsDto.StudentSigninSts> studentSigninCountMap = new HashMap<Long, CourseSigninStsDto.StudentSigninSts>();
        HashMap<String, Integer> studentSignStatusMap = new HashMap<String, Integer>();
        dto.setSignInStatusMap(studentSignStatusMap);
        for (OrgLessonSign lessonSign : signList) {
            studentSignStatusMap.put(lessonSign.getLessonId() + "|" + lessonSign.getUserId(), lessonSign.getStatus());
            userId = lessonSign.getUserId();
            sts = (CourseSigninStsDto.StudentSigninSts)studentSigninCountMap.get(userId);
            if (sts == null) {
                sts = new CourseSigninStsDto.StudentSigninSts();
                sts.setUserId(userId);
                studentSigninCountMap.put(userId, sts);
            }
            if (lessonSign.getStatus() == 1) {
                sts.setSignedCount(sts.getSignedCount() + 1);
                sts.setSignCount(sts.getSignCount() + 1);
                continue;
            }
            if (lessonSign.getStatus() == 2) {
                sts.setLeaveCount(sts.getLeaveCount() + 1);
                sts.setSignCount(sts.getSignCount() + 1);
                continue;
            }
            if (lessonSign.getStatus() != 3) continue;
            sts.setAbsentCount(sts.getAbsentCount() + 1);
            sts.setSignCount(sts.getSignCount() + 1);
        }
        for (OrgStudent orgStudent : studentMap.values()) {
            userId = orgStudent.getUserId();
            sts = (CourseSigninStsDto.StudentSigninSts)studentSigninCountMap.get(userId);
            if (sts != null) {
                sts.setStudentName(orgStudent.getName());
            } else {
                sts = new CourseSigninStsDto.StudentSigninSts();
                sts.setUserId(userId);
                sts.setStudentName(orgStudent.getName());
            }
            studentSigninStsList.add(sts);
        }
        return dto;
    }

    @Override
    public CourseSigninRecordDto queryCourseStudentSignInDetailsDto(Long orgId, Long courseId) {
        Long userId;
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (course == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0bid\u65e0\u6548");
        }
        ArrayList<Long> courseIds = new ArrayList<Long>();
        courseIds.add(courseId);
        List lessonList = this.orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null, new String[0]);
        List<LessonResponseDto> lessonResponList = this.courseLessonService.buildLessonBaseInfoList(orgId, courseId, lessonList);
        ArrayList<Long> lessonIds = new ArrayList<Long>();
        for (LessonResponseDto lesson : lessonResponList) {
            lessonIds.add(lesson.getLessonId());
        }
        List userIds = this.courseStudentService.getCourseStudentUserIds(orgId, courseId);
        Map studentMap = this.orgStudentDao.getStudentMap((Collection)userIds, orgId);
        List<OrgLessonSign> signList = this.queryEfectLessonSignBatch(courseIds);
        CourseSigninRecordDto dto = new CourseSigninRecordDto();
        dto.setCourseId(courseId);
        dto.setCourseName(course.getName());
        dto.setPlanNum(course.getFreq());
        dto.setLessonCourseList(lessonResponList);
        dto.setLessonNum(lessonResponList.size());
        ArrayList<CourseSigninRecordDto.StudentSigninRecord> studentSigninRecordList = new ArrayList<CourseSigninRecordDto.StudentSigninRecord>();
        dto.setStudentSigninRecordList(studentSigninRecordList);
        HashMap<Long, CourseSigninRecordDto.StudentSigninRecord> studentSigninCountMap = new HashMap<Long, CourseSigninRecordDto.StudentSigninRecord>();
        HashMap<String, Integer> studentSignStatusMap = new HashMap<String, Integer>();
        dto.setSignInStatusMap(studentSignStatusMap);
        HashSet studentLessonSet = Sets.newHashSet();
        dto.setStudentLessonSet(studentLessonSet);
        Map userIdsLessonMap = this.orgStudentLessonDao.getLessonIdsOfStudents(orgId, (Collection)userIds, lessonIds);
        for (Long userId2 : userIdsLessonMap.keySet()) {
            List lessons = (List)userIdsLessonMap.get(userId2);
            for (Long lessonId : lessons) {
                studentLessonSet.add(String.valueOf(lessonId + "|" + userId2));
            }
        }
        for (OrgLessonSign lessonSign : signList) {
            studentSignStatusMap.put(lessonSign.getLessonId() + "|" + lessonSign.getUserId(), lessonSign.getStatus());
            userId = lessonSign.getUserId();
            CourseSigninRecordDto.StudentSigninRecord sts = (CourseSigninRecordDto.StudentSigninRecord)studentSigninCountMap.get(userId);
            if (sts == null) {
                sts = new CourseSigninRecordDto.StudentSigninRecord();
                sts.setUserId(userId);
                studentSigninCountMap.put(userId, sts);
            }
            if (lessonSign.getStatus() == 1) {
                sts.setSignedCount(sts.getSignedCount() + 1);
                sts.setSignCount(sts.getSignCount() + 1);
                continue;
            }
            if (lessonSign.getStatus() == 2) {
                sts.setLeaveCount(sts.getLeaveCount() + 1);
                sts.setSignCount(sts.getSignCount() + 1);
                continue;
            }
            if (lessonSign.getStatus() != 3) continue;
            sts.setAbsentCount(sts.getAbsentCount() + 1);
            sts.setSignCount(sts.getSignCount() + 1);
        }
        for (OrgStudent orgStudent : studentMap.values()) {
            userId = orgStudent.getUserId();
            CourseSigninRecordDto.StudentSigninRecord ssr = (CourseSigninRecordDto.StudentSigninRecord)studentSigninCountMap.get(userId);
            if (ssr != null) {
                ssr.setStudentName(orgStudent.getName());
            } else {
                ssr = new CourseSigninRecordDto.StudentSigninRecord();
                ssr.setUserId(userId);
                ssr.setStudentName(orgStudent.getName());
            }
            studentSigninRecordList.add(ssr);
        }
        return dto;
    }

    private Map<Long, List<OrgLessonSign>> getUserIdLessonSignMap(List<OrgLessonSign> signList) {
        return CollectorUtil.group(signList, (Function)new Function<OrgLessonSign, Long>(){

            public Long apply(OrgLessonSign arg0) {
                return arg0.getUserId();
            }
        }, (Function)new Function<OrgLessonSign, OrgLessonSign>(){

            public OrgLessonSign apply(OrgLessonSign arg0) {
                return arg0;
            }
        });
    }

    private Map<Long, Integer> toLessonSignMap(List<OrgLessonSign> signList) {
        HashMap lessonSignMap = Maps.newHashMap();
        if (CollectionUtils.isEmpty(signList)) {
            return Collections.emptyMap();
        }
        for (OrgLessonSign sign : signList) {
            lessonSignMap.put(sign.getLessonId(), sign.getStatus());
        }
        return lessonSignMap;
    }

    @Override
    public StudentSigninRecordDto queryStudentSignInDetailsDto(Long orgId, Long studentId) {
        OrgStudent student = this.orgStudentDao.getStudentByUserId(orgId, studentId, new String[0]);
        if (student == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b66\u751fid\u65e0\u6548");
        }
        StudentSigninRecordDto dto = new StudentSigninRecordDto();
        dto.setStudentId(studentId);
        dto.setStudentName(student.getName());
        Long userId = student.getUserId();
        ArrayList userIds = Lists.newArrayList();
        userIds.add(userId);
        List orgStudentCourses = this.orgStudentCourseDao.getStudentListByStudentId(studentId, new String[0]);
        ArrayList<Long> courseIds = new ArrayList<Long>();
        for (OrgStudentCourse orgStudentCourse : orgStudentCourses) {
            courseIds.add(orgStudentCourse.getCourseId());
        }
        Map courseIdNameMap = this.orgCourseDao.getOrgCourseMap(courseIds);
        List lessonList = this.orgClassLessonDao.queryLessons(orgId, courseIds, null, null, null, null, null, new String[0]);
        HashMap<Long, List> lessonCourseListMap = new HashMap<Long, List>();
        ArrayList<Long> lessonIds = new ArrayList<Long>();
        for (OrgClassLesson lesson : lessonList) {
            Long lessonId = lesson.getId();
            lessonIds.add(lessonId);
            Long courseId = lesson.getCourseId();
            Object courseLessonList = (List)lessonCourseListMap.get(courseId);
            if (courseLessonList == null) {
                courseLessonList = Lists.newArrayList();
                lessonCourseListMap.put(courseId, (List)courseLessonList);
            }
            LessonResponseDto lessonDto = new LessonResponseDto();
            lessonDto.setCourseId(lesson.getCourseId());
            lessonDto.setLessonId(lesson.getId());
            lessonDto.setIndex(lesson.getNumber());
            lessonDto.setLessonStartTime(lesson.getStartTime());
            lessonDto.setLessonEndTime(lesson.getEndTime());
            courseLessonList.add(lessonDto);
        }
        List lessonSignList = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), lessonIds, new String[]{"lessonId", "updateTime", "status"});
        HashMap<String, OrgLessonSign> studentSignStatusMap = new HashMap<String, OrgLessonSign>();
        for (OrgLessonSign lessonSign : lessonSignList) {
            studentSignStatusMap.put(lessonSign.getLessonId() + "|" + lessonSign.getUserId(), lessonSign);
        }
        HashSet studentLessonSet = Sets.newHashSet();
        Map userIdsLessonMap = this.orgStudentLessonDao.getLessonIdsOfStudents(orgId, (Collection)userIds, lessonIds);
        for (Long tempuserId : userIdsLessonMap.keySet()) {
            List lessons = (List)userIdsLessonMap.get(tempuserId);
            for (Long lessonId : lessons) {
                String tempKey = String.valueOf(lessonId + "|" + tempuserId);
                studentLessonSet.add(tempKey);
            }
        }
        ArrayList courseSigninResultList = Lists.newArrayList();
        dto.setCourseSigninResultList(courseSigninResultList);
        Date now = new Date();
        HashMap<Long, List<LessonResponseDto>> lessonCourseListMapNew = new HashMap<Long, List<LessonResponseDto>>();
        dto.setLessonCourseListMap(lessonCourseListMapNew);
        for (Long courseId : lessonCourseListMap.keySet()) {
            ArrayList<LessonResponseDto> tempLessonDtoList = new ArrayList<LessonResponseDto>();
            lessonCourseListMapNew.put(courseId, tempLessonDtoList);
            OrgCourseConsumeRule rule = this.orgCourseConsumeRuleService.getRuleByCourseId(orgId, courseId);
            StudentSigninRecordDto.CourseSigninResult signinResult = new StudentSigninRecordDto.CourseSigninResult();
            courseSigninResultList.add(signinResult);
            OrgCourse course = (OrgCourse)courseIdNameMap.get(courseId);
            signinResult.setCourseId(courseId);
            signinResult.setCourseName(course.getName());
            signinResult.setPlanCount(course.getFreq());
            signinResult.setCourseConsumeRuleStr(rule.getRuleDesc());
            signinResult.setCourseConsumeRuleValue(rule.getRuleValue());
            boolean timeEndConsume = false;
            if (signinResult.getCourseConsumeRuleValue() == null || signinResult.getCourseConsumeRuleValue() == 0) {
                timeEndConsume = true;
            }
            int arrangeCount = 0;
            int signedCount = 0;
            int leaveCount = 0;
            int absentCount = 0;
            int endCount = 0;
            for (LessonResponseDto lesson : (List)lessonCourseListMap.get(courseId)) {
                boolean consumed;
                String tempKey = String.valueOf(lesson.getLessonId() + "|" + userId);
                if (!studentLessonSet.contains(tempKey)) continue;
                tempLessonDtoList.add(lesson);
                ++arrangeCount;
                OrgLessonSign tempSigninStatus = (OrgLessonSign)studentSignStatusMap.get(tempKey);
                if (tempSigninStatus != null) {
                    if (tempSigninStatus.getStatus().intValue() == SignStatus.SIGNED.getCode()) {
                        ++signedCount;
                    } else if (tempSigninStatus.getStatus().intValue() == SignStatus.LEAVE.getCode()) {
                        ++leaveCount;
                    } else if (tempSigninStatus.getStatus().intValue() == SignStatus.ABSENT.getCode()) {
                        ++absentCount;
                    }
                    lesson.setSignTime(tempSigninStatus.getUpdateTime());
                }
                if (timeEndConsume) {
                    if (!lesson.getLessonEndTime().before(now)) continue;
                    ++endCount;
                    continue;
                }
                if (tempSigninStatus == null || !(consumed = CourseConsumeRuleEnum.signStatusCodeIsConsume((Integer)signinResult.getCourseConsumeRuleValue(), (Integer)tempSigninStatus.getStatus()))) continue;
                ++endCount;
            }
            signinResult.setSignedCount(signedCount);
            signinResult.setLeaveCount(leaveCount);
            signinResult.setAbsentCount(absentCount);
            signinResult.setArrangeCount(arrangeCount);
            signinResult.setEndCount(endCount);
        }
        return dto;
    }
}

