/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.request.UserSmsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.CourseSmsListDto;
import com.baijia.tianxiao.biz.erp.dto.response.UserSmsResponseDto;
import com.baijia.tianxiao.biz.erp.service.ErpCourseSmsService;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseSmsDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseSms;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.constant.CourseErrorCode;
import com.baijia.tianxiao.sal.course.constant.ViewStatus;
import com.baijia.tianxiao.sal.course.dto.response.CourseListReponseDto;
import com.baijia.tianxiao.sal.course.dto.response.StudentResponseDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpCourseSmsServiceImpl
implements ErpCourseSmsService {
    private static final Logger log = LoggerFactory.getLogger(ErpCourseSmsServiceImpl.class);
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseSmsDao orgCourseSmsDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;

    private Long getOrgNumber(Long orgId) {
        OrgAccount account = this.orgAccountDao.getAccountById(orgId.intValue(), new String[]{"number"});
        if (account == null) {
            return null;
        }
        Integer number = account.getNumber();
        return number != null ? Long.valueOf(number.longValue()) : null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<CourseSmsListDto> getCourseList(Long orgId, Date startTime, Date endTime, String searchKey, PageDto pageDto) {
        Long orgNumber = this.getOrgNumber(orgId);
        ArrayList courseIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", courseIds);
                courseIds = Lists.newArrayList();
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId());
                courseIds.addAll(tempIds);
            }
        }
        List courses = this.orgCourseDao.getCourseList(orgNumber, courseIds, searchKey, null, startTime, endTime, pageDto, new String[0]);
        log.debug("*********courses:{}", (Object)courses);
        List courseListReponseDtos = this.orgCourseListService.getCourseList(courses, orgId, true, true, true, Boolean.valueOf(true), false, false, true);
        log.debug("********courseListReponseDtos:{}", (Object)courseListReponseDtos);
        ArrayList responseDtos = Lists.newArrayList();
        for (CourseListReponseDto courseListReponseDto : courseListReponseDtos) {
            CourseSmsListDto dto = new CourseSmsListDto();
            this.buildCourseSmsListDto(courseListReponseDto, dto);
            responseDtos.add(dto);
        }
        return responseDtos;
    }

    private void buildCourseSmsListDto(CourseListReponseDto courseListReponseDto, CourseSmsListDto dto) {
        dto.setColor(courseListReponseDto.getColor());
        dto.setCourseName(courseListReponseDto.getCourseName());
        dto.setCourseUrl(courseListReponseDto.getCourseUrl());
        dto.setEndTime(courseListReponseDto.getEndTime());
        dto.setLessonCount(courseListReponseDto.getLessonCount());
        dto.setOrgCourseId(courseListReponseDto.getOrgCourseId());
        dto.setOrgCourseNumber(courseListReponseDto.getOrgCourseNumber());
        dto.setSmsStudent(courseListReponseDto.getSmsStudent());
        dto.setSmsTeacher(courseListReponseDto.getSmsTeacher());
        dto.setViewStudent(courseListReponseDto.getViewStudent());
        dto.setViewTeacher(courseListReponseDto.getViewTeacher());
        dto.setStartTime(courseListReponseDto.getStartTime());
    }

    @Override
    @Transactional(readOnly=true)
    public List<UserSmsResponseDto> getCourseSmsViewList(Long orgId, UserSmsRequestDto dto) {
        log.info("get course Sms user list , orgId={}, param={}", (Object)orgId, (Object)dto);
        Long orgNumber = this.getOrgNumber(orgId);
        OrgCourse course = this.orgCourseDao.getByCourseId(dto.getCourseId(), new String[0]);
        ArrayList responseDto = Lists.newArrayList();
        if (course == null || course.getOrgNumber().longValue() != orgNumber.longValue()) {
            throw new BussinessException((UniverseErrorCode)CourseErrorCode.COURSE_NOT_EXIST);
        }
        List courseSmsList = this.orgCourseSmsDao.getOrgCourseSmsList(orgId, dto.getCourseId(), dto.getUserRole(), new String[0]);
        Map smsMap = CollectorUtil.collectMap((Collection)courseSmsList, (Function)new Function<OrgCourseSms, Long>(){

            public Long apply(OrgCourseSms arg0) {
                return arg0.getUserId();
            }
        });
        if (dto.getUserRole().intValue() == UserRole.STUDENT.getRole()) {
            List students = this.courseStudentService.getOrgCourseStudentList(orgId, dto.getCourseId());
            Collection studentIds = CollectorUtil.collect((Collection)students, (Function)new Function<StudentResponseDto, Long>(){

                public Long apply(StudentResponseDto arg0) {
                    return arg0.getStudentId();
                }
            });
            Map studentIdMap = this.orgStudentDao.getStudentIdUserIdMap(studentIds);
            for (StudentResponseDto student : students) {
                UserSmsResponseDto userSmsDto = new UserSmsResponseDto();
                this.buildStudentSmsReponse(student, userSmsDto, smsMap, studentIdMap);
                responseDto.add(userSmsDto);
            }
        } else {
            List teachers = this.courseTeacherService.listCourseTeacher(orgId, dto.getCourseId());
            for (TeacherResponseDto teacher : teachers) {
                UserSmsResponseDto userSmsDto = new UserSmsResponseDto();
                this.buildTeacherSmsResponse(teacher, userSmsDto, smsMap);
                responseDto.add(userSmsDto);
            }
        }
        return responseDto;
    }

    private void buildTeacherSmsResponse(TeacherResponseDto teacher, UserSmsResponseDto dto, Map<Long, OrgCourseSms> smsMap) {
        OrgCourseSms sms;
        dto.setUserId(teacher.getTeacherId());
        dto.setName(teacher.getTeacherName());
        dto.setAvatar(teacher.getAvatar());
        if (StringUtils.isBlank((CharSequence)teacher.getMobile())) {
            dto.setHasMobile(0);
        }
        if ((sms = smsMap.get(teacher.getTeacherId())) != null) {
            dto.setSend(sms.getSend());
            dto.setViewStatus(sms.getViewStatus());
        } else {
            dto.setSend(0);
            dto.setViewStatus(ViewStatus.NOT_VIEW.getCode());
        }
    }

    private void buildStudentSmsReponse(StudentResponseDto student, UserSmsResponseDto dto, Map<Long, OrgCourseSms> smsMap, Map<Long, Long> studentIdMap) {
        dto.setUserId(student.getStudentId());
        dto.setName(student.getName());
        dto.setAvatar(student.getAvatarUrl());
        Long userId = studentIdMap.get(student.getStudentId());
        OrgCourseSms sms = smsMap.get(userId);
        if (sms != null) {
            dto.setSend(sms.getSend());
            dto.setViewStatus(sms.getViewStatus());
        } else {
            dto.setSend(0);
            dto.setViewStatus(ViewStatus.NOT_VIEW.getCode());
        }
    }
}

