/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.sync.impl;

import com.baijia.tianxiao.biz.erp.dto.SplitPurchaseDto;
import com.baijia.tianxiao.biz.erp.sync.SyncPayService;
import com.baijia.tianxiao.constants.signup.PayResult;
import com.baijia.tianxiao.constants.signup.PayType;
import com.baijia.tianxiao.constants.signup.SplitCourseResult;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgSinupPurchaseDao;
import com.baijia.tianxiao.dal.org.po.OrgSinupPurchase;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupInfoDao;
import com.baijia.tianxiao.dal.signup.dao.OrgSignupSyncInfoDao;
import com.baijia.tianxiao.dal.signup.po.OrgSignupCourse;
import com.baijia.tianxiao.dal.signup.po.OrgSignupInfo;
import com.baijia.tianxiao.dal.signup.po.OrgSignupSyncInfo;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.dto.signup.PayResponseDto;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.util.NumberUtil;
import com.baijia.tianxiao.util.httpclient.HttpClientUtils;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.baijia.tianxiao.util.properties.PropertiesReader;
import com.baijia.tianxiao.util.rest.RestUtils;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Service(value="syncSignupAndSpliteService")
public class SyncSignupPurchaseAndSplitCourseServiceImpl
implements SyncPayService {
    private static final Logger log = LoggerFactory.getLogger(SyncSignupPurchaseAndSplitCourseServiceImpl.class);
    @Resource
    private OrgSinupPurchaseDao orgSinupPurchaseDao;
    @Resource
    private OrgSignupInfoDao orgSignupInfoDao;
    @Resource
    private OrgSignupSyncInfoDao orgSignupSyncInfoDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private SignupService signupService;

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRED)
    public void sync() {
        OrgSignupSyncInfo syncInfo = this.getSyncInfo(1);
        int maxSize = 100;
        this.syncPurchase(syncInfo, maxSize);
        this.splitPurchase();
        log.info("save syncInfo:{} to db", (Object)syncInfo);
        this.orgSignupSyncInfoDao.saveOrUpdateSyncInfo(syncInfo);
    }

    private void splitPurchase() {
        ArrayList pendList = Lists.newArrayList((Object[])new Integer[]{SplitCourseResult.PENDING.getCode()});
        ArrayList paySuccessList = Lists.newArrayList((Object[])new Integer[]{PayResult.SUCCESS.getCode()});
        List pendingSplitList = this.orgSignupInfoDao.searchSignupInfoWithCourseInfo((List)pendList, (List)paySuccessList, null, null, new String[0]);
        log.info("get split course size:{}", (Object)pendingSplitList.size());
        if (CollectionUtils.isNotEmpty((Collection)pendingSplitList)) {
            for (OrgSignupInfo orgSignupInfo : pendingSplitList) {
                this.updateSignupInfo(null, orgSignupInfo, null);
            }
        }
    }

    private void syncPurchase(OrgSignupSyncInfo syncInfo, int maxSize) {
        List purchases = this.orgSinupPurchaseDao.searchByUpdateTimeAndStatus(Integer.valueOf(PayResult.SUCCESS.getCode()), syncInfo.getSyncTime(), Integer.valueOf(maxSize), new String[0]);
        log.info("search success from pay by syncInfo:{},maxSize:{},results:{}", new Object[]{syncInfo, maxSize, purchases.size()});
        Date current = new Date();
        if (CollectionUtils.isNotEmpty((Collection)purchases)) {
            HashSet purchaseIds = Sets.newHashSet();
            for (OrgSinupPurchase orgSinupPurchase : purchases) {
                purchaseIds.add(orgSinupPurchase.getPurchaseId());
                if (!orgSinupPurchase.getUpdateTime().after(syncInfo.getSyncTime()) || !orgSinupPurchase.getUpdateTime().before(current)) continue;
                syncInfo.setSyncTime(orgSinupPurchase.getUpdateTime());
            }
            log.debug("-------------------------------------------purchaseIds={}", (Object)purchaseIds);
            Map tradeNoMap = RestUtils.getTradeNoMap((Collection)purchaseIds);
            log.info("found pay success purchase ids:{}", (Object)purchaseIds);
            Map<Long, OrgSignupInfo> signupInfos = this.getSignupInfoMap(purchaseIds);
            for (OrgSinupPurchase orgSinupPurchase : purchases) {
                Long purchaseId = orgSinupPurchase.getPurchaseId();
                OrgSignupInfo signupInfo = signupInfos.get(purchaseId);
                if (signupInfo == null) {
                    signupInfo = this.createAndSaveSignupInfo(orgSinupPurchase, tradeNoMap);
                    log.info("create signup info:{}", (Object)signupInfo);
                    continue;
                }
                this.updateSignupInfo(orgSinupPurchase, signupInfo, tradeNoMap);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    private OrgSignupInfo createAndSaveSignupInfo(OrgSinupPurchase sinupPurchase, Map<Long, Long> tradeNoMap) {
        log.info("create signup info from purchase:{}", (Object)sinupPurchase);
        OrgSignupInfo info = new OrgSignupInfo();
        info.setCreateTime(sinupPurchase.getPayTime());
        info.setIsDel((Number)DeleteStatus.NORMAL.getValue());
        info.setMobile("");
        info.setOperator("");
        info.setOrgId(sinupPurchase.getOrgId());
        info.setOrgNumber(sinupPurchase.getOrgNumber());
        info.setPayType(Integer.valueOf(PayType.getPayTypeByTypeStr((String)sinupPurchase.getPayType()).getCode()));
        info.setPurchaseStatus(sinupPurchase.getStatus());
        info.setRemark("");
        info.setSignupPurchaseId(sinupPurchase.getPurchaseId());
        info.setSignupType(Integer.valueOf(SignupType.POS_CARD.getCode()));
        info.setSplitResult(Integer.valueOf(SplitCourseResult.NOT_COMMIT.getCode()));
        info.setStudentName("");
        info.setTotalPrices(Long.valueOf(NumberUtil.multiply((Number)sinupPurchase.getTotalPrices(), (BigDecimal)new BigDecimal(100), (int)0).longValue()));
        info.setUpdateTime(new Date());
        info.setPayTime(sinupPurchase.getPayTime());
        info.setUserId(Long.valueOf(0L));
        info.setTradeNo((Number)tradeNoMap.get(sinupPurchase.getPurchaseId()));
        this.orgSignupInfoDao.saveOrUpdateSignupInfo(info);
        return info;
    }

    @Transactional
    private void updateSignupInfo(OrgSinupPurchase sinupPurchase, @NonNull OrgSignupInfo signupInfo, Map<Long, Long> tradeNoMap) {
        if (signupInfo == null) {
            throw new NullPointerException("signupInfo");
        }
        if (signupInfo.getTotalPrices() == 0L && sinupPurchase == null) {
            sinupPurchase = this.orgSinupPurchaseDao.getByPurchaseId(signupInfo.getSignupPurchaseId(), new String[0]);
        }
        if (sinupPurchase != null && sinupPurchase.getStatus().intValue() != PayResult.SUCCESS.getCode()) {
            log.warn("sinupPurchase is not success:{}", (Object)sinupPurchase);
            return;
        }
        signupInfo.setPurchaseStatus(sinupPurchase != null ? (Number)sinupPurchase.getStatus() : (Number)PayResult.SUCCESS.getCode());
        if (sinupPurchase != null && sinupPurchase.getPayTime() != null && signupInfo.getCreateTime().after(sinupPurchase.getPayTime())) {
            signupInfo.setCreateTime(sinupPurchase.getPayTime());
            if (CollectionUtils.isNotEmpty((Collection)signupInfo.getOrgSignupCourses())) {
                signupInfo.setTotalPrices(Long.valueOf((long)(sinupPurchase.getTotalPrices() * 100.0)));
                signupInfo.setCreateTime(sinupPurchase.getPayTime());
                signupInfo.setPayTime(sinupPurchase.getPayTime());
                log.info("update split success pos pay before signup record:{}", (Object)sinupPurchase);
            }
        }
        if (sinupPurchase != null && sinupPurchase.getStatus().equals(PayResult.SUCCESS.getCode()) && signupInfo.getPayType().equals(PayType.CASH.getCode())) {
            log.info("force set cash pay type into pos pay type.");
            signupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.PENDING.getCode()));
        }
        log.info("sync signup purchase ={}", (Object)sinupPurchase);
        if (sinupPurchase != null && sinupPurchase.getStatus().intValue() == PayResult.SUCCESS.getCode()) {
            log.info("sync signup purchase1 ={}", (Object)sinupPurchase);
            signupInfo.setPayType(Integer.valueOf(PayType.getPayTypeByTypeStr((String)sinupPurchase.getPayType()).getCode()));
            signupInfo.setPayTime(sinupPurchase.getPayTime());
        }
        if (tradeNoMap != null) {
            signupInfo.setTradeNo((Number)tradeNoMap.get(sinupPurchase.getPurchaseId()));
        }
        try {
            List<SplitPurchaseDto> purchaseData = this.buildSplitPurchaseDto(signupInfo);
            if (CollectionUtils.isNotEmpty(purchaseData)) {
                log.info("start to split purchase :{}", purchaseData);
                SyncSignupPurchaseAndSplitCourseServiceImpl.splitSignupPurchase(purchaseData);
                signupInfo.setSplitResult(Integer.valueOf(SplitCourseResult.SUCCESS.getCode()));
                if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{signupInfo.getMobile()}) && signupInfo.getPurchaseStatus().intValue() == PayResult.SUCCESS.getCode()) {
                    log.info("send sms to fronted student:{}", (Object)signupInfo.getMobile());
                }
            }
            signupInfo.setUpdateTime(new Date());
            this.orgSignupInfoDao.saveOrUpdateSignupInfo(signupInfo);
        }
        catch (Exception e) {
            log.error("split signup purchase catch error:{}", (Throwable)e);
        }
    }

    private List<SplitPurchaseDto> buildSplitPurchaseDto(OrgSignupInfo signupInfo) throws BussinessException {
        if (signupInfo.getSplitResult().intValue() == SplitCourseResult.SUCCESS.getCode()) {
            log.info("signupInfo has split ,skip");
            return Collections.emptyList();
        }
        if (CollectionUtils.isEmpty((Collection)signupInfo.getOrgSignupCourses())) {
            log.info("signupInfo has no signup courses,skip");
            return Collections.emptyList();
        }
        ArrayList<SplitPurchaseDto> purchaseData = new ArrayList<SplitPurchaseDto>(signupInfo.getOrgSignupCourses().size());
        Long totalNew = 0L;
        if (CollectionUtils.isNotEmpty((Collection)signupInfo.getOrgSignupCourses())) {
            for (OrgSignupCourse signupCourse : signupInfo.getOrgSignupCourses()) {
                if (signupCourse.getPayPrice().intValue() < 0) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4ef7\u683c\u9519\u8bef\u5566");
                }
                totalNew = totalNew + signupCourse.getPayPrice();
                purchaseData.add(SplitPurchaseDto.Builder.create().setCourseNumber(signupCourse.getOrgCourseNumber()).setPayPrice(signupCourse.getPayPrice()).setPurchaseId(signupInfo.getSignupPurchaseId()).setUserId(signupInfo.getUserId()).build());
            }
        }
        if (totalNew > signupInfo.getTotalPrices()) {
            log.error("current total price:{},is more than signup total price:{},signup info:{}", new Object[]{totalNew, signupInfo.getTotalPrices(), signupInfo});
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u7a0b\u4ef7\u683c\u548c\u652f\u4ed8\u4ef7\u683c\u4e0d\u4e00\u81f4\u9519\u8bef");
        }
        if (totalNew < signupInfo.getTotalPrices()) {
            log.info("signupInfo:{} has not fill complete ,skip", (Object)signupInfo);
            return Collections.emptyList();
        }
        return purchaseData;
    }

    private Map<Long, OrgSignupInfo> getSignupInfoMap(Collection<Long> purchaseIds) {
        List infos = this.orgSignupInfoDao.searchByPurchaseIdsWithCourseInfo(purchaseIds, new String[0]);
        if (CollectionUtils.isEmpty((Collection)infos)) {
            return Collections.emptyMap();
        }
        HashMap result = Maps.newHashMap();
        for (OrgSignupInfo orgSignupInfo : infos) {
            result.put(orgSignupInfo.getSignupPurchaseId(), orgSignupInfo);
        }
        return result;
    }

    private OrgSignupSyncInfo getSyncInfo(Integer posCardSignup) {
        OrgSignupSyncInfo syncInfo = this.orgSignupSyncInfoDao.getOrgSignupSyncInfo(posCardSignup);
        if (syncInfo == null) {
            syncInfo = new OrgSignupSyncInfo();
            syncInfo.setSyncId(Long.valueOf(0L));
            try {
                syncInfo.setSyncTime(DateUtils.parseDate((String)"2015-09-01", (String[])new String[]{"yyyy-MM-dd"}));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            syncInfo.setSyncType((Number)posCardSignup);
        }
        return syncInfo;
    }

    public static void splitSignupPurchase(List<SplitPurchaseDto> purchaseData) throws BussinessException {
        String response = "";
        try {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("purchaseData", JacksonUtil.obj2Str(purchaseData));
            log.debug("purchaseData", (Object)JacksonUtil.obj2Str(purchaseData));
            String url = PropertiesReader.getValue((String)"url", (String)"splitOrgSinupPurchase.url");
            response = HttpClientUtils.doPost((String)url, params, (String)"UTF-8");
            log.info("fillCourseInfo--splitSignupPurchase-->response {}", (Object)response);
        }
        catch (Exception e) {
            log.warn("split purchase get error:{}", (Throwable)e);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c6\u5355\u5931\u8d25");
        }
        SyncSignupPurchaseAndSplitCourseServiceImpl.checkPayResponse(response, PayResponseDto.class);
    }

    private static <T extends PayResponseDto> T checkPayResponse(String response, Class<T> type) throws BussinessException {
        PayResponseDto splitSignupPurchaseResponseDto = null;
        if (StringUtils.isNotEmpty((CharSequence)response)) {
            try {
                splitSignupPurchaseResponseDto = (PayResponseDto)JacksonUtil.str2Obj((String)response, type);
            }
            catch (Exception e) {
                log.error("parse result:{} to object get error:{}", (Object)response, (Object)e);
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c6\u5355\u8ba2\u5355\u5931\u8d250");
            }
            if (splitSignupPurchaseResponseDto != null && splitSignupPurchaseResponseDto.getCode() != 0) {
                String message = "";
                try {
                    message = new String(splitSignupPurchaseResponseDto.getMsg().getBytes("UTF-8"), "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c6\u5355\u8ba2\u5355\u5931\u8d251");
                }
                if (!message.startsWith("\u5f53\u524d\u673a\u6784\u6536\u8d39\u8ba2\u5355\u5df2\u5206\u62c6\u5b8c\u6210!")) {
                    throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c6\u5355\u8ba2\u5355\u5931\u8d252");
                }
            }
            return (T)splitSignupPurchaseResponseDto;
        }
        throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u62c6\u5355\u8ba2\u5355\u5931\u8d253");
    }
}

