/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.dto.response.studentCenter.StudentCenterInfoDto;
import com.baijia.tianxiao.biz.erp.service.PersonalCenterService;
import com.baijia.tianxiao.constant.Flag;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgBaseInfoDto;
import com.baijia.tianxiao.dal.wechat.constant.WechatOpenIdEntityType;
import com.baijia.tianxiao.dal.wechat.dao.AuthorizationInfoDao;
import com.baijia.tianxiao.dal.wechat.dao.OrgWechatOpenIdRecordDao;
import com.baijia.tianxiao.dal.wechat.po.OrgWechatOpenIdRecord;
import com.baijia.tianxiao.dto.smstoken.StudentSmsTokenDto;
import com.baijia.tianxiao.dto.smstoken.TeacherSmsTokenDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.organization.dto.OrgSelectionDto;
import com.baijia.tianxiao.sal.wechat.api.WechatFreeVersionService;
import com.baijia.tianxiao.sal.wechat.constant.webauth.WebAuthScope;
import com.baijia.tianxiao.sal.wechat.helper.WechatProperties;
import com.baijia.tianxiao.sal.wechat.helper.webauthlink.WechatWebAuthLinkBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PersonalCenterServiceImpl
implements PersonalCenterService {
    private static final Logger log = LoggerFactory.getLogger(PersonalCenterServiceImpl.class);
    @Autowired(required=false)
    private WechatFreeVersionService freeVersionService;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Autowired
    private OrgWechatOpenIdRecordDao orgWechatOpenIdRecordDao;
    @Autowired
    private OrgInfoDao orgInfoDao;
    @Autowired
    private AuthorizationInfoDao authorizationInfoDao;

    @Override
    public void fillStudentCenterInfoDto(StudentCenterInfoDto dto, String sms_token) throws Exception {
        if (dto == null || StringUtils.isBlank((CharSequence)sms_token)) {
            log.error("wrong param dto:{},wechatAppId:{}", (Object)dto, (Object)sms_token);
            return;
        }
        StudentSmsTokenDto token = StudentSmsTokenDto.fromTokenStr((String)sms_token);
        Long orgId = token.getOrgId();
        String wechatAppId = token.getWechatAppId();
        String openId = token.getOpenId();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        String websiteFmt = "%si/%s";
        websiteFmt = String.format(websiteFmt, WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());
        dto.setWebsite(websiteFmt);
        dto.setOrgId(orgId);
        if (wechatAppId != null && this.freeVersionService.isFreeAccount(wechatAppId.toString())) {
            dto.setFromFV(Flag.TRUE.getInt());
            dto.setImsite(WechatWebAuthLinkBuilder.imSite((WebAuthScope)WebAuthScope.BASE, (String)wechatAppId.toString(), (String)sms_token));
            List records = this.orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.STUDENT);
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                ArrayList<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
                OrgSelectionDto orgSelectionDto = null;
                HashMap<Long, Integer> counterMap = new HashMap<Long, Integer>();
                for (OrgWechatOpenIdRecord record : records) {
                    if (counterMap.get((long)record.getOrgId()) != null) continue;
                    counterMap.put(record.getOrgId(), Flag.TRUE.getInt());
                    if (this.authorizationInfoDao.getByOrgId(Integer.valueOf(record.getOrgId().intValue())) != null) continue;
                    orgSelectionDto = new OrgSelectionDto();
                    OrgBaseInfoDto orgInfo = this.orgInfoDao.getBaseInfo(record.getOrgId().intValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.studentCenter((WebAuthScope)WebAuthScope.BASE, (String)record.getAuthorizerAppId(), (Long)record.getOrgId()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
            }
        }
    }

    @Override
    public void fillTeacherCenterInfoDto(TeacherResponseDto dto, String sms_token) throws Exception {
        if (dto == null || StringUtils.isBlank((CharSequence)sms_token)) {
            log.error("wrong param dto:{},wechatAppId:{}", (Object)dto, (Object)sms_token);
            return;
        }
        TeacherSmsTokenDto token = TeacherSmsTokenDto.fromTokenStr((String)sms_token);
        Long orgId = token.getOrgId();
        String wechatAppId = token.getWechatAppId();
        String openId = token.getOpenId();
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(orgId.intValue(), new String[0]);
        String websiteFmt = "%si/%s";
        websiteFmt = String.format(websiteFmt, WechatProperties.getWebMTianXiaoUrlPrefix(), orgAccount.getNumber());
        dto.setWebsite(websiteFmt);
        dto.setOrgId(orgId);
        if (wechatAppId != null && this.freeVersionService.isFreeAccount(wechatAppId.toString())) {
            dto.setFromFV(Integer.valueOf(Flag.TRUE.getInt()));
            List records = this.orgWechatOpenIdRecordDao.listBy(wechatAppId, openId, WechatOpenIdEntityType.TEACHER);
            if (CollectionUtils.isNotEmpty((Collection)records)) {
                ArrayList<OrgSelectionDto> list = new ArrayList<OrgSelectionDto>();
                OrgSelectionDto orgSelectionDto = null;
                HashMap<Long, Integer> counterMap = new HashMap<Long, Integer>();
                for (OrgWechatOpenIdRecord record : records) {
                    if (counterMap.get((long)record.getOrgId()) != null) continue;
                    counterMap.put(record.getOrgId(), Flag.TRUE.getInt());
                    if (this.authorizationInfoDao.getByOrgId(Integer.valueOf(record.getOrgId().intValue())) != null) continue;
                    orgSelectionDto = new OrgSelectionDto();
                    OrgBaseInfoDto orgInfo = this.orgInfoDao.getBaseInfo(record.getOrgId().intValue());
                    orgSelectionDto.setShortName(orgInfo.getShortName());
                    orgSelectionDto.setOrgId(Long.valueOf(orgInfo.getOrgId().longValue()));
                    orgSelectionDto.setUrl(WechatWebAuthLinkBuilder.teacherCenter((WebAuthScope)WebAuthScope.BASE, (String)record.getAuthorizerAppId(), (Long)record.getOrgId()));
                    list.add(orgSelectionDto);
                }
                dto.setOrgList(list);
            }
        }
    }
}

