/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.service.ErpStudentService;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseStudentOpDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgStudent;
import com.baijia.tianxiao.dal.org.po.OrgStudentCourse;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.signup.constant.SignupType;
import com.baijia.tianxiao.dal.storage.dao.StorageDao;
import com.baijia.tianxiao.dal.storage.po.Storage;
import com.baijia.tianxiao.dal.user.dao.StudentDao;
import com.baijia.tianxiao.dal.user.po.Student;
import com.baijia.tianxiao.dto.PersonBaseDto;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.StudentCourseStatus;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.OrgCourseService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.course.util.StudentNameUtil;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.organization.org.service.TxCascadeCredentialService;
import com.baijia.tianxiao.sal.push.dto.ConsultAvatarUrlAndNameDto;
import com.baijia.tianxiao.sal.push.service.ConsultAvatarUrlService;
import com.baijia.tianxiao.sal.signup.dto.SignupCourseInfoDto;
import com.baijia.tianxiao.sal.signup.dto.request.FillCourseInfoRequestDto;
import com.baijia.tianxiao.sal.signup.service.SignupService;
import com.baijia.tianxiao.sal.student.api.OrgStudentService;
import com.baijia.tianxiao.sal.student.dto.request.StudentListRequestDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoListReponseDto;
import com.baijia.tianxiao.sal.student.dto.response.StudentInfoReponseDto;
import com.baijia.tianxiao.sal.student.enums.StudentErrorCode;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.HanZiPinYinUtils;
import com.baijia.tianxiao.util.mobile.MaskUtil;
import com.baijia.tianxiao.util.storage.StorageUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;
import lombok.NonNull;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ErpStudentServiceImpl
implements ErpStudentService {
    private static final Logger log = LoggerFactory.getLogger(ErpStudentServiceImpl.class);
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private SignupService signupService;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgCourseStudentOpDao orgCourseStudentStatusDao;
    @Resource
    private OrgCourseService orgCourseService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private OrgStudentService orgStudentService;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Resource
    private StudentDao studentDao;
    @Resource
    private StorageDao storageDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgAccountDao orgAccountDao;
    @Resource
    private ConsultAvatarUrlService consultAvatarUrlService;
    @Resource
    private TxCascadeCredentialService txCascadeCredentialService;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;

    @Override
    public StudentInfoListReponseDto getStudentListWithAttendanceRate(StudentListRequestDto studentListRequestDto, Long orgId, PageDto pageDto) {
        TXCascadeAccount txCascadeAccount;
        boolean needFilter = false;
        List tempcourseIds = null;
        List tempstudentIds = null;
        if (TianxiaoMContext.getTXCascadeId() != null && (txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0])).getAccountType().intValue() == CascadeType.STAFF.getValue()) {
            tempcourseIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
            tempstudentIds = this.orgStudentService.getStudentidsByCourseIds(orgId, tempcourseIds);
            if (CollectionUtils.isEmpty((Collection)tempstudentIds)) {
                return new StudentInfoListReponseDto();
            }
            needFilter = true;
        }
        log.debug("tempcourseIds={}", tempcourseIds);
        log.debug("tempstudentIds={}", tempstudentIds);
        StudentInfoListReponseDto studentInfoListReponseDto = null;
        studentInfoListReponseDto = needFilter ? this.orgStudentService.getStudentList(studentListRequestDto, tempstudentIds, orgId, pageDto) : this.orgStudentService.getStudentList(studentListRequestDto, orgId, pageDto);
        log.debug("studentInfoListReponseDto={}", (Object)studentInfoListReponseDto);
        ArrayList studentIds = Lists.newArrayList();
        for (StudentInfoReponseDto stu : studentInfoListReponseDto.getList()) {
            studentIds.add(stu.getStudentId());
        }
        Map map = this.orgLessonSignService.getAttendanceRateOfStudents(orgId, (Collection)studentIds);
        log.debug("map={}", (Object)map);
        Iterator i$ = studentInfoListReponseDto.getList().iterator();
        while (i$.hasNext()) {
            StudentInfoReponseDto stu;
            Double rate = (Double)map.get((stu = (StudentInfoReponseDto)i$.next()).getStudentId());
            stu.setAttendanceRate(Double.valueOf(rate == null ? 0.0 : rate));
        }
        return studentInfoListReponseDto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addOrgCourseStudent(Long orgId, Long courseId, Collection<Long> studentIds, Collection<Header> headers, boolean doSignup) {
        if (CollectionUtils.isEmpty(studentIds)) {
            log.info("studentIds is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fID\u4e3a\u7a7a");
        }
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(courseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u7a0b\u4e0d\u80fd\u6dfb\u52a0\u5b66\u751f");
        }
        List orgStudents = this.orgStudentDao.getStudentByIds(orgId, studentIds, new String[0]);
        for (OrgStudent orgStudent : orgStudents) {
            OrgStudentCourse osc = this.orgStudentCourseDao.getStudentCourse(orgId, courseId, orgStudent.getUserId());
            if (osc == null) {
                OrgStudentCourse orgStudentCourse = new OrgStudentCourse();
                this.buildOrgStudentCourse(orgStudentCourse, orgStudent, courseId);
                orgStudentCourse.setStatus(Integer.valueOf(0));
                this.orgStudentCourseDao.save((Object)orgStudentCourse, new String[0]);
                if (!doSignup) continue;
                this.signUp(orgId, orgCourse, orgStudent.getId());
                continue;
            }
            osc.setStatus(Integer.valueOf(0));
            this.orgStudentCourseDao.update((Object)osc, new String[]{"status"});
            if (!doSignup) continue;
            this.signUp(orgId, orgCourse, orgStudent.getId());
        }
    }

    private void signUp(Long orgId, OrgCourse orgCourse, Long studentId) {
        ArrayList courseInfos = Lists.newArrayList();
        FillCourseInfoRequestDto signUpDto = new FillCourseInfoRequestDto();
        SignupCourseInfoDto courseInfo = new SignupCourseInfoDto();
        courseInfo.setCount(1);
        courseInfo.setDiscount(100);
        courseInfo.setOrgCourseName(orgCourse.getName());
        courseInfo.setOrgCourseId(orgCourse.getId());
        courseInfo.setOrgCourseNumber(orgCourse.getNumber());
        courseInfo.setOriginPrice(orgCourse.getPrice());
        courseInfo.setPayPrice(orgCourse.getPrice());
        courseInfo.setPreferential(0.0);
        courseInfos.add(courseInfo);
        signUpDto.setCourseInfos((List)courseInfos);
        signUpDto.setOrgId(orgId);
        signUpDto.setSignupType(SignupType.FRONTED.getCode());
        OrgStudent student = (OrgStudent)this.orgStudentDao.getById((Serializable)studentId, new String[0]);
        if (student == null || student.getDelStatus().intValue() != DeleteStatus.NORMAL.getValue()) {
            log.warn("student = null, orgId = {}, studentId = {}", (Object)orgId, (Object)studentId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "studentId = " + studentId + " not found!");
        }
        signUpDto.setStudentMobile(student.getMobile());
        signUpDto.setStudentName(StudentNameUtil.buildStudentName((OrgStudent)student));
        log.debug("signUpDto = {}", (Object)signUpDto);
        this.signupService.signUp(signUpDto);
    }

    private void buildOrgStudentCourse(OrgStudentCourse orgStudentCourse, OrgStudent ttsStudent, @NonNull Long courseId) {
        if (courseId == null) {
            throw new NullPointerException("courseId");
        }
        orgStudentCourse.setCourseId(courseId);
        orgStudentCourse.setOrgId(ttsStudent.getOrgId());
        orgStudentCourse.setUserId(ttsStudent.getUserId());
        orgStudentCourse.setStudentMobile(MaskUtil.maskMobile((String)ttsStudent.getMobile()));
        if (StringUtils.isEmpty((String)ttsStudent.getName())) {
            orgStudentCourse.setStudentName("");
        } else {
            orgStudentCourse.setStudentName(ttsStudent.getName());
        }
        orgStudentCourse.setDelStatus(Integer.valueOf(DeleteStatus.NORMAL.getValue()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void transferOrgCourseStudent(@NonNull Long orgId, @NonNull Long studentId, @NonNull Long fromCourseId, @NonNull Long toCourseId, String cause, @NonNull Collection<Header> headers) {
        if (orgId == null) {
            throw new NullPointerException("orgId");
        }
        if (studentId == null) {
            throw new NullPointerException("studentId");
        }
        if (fromCourseId == null) {
            throw new NullPointerException("fromCourseId");
        }
        if (toCourseId == null) {
            throw new NullPointerException("toCourseId");
        }
        if (headers == null) {
            throw new NullPointerException("headers");
        }
        this.courseStudentService.transferOrgCourseStudent(orgId, studentId, fromCourseId, toCourseId, cause);
        ArrayList studentIds = Lists.newArrayList();
        studentIds.add(studentId);
        this.addOrgCourseStudent(orgId, toCourseId, studentIds, headers, false);
    }

    @Override
    @Transactional(readOnly=true)
    public List<PersonBaseDto> searchOrgStudents(Long orgId, String param, PageDto page) throws Exception {
        Preconditions.checkArgument((orgId != null ? 1 : 0) != 0, (Object)"orgId can not be null");
        OrgAccount account = (OrgAccount)this.orgAccountDao.getById((Serializable)orgId, new String[0]);
        if (account == null) {
            throw new BussinessException((UniverseErrorCode)StudentErrorCode.ORG_NOT_EXIST);
        }
        List students = this.orgStudentDao.fuzzySearchStudents(orgId, param, page, new String[]{"id", "userId", "name", "mobile"});
        ArrayList list = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)students)) {
            boolean isShowMobile = this.txCascadeCredentialService.isShowMobile(orgId, TianxiaoMContext.getTXCascadeId());
            Map studentMap = BaseUtils.listToMap((List)students, (String)"userId");
            Map avatarMap = this.consultAvatarUrlService.batchStudentAvatarUrlAndNameDMap(studentMap.keySet(), orgId);
            for (Long userId : studentMap.keySet()) {
                OrgStudent orgStudent = (OrgStudent)studentMap.get(userId);
                PersonBaseDto dto = new PersonBaseDto();
                dto.setId(orgStudent.getId());
                dto.setName(orgStudent.getName());
                dto.setPinyinName(HanZiPinYinUtils.getLowerCasePinYin((String)orgStudent.getName()));
                dto.setAvatarUrl(((ConsultAvatarUrlAndNameDto)avatarMap.get(userId)).getAvatarUrl());
                if (!isShowMobile) {
                    dto.setMobile(MaskUtil.maskMobile((String)dto.getMobile()));
                } else {
                    dto.setMobile(orgStudent.getMobile());
                }
                list.add(dto);
            }
        }
        return list;
    }

    private Map<Long, String> getAndCacheStudentAvatar(Collection<Long> usrIds) {
        HashMap map = Maps.newHashMap();
        if (CollectionUtils.isEmpty(usrIds)) {
            return map;
        }
        List students = this.studentDao.getByUserIds(usrIds, new String[]{"userId", "avatar"});
        HashMap userIdStorageIdMap = Maps.newHashMap();
        HashSet avatarIds = Sets.newHashSet();
        for (Student student : students) {
            if (student.getAvatar() != null) {
                avatarIds.add(student.getAvatar());
            }
            userIdStorageIdMap.put(student.getUserId(), student.getAvatar());
        }
        HashMap storageIdUrlMap = Maps.newHashMap();
        List storages = this.storageDao.getByIds((Collection)avatarIds, new String[0]);
        for (Storage storage : storages) {
            storageIdUrlMap.put(storage.getId(), StorageUtil.constructUrl((Long)storage.getFid(), (String)storage.getMimetype(), (String)storage.getSn()));
        }
        for (Student student : students) {
            if (student.getAvatar() == null) continue;
            map.put(student.getUserId(), storageIdUrlMap.get(((Integer)userIdStorageIdMap.get(student.getUserId())).longValue()));
        }
        return map;
    }

    private Map<Long, Integer> getAndCachedStudentSignInfo(Long courseId, Collection<Long> userIds) {
        Map cache = this.orgLessonSignDao.getOrgCourseStudentSignCount(userIds, courseId);
        return cache;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveCourseStudents(Long orgId, Long courseId, Collection<Long> studentIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        ArrayList studentUserIds = Lists.newArrayList();
        Map userIdAndIdMap = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(studentIds)) {
            userIdAndIdMap = this.orgStudentDao.getStudentUserIdAndIdMap(studentIds);
            studentUserIds.addAll(userIdAndIdMap.keySet());
        }
        Set<Object> existStudents = Sets.newHashSet();
        List courseStudents = this.orgStudentCourseDao.getStudentListByCourseId(orgId, courseId, new String[0]);
        for (OrgStudentCourse orgStudentCourse : courseStudents) {
            if (orgStudentCourse.getStatus() != 0) continue;
            existStudents.add(orgStudentCourse.getUserId());
        }
        Map existStudentMap = this.orgStudentDao.getUserIdStudentIdMap((Collection)existStudents, orgId, true);
        existStudents = existStudentMap.keySet();
        HashSet tempStudents = Sets.newHashSet((Iterable)existStudents);
        HashSet toDelStudents = Sets.newHashSet();
        if (CollectionUtils.isNotEmpty((Collection)studentUserIds)) {
            tempStudents.removeAll(studentUserIds);
        }
        toDelStudents.addAll(tempStudents);
        List lessonStudents = this.orgStudentLessonDao.getOrgStudentLessonsByCourseIds(Arrays.asList(courseId));
        Set arrangeStudents = BaseUtils.getPropertiesList((List)lessonStudents, (String)"userId");
        for (Long studentId : toDelStudents) {
            if (!arrangeStudents.contains(studentId)) continue;
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5df2\u6392\u8bfe\u7684\u5b66\u751f\u65e0\u6cd5\u5220\u9664");
        }
        if (CollectionUtils.isNotEmpty((Collection)toDelStudents)) {
            this.orgStudentCourseDao.batchDeleteOrgCourseStudent(orgId, courseId, (Collection)toDelStudents, Integer.valueOf(StudentCourseStatus.WITHDRAW.getCode()));
        }
        studentUserIds.removeAll(existStudents);
        if (CollectionUtils.isNotEmpty((Collection)studentUserIds)) {
            HashSet toAddStudents = Sets.newHashSet();
            for (Long userId : studentUserIds) {
                toAddStudents.add(userIdAndIdMap.get(userId));
            }
            this.addOrgCourseStudent(orgId, courseId, toAddStudents, null, false);
        }
    }
}

