/*
 * Decompiled with CFR 0.152.
 */
package com.baijia.tianxiao.biz.erp.service.impl;

import com.baijia.tianxiao.biz.erp.constant.CourseSignStatus;
import com.baijia.tianxiao.biz.erp.constant.StudentStatus;
import com.baijia.tianxiao.biz.erp.dto.LessonTime;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.AddCourseLessonRequestDtoForPC;
import com.baijia.tianxiao.biz.erp.dto.request.EditLessonRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.FastSignInLessonsEditRequestDto;
import com.baijia.tianxiao.biz.erp.dto.request.ListLessonsRequestDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonConflictCheckListDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonConflictInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.LessonTimeTableResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.ListLessonResponseDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.ConflictInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonBaseInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.LessonScheduleInfoDto;
import com.baijia.tianxiao.biz.erp.dto.response.schedule.NameAndIdDto;
import com.baijia.tianxiao.biz.erp.enums.BatchOperateType;
import com.baijia.tianxiao.biz.erp.service.CourseLessonService;
import com.baijia.tianxiao.biz.erp.teacherCenter.service.ExcelCourseExportService;
import com.baijia.tianxiao.consants.DataStatus;
import com.baijia.tianxiao.consants.UserRole;
import com.baijia.tianxiao.constant.CommentStatus;
import com.baijia.tianxiao.constant.SignStatus;
import com.baijia.tianxiao.constants.TianXiaoConstant;
import com.baijia.tianxiao.constants.UserRoleEnum;
import com.baijia.tianxiao.constants.org.BizConf;
import com.baijia.tianxiao.dal.enums.CourseTypeEnum;
import com.baijia.tianxiao.dal.org.constant.DeleteStatus;
import com.baijia.tianxiao.dal.org.dao.OrgAccountDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgClassRoomDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgCourseTeacherDao;
import com.baijia.tianxiao.dal.org.dao.OrgInfoDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonCommentDao;
import com.baijia.tianxiao.dal.org.dao.OrgLessonSignDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentCourseDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentDao;
import com.baijia.tianxiao.dal.org.dao.OrgStudentLessonDao;
import com.baijia.tianxiao.dal.org.dao.OrgTeacherLessonDao;
import com.baijia.tianxiao.dal.org.dao.TXCascadeAccountDao;
import com.baijia.tianxiao.dal.org.dto.DropDownListRequestDto;
import com.baijia.tianxiao.dal.org.dto.TimeTableRequestDto;
import com.baijia.tianxiao.dal.org.po.OrgAccount;
import com.baijia.tianxiao.dal.org.po.OrgClassLesson;
import com.baijia.tianxiao.dal.org.po.OrgClassRoom;
import com.baijia.tianxiao.dal.org.po.OrgCourse;
import com.baijia.tianxiao.dal.org.po.OrgCourseTeacher;
import com.baijia.tianxiao.dal.org.po.OrgLessonConflict;
import com.baijia.tianxiao.dal.org.po.OrgLessonSign;
import com.baijia.tianxiao.dal.org.po.OrgStudentLesson;
import com.baijia.tianxiao.dal.org.po.OrgTeacherLesson;
import com.baijia.tianxiao.dal.org.po.TXCascadeAccount;
import com.baijia.tianxiao.dal.user.dao.TeacherDao;
import com.baijia.tianxiao.dal.user.po.Teacher;
import com.baijia.tianxiao.dto.UniverseErrorCode;
import com.baijia.tianxiao.enums.CommonErrorCode;
import com.baijia.tianxiao.enums.DropdownListType;
import com.baijia.tianxiao.excel.dto.ExportField;
import com.baijia.tianxiao.exception.BussinessException;
import com.baijia.tianxiao.filter.TianxiaoMContext;
import com.baijia.tianxiao.filter.TianxiaoPCContext;
import com.baijia.tianxiao.sal.comment.constant.CommentErrorCode;
import com.baijia.tianxiao.sal.course.dto.HeaderDto;
import com.baijia.tianxiao.sal.course.dto.request.LessonConflictCheckDto;
import com.baijia.tianxiao.sal.course.dto.response.OrgStudentsChooseListDto;
import com.baijia.tianxiao.sal.course.dto.response.TeacherResponseDto;
import com.baijia.tianxiao.sal.course.enums.LessonConflictEnum;
import com.baijia.tianxiao.sal.course.service.CourseStudentService;
import com.baijia.tianxiao.sal.course.service.CourseTeacherService;
import com.baijia.tianxiao.sal.course.service.OrgCourseListService;
import com.baijia.tianxiao.sal.course.service.OrgLessonConflictService;
import com.baijia.tianxiao.sal.course.service.OrgLessonSignService;
import com.baijia.tianxiao.sal.organization.constant.CascadeType;
import com.baijia.tianxiao.sal.room.dto.ClassRoomDto;
import com.baijia.tianxiao.sal.room.service.ClassRoomService;
import com.baijia.tianxiao.sal.student.api.OrgStudentCourseService;
import com.baijia.tianxiao.sal.student.enums.LessonStatus;
import com.baijia.tianxiao.sqlbuilder.dto.PageDto;
import com.baijia.tianxiao.util.BaseUtils;
import com.baijia.tianxiao.util.collection.CollectorUtil;
import com.baijia.tianxiao.util.date.DateUtil;
import com.baijia.tianxiao.util.date.TimeStamp;
import com.baijia.tianxiao.util.json.JacksonUtil;
import com.beust.jcommander.internal.Lists;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CourseLessonServiceImpl
implements CourseLessonService {
    private static final Logger log = LoggerFactory.getLogger(CourseLessonServiceImpl.class);
    private static final String DEFAULT_ROOM_OR_TEACHER_NAME = "\u672a\u8bbe\u7f6e";
    @Resource
    private OrgClassLessonDao orgClassLessonDao;
    @Resource
    private OrgTeacherLessonDao orgTeacherLessonDao;
    @Resource
    private OrgStudentLessonDao orgStudentLessonDao;
    @Resource
    private OrgLessonSignDao orgLessonSignDao;
    @Resource
    private OrgCourseDao orgCourseDao;
    @Resource
    private OrgStudentDao orgStudentDao;
    @Resource
    private TeacherDao teacherDao;
    @Resource
    private OrgClassRoomDao orgClassRoomDao;
    @Resource
    private OrgLessonCommentDao orgLessonCommentDao;
    @Resource
    private OrgCourseListService orgCourseListService;
    @Resource
    private CourseStudentService courseStudentService;
    @Resource
    private CourseTeacherService courseTeacherService;
    @Resource
    private ClassRoomService classRoomService;
    @Resource
    private OrgInfoDao orgInfoDao;
    @Resource
    private OrgStudentCourseDao orgStudentCourseDao;
    @Resource
    private OrgStudentCourseService orgStudentCourseService;
    @Autowired
    private TXCascadeAccountDao txCascadeAccountDao;
    @Autowired
    private OrgAccountDao orgAccountDao;
    @Resource
    private OrgCourseTeacherDao orgCourseTeacherDao;
    @Resource
    private OrgLessonSignService orgLessonSignService;
    @Resource
    private OrgLessonConflictService orgLessonConflictService;
    @Resource
    private TXCascadeAccountDao cascadeAccountDao;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addClassLessons(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDto dto) {
        AddCourseLessonRequestDtoForPC dtoForPC = new AddCourseLessonRequestDtoForPC();
        try {
            BeanUtils.copyProperties((Object)dtoForPC, (Object)dto);
            if (CollectionUtils.isNotEmpty(dto.getStudentIds())) {
                dtoForPC.setStudentIds(StringUtils.join((Object[])dto.getStudentIds().toArray(), (String)","));
            }
            dtoForPC.setRepeatUnit(dto.getRepeatUnit().getCode());
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        this.addClassLessonsForPC(orgId, startDay, endDay, dtoForPC);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addClassLessonsForPC(Long orgId, Date startDay, Date endDay, AddCourseLessonRequestDtoForPC dto) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((startDay != null ? 1 : 0) != 0, (Object)"start day can not be null");
        Preconditions.checkArgument((dto != null ? 1 : 0) != 0, (Object)"class lessons param is illegal");
        Preconditions.checkArgument((dto.getCourseId() != null && dto.getCourseId() > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        OrgCourse orgCourse = this.orgCourseDao.getByCourseId(dto.getCourseId(), new String[0]);
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && orgCourse.getIsClass() == CourseTypeEnum.IS_CLASS_FALSE.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5f53\u524d\u7248\u672c\u4e0d\u652f\u6301\uff0c\u8bf7\u5347\u7ea7\u65b0\u7248\u672c");
        }
        List<Calendar> calens = dto.getRepeatUnit().getAvaliableDays(startDay, dto.getRepeatCount(), dto.getRepeatRange(), dto.getWeekDays(), dto.getCalendarDays());
        TimeStamp startTime = TimeStamp.parse((String)dto.getStartTime());
        TimeStamp endTime = TimeStamp.parse((String)dto.getEndTime());
        OrgClassLesson lesson = null;
        List lessons = Lists.newArrayList();
        List lessonConflicts = Lists.newArrayList();
        int index = 1;
        for (Calendar cal : calens) {
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            lesson = new OrgClassLesson();
            lesson.setStartTime(lessonTime.getStartTime());
            lesson.setEndTime(lessonTime.getEndTime());
            lesson.setCourseId(dto.getCourseId());
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            lesson.setLayoutId(Long.valueOf(0L));
            lesson.setRoomId(Long.valueOf(dto.getRoomId() != null ? dto.getRoomId() : 0L));
            lesson.setUpdateTime(new Date());
            lesson.setNumber(Integer.valueOf(index));
            lesson.setOrgId(orgId);
            lessons.add(lesson);
            ++index;
        }
        log.info("save {} lessons into db,params:{}", (Object)lessons.size(), (Object)dto);
        this.orgClassLessonDao.saveAll(lessons, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId"});
        HashSet roomIds = Sets.newHashSet();
        roomIds.add(dto.getRoomId() != null ? dto.getRoomId() : 0L);
        this.classRoomService.addClassRoomCourse(Long.valueOf(orgId), dto.getCourseId(), (Collection)roomIds);
        this.resetLessonNumber(orgId, dto.getCourseId());
        for (OrgClassLesson classLesson : lessons) {
            this.courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), dto.getStudentIds(), true);
            HashSet teacherIds = Sets.newHashSet();
            HashSet tempTeacherIds = Sets.newHashSet();
            if (dto.getTeacherId() != null && dto.getTeacherId() > 0L) {
                teacherIds.add(dto.getTeacherId());
                tempTeacherIds.addAll(teacherIds);
                this.courseTeacherService.addTeacherToCourse(orgId, classLesson.getCourseId(), (Collection)teacherIds);
                this.courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), (Collection)tempTeacherIds);
            }
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setLessonId(classLesson.getId());
            conflict.setOrgId(orgId);
            conflict.setRoomId(Long.valueOf(classLesson.getRoomId() == null ? 0L : classLesson.getRoomId()));
            conflict.setStartTime(classLesson.getStartTime());
            conflict.setEndTime(classLesson.getEndTime());
            if (tempTeacherIds.size() > 1) {
                int i = 1;
                Iterator teacherIt = tempTeacherIds.iterator();
                while (teacherIt.hasNext()) {
                    if (i > 1) {
                        try {
                            OrgLessonConflict cloneConflict = (OrgLessonConflict)BeanUtils.cloneBean((Object)conflict);
                            cloneConflict.setTeacherId((Long)teacherIt.next());
                            lessonConflicts.add(cloneConflict);
                        }
                        catch (Exception e) {
                            throw new RuntimeException("clone bean error:", e);
                        }
                    } else {
                        conflict.setTeacherId((Long)teacherIt.next());
                        lessonConflicts.add(conflict);
                    }
                    ++i;
                }
                continue;
            }
            conflict.setTeacherId(Long.valueOf(dto.getTeacherId() == null ? 0L : dto.getTeacherId()));
            lessonConflicts.add(conflict);
        }
        this.orgLessonConflictService.saveOrgLessonConflicts(lessonConflicts);
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto listLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        HashMap<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Object, Object> courseMap = Maps.newHashMap();
            courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map<Object, Object> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = this.getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Object, Object> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = this.getOrgClassRoomMap(roomIds);
            }
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto listSignInLessons(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        HashMap<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.querySignInLesson(orgId, lessonIdTeacherIdMap, params, true);
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Object, Object> courseMap = Maps.newHashMap();
            courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map<Object, Object> lessonIdTeacherNameMap = Maps.newHashMap();
            if (params.isNeedTeacherName()) {
                lessonIdTeacherNameMap = this.getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
            }
            Map<Object, Object> classRoomMap = Maps.newHashMap();
            if (params.isNeedRoomName()) {
                classRoomMap = this.getOrgClassRoomMap(roomIds);
            }
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    private Map<Long, String> getLessonIdTeacherName(Long orgId, Collection<Long> lessonIds, Map<Long, Long> lessonTeacherIdMap) {
        if (MapUtils.isEmpty(lessonTeacherIdMap)) {
            lessonTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, lessonIds);
        }
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        HashMap<Long, String> lessonIdTeacherNameMap = new HashMap<Long, String>(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, (String)teacherNameMap.get(lessonTeacherIdMap.get(lessonId)));
        }
        return lessonIdTeacherNameMap;
    }

    private List<OrgClassLesson> queryLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap, ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet teacherIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", (Object)courseIds);
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                log.debug("user cascadeId={},courseIds={}", (Object)TianxiaoMContext.getTXCascadeId(), (Object)tempIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    courseIds.addAll(tempIds);
                } else if (!tempIds.containsAll(courseIds)) {
                    courseIds.clear();
                }
                log.debug("after set courseIds:{}", (Object)courseIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    return Collections.EMPTY_LIST;
                }
            }
        }
        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(this.courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return Collections.emptyList();
            }
        }
        lessonIdTeacherIdMap = this.queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());
        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)courseIds, (Collection)roomIds, (Collection)lessonIds, startTime, endTime, params.getPageDto(), new String[0]);
        return lessons;
    }

    private List<OrgClassLesson> querySignInLesson(Long orgId, Map<Long, Long> lessonIdTeacherIdMap, ListLessonsRequestDto params, boolean isTimeTable) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet teacherIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        if (params.getCourseId() != null) {
            courseIds.add(params.getCourseId());
        }
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", (Object)courseIds);
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                log.debug("user cascadeId={},courseIds={}", (Object)TianxiaoMContext.getTXCascadeId(), (Object)tempIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    courseIds.addAll(tempIds);
                } else if (!tempIds.containsAll(courseIds)) {
                    courseIds.clear();
                }
                log.debug("after set courseIds:{}", (Object)courseIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    return Collections.EMPTY_LIST;
                }
            }
        }
        if (params.getRoomId() != null) {
            roomIds.add(params.getRoomId());
        }
        if (params.getTeacherId() != null) {
            teacherIds.add(params.getTeacherId());
        }
        if (params.getStudentId() != null) {
            lessonIds.addAll(this.courseStudentService.getStudentLessonIds(orgId, params.getStudentId()));
            if (CollectionUtils.isEmpty((Collection)lessonIds)) {
                return Collections.emptyList();
            }
        }
        lessonIdTeacherIdMap = this.queryLessonIdByTeacherId(orgId, teacherIds);
        if (CollectionUtils.isNotEmpty((Collection)teacherIds) && lessonIdTeacherIdMap.isEmpty()) {
            return Collections.emptyList();
        }
        lessonIds.addAll(lessonIdTeacherIdMap.keySet());
        Date startTime = params.getStartTime();
        Date endTime = params.getEndTime();
        if (isTimeTable) {
            startTime = params.getFirstLessonStartTime();
            endTime = params.getLastLessonStartTime();
        }
        List lessons = this.orgClassLessonDao.querySignInLessons(orgId, (Collection)courseIds, (Collection)roomIds, (Collection)lessonIds, startTime, endTime, params.getPageDto(), params.getLessonId(), new String[0]);
        return lessons;
    }

    @Override
    @Transactional(readOnly=true)
    public List<LessonTimeTableResponseDto> queryTimeTable(Long orgId, ListLessonsRequestDto params) {
        Preconditions.checkArgument((params.getStartTime() != null && params.getEndTime() != null ? 1 : 0) != 0, (Object)"start time or end time is null");
        Preconditions.checkArgument((boolean)params.getEndTime().after(params.getStartTime()), (Object)"time condition error");
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, false);
        if (CollectionUtils.isNotEmpty(lessons)) {
            HashSet lessonIds = Sets.newHashSet();
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            if (lessonIdTeacherIdMap.isEmpty()) {
                lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
                log.debug("query lessonId teacherId map:{}by lessonIds:{}", lessonIdTeacherIdMap, (Object)lessonIds);
            }
            Map<Long, OrgCourse> courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonIdTeacherIdMap.values());
            Map<Long, OrgClassRoom> classRoomMap = this.getOrgClassRoomMap(roomIds);
            List result = Lists.newArrayList();
            for (OrgClassLesson lesson : lessons) {
                Long teacherId = lessonIdTeacherIdMap.get(lesson.getId());
                OrgCourse tempCourse = courseMap.get(lesson.getCourseId());
                if (tempCourse == null || tempCourse.getIsDel() != 0) continue;
                LessonTimeTableResponseDto dto = this.buildTimeTableDto(lesson, tempCourse, classRoomMap.get(lesson.getRoomId()), teacherId, (String)teacherNameMap.get(teacherId));
                result.add(dto);
            }
            return result;
        }
        return Collections.emptyList();
    }

    private Map<Long, OrgClassRoom> getOrgClassRoomMap(Collection<Long> roomIds) {
        List classRooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"id", "roomName", "roomSize"});
        return CollectorUtil.collectMap((Collection)classRooms, (Function)new Function<OrgClassRoom, Long>(){

            public Long apply(OrgClassRoom input) {
                return input.getId();
            }
        });
    }

    private Map<Long, OrgCourse> getOrgCourseMap(Long orgId, Collection<Long> courseIds) {
        List courseList = this.orgCourseDao.getByIds(courseIds, new String[]{"id", "cover", "name", "color", "isDel", "courseType"});
        Iterator courseIter = courseList.iterator();
        while (courseIter.hasNext()) {
            OrgCourse orgCourse = (OrgCourse)courseIter.next();
            if (orgCourse.getIsDel() == 0) continue;
            courseIter.remove();
        }
        this.orgCourseListService.getCourseList(courseList, orgId, false, false, false, Boolean.valueOf(false), false, false, false);
        return CollectorUtil.collectMap((Collection)courseList, (Function)new Function<OrgCourse, Long>(){

            public Long apply(OrgCourse input) {
                return input.getId();
            }
        });
    }

    private LessonTimeTableResponseDto buildTimeTableDto(OrgClassLesson lesson, OrgCourse course, OrgClassRoom classRoom, Long teacherId, String teacherName) {
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        dto.setCourseId(lesson.getCourseId());
        if (course != null) {
            dto.setCourseColor(course.getColor());
            dto.setCourseName(course.getName());
        }
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setLessonId(lesson.getId());
        dto.setIndex(lesson.getNumber());
        dto.setRoomId(lesson.getRoomId());
        if (classRoom != null) {
            dto.setRoomName(classRoom.getRoomName());
        }
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        dto.setTeacherId(teacherId);
        dto.setTeacherName(teacherName);
        return dto;
    }

    private ListLessonResponseDto buildListLessonResponseDto(List<OrgClassLesson> lessons, Map<Long, OrgCourse> courseMap, Map<Long, String> lessonIdTeacherNameMap, Map<Long, OrgClassRoom> classRoomMap, Map<Long, Integer> studentCountMap, Map<Long, Integer> signStudentCountMap, Map<Long, Integer> commentCount, Map<Long, Integer> lessonSignStatus) {
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Date now = new Date();
            for (OrgClassLesson lesson : lessons) {
                if (result.getFirstLessonStartTime() == null || result.getFirstLessonStartTime().after(lesson.getStartTime())) {
                    result.setFirstLessonStartTime(lesson.getStartTime());
                }
                if (result.getLastLessonStartTime() == null || result.getLastLessonStartTime().before(lesson.getStartTime())) {
                    result.setLastLessonStartTime(lesson.getStartTime());
                }
                LessonResponseDto dto = new LessonResponseDto();
                dto.setCourseId(lesson.getCourseId());
                dto.setIndex(lesson.getNumber());
                OrgCourse course = courseMap.get(lesson.getCourseId());
                if (course == null) continue;
                if (StringUtils.isNotBlank((CharSequence)course.getName())) {
                    dto.setCourseName(course.getName());
                }
                dto.setCourseType((int)course.getCourseType());
                OrgClassRoom classRoom = classRoomMap.get(lesson.getRoomId());
                dto.setRoomId(lesson.getRoomId());
                if (classRoom != null) {
                    dto.setRoomName(classRoom.getRoomName());
                }
                dto.setTeacherName(lessonIdTeacherNameMap.get(lesson.getId()));
                dto.setLessonEndTime(lesson.getEndTime());
                dto.setLessonId(lesson.getId());
                dto.setLessonStartTime(lesson.getStartTime());
                CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
                if (now.after(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.NO_SIGN;
                    dto.setIsOver(1);
                }
                if (now.after(lesson.getStartTime()) && now.before(lesson.getEndTime())) {
                    signStatus = CourseSignStatus.SIGNING;
                }
                Integer signCount = signStudentCountMap.get(lesson.getId());
                SignStatus stuSignStatus = SignStatus.getSignStatusByCode((Integer)lessonSignStatus.get(lesson.getId()));
                if (stuSignStatus != null) {
                    log.debug("lessonId:{},lessonSignStatus:{},status:{}", new Object[]{lesson.getId(), lessonSignStatus, stuSignStatus});
                    dto.setSignStatusEnum(stuSignStatus);
                } else {
                    if (signCount != null && signCount > 0) {
                        signStatus = CourseSignStatus.SIGNED;
                    }
                    dto.setCourseSignStatusEnum(signStatus);
                }
                Integer commentCnt = commentCount.get(lesson.getId());
                if (commentCnt != null && commentCnt > 0) {
                    dto.setCommentEnum(CommentStatus.COMMENTED);
                } else {
                    dto.setCommentEnum(CommentStatus.getCommentStatusByTime((Date)lesson.getStartTime(), (Date)lesson.getEndTime(), (boolean)true));
                }
                Integer studentCount = studentCountMap.get(lesson.getId());
                dto.setSignCount(signCount != null ? signCount : 0);
                dto.setStudentCount(studentCount != null ? studentCount : 0);
                result.getList().add(dto);
            }
        }
        return result;
    }

    private Map<Long, Long> queryLessonIdByTeacherId(Long orgId, Collection<Long> teacherIds) {
        if (CollectionUtils.isEmpty(teacherIds)) {
            return Collections.emptyMap();
        }
        List teacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, teacherIds, new String[]{"lessonId", "teacherId"});
        if (CollectionUtils.isNotEmpty((Collection)teacherLessons)) {
            HashMap<Long, Long> result = new HashMap<Long, Long>();
            for (OrgTeacherLesson orgTeacherLesson : teacherLessons) {
                result.put(orgTeacherLesson.getLessonId(), orgTeacherLesson.getTeacherId());
            }
            return result;
        }
        return Collections.emptyMap();
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonInfo(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        Date now = new Date();
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        LessonTimeTableResponseDto dto = new LessonTimeTableResponseDto();
        OrgCourse course = this.orgCourseDao.getByCourseId(lesson.getCourseId(), new String[]{"id", "name", "courseType", "color", "isFinish"});
        if (course == null) {
            log.warn("can not found course by lesson:{}", (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR, "\u65e0\u6cd5\u627e\u5230\u5bf9\u5e94\u73ed\u7ea7");
        }
        dto.setCourseColor(course.getColor());
        dto.setCourseId(course.getId());
        dto.setCourseType((int)course.getCourseType());
        dto.setCourseName(course.getName());
        dto.setCourseFinish(course.getIsFinish());
        dto.setCreateTime(lesson.getCreateTime());
        dto.setEndTime(lesson.getEndTime());
        dto.setIndex(lesson.getNumber());
        dto.setLessonId(lesson.getId());
        CourseSignStatus signStatus = CourseSignStatus.HAS_NOT_STARTED;
        if (now.after(lesson.getStartTime())) {
            signStatus = CourseSignStatus.NO_SIGN;
            if (now.before(lesson.getEndTime())) {
                signStatus = CourseSignStatus.SIGNING;
            }
        }
        dto.setRoomId(lesson.getRoomId());
        dto.setSignStatusEnum(signStatus);
        dto.setStartTime(lesson.getStartTime());
        dto.setUpdateTime(lesson.getUpdateTime());
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public LessonTimeTableResponseDto lessonDetail(Long orgId, Long lessonId, boolean needStudentSign) {
        LessonTimeTableResponseDto dto = this.lessonInfo(orgId, lessonId);
        dto.setStudents(this.courseStudentService.getLessonStudent(orgId, lessonId, needStudentSign));
        for (OrgStudentsChooseListDto student : dto.getStudents()) {
            if (student.getSignStatus() == null || SignStatus.SIGNED.getCode() != student.getSignStatus().intValue()) continue;
            dto.increaseSignStudent();
        }
        List teacherDtos = this.courseTeacherService.getLessonTeacher(orgId, lessonId);
        if (CollectionUtils.isNotEmpty((Collection)teacherDtos)) {
            TeacherResponseDto teacherDto = (TeacherResponseDto)teacherDtos.get(0);
            dto.setTeacherId(teacherDto.getTeacherId());
            dto.setTeacherName(teacherDto.getTeacherName());
        }
        if (dto.getRoomId() != null && dto.getRoomId() > 0L) {
            OrgClassRoom classRoom = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)dto.getRoomId(), new String[]{"id", "roomName"});
            dto.setRoomName(classRoom.getRoomName());
        }
        return dto;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void delLesson(Long orgId, Long lessonId) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((lessonId != null && lessonId > 0L ? 1 : 0) != 0, (Object)"lessonId is illegal");
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)lessonId, (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        this.hasDeleteLessonPermission(lesson.getCourseId());
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonCommentDao.getLessonComments(lessonId, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_COMMENT);
        }
        if (CollectionUtils.isNotEmpty((Collection)this.orgLessonSignDao.getLessonSignList(orgId, null, lessonId, null, null, null, null, null, new String[]{"id"}))) {
            throw new BussinessException((UniverseErrorCode)CommentErrorCode.LESSON_WITH_SIGN);
        }
        this.courseStudentService.deleteStudentFromLesson(orgId, lessonId, null);
        this.courseTeacherService.delTeacherFromLesson(orgId, lessonId, null);
        this.orgClassLessonDao.delById((Serializable)lessonId);
        this.resetLessonNumber(orgId, lesson.getCourseId());
        List lessonIds = Lists.newArrayList((int)1);
        lessonIds.add(lessonId);
        this.orgLessonConflictService.delByLessonIds(orgId, lessonIds);
    }

    void hasDeleteLessonPermission(Long courseId) {
        if (TianxiaoMContext.getTXCascadeId() != null) {
            List tempIds;
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() && (CollectionUtils.isEmpty((Collection)(tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null))) || !tempIds.contains(courseId))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u65e0\u6743\u64cd\u4f5c");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void editLesson(Long orgId, EditLessonRequestDto editDto) {
        Preconditions.checkNotNull((Object)editDto, (Object)"param can not be null");
        editDto.validate();
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)editDto.getLessonId(), new String[0]);
        if (lesson == null || !orgId.equals(lesson.getOrgId())) {
            log.warn("lesson id:{} is illegal,query lesson:{}", (Object)editDto.getLessonId(), (Object)lesson);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u8282ID\u4e0d\u6b63\u786e");
        }
        this.editValidate(lesson.getCourseId());
        lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        boolean needRearrange = false;
        if (!editDto.getEndTime().equals(lesson.getEndTime()) || !editDto.getStartTime().equals(lesson.getStartTime())) {
            lesson.setEndTime(editDto.getEndTime());
            lesson.setStartTime(editDto.getStartTime());
            needRearrange = true;
        }
        List teacherIds = Lists.newArrayList();
        if (editDto.getRoomId() == null) {
            editDto.setRoomId(0L);
        }
        if (editDto.getTeacherId() == null) {
            editDto.setTeacherId(0L);
        } else {
            teacherIds.add(editDto.getTeacherId());
        }
        lesson.setRoomId(editDto.getRoomId());
        lesson.setUpdateTime(new Date());
        this.orgClassLessonDao.update((Object)lesson, new String[0]);
        if (needRearrange) {
            this.resetLessonNumber(orgId, lesson.getCourseId());
        }
        HashSet roomIds = Sets.newHashSet();
        roomIds.add(editDto.getRoomId() != null ? editDto.getRoomId() : 0L);
        this.classRoomService.addClassRoomCourse(Long.valueOf(orgId), lesson.getCourseId(), (Collection)roomIds);
        this.courseTeacherService.resetLessonTeacher(orgId, lesson.getCourseId(), lesson.getId(), (Collection)teacherIds);
        OrgLessonConflict conflict = new OrgLessonConflict();
        conflict.setOrgId(orgId);
        conflict.setTeacherId(editDto.getTeacherId());
        conflict.setRoomId(editDto.getRoomId());
        conflict.setLessonId(editDto.getLessonId());
        conflict.setStartTime(editDto.getStartTime());
        conflict.setEndTime(editDto.getEndTime());
        conflict.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
        this.orgLessonConflictService.updateOrgLessonConflictsForce(conflict);
    }

    void editValidate(Long courseId) {
        if (TianxiaoMContext.getTXCascadeId() != null) {
            List tempIds;
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.cascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() && (CollectionUtils.isEmpty((Collection)(tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, null, null))) || !tempIds.contains(courseId))) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.PERMISSION_DENY, "\u65e0\u6743\u64cd\u4f5c\u4e0d\u5c5e\u4e8e\u60a8\u7684\u8bfe\u8282");
            }
        }
    }

    private void resetLessonNumber(Long orgId, Long courseId) {
        List lessons = this.orgClassLessonDao.queryLessons(orgId, (Collection)Lists.newArrayList((Object[])new Long[]{courseId}), null, null, null, null, null, new String[]{"id"});
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            int index = 1;
            Map[] params = new Map[lessons.size()];
            for (OrgClassLesson lesson : lessons) {
                HashMap<String, Number> param = new HashMap<String, Number>();
                param.put("id", lesson.getId());
                param.put("number", index);
                params[index - 1] = param;
                ++index;
            }
            this.orgClassLessonDao.batchUpdateLessonNumber(params);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Long getTeacherId(Long orgId, Long lessonId) {
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        if (teacherLesson != null) {
            return teacherLesson.getTeacherId();
        }
        return null;
    }

    @Override
    @Transactional(readOnly=true)
    public List<Long> getLessonStudentUserIds(Long orgId, Collection<Long> lessonIds) {
        if (CollectionUtils.isEmpty(lessonIds)) {
            return Lists.newArrayList();
        }
        return this.orgStudentLessonDao.getUserIdsByLessonIds(orgId, lessonIds);
    }

    @Override
    public void export(HttpServletResponse response, Long orgId, ListLessonsRequestDto param, List<LessonTimeTableResponseDto> dtoList) {
        Preconditions.checkArgument((param.getStartTime() != null ? 1 : 0) != 0, (Object)"\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((param.getEndTime() != null ? 1 : 0) != 0, (Object)"\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        String orgName = this.orgInfoDao.getOrgShortNameByOrgId(Integer.valueOf(orgId.intValue()));
        String startTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getStartTime());
        String endTimeStr = TianXiaoConstant.DAY_FORMAT.format(param.getEndTime());
        String fileName = orgName + "-\u8bfe\u8868\u7edf\u8ba1-" + startTimeStr + "~" + endTimeStr + ".xlsx";
        SXSSFWorkbook workbook = null;
        List dates = DateUtil.getDateBetween((Date)param.getStartTime(), (Date)param.getEndTime());
        try {
            workbook = new SXSSFWorkbook(200);
            HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
            List summaryFields = Lists.newArrayList();
            summaryFields.add(new ExportField(" ", "@", 5620));
            for (Date date : dates) {
                summaryFields.add(new ExportField("\u5468" + DateUtil.getChineseWeekDay((Date)date) + "(" + DateUtil.getDayStr((Date)date) + ")", "@", 5120));
            }
            List titles = Lists.newArrayList();
            titles.add(startTimeStr + "~" + endTimeStr + "\u8bfe\u8868\u7edf\u8ba1");
            ExcelCourseExportService.createSheet((Workbook)workbook, "\u8bfe\u8868\u7edf\u8ba1", titles, cellStyleMap, summaryFields, dtoList, param.getStartTime());
            ExcelCourseExportService.exportExcel(response, (Workbook)workbook, fileName);
            log.debug("course lesson export success");
        }
        catch (Exception var20) {
            log.error("export catch exception:", (Throwable)var20);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5bfc\u51fa\u6570\u636e\u5904\u7406\u5f02\u5e38");
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException var19) {
                log.error("close workbook catch error:", (Throwable)var19);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        String json = FileUtils.readFileToString((File)new File("/Users/wengshengli/Downloads/response.json"));
        List dtoList = JacksonUtil.str2List((String)json, LessonTimeTableResponseDto.class);
        Date startDate = new Date(1465747200682L);
        Date endDate = new Date(1466351999682L);
        System.out.println(DateUtil.getDateDiff((Date)startDate, (Date)endDate));
        List dates = DateUtil.getDateBetween((Date)startDate, (Date)endDate);
        SXSSFWorkbook workbook = new SXSSFWorkbook(200);
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>();
        List summaryFields = Lists.newArrayList();
        summaryFields.add(new ExportField("", "@", 5620));
        for (Date date : dates) {
            summaryFields.add(new ExportField("\u5468" + DateUtil.getChineseWeekDay((Date)date) + "(" + DateUtil.getDayStr((Date)date) + ")", "@", 5120));
        }
        List titles = Lists.newArrayList();
        titles.add("\u8bfe\u8282\u6c47\u603b\u8868");
        ExcelCourseExportService.createSheet((Workbook)workbook, "\u8bfe\u8282\u6c47\u603b", titles, cellStyleMap, summaryFields, dtoList, startDate);
        File excelFile = new File("/Users/wengshengli/Documents/test1.xlsx");
        workbook.write((OutputStream)new FileOutputStream(excelFile));
    }

    @Override
    public HeaderDto getHeaderInfo() {
        HeaderDto dto = new HeaderDto();
        Integer txCascadeAccountId = TianxiaoMContext.getTXCascadeId();
        if (txCascadeAccountId == null) {
            return dto;
        }
        OrgAccount orgAccount = this.orgAccountDao.getAccountById(TianxiaoMContext.getOrgId().intValue(), new String[0]);
        if (orgAccount == null) {
            log.info("orgAccount doesn't exist! orgAccountId:{}", (Object)TianxiaoMContext.getOrgId());
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u65e0\u6743\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)txCascadeAccountId, new String[0]);
        if (txCascadeAccount == null) {
            log.info("txCascadeAccount doesn't exist! txCascadeAccountId:{}", (Object)txCascadeAccountId);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u60a8\u65e0\u6743\u4f7f\u7528\u6b64\u529f\u80fd");
        }
        List courseIds = Lists.newArrayList();
        Integer notSignCount = 0;
        if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue() && CollectionUtils.isNotEmpty((Collection)(courseIds = this.orgCourseDao.getCourseIdsByCascadeId(txCascadeAccountId, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null)))) {
            notSignCount = this.orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
        }
        if (txCascadeAccount.getAccountType().intValue() == CascadeType.MANAGER.getValue()) {
            notSignCount = this.orgClassLessonDao.getLessonCount(orgAccount.getId(), courseIds, new Date());
            courseIds = this.orgCourseDao.getCourseIds(Long.valueOf(orgAccount.getNumber().longValue()), null, null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
        }
        Integer totalCount = courseIds.size();
        dto.setClassCount(totalCount);
        dto.setSignCount(notSignCount);
        return dto;
    }

    @Override
    @Transactional(readOnly=true)
    public ListLessonResponseDto queryCourseLessons(Long orgId, ListLessonsRequestDto params) {
        HashMap<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        List<OrgClassLesson> lessons = this.queryLesson(orgId, lessonIdTeacherIdMap, params, true);
        ArrayList<Long> courseIds = new ArrayList<Long>();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        ListLessonResponseDto result = new ListLessonResponseDto();
        if (CollectionUtils.isNotEmpty(lessons)) {
            Collections.sort(lessons, new Comparator<OrgClassLesson>(){

                @Override
                public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                    return o1.getNumber().compareTo(o2.getNumber());
                }
            });
            for (OrgClassLesson lesson : lessons) {
                courseIds.add(lesson.getCourseId());
                roomIds.add(lesson.getRoomId());
                lessonIds.add(lesson.getId());
            }
            Map<Long, OrgCourse> courseMap = this.getOrgCourseMap(orgId, courseIds);
            Map studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            Map signStudentCountMap = Maps.newHashMap();
            if (!params.isNeedStudentSignStatus() && params.isNeedSignInfo()) {
                signStudentCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds);
            }
            Map commentCount = Maps.newHashMap();
            Map lessonSignStatus = Maps.newHashMap();
            if (params.isNeedStudentSignStatus()) {
                Preconditions.checkArgument((params.getStudentId() != null && params.getStudentId() > 0L ? 1 : 0) != 0, (Object)"\u5b66\u751fID\u4e0d\u6b63\u786e");
                Long userId = this.orgStudentDao.getUserId(params.getStudentId());
                commentCount = this.orgLessonCommentDao.getLessonCommentCountMap((Collection)lessonIds, orgId, userId, null, Integer.valueOf(UserRole.STUDENT.getRole()), Boolean.valueOf(false));
                List lessonSign = this.orgLessonSignDao.getStudentSign(orgId, userId, Integer.valueOf(UserRole.STUDENT.getRole()), (Collection)lessonIds, new String[]{"lessonId", "status"});
                if (CollectionUtils.isNotEmpty((Collection)lessonSign)) {
                    lessonSignStatus = CollectorUtil.collectMap((Collection)lessonSign, (Function)new Function<OrgLessonSign, Long>(){

                        public Long apply(OrgLessonSign input) {
                            return input.getLessonId();
                        }
                    }, (Function)new Function<OrgLessonSign, Integer>(){

                        public Integer apply(OrgLessonSign input) {
                            return input.getStatus();
                        }
                    });
                    log.debug("student lesson sign:{}", (Object)lessonSignStatus);
                }
            }
            HashMap lessonIdTeacherNameMap = Maps.newHashMap();
            HashMap classRoomMap = Maps.newHashMap();
            result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap, signStudentCountMap, commentCount, lessonSignStatus);
            Date now = new Date();
            int lastRow = result.getList().size() - 1;
            if (lastRow >= 0) {
                result.setNewLessonId(result.getList().get(lastRow).getLessonId());
                for (LessonResponseDto lesson : result.getList()) {
                    if (!now.before(lesson.getLessonEndTime())) continue;
                    result.setNewLessonId(lesson.getLessonId());
                    break;
                }
            }
        } else {
            result.setFirstLessonStartTime(params.getFirstLessonStartTime());
            result.setLastLessonStartTime(params.getLastLessonStartTime());
            if (params.getFirstLessonStartTime() == null && params.getLastLessonStartTime() == null) {
                result.setFirstLessonStartTime(DateUtil.getCurrentDate());
            }
        }
        return result;
    }

    @Override
    public List<LessonScheduleInfoDto> queryCourseLessonsByParams(Long orgId, TimeTableRequestDto params, PageDto pageDto) {
        List teacherLessons;
        Collection lessonIds = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)params.getTeacherIds()) && CollectionUtils.isNotEmpty((Collection)(teacherLessons = this.orgTeacherLessonDao.queryTeacherLessons(orgId, (Collection)params.getTeacherIds(), new String[]{"lessonId"})))) {
            lessonIds = BaseUtils.getPropertiesList((List)teacherLessons, (String)"lessonId");
        }
        List lessons = this.orgClassLessonDao.getOrgClassLessonByParams(orgId, params, lessonIds, pageDto);
        List data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set roomIds = BaseUtils.getPropertiesList(result, (String)"roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();
                Set courseIds = BaseUtils.getPropertiesList(result, (String)"courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                List courseList = this.orgCourseDao.getByIds((Collection)courseIds, new String[0]);
                HashMap map = Maps.newHashMap();
                for (OrgCourse course : courseList) {
                    map.put(course.getId(), course);
                }
                for (LessonResponseDto dto : result) {
                    if (((OrgCourse)map.get(dto.getCourseId())).getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode() && dto.getStudentCount() == 0) continue;
                    Long courseId = dto.getCourseId();
                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setRoomId(dto.getRoomId());
                    if (dto.getRoomId() == null || dto.getRoomId() <= 0L) {
                        item.setRoomName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setRoomName(dto.getRoomName());
                    }
                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    if (dto.getTeacherId() == null || dto.getTeacherId() <= 0L) {
                        item.setTeacherName(DEFAULT_ROOM_OR_TEACHER_NAME);
                    } else {
                        item.setTeacherName(dto.getTeacherName());
                    }
                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    if (now.before(dto.getLessonStartTime())) {
                        item.setLessonStatus(LessonStatus.UN_START.getStatus());
                    } else if (now.after(dto.getLessonEndTime())) {
                        item.setLessonStatus(LessonStatus.FINISHED.getStatus());
                    } else {
                        item.setLessonStatus(LessonStatus.ONGOING.getStatus());
                    }
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }
                    item.setCourseType(dto.getCourseType() == null ? CourseTypeEnum.COURSE_TYPE_CLASS.getCode() : dto.getCourseType());
                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }
                    this.wrapConflictInfo(orgId, item);
                    if (params.getIsConflict() == BizConf.TRUE.intValue() && item.getIsConflict() == BizConf.FALSE.intValue()) continue;
                    data.add(item);
                }
            }
        }
        log.info("queryCourseLessonsByCourseId.orgId:{}, params:{}, data:{}", new Object[]{orgId, params, data});
        return data;
    }

    Map<Long, Integer> getAndCachedFinishedLessonCount(Long orgId, Collection<Long> courseIds) {
        Map cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty(courseIds)) {
            cache = this.orgClassLessonDao.getFinishLessonCount(orgId, courseIds, Integer.valueOf(DeleteStatus.NORMAL.getValue()));
        }
        return cache;
    }

    @Override
    public List<LessonScheduleInfoDto> queryCourseLessonsByParams(Long orgId, Long lessonId, Long teacherId, Long roomId, Long startTime, Long endTime, PageDto pageDto) {
        return null;
    }

    void wrapConflictInfo(Long orgId, LessonScheduleInfoDto dto) {
        LessonConflictCheckDto lessonConflictCheckDto = new LessonConflictCheckDto();
        lessonConflictCheckDto.setEndTimeDate(new Date(dto.getEndTime()));
        lessonConflictCheckDto.setLessonId(dto.getLessonId());
        lessonConflictCheckDto.setPageNum(1);
        lessonConflictCheckDto.setPageSize(20);
        lessonConflictCheckDto.setRoomId(dto.getRoomId());
        lessonConflictCheckDto.setStartTimeDate(new Date(dto.getStartTime()));
        lessonConflictCheckDto.setTeacherId(dto.getTeacherId());
        LessonConflictEnum conflict = this.orgLessonConflictService.lessonConflictFlagCheck(orgId, lessonConflictCheckDto);
        ConflictInfoDto conflictInfo = null;
        if (conflict != null && conflict != LessonConflictEnum.NO_CONFLICT) {
            conflictInfo = new ConflictInfoDto();
            conflictInfo.setConflictType(conflict.getCode());
            conflictInfo.setConflictTypeStr(conflict.getNote());
            dto.setIsConflict(BizConf.TRUE);
        } else {
            dto.setIsConflict(BizConf.FALSE);
        }
        dto.setConflictInfo(conflictInfo);
    }

    private List<Long> getCurrentUserCoursesIds() {
        List courseIds = Lists.newArrayList();
        if (TianxiaoMContext.getTXCascadeId() != null) {
            TXCascadeAccount txCascadeAccount = (TXCascadeAccount)this.txCascadeAccountDao.getById((Serializable)TianxiaoMContext.getTXCascadeId(), new String[0]);
            if (txCascadeAccount == null) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u5b50\u5e10\u53f7\u4e0d\u5b58\u5728");
            }
            if (txCascadeAccount.getAccountType().intValue() == CascadeType.STAFF.getValue()) {
                log.debug("before clear courseIds:{}", (Object)courseIds);
                List tempIds = this.orgCourseDao.getCourseIdsByCascadeId(TianxiaoMContext.getTXCascadeId(), null, CourseTypeEnum.IS_CLASS_TRUE.getCode(), null);
                log.debug("user cascadeId={},courseIds={}", (Object)TianxiaoMContext.getTXCascadeId(), (Object)tempIds);
                if (CollectionUtils.isEmpty((Collection)courseIds)) {
                    courseIds.addAll(tempIds);
                } else if (!tempIds.containsAll(courseIds)) {
                    courseIds.clear();
                }
            }
        }
        return courseIds;
    }

    private ListLessonResponseDto wrap(Long orgId, List<OrgClassLesson> lessons) {
        HashMap lessonSignStatus;
        HashMap commentCount;
        Map signStudentCountMap;
        Map studentCountMap;
        HashSet courseIds = Sets.newHashSet();
        HashSet roomIds = Sets.newHashSet();
        HashSet lessonIds = Sets.newHashSet();
        Map<Long, Long> lessonIdTeacherIdMap = new HashMap<Long, Long>();
        ListLessonResponseDto result = new ListLessonResponseDto();
        Collections.sort(lessons, new Comparator<OrgClassLesson>(){

            @Override
            public int compare(OrgClassLesson o1, OrgClassLesson o2) {
                return o1.getNumber().compareTo(o2.getNumber());
            }
        });
        for (OrgClassLesson lesson : lessons) {
            courseIds.add(lesson.getCourseId());
            roomIds.add(lesson.getRoomId());
            lessonIds.add(lesson.getId());
        }
        Map<Object, Object> courseMap = Maps.newHashMap();
        courseMap = this.getOrgCourseMap(orgId, courseIds);
        Map<Object, Object> lessonIdTeacherNameMap = Maps.newHashMap();
        lessonIdTeacherNameMap = this.getLessonIdTeacherName(orgId, lessonIds, lessonIdTeacherIdMap);
        Map<Object, Object> classRoomMap = Maps.newHashMap();
        classRoomMap = this.getOrgClassRoomMap(roomIds);
        result = this.buildListLessonResponseDto(lessons, courseMap, lessonIdTeacherNameMap, classRoomMap, studentCountMap = this.orgStudentLessonDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds), signStudentCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, (Collection)lessonIds), commentCount = Maps.newHashMap(), lessonSignStatus = Maps.newHashMap());
        if (CollectionUtils.isNotEmpty(result.getList())) {
            lessonIdTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
            for (LessonResponseDto dto : result.getList()) {
                if (!lessonIdTeacherIdMap.containsKey(dto.getLessonId())) continue;
                dto.setTeacherId(lessonIdTeacherIdMap.get(dto.getLessonId()));
            }
        }
        return result;
    }

    Map<Long, OrgClassRoom> getAndCachedClassRoom(Collection<Long> roomIds) {
        List rooms = this.orgClassRoomDao.getByIds(roomIds, new String[]{"id", "roomName", "roomSize"});
        Map cache = Maps.newHashMap();
        if (CollectionUtils.isNotEmpty((Collection)rooms)) {
            cache = BaseUtils.listToMap((List)rooms, (String)"id");
        }
        return cache;
    }

    @Override
    @Transactional
    public void batchOperateLesson(Long orgId, Long courseId, List<Long> lessonIds, BatchOperateType operateType, String targetId) {
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            if (operateType == BatchOperateType.del_lesson) {
                this.delLesson(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.add_student) {
                this.addStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.del_student) {
                this.delStudent(orgId, courseId, lessonIds, targetId);
            } else if (operateType == BatchOperateType.change_teacher) {
                Long teacherId = Long.valueOf(targetId);
                this.changeTeacher(orgId, courseId, lessonIds, teacherId);
            } else if (operateType == BatchOperateType.change_classroom) {
                Long roomId = Long.valueOf(targetId);
                this.changeClassroom(orgId, courseId, lessonIds, roomId);
            } else if (operateType == BatchOperateType.change_time) {
                String[] time = targetId.split(",");
                String startTimeStr = time[0];
                String endTimeStr = time[1];
                this.changeTime(orgId, courseId, lessonIds, startTimeStr, endTimeStr);
            }
        }
    }

    private void delLesson(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        Map signCountMap = this.orgLessonSignDao.queryLessonStudentCountMap(orgId, lessonIds);
        for (Long lessonId : lessonIds) {
            Integer tempCount = (Integer)signCountMap.get(lessonId);
            if (tempCount == null || tempCount <= 0) continue;
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u8bfe\u7a0b\u5df2\u7b7e\u5230\uff0c\u4e0d\u80fd\u5220\u9664");
        }
        this.orgClassLessonDao.updateDelByLessonIds(orgId, lessonIds);
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("delStatus", "1");
        this.orgStudentLessonDao.update((Map)condition, new String[]{"delStatus"});
        HashMap<String, List<Long>> delCondition = new HashMap<String, List<Long>>();
        delCondition.put("lessonId", lessonIds);
        this.orgTeacherLessonDao.delByCondition(delCondition);
        this.orgLessonConflictService.delByLessonIds(orgId, lessonIds);
        this.resetLessonNumber(orgId, courseId);
    }

    private void addStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u7a0b\u4e0d\u80fd\u6dfb\u52a0\u5b66\u751f\uff0c\u8bf7\u4e0b\u8f7d\u65b0\u7248\u5929\u6821");
        }
        ArrayList studentIds = null;
        try {
            studentIds = (ArrayList)JacksonUtil.str2Obj((String)targetId, (TypeReference)new TypeReference<List<Long>>(){});
        }
        catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u8f6c\u6362\u5f02\u5e38");
        }
        if (CollectionUtils.isEmpty((Collection)studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap((Collection)studentIds);
        if (MapUtils.isEmpty((Map)userIdMap)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        studentIds = new ArrayList(userIdMap.values());
        List courseStudents = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        if (!courseStudents.containsAll(studentIds)) {
            studentIds.retainAll(courseStudents);
            log.warn("lesson studeng:{} is not all course student ids:{}", studentIds, (Object)courseStudents);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u5b66\u751f\u4e2d\u6dfb\u52a0\u8bfe\u8282\u5b66\u751f");
        }
        Map lessonStudentIds = this.orgStudentLessonDao.getLessonStudentList(lessonIds);
        List delLessonStudent = this.orgStudentLessonDao.getLessonStudentListDelStatus(lessonIds);
        HashMap lesseonStudentMap = Maps.newHashMap();
        for (OrgStudentLesson orgStudentLesson : delLessonStudent) {
            String tempKey = orgStudentLesson.getUserId() + "|" + orgStudentLesson.getLessonId();
            lesseonStudentMap.put(tempKey, orgStudentLesson);
        }
        log.info("check orgStudentLessonDao.getLessonStudentList(lessonIds):{},result={}", lessonIds, (Object)lessonStudentIds);
        List saveStudentLessons = Lists.newArrayList();
        List updateStudentLessons = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            List addedStuIds;
            ArrayList tempStudentIds = new ArrayList(studentIds);
            if (lessonStudentIds.containsKey(lessonId) && CollectionUtils.isNotEmpty((Collection)(addedStuIds = (List)lessonStudentIds.get(lessonId)))) {
                tempStudentIds.removeAll(addedStuIds);
            }
            OrgStudentLesson po = null;
            for (Long studentId : tempStudentIds) {
                po = new OrgStudentLesson();
                po.setCreateTime(new Date());
                po.setLessonId(lessonId);
                po.setOrgId(orgId);
                po.setUserId(studentId);
                String tempKey = studentId + "|" + lessonId;
                if (lesseonStudentMap.containsKey(tempKey)) {
                    OrgStudentLesson tempStudentLesson = (OrgStudentLesson)lesseonStudentMap.get(tempKey);
                    po.setId(tempStudentLesson.getId());
                    po.setDelStatus(Integer.valueOf(0));
                    po.setStartStatus(Integer.valueOf(0));
                    updateStudentLessons.add(po);
                    continue;
                }
                saveStudentLessons.add(po);
            }
        }
        log.info("save students :{} to lessonid:{}", (Object)saveStudentLessons, lessonIds);
        this.orgStudentLessonDao.saveAll(saveStudentLessons, new String[]{"createTime", "lessonId", "orgId", "userId"});
        for (OrgStudentLesson updateStudentLesson : updateStudentLessons) {
            this.orgStudentLessonDao.update((Object)updateStudentLesson, new String[]{"createTime", "delStatus", "startStatus"});
        }
    }

    private int delStudent(Long orgId, Long courseId, List<Long> lessonIds, String targetId) {
        OrgCourse orgCourse = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0]);
        if (orgCourse == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u73ed\u7ea7\u4e0d\u5b58\u5728");
        }
        if (orgCourse.getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "1\u5bf91\u8bfe\u7a0b\u4e0d\u80fd\u5220\u9664\u5b66\u751f\uff0c\u8bf7\u4e0b\u8f7d\u65b0\u7248\u5929\u6821");
        }
        ArrayList studentIds = null;
        try {
            studentIds = (ArrayList)JacksonUtil.str2Obj((String)targetId, (TypeReference)new TypeReference<List<Long>>(){});
        }
        catch (Exception e1) {
            log.warn("json class cast exception");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u8f6c\u6362\u4e00\u573a");
        }
        if (CollectionUtils.isEmpty((Collection)studentIds)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        Map userIdMap = this.orgStudentDao.getStudentIdUserIdMap((Collection)studentIds);
        if (MapUtils.isEmpty((Map)userIdMap)) {
            log.warn("add student ids is empty");
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5b66\u751fid\u4e3a\u7a7a");
        }
        studentIds = new ArrayList(userIdMap.values());
        List courseStudents = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
        if (!courseStudents.containsAll(studentIds)) {
            log.warn("lesson teacher:{} is not all course teacher ids:{}", studentIds, (Object)courseStudents);
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5fc5\u987b\u4ece\u8bfe\u7a0b\u5b66\u751f\u4e2d\u5220\u9664\u8bfe\u8282\u5b66\u751f");
        }
        HashMap<String, Object> countCondition = new HashMap<String, Object>();
        countCondition.put("orgId", orgId);
        countCondition.put("courseId", courseId);
        countCondition.put("lessonId", lessonIds);
        countCondition.put("userId", studentIds);
        countCondition.put("status", SignStatus.SIGNED.getCode());
        countCondition.put("userRole", UserRoleEnum.STUDENT.getCode());
        int count = this.orgLessonSignDao.countByCondition(countCondition, "userId", false);
        if (count > 0) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.PARAM_ERROR, "\u5df2\u7ecf\u7b7e\u5230\u7684\u5b66\u751f\u4e0d\u80fd\u5220\u9664");
        }
        HashMap condition = Maps.newHashMap();
        condition.put("orgId", orgId);
        condition.put("lessonId", lessonIds);
        condition.put("userId", studentIds);
        return this.orgStudentLessonDao.delByCondition((Map)condition);
    }

    private void changeTeacher(Long orgId, Long courseId, List<Long> lessonIds, Long teacherId) {
        HashMap<String, List<Long>> delCondition = new HashMap<String, List<Long>>();
        delCondition.put("lessonId", lessonIds);
        int result = this.orgTeacherLessonDao.delByCondition(delCondition);
        log.info("del from org teacher lesson by lessonId:{},result:{}", lessonIds, (Object)result);
        List saveLessonTeachers = Lists.newArrayList();
        OrgTeacherLesson po = null;
        for (Long lessonId : lessonIds) {
            po = new OrgTeacherLesson();
            po.setCreateTime(new Date());
            po.setLessonId(lessonId);
            po.setOrgId(orgId);
            po.setTeacherId(teacherId);
            saveLessonTeachers.add(po);
        }
        log.info("save teachers :{} to lessonId:{}", (Object)saveLessonTeachers, lessonIds);
        this.orgTeacherLessonDao.saveAll(saveLessonTeachers, new String[]{"createTime", "lessonId", "orgId", "teacherId"});
        List courseTeachers = this.orgCourseTeacherDao.getTeacher(orgId, courseId);
        HashSet userIds = Sets.newHashSet();
        for (OrgCourseTeacher courseTeacher : courseTeachers) {
            userIds.add(courseTeacher.getUserId());
        }
        if (!userIds.contains(teacherId)) {
            ArrayList<Long> teacherIds = new ArrayList<Long>();
            teacherIds.add(teacherId);
            this.courseTeacherService.addTeacherToCourse(orgId, courseId, teacherIds);
        }
        List conflictList = Lists.newArrayList();
        for (Long lessonId : lessonIds) {
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setTeacherId(teacherId);
            conflictList.add(conflict);
        }
        this.orgLessonConflictService.updateOrgLessonConflictForTeacherChange(conflictList);
    }

    private void changeClassroom(Long orgId, Long courseId, List<Long> lessonIds, Long roomId) {
        this.orgClassLessonDao.updateLessonClassRoom(orgId, lessonIds, roomId);
        List roomList = this.classRoomService.listOrgCourseRooms(orgId, courseId);
        ArrayList<Long> currentRoomIds = new ArrayList<Long>();
        for (ClassRoomDto dto : roomList) {
            currentRoomIds.add(dto.getRoomId());
        }
        if (!currentRoomIds.contains(roomId)) {
            ArrayList<Long> newCourseIds = new ArrayList<Long>();
            newCourseIds.add(roomId);
            this.classRoomService.addClassRoomCourse(orgId, courseId, newCourseIds);
        }
        for (Long lessonId : lessonIds) {
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lessonId);
            conflict.setRoomId(roomId);
            this.orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }
    }

    private void changeTime(Long orgId, Long courseId, List<Long> lessonIds, String startTimeStr, String endTimeStr) {
        TimeStamp startTime = TimeStamp.parse((String)startTimeStr);
        TimeStamp endTime = TimeStamp.parse((String)endTimeStr);
        List list = this.orgClassLessonDao.getByIds(lessonIds, new String[0]);
        for (OrgClassLesson lesson : list) {
            Calendar cal = Calendar.getInstance();
            cal.setTime(lesson.getStartTime());
            LessonTime lessonTime = new LessonTime(cal, startTime, endTime);
            HashMap<String, Comparable<Long>> map = new HashMap<String, Comparable<Long>>();
            map.put("id", lesson.getId());
            map.put("startTime", lessonTime.getStartTime());
            map.put("endTime", lessonTime.getEndTime());
            this.orgClassLessonDao.update(map, new String[]{"startTime", "endTime"});
            OrgLessonConflict conflict = new OrgLessonConflict();
            conflict.setOrgId(orgId);
            conflict.setLessonId(lesson.getId());
            conflict.setStartTime(lessonTime.getStartTime());
            conflict.setEndTime(lessonTime.getEndTime());
            this.orgLessonConflictService.updateOrgLessonConflictForRoomOrTimeChange(conflict);
        }
        this.resetLessonNumber(orgId, courseId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<Long> addClassLessonsBatchForFastSignIn(Long orgId, Long courseId, Integer addLessonTimes, Set<Long> studentIds) {
        Preconditions.checkArgument((orgId != null && orgId > 0L ? 1 : 0) != 0, (Object)"orgId is illegal");
        Preconditions.checkArgument((courseId != null && courseId > 0L ? 1 : 0) != 0, (Object)"courseId is illegal");
        Long defaultTeacherId = 0L;
        Long defaultRoomId = 0L;
        OrgClassLesson lesson = null;
        List lessons = Lists.newArrayList();
        Date todayStartTime = DateUtil.getStartOfDay((Date)new Date());
        Date startTime = DateUtil.getDiffDateTime((Date)todayStartTime, (int)6, (int)11);
        Date endTime = DateUtil.getDiffDateTime((Date)todayStartTime, (int)7, (int)11);
        for (int i = 0; i < addLessonTimes; ++i) {
            lesson = new OrgClassLesson();
            lesson.setStartTime(startTime);
            lesson.setEndTime(endTime);
            lesson.setCourseId(courseId);
            lesson.setCreateTime(new Date());
            lesson.setDelStatus(Integer.valueOf(DataStatus.NORMAL.getValue()));
            lesson.setLayoutId(Long.valueOf(0L));
            lesson.setRoomId(Long.valueOf(defaultRoomId != null ? defaultRoomId : 0L));
            lesson.setUpdateTime(new Date());
            lesson.setNumber(Integer.valueOf(i + 1));
            lesson.setOrgId(orgId);
            lessons.add(lesson);
        }
        log.info("save {} lessons into db,params:{}", (Object)lessons.size(), (Object)("courseId=" + courseId));
        this.orgClassLessonDao.saveAll(lessons, new String[]{"startTime", "endTime", "courseId", "createTime", "delStatus", "layoutId", "roomId", "updateTime", "orgId"});
        this.resetLessonNumber(orgId, courseId);
        List newLessonsIds = Lists.newArrayList();
        for (OrgClassLesson classLesson : lessons) {
            newLessonsIds.add(classLesson.getId());
            this.courseStudentService.addStudentToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), studentIds, true);
            if (defaultTeacherId == null || defaultTeacherId <= 0L) continue;
            List tearcherIds = Lists.newArrayList();
            tearcherIds.add(defaultTeacherId);
            this.courseTeacherService.addTeacherToLesson(orgId, classLesson.getCourseId(), classLesson.getId(), (Collection)tearcherIds);
        }
        return newLessonsIds;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchEditLessonsForFastSignIn(FastSignInLessonsEditRequestDto dto) {
        List<Long> lessonIds = dto.getLessonIds();
        Long orgId = dto.getOrgId();
        Long courseId = dto.getCourseId();
        Long roomId = dto.getRoomId();
        Long teacherId = dto.getTeacherId();
        String startTimeStr = dto.getStartTime();
        String endTimeStr = dto.getEndTime();
        if (CollectionUtils.isNotEmpty(lessonIds)) {
            if (roomId != null && roomId > 0L) {
                this.changeClassroom(orgId, courseId, lessonIds, roomId);
            }
            if (teacherId != null && teacherId > 0L) {
                this.changeTeacher(orgId, courseId, lessonIds, teacherId);
            }
            if (StringUtils.isNotBlank((CharSequence)startTimeStr) && StringUtils.isNotBlank((CharSequence)endTimeStr)) {
                this.changeTime(orgId, courseId, lessonIds, startTimeStr, endTimeStr);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public List<LessonResponseDto> findLessonBaseInfoByLessonIds(Long orgId, Long courseId, List<Long> lessonIds) {
        List lessons = this.orgClassLessonDao.queryLessons(orgId, null, null, lessonIds, null, null, null, new String[0]);
        return this.buildLessonBaseInfoList(orgId, courseId, lessons);
    }

    @Override
    @Transactional
    public List<LessonResponseDto> buildLessonBaseInfoList(Long orgId, Long courseId, List<OrgClassLesson> lessons) {
        List lessonIds = Lists.newArrayList();
        for (OrgClassLesson lesson : lessons) {
            lessonIds.add(lesson.getId());
        }
        HashSet<Long> roomIds = new HashSet<Long>();
        for (OrgClassLesson lesson : lessons) {
            if (lesson.getRoomId() == null || lesson.getRoomId() <= 0L) continue;
            roomIds.add(lesson.getRoomId());
        }
        Map lessonTeacherIdMap = this.orgTeacherLessonDao.queryLessonTeacherIdMap(orgId, (Collection)lessonIds);
        Map teacherNameMap = this.teacherDao.getTeacherRealNameMap(lessonTeacherIdMap.values());
        HashMap lessonIdTeacherNameMap = new HashMap(lessonTeacherIdMap.size());
        for (Long lessonId : lessonTeacherIdMap.keySet()) {
            lessonIdTeacherNameMap.put(lessonId, teacherNameMap.get(lessonTeacherIdMap.get(lessonId)));
        }
        Map<Long, OrgClassRoom> lessonRoomMap = this.getOrgClassRoomMap(roomIds);
        ArrayList<LessonResponseDto> dtoList = new ArrayList<LessonResponseDto>();
        for (OrgClassLesson lesson : lessons) {
            Long teacherId;
            LessonResponseDto dto = new LessonResponseDto();
            dto.setCourseId(lesson.getCourseId());
            dto.setLessonId(lesson.getId());
            dto.setIndex(lesson.getNumber());
            Long roomId = lesson.getRoomId();
            OrgClassRoom classRoom = lessonRoomMap.get(roomId);
            if (classRoom != null) {
                dto.setRoomId(roomId);
                dto.setRoomName(classRoom.getRoomName());
            }
            if ((teacherId = (Long)lessonTeacherIdMap.get(lesson.getId())) != null && teacherId > 0L) {
                dto.setTeacherId(teacherId);
                dto.setTeacherName((String)teacherNameMap.get(teacherId));
            }
            dto.setLessonStartTime(lesson.getStartTime());
            dto.setLessonEndTime(lesson.getEndTime());
            dtoList.add(dto);
        }
        return dtoList;
    }

    @Override
    @Transactional(readOnly=true)
    public LessonConflictCheckListDto lessonConflictCheck(Long orgId, LessonConflictCheckDto lessonConflictCheckDto) {
        List roomConflictList;
        int num;
        List teacherConflictList;
        PageDto pageDto = new PageDto();
        pageDto.setPageNum(Integer.valueOf(lessonConflictCheckDto.getPageNum()));
        pageDto.setPageSize(Integer.valueOf(lessonConflictCheckDto.getPageSize()));
        LessonConflictCheckListDto lessonConflictCheckListDto = new LessonConflictCheckListDto();
        Long teacherId = lessonConflictCheckDto.getTeacherId();
        Long roomId = lessonConflictCheckDto.getRoomId();
        Date startTime = lessonConflictCheckDto.getStartTimeDate();
        Date endTime = lessonConflictCheckDto.getEndTimeDate();
        Long lessonId = lessonConflictCheckDto.getLessonId();
        if (teacherId != null && teacherId > 0L && CollectionUtils.isNotEmpty((Collection)(teacherConflictList = this.orgLessonConflictService.checkTeacherConflict(orgId, teacherId, startTime, endTime, lessonId, pageDto)))) {
            num = this.orgLessonConflictService.queryTeacherConflictNum(orgId, teacherId, startTime, endTime, lessonId);
            try {
                PageDto tpageDto = (PageDto)BeanUtils.cloneBean((Object)pageDto);
                tpageDto.setCount(Integer.valueOf(num));
                lessonConflictCheckListDto.setTeacherConflictPageDto(tpageDto);
            }
            catch (Exception e) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR);
            }
            lessonConflictCheckListDto.setTeacherConflictData(this.change(teacherConflictList));
        }
        if (roomId != null && roomId > 0L && CollectionUtils.isNotEmpty((Collection)(roomConflictList = this.orgLessonConflictService.checkRoomConflict(orgId, roomId, startTime, endTime, lessonId, pageDto)))) {
            num = this.orgLessonConflictService.queryRoomConflictNum(orgId, roomId, startTime, endTime, lessonId);
            try {
                PageDto rpageDto = (PageDto)BeanUtils.cloneBean((Object)pageDto);
                rpageDto.setCount(Integer.valueOf(num));
                lessonConflictCheckListDto.setRoomConflictPageDto(rpageDto);
            }
            catch (Exception e) {
                throw new BussinessException((UniverseErrorCode)CommonErrorCode.SYSTEM_ERROR);
            }
            lessonConflictCheckListDto.setRoomConflictData(this.change(roomConflictList));
        }
        return lessonConflictCheckListDto;
    }

    @Override
    public void flushConflictData() {
        log.info("flushConflictData start load mysql data!!!!!!!!!!!!!!!!!!!!");
        List list = this.orgClassLessonDao.getflushConflictData();
        log.info("flushConflictData load mysql data finished!!!!!!!!!!!!!!!!!!!!");
        Collections.sort(list, new Comparator<OrgLessonConflict>(){

            @Override
            public int compare(OrgLessonConflict o1, OrgLessonConflict o2) {
                if (o1.getLessonId() < o2.getLessonId()) {
                    return -1;
                }
                if (o1.getLessonId() > o2.getLessonId()) {
                    return 1;
                }
                return 0;
            }
        });
        log.info("flushConflictData start lessonId :" + ((OrgLessonConflict)list.get(0)).getLessonId() + " , end lessonId:" + ((OrgLessonConflict)list.get(list.size() - 1)).getLessonId());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            Set courseIds = BaseUtils.getPropertiesList((List)list, (String)"courseId");
            int i = 0;
            int index = 0;
            List courseList = Lists.newArrayList();
            HashSet querySet = null;
            for (Long cid : courseIds) {
                if (i == 0) {
                    querySet = Sets.newHashSet();
                }
                querySet.add(cid);
                if (++i != 10000 && ++index != courseIds.size()) continue;
                List queryCourseList = this.orgCourseDao.getByIds((Collection)querySet, new String[0]);
                courseList.addAll(queryCourseList);
                i = 0;
            }
            ConcurrentMap courseMap = Maps.newConcurrentMap();
            if (CollectionUtils.isNotEmpty((Collection)courseList)) {
                for (OrgCourse course : courseList) {
                    if (course.getIsDel().intValue() != DataStatus.NORMAL.getValue()) continue;
                    courseMap.putIfAbsent(course.getId(), course);
                }
                courseList = null;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    OrgLessonConflict conflict = (OrgLessonConflict)it.next();
                    if (courseMap.containsKey(conflict.getCourseId())) continue;
                    it.remove();
                }
                courseMap = null;
                if (CollectionUtils.isNotEmpty((Collection)list)) {
                    log.info("flushConflictData start insert mysql!!!!!!!!!!!!!!!!!!!!");
                    this.orgLessonConflictService.saveOrgLessonConflicts(list);
                    log.info("flushConflictData insert mysql finished!!!!!!!!!!!!!!!!!!!!");
                }
            }
        }
        list = null;
    }

    private List<LessonConflictInfoDto> change(List<OrgLessonConflict> source) {
        List dest = Lists.newArrayList();
        for (OrgLessonConflict conflict : source) {
            LessonConflictInfoDto info = new LessonConflictInfoDto();
            info.setLessonId(conflict.getLessonId());
            OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)conflict.getLessonId(), new String[0]);
            info.setIndex(lesson.getNumber());
            info.setLessonEndTime(lesson.getEndTime().getTime());
            info.setLessonStartTime(lesson.getStartTime().getTime());
            OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)lesson.getCourseId(), new String[0]);
            info.setCourseName(course.getName());
            dest.add(info);
        }
        return dest;
    }

    @Override
    public List<NameAndIdDto> getLessonCalendarQueryDropDownList(Long orgId, DropDownListRequestDto params) {
        List<NameAndIdDto> result = Lists.newArrayList();
        if (params.getReqType() == DropdownListType.TEACHER.getType()) {
            Set lessonIds;
            List lessonTeachers;
            List lessons = this.orgClassLessonDao.getOrgClassLessonByParams(orgId, params.getParams(), null, null);
            if (CollectionUtils.isNotEmpty((Collection)lessons) && CollectionUtils.isNotEmpty((Collection)(lessonTeachers = this.orgTeacherLessonDao.queryByLessonIds(orgId, (Collection)(lessonIds = BaseUtils.getPropertiesList((List)lessons, (String)"id")))))) {
                Set teacherIds = BaseUtils.getPropertiesList((List)lessonTeachers, (String)"teacherId");
                List teachers = this.teacherDao.fuzzyQueryByNameAndMobile(orgId, (Collection)teacherIds, params.getSearch());
                result = this.collectTeacherInfo(teachers);
            }
        } else if (params.getReqType() == DropdownListType.ROOM.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set roomIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                roomIds = BaseUtils.getPropertiesList(lessons, (String)"roomId");
            }
            result = this.collectRoomInfo(orgId, roomIds, params.getSearch());
        } else if (params.getReqType() == DropdownListType.COURSE.getType()) {
            List<OrgClassLesson> lessons = this.getOrgLessonByParams(orgId, params.getParams());
            Set courseIds = Sets.newHashSet();
            if (CollectionUtils.isNotEmpty(lessons)) {
                courseIds = BaseUtils.getPropertiesList(lessons, (String)"courseId");
            }
            OrgAccount orgAccount = (OrgAccount)this.orgAccountDao.getById((Serializable)TianxiaoPCContext.getOrgId(), new String[0]);
            result = this.collectCourseInfo(orgAccount.getNumber(), params.getSearch(), courseIds);
        }
        return result;
    }

    private List<OrgClassLesson> getOrgLessonByParams(Long orgId, TimeTableRequestDto params) {
        List teachers;
        List lessons = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)params.getTeacherIds()) && CollectionUtils.isNotEmpty((Collection)(teachers = this.orgTeacherLessonDao.queryTeacherLessons(orgId, (Collection)params.getTeacherIds(), new String[]{"lessonId"})))) {
            Set lessonIds = BaseUtils.getPropertiesList((List)teachers, (String)"lessonId");
            lessons = this.orgClassLessonDao.getOrgClassLessonByParams(orgId, params, (Collection)lessonIds, null);
        }
        return lessons;
    }

    private List<NameAndIdDto> collectTeacherInfo(List<Teacher> teachers) {
        List idAndNames = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(teachers)) {
            idAndNames = (List)CollectionUtils.collect(teachers, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    NameAndIdDto idAndName = new NameAndIdDto();
                    Teacher teacher = (Teacher)input;
                    idAndName.setId(teacher.getUserId());
                    idAndName.setName(teacher.getRealName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    private List<NameAndIdDto> collectCourseInfo(Integer orgNumber, String query, Collection<Long> courseIds) {
        List idAndNames = Lists.newArrayList();
        List courses = this.orgCourseDao.fuzzyQuery(orgNumber, query, courseIds, null);
        if (CollectionUtils.isNotEmpty((Collection)courses)) {
            idAndNames = (List)CollectionUtils.collect((Collection)courses, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    OrgCourse course = (OrgCourse)input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(course.getId());
                    idAndName.setName(course.getName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    private List<NameAndIdDto> collectRoomInfo(Long orgId, Collection<Long> roomIds, String query) {
        List idAndNames = Lists.newArrayList();
        List rooms = this.orgClassRoomDao.getOrgClassRoomByNameAndIds(orgId, roomIds, query);
        if (CollectionUtils.isNotEmpty((Collection)rooms)) {
            idAndNames = (List)CollectionUtils.collect((Collection)rooms, (Transformer)new Transformer(){

                public Object transform(Object input) {
                    OrgClassRoom room = (OrgClassRoom)input;
                    NameAndIdDto idAndName = new NameAndIdDto();
                    idAndName.setId(room.getId());
                    idAndName.setName(room.getRoomName());
                    return idAndName;
                }
            });
        }
        return idAndNames;
    }

    @Override
    public LessonScheduleInfoDto lessonDetail(Long orgId, Long lessonId) {
        OrgClassLesson lesson = (OrgClassLesson)this.orgClassLessonDao.getById((Serializable)lessonId, new String[0]);
        if (lesson == null) {
            throw new BussinessException((UniverseErrorCode)CommonErrorCode.BUSINESS_ERROR, "\u8bfe\u8282\u4e0d\u5b58\u5728\u6216\u5df2\u88ab\u5220\u9664");
        }
        List lessons = Lists.newArrayList((Object[])new OrgClassLesson[]{lesson});
        List data = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty((Collection)lessons)) {
            ListLessonResponseDto ret = this.wrap(orgId, lessons);
            List<LessonResponseDto> result = ret.getList();
            LessonScheduleInfoDto item = null;
            if (CollectionUtils.isNotEmpty(result)) {
                Set roomIds = BaseUtils.getPropertiesList(result, (String)"roomId");
                Map<Long, OrgClassRoom> roomCache = this.getAndCachedClassRoom(roomIds);
                Date now = new Date();
                Set courseIds = BaseUtils.getPropertiesList(result, (String)"courseId");
                Map<Long, Integer> cache = this.getAndCachedFinishedLessonCount(orgId, courseIds);
                for (LessonResponseDto dto : result) {
                    OrgCourse course;
                    Long courseId = dto.getCourseId();
                    item = new LessonScheduleInfoDto();
                    item.setEndTime(dto.getLessonEndTime().getTime());
                    item.setStartTime(dto.getLessonStartTime().getTime());
                    item.setLessonId(dto.getLessonId());
                    item.setRoomId(dto.getRoomId());
                    item.setRoomName(dto.getRoomName());
                    item.setStudentCount(dto.getStudentCount());
                    item.setTeacherId(dto.getTeacherId());
                    item.setTeacherName(dto.getTeacherName());
                    item.setCourseId(courseId);
                    item.setCourseName(dto.getCourseName());
                    item.setTotalStudents(dto.getStudentCount());
                    item.setIndex(dto.getIndex());
                    item.setCourseType(dto.getCourseType() == null ? 0 : dto.getCourseType());
                    item.setLessonStatus(now.before(dto.getLessonStartTime()) ? LessonStatus.UN_START.getStatus() : (now.before(dto.getLessonEndTime()) ? LessonStatus.ONGOING.getStatus() : LessonStatus.FINISHED.getStatus()));
                    if (cache.containsKey(courseId)) {
                        item.setFinishedLessons(cache.get(courseId));
                    }
                    long roomId = dto.getRoomId();
                    if (roomCache.containsKey(dto.getRoomId())) {
                        item.setRoomCapacity(roomCache.containsKey(roomId) ? roomCache.get(roomId).getRoomSize() : 0);
                    }
                    if ((course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[0])).getCourseType() == CourseTypeEnum.COURSE_TYPE_1v1.getCode()) {
                        List scount = this.orgStudentCourseDao.getStudents(orgId, courseId, Integer.valueOf(0));
                        item.setStudentStatus(CollectionUtils.isEmpty((Collection)scount) ? StudentStatus.YES.getCode() : StudentStatus.NO.getCode());
                    }
                    this.wrapConflictInfo(orgId, item);
                    data.add(item);
                }
                return (LessonScheduleInfoDto)data.get(0);
            }
        }
        return null;
    }

    LessonBaseInfoDto wrap(Long orgId, OrgClassLesson lesson) {
        Long lessonId = lesson.getId();
        LessonBaseInfoDto result = new LessonBaseInfoDto();
        Long courseId = lesson.getCourseId();
        Long roomId = lesson.getRoomId();
        OrgTeacherLesson teacherLesson = this.orgTeacherLessonDao.getByLessonId(orgId, lessonId);
        this.getAndSetCourseInfo(courseId, result);
        this.getAndSetRoomInfo(roomId, result);
        result.setEndTime(lesson.getEndTime().getTime());
        result.setEndTimeStr(BaseUtils.getFormatTime((Date)lesson.getEndTime(), (String)"HH:mm"));
        result.setLessonId(lessonId);
        result.setStartTime(lesson.getStartTime().getTime());
        result.setStartTimeStr(BaseUtils.getFormatTime((Date)lesson.getStartTime(), (String)"HH:mm"));
        result.setTeacherId(teacherLesson.getTeacherId());
        result.setTeacherName(teacherLesson.getTeacherName());
        result.setDayOfWeek(DateUtil.getWeekDay((Date)lesson.getStartTime()));
        result.setDuration(this.calculateDuration(lesson.getStartTime(), lesson.getEndTime()));
        result.setTime(this.getLessonStartTime(lesson.getStartTime()));
        return result;
    }

    String getLessonStartTime(Date date) {
        StringBuffer sb = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("M\u6708d\u65e5");
        String time = sdf.format(date);
        String weekDay = DateUtil.getChineseWeekDay((Date)date);
        sb.append(time).append(" ").append("\u661f\u671f").append(weekDay);
        return sb.toString();
    }

    String calculateDuration(Date startTime, Date endTime) {
        long interval = (endTime.getTime() - startTime.getTime()) / 60000L;
        String duration = "";
        if (interval > 60L) {
            BigDecimal bg1 = new BigDecimal(interval);
            BigDecimal bg2 = new BigDecimal(interval);
            duration = bg1.divide(bg2, 1, RoundingMode.HALF_DOWN).toString() + "\u5c0f\u65f6";
        } else {
            duration = interval + "\u5206\u949f";
        }
        return duration;
    }

    void getAndSetCourseInfo(Long courseId, LessonBaseInfoDto result) {
        OrgCourse course = (OrgCourse)this.orgCourseDao.getById((Serializable)courseId, new String[]{"id", "name"});
        if (course != null) {
            result.setCourseId(course.getId());
            result.setCourseName(course.getName());
        }
    }

    void getAndSetRoomInfo(Long roomId, LessonBaseInfoDto result) {
        OrgClassRoom room = (OrgClassRoom)this.orgClassRoomDao.getById((Serializable)roomId, new String[]{"id", "roomName"});
        if (room != null) {
            result.setRoomName(room.getRoomName());
            result.setRoomId(room.getId());
        }
    }
}

